/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class HostDeviceTest
extends EgSnmpGenericTest {
    private static String descrOid = ".1.3.6.1.2.1.25.3.2.1.3";
    private static String statusOid = ".1.3.6.1.2.1.25.3.2.1.5";
    private static String errorsOid = ".1.3.6.1.2.1.25.3.2.1.6";
    private static int numMeasures = 2;
    private int rediscCount = -1;
    private int maxRediscPeriod = 4;
    private int numDevices = 0;
    private Hashtable indexToDescMap = new Hashtable();
    private Hashtable indexToLastErrorsMap = new Hashtable();

    public HostDeviceTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(numMeasures);
    }

    private void discDevices() {
        ++this.rediscCount;
        if (this.rediscCount >= this.maxRediscPeriod) {
            this.rediscCount = 0;
        }
        if (this.rediscCount != 0) {
            return;
        }
        boolean bl = this.runSnmpCmdForOid(descrOid);
        if (!bl || this.lhs == null || this.lhs.length <= 0) {
            this.rediscCount = -1;
            return;
        }
        this.indexToDescMap = new Hashtable();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.lhs.length; ++i) {
            String string = this.rhs[i];
            if (arrayList.contains(string)) {
                string = string + "_" + this.lhs[i];
            }
            arrayList.add(string);
            this.indexToDescMap.put(this.lhs[i], string);
        }
        arrayList = null;
        this.numDevices = this.lhs.length;
    }

    public void computeMeasures(Hashtable hashtable) {
        double d;
        int n;
        this.discDevices();
        if (this.numDevices == 0) {
            return;
        }
        boolean bl = this.runSnmpCmdForOid(errorsOid);
        Hashtable<String, Double> hashtable2 = new Hashtable<String, Double>();
        if (bl && this.lhs != null && this.lhs.length > 0) {
            for (n = 0; n < this.lhs.length; ++n) {
                d = -1.0;
                try {
                    d = Double.parseDouble(this.rhs[n]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!(d >= 0.0)) continue;
                hashtable2.put(this.lhs[n], new Double(d));
            }
        }
        if (!(bl = this.runSnmpCmdForOid(statusOid)) || this.lhs == null || this.lhs.length == 0) {
            return;
        }
        for (n = 0; n < this.lhs.length; ++n) {
            d = -1.0;
            try {
                d = Double.parseDouble(this.rhs[n]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (d == 1.0) {
                d = 5.0;
            } else if (d == 2.0) {
                d = 100.0;
            } else if (d == 3.0) {
                d = 1.0;
            } else if (d == 5.0) {
                d = 0.0;
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            String string = (String)this.indexToDescMap.get(this.lhs[n]);
            if (string == null) continue;
            Double d2 = (Double)hashtable2.get(this.lhs[n]);
            double d3 = 0.0;
            if (d2 != null) {
                double d4;
                double d5 = d2;
                Double d6 = (Double)this.indexToLastErrorsMap.get(this.lhs[n]);
                if (d6 != null && (d4 = d6.doubleValue()) >= 0.0 && d5 >= 0.0 && (d3 = d5 - d4) < 0.0) {
                    d3 = -1.0;
                }
            }
            arrayList.add(new Double(d));
            arrayList.add(new Double(d3));
            this.addNewMeasure(string, arrayList);
        }
        this.indexToLastErrorsMap = hashtable2;
    }
}

