/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class HostProcessorTest
extends EgSnmpGenericTest {
    private static String descrOid = ".1.3.6.1.2.1.25.3.2.1.3";
    private static String cpuOid = ".1.3.6.1.2.1.25.3.3.1.2";
    private static int numMeasures = 1;
    private int rediscCount = -1;
    private int maxRediscPeriod = 4;
    private int numDevices = 0;
    private Hashtable indexToDescMap = new Hashtable();

    public HostProcessorTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(numMeasures);
    }

    private void discDevices() {
        ++this.rediscCount;
        if (this.rediscCount >= this.maxRediscPeriod) {
            this.rediscCount = 0;
        }
        if (this.rediscCount != 0) {
            return;
        }
        boolean bl = this.runSnmpCmdForOid(descrOid);
        if (!bl || this.lhs == null || this.lhs.length <= 0) {
            this.rediscCount = -1;
            return;
        }
        this.indexToDescMap = new Hashtable();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.lhs.length; ++i) {
            String string = this.rhs[i];
            if (arrayList.contains(string)) {
                string = string + "_" + this.lhs[i];
            }
            arrayList.add(string);
            this.indexToDescMap.put(this.lhs[i], string);
        }
        arrayList = null;
        this.numDevices = this.lhs.length;
    }

    public void computeMeasures(Hashtable hashtable) {
        this.discDevices();
        if (this.numDevices == 0) {
            return;
        }
        boolean bl = this.runSnmpCmdForOid(cpuOid);
        if (!bl || this.lhs == null || this.lhs.length == 0) {
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.lhs.length; ++i) {
            double d3 = -1.0;
            try {
                d3 = Double.parseDouble(this.rhs[i]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string = (String)this.indexToDescMap.get(this.lhs[i]);
            if (string == null) continue;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d3));
            this.addNewMeasure(string, arrayList);
            d += 1.0;
            d2 += d3;
        }
        if (d > 0.0) {
            double d4 = d2 / d;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d4));
            this.addNewMeasure("Summary", arrayList);
        }
    }
}

