/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class HwArrayControlTest
extends EgSnmpGenericTest {
    private boolean isDell = false;
    private boolean isCpq = true;
    private static int numMeasures = 2;
    private static String cntlCondOid = ".1.3.6.1.4.1.232.3.2.2.1.1.6";
    private static String boardCondOid = ".1.3.6.1.4.1.232.3.2.2.1.1.12";
    private static String slotOid = ".1.3.6.1.4.1.232.3.2.2.1.1.5";
    private Hashtable slotIndexMap = new Hashtable();
    private int redisc = 0;

    public HwArrayControlTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(numMeasures);
        this.isDynamicInfoTest = true;
    }

    private void discover() {
        if (this.runSnmpCmdForOid(slotOid)) {
            this.slotIndexMap = new Hashtable();
            if (this.lhs != null) {
                for (int i = 0; i < this.lhs.length; ++i) {
                    this.slotIndexMap.put(this.lhs[i], this.rhs[i]);
                }
                this.redisc = 1;
            }
        }
    }

    private double getCpqValue(int n) {
        if (this.lhs == null || this.lhs.length == 0) {
            return -5.0;
        }
        double d = -5.0;
        try {
            d = Double.parseDouble(this.rhs[n]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (d < 0.0) {
            d = -5.0;
        }
        if (d <= 2.0) {
            return 1.0;
        }
        if (d == 3.0) {
            return 2.0;
        }
        return 3.0;
    }

    public void computeMeasures(Hashtable hashtable) {
        boolean bl = true;
        if (!this.isDell && !this.isCpq) {
            bl = false;
        }
        if (this.isDell || !bl) {
            this.runDellStatusTest();
        }
        if (!this.isDell && this.isCpq || !bl) {
            this.runCpqStatusTest();
        }
    }

    private void runCpqStatusTest() {
        if (this.redisc == 0) {
            this.discover();
        }
        if (this.slotIndexMap == null || this.slotIndexMap.size() == 0) {
            this.isCpq = false;
            return;
        }
        ++this.redisc;
        if (this.redisc >= 12) {
            this.redisc = 0;
        }
        if (this.runSnmpCmdForOid(cntlCondOid)) {
            int n;
            Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
            Hashtable<String, Double> hashtable2 = new Hashtable<String, Double>();
            if (this.lhs != null) {
                this.isCpq = true;
                for (n = 0; n < this.lhs.length; ++n) {
                    hashtable.put(this.lhs[n], new Double(this.getCpqValue(n)));
                }
            }
            if (this.runSnmpCmdForOid(boardCondOid) && this.lhs != null) {
                this.isCpq = true;
                for (n = 0; n < this.lhs.length; ++n) {
                    hashtable2.put(this.lhs[n], new Double(this.getCpqValue(n)));
                }
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string;
                String string2 = (String)enumeration.nextElement();
                Double d = (Double)hashtable.get(string2);
                Double d2 = (Double)hashtable2.get(string2);
                if (d == null) {
                    d = new Double(-5.0);
                }
                if (d2 == null) {
                    d2 = new Double(-5.0);
                }
                if ((string = (String)this.slotIndexMap.get(string2)) == null) continue;
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(d);
                arrayList.add(d2);
                this.addNewMeasure(string, arrayList);
            }
        } else {
            this.isCpq = false;
        }
    }

    private void runDellStatusTest() {
    }
}

