/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

class HwBatteryTest
extends EgSnmpGenericTest {
    private String key = "";
    private String LocVal = "";
    private String StatusVal = "";
    private String ReadingVal = "";
    private String StatesVal = "";
    private String info = "";
    private int Len = 0;
    private String chasisIndex = "";
    private String deviceIndex = "";
    private boolean isDell = false;
    private boolean isCpq = false;
    private boolean isIbm = false;

    public HwBatteryTest(String[] stringArray) {
        super(stringArray);
        this.isDynamicInfoTest = true;
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
        this.setMeasureCount(3);
    }

    public void computeMeasures(Hashtable hashtable) {
        boolean bl = false;
        if (this.isDell || this.isCpq || this.isIbm) {
            bl = true;
        }
        if (this.isDell || !bl) {
            this.runDellBatteryTest();
        }
        if (!this.isDell && this.isCpq && !this.isIbm || !bl) {
            this.runCpqBatteryTest();
        }
        if (!this.isDell && !this.isCpq && this.isIbm || !bl) {
            this.runIbmBatteryTest();
        }
    }

    public void runDellBatteryTest() {
        Hashtable hashtable = this.getMeasure(".1.3.6.1.4.1.674.10892.1.600.50.1.7");
        Hashtable hashtable2 = this.getMeasure(".1.3.6.1.4.1.674.10892.1.600.50.1.4");
        Hashtable hashtable3 = this.getMeasure(".1.3.6.1.4.1.674.10892.1.600.50.1.5");
        Hashtable hashtable4 = this.getMeasure(".1.3.6.1.4.1.674.10892.1.600.50.1.6");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            this.key = (String)enumeration.nextElement();
            this.Len = this.key.indexOf(".");
            this.chasisIndex = this.key.substring(0, this.Len);
            this.deviceIndex = this.key.substring(this.Len + 1);
            this.info = (String)hashtable.get(this.key);
            this.info = "chasis" + this.chasisIndex + "_" + "Battery" + this.deviceIndex + "_" + this.info;
            this.StatesVal = (String)hashtable2.get(this.key);
            this.StatesVal = this.checkNull(this.StatesVal);
            double d = this.getState(this.StatesVal);
            this.StatusVal = (String)hashtable3.get(this.key);
            this.StatusVal = this.checkNull(this.StatusVal);
            double d2 = Double.parseDouble(this.StatusVal);
            if (d2 == 3.0) {
                d2 = 0.0;
            }
            this.ReadingVal = (String)hashtable4.get(this.key);
            this.ReadingVal = this.checkNull(this.ReadingVal);
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            arrayList.add(new Double(this.ReadingVal));
            System.out.println("[HwBatteryTest]info========>" + this.info + "Measure=======>" + arrayList);
            this.addNewMeasure(this.info, arrayList);
        }
    }

    public Hashtable getMeasure(String string) {
        boolean bl = this.runSnmpCmdForOid(string);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = "";
        String string3 = "";
        if (bl) {
            for (int i = 0; i < this.lhs.length; ++i) {
                string2 = this.lhs[i];
                string3 = this.rhs[i];
                hashtable.put(string2, string3);
            }
        }
        return hashtable;
    }

    public double getState(String string) {
        double d = Double.parseDouble(string);
        if (d == 2.0) {
            return 0.0;
        }
        if (d == 4.0) {
            return 5.0;
        }
        if (d == 6.0) {
            return 3.0;
        }
        return d;
    }

    public String checkNull(String string) {
        if (string == null || string.length() == 0) {
            string = "-5";
        }
        return string;
    }

    public void runCpqBatteryTest() {
    }

    public void runIbmBatteryTest() {
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host", "192.168.8.50", "-port", "NULL", "-snmpPort", "161", "-snmpversion", "v1", "-snmpCommunity", "public"};
        HwBatteryTest hwBatteryTest = new HwBatteryTest(stringArray2);
        hwBatteryTest.computeMeasures(new Hashtable());
    }
}

