/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

class HwMemoryTest
extends EgSnmpGenericTest {
    private String key = "";
    private String LocVal = "";
    private String StVal = "";
    private String SizeVal = "";
    private String StatesVal = "";
    private String StatusVal = "";
    private String SpeedVal = "";
    private String info = "";
    private int Len = 0;
    private String chasisIndex = "";
    private String deviceIndex = "";
    private boolean isDell = false;
    private boolean isCpq = false;
    private boolean isIbm = false;

    public HwMemoryTest(String[] stringArray) {
        super(stringArray);
        this.isDynamicInfoTest = true;
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
        this.setMeasureCount(4);
    }

    public void computeMeasures(Hashtable hashtable) {
        boolean bl = false;
        if (this.isDell || this.isCpq || this.isIbm) {
            bl = true;
        }
        if (this.isDell || !bl) {
            this.runDellMemoryTest();
        }
        if (!this.isDell && this.isCpq && !this.isIbm || !bl) {
            this.runCpqMemoryTest();
        }
        if (!this.isDell && !this.isCpq && this.isIbm || !bl) {
            this.runIbmMemoryTest();
        }
    }

    public void runDellMemoryTest() {
        Hashtable hashtable = this.getMeasure(".1.3.6.1.4.1.674.10892.1.1100.50.1.8");
        Hashtable hashtable2 = this.getMeasure(".1.3.6.1.4.1.674.10892.1.1100.50.1.4");
        Hashtable hashtable3 = this.getMeasure(".1.3.6.1.4.1.674.10892.1.1100.50.1.5");
        Hashtable hashtable4 = this.getMeasure(".1.3.6.1.4.1.674.10892.1.1100.50.1.14");
        Hashtable hashtable5 = this.getMeasure(".1.3.6.1.4.1.674.10892.1.1100.50.1.15");
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            this.key = (String)enumeration.nextElement();
            this.Len = this.key.indexOf(".");
            this.chasisIndex = this.key.substring(0, this.Len);
            this.deviceIndex = this.key.substring(this.Len + 1);
            this.info = (String)hashtable.get(this.key);
            this.info = "chasis" + this.chasisIndex + "_" + "Memory" + this.deviceIndex + "_" + this.info;
            this.StatesVal = (String)hashtable2.get(this.key);
            this.StatesVal = this.checkNull(this.StatesVal);
            double d4 = this.getState(this.StatesVal);
            this.StatusVal = (String)hashtable3.get(this.key);
            this.StatusVal = this.checkNull(this.StatusVal);
            double d5 = Double.parseDouble(this.StatusVal);
            if (d5 == 3.0) {
                d5 = 0.0;
            }
            this.SizeVal = (String)hashtable4.get(this.key);
            if (this.SizeVal != null && this.SizeVal.length() > 0) {
                d2 = Double.parseDouble(this.SizeVal);
                d = d2 / 1048576.0;
            }
            this.SpeedVal = (String)hashtable5.get(this.key);
            this.SpeedVal = this.checkNull(this.SpeedVal);
            arrayList.add(new Double(d4));
            arrayList.add(new Double(d5));
            arrayList.add(new Double(d));
            arrayList.add(new Double(this.SpeedVal));
            System.out.println("[HwMemoryTest]info========>" + this.info + "Measure=======>" + arrayList);
            this.addNewMeasure(this.info, arrayList);
        }
    }

    public Hashtable getMeasure(String string) {
        boolean bl = this.runSnmpCmdForOid(string);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = "";
        String string3 = "";
        if (bl) {
            for (int i = 0; i < this.lhs.length; ++i) {
                string2 = this.lhs[i];
                string3 = this.rhs[i];
                hashtable.put(string2, string3);
            }
        }
        return hashtable;
    }

    public double getState(String string) {
        double d = Double.parseDouble(string);
        if (d == 2.0) {
            return 0.0;
        }
        if (d == 4.0) {
            return 5.0;
        }
        if (d == 6.0) {
            return 3.0;
        }
        return d;
    }

    public String checkNull(String string) {
        if (string == null || string.length() == 0) {
            string = "-5";
        }
        return string;
    }

    public void runCpqMemoryTest() {
    }

    public void runIbmMemoryTest() {
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host", "192.168.8.50", "-port", "NULL", "-snmpPort", "161", "-snmpversion", "v1", "-snmpCommunity", "public"};
        HwMemoryTest hwMemoryTest = new HwMemoryTest(stringArray2);
        hwMemoryTest.computeMeasures(new Hashtable());
    }
}

