/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class HwStatusTest
extends EgSnmpGenericTest {
    private static String oid = ".1.3.6.1.4.1.674.10892.1.200.10.1";
    private boolean isDell = false;
    private boolean isCpq = false;
    private static int numMeasures = 9;
    private static String oid1 = ".1.3.6.1.4.1.232.6.2.6.1";
    private static String oid2 = ".1.3.6.1.4.1.232.6.2.6.3";
    private static String oid3 = ".1.3.6.1.4.1.232.6.2.6.5";
    private static String oid4 = ".1.3.6.1.4.1.232.6.2.6.4";
    private static String oid5 = ".1.3.6.1.4.1.232.6.2.9.1";
    private static String oid6 = ".1.3.6.1.4.1.232.6.2.14.4";

    public HwStatusTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(numMeasures);
        this.isDynamicInfoTest = true;
    }

    private double getValue(int n) {
        if (this.lhs == null || this.lhs.length == 0) {
            return -5.0;
        }
        double d = -5.0;
        try {
            d = Double.parseDouble(this.rhs[n]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (d < 0.0) {
            d = -5.0;
        }
        if (d <= 2.0) {
            return -1.0;
        }
        if (d == 3.0) {
            return 1.0;
        }
        if (d == 4.0) {
            return 2.0;
        }
        if (d == 5.0 || d == 6.0) {
            return 3.0;
        }
        return -5.0;
    }

    private double getCpqValue(int n) {
        if (this.lhs == null || this.lhs.length == 0) {
            return -5.0;
        }
        double d = -5.0;
        try {
            d = Double.parseDouble(this.rhs[n]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (d < 0.0) {
            d = -5.0;
        }
        if (d <= 2.0) {
            return 1.0;
        }
        if (d == 3.0) {
            return 2.0;
        }
        return 3.0;
    }

    public void computeMeasures(Hashtable hashtable) {
        boolean bl = false;
        if (this.isDell || this.isCpq) {
            bl = true;
        }
        if (this.isDell || !bl) {
            this.runDellStatusTest();
        }
        if (!this.isDell && this.isCpq || !bl) {
            this.runCpqStatusTest();
        }
    }

    private void runCpqStatusTest() {
        this.isCpq = false;
        if (this.runSnmpCmdForOid(oid1)) {
            this.isCpq = true;
            double d = this.getCpqValue(0);
            double d2 = -5.0;
            if (this.runSnmpCmdForOid(oid5)) {
                d2 = this.getCpqValue(0);
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d));
            arrayList.add(new Double(-5.0));
            arrayList.add(new Double(d2));
            arrayList.add(new Double(-5.0));
            arrayList.add(new Double(-5.0));
            double d3 = -5.0;
            if (this.runSnmpCmdForOid(oid3)) {
                d3 = this.getCpqValue(0);
            }
            if (d3 > 1.0) {
                arrayList.add(new Double(d3));
            } else {
                if (this.runSnmpCmdForOid(oid4)) {
                    d3 = this.getCpqValue(0);
                }
                arrayList.add(new Double(d3));
            }
            double d4 = -5.0;
            if (this.runSnmpCmdForOid(oid2)) {
                d4 = this.getCpqValue(0);
            }
            arrayList.add(new Double(d4));
            double d5 = -5.0;
            if (this.runSnmpCmdForOid(oid6)) {
                d5 = this.getCpqValue(0);
            }
            arrayList.add(new Double(d5));
            arrayList.add(new Double(-5.0));
            this.addNewMeasure(arrayList);
        } else {
            this.isCpq = false;
        }
    }

    private void runDellStatusTest() {
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = -5.0;
        double d5 = -5.0;
        double d6 = -5.0;
        double d7 = -5.0;
        double d8 = -5.0;
        double d9 = -5.0;
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        Hashtable<String, Double> hashtable2 = new Hashtable<String, Double>();
        Hashtable<String, Double> hashtable3 = new Hashtable<String, Double>();
        Hashtable<String, Double> hashtable4 = new Hashtable<String, Double>();
        Hashtable<String, Double> hashtable5 = new Hashtable<String, Double>();
        Hashtable<String, Double> hashtable6 = new Hashtable<String, Double>();
        Hashtable<String, Double> hashtable7 = new Hashtable<String, Double>();
        Hashtable<String, Double> hashtable8 = new Hashtable<String, Double>();
        Hashtable<String, Double> hashtable9 = new Hashtable<String, Double>();
        this.isDell = false;
        if (this.runSnmpCmdForOid(oid)) {
            if (this.lhs == null) {
                return;
            }
            this.isDell = true;
            for (int i = 0; i < this.lhs.length; ++i) {
                String string;
                if (this.lhs[i].startsWith("2.")) {
                    d = this.getValue(i);
                    string = this.lhs[i].substring(2);
                    hashtable.put(string, new Double(d));
                    continue;
                }
                if (this.lhs[i].startsWith("4.")) {
                    d2 = this.getValue(i);
                    string = this.lhs[i].substring(2);
                    hashtable2.put(string, new Double(d2));
                    continue;
                }
                if (this.lhs[i].startsWith("9.")) {
                    d3 = this.getValue(i);
                    string = this.lhs[i].substring(2);
                    hashtable3.put(string, new Double(d3));
                    continue;
                }
                if (this.lhs[i].startsWith("12.")) {
                    d4 = this.getValue(i);
                    string = this.lhs[i].substring(3);
                    hashtable4.put(string, new Double(d4));
                    continue;
                }
                if (this.lhs[i].startsWith("15.")) {
                    d5 = this.getValue(i);
                    string = this.lhs[i].substring(3);
                    hashtable5.put(string, new Double(d5));
                    continue;
                }
                if (this.lhs[i].startsWith("21.")) {
                    d6 = this.getValue(i);
                    string = this.lhs[i].substring(3);
                    hashtable6.put(string, new Double(d6));
                    continue;
                }
                if (this.lhs[i].startsWith("24.")) {
                    d7 = this.getValue(i);
                    string = this.lhs[i].substring(3);
                    hashtable7.put(string, new Double(d7));
                    continue;
                }
                if (this.lhs[i].startsWith("27.")) {
                    d8 = this.getValue(i);
                    string = this.lhs[i].substring(3);
                    hashtable8.put(string, new Double(d8));
                    continue;
                }
                if (!this.lhs[i].startsWith("30.")) continue;
                d9 = this.getValue(i);
                string = this.lhs[i].substring(3);
                hashtable9.put(string, new Double(d9));
            }
        } else {
            this.isDell = false;
            return;
        }
        Enumeration enumeration = hashtable.keys();
        int n = hashtable.size();
        if (n == 1) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            arrayList.add(new Double(d3));
            arrayList.add(new Double(d4));
            arrayList.add(new Double(d5));
            arrayList.add(new Double(d6));
            arrayList.add(new Double(d7));
            arrayList.add(new Double(d8));
            arrayList.add(new Double(d9));
            this.addNewMeasure(arrayList);
            return;
        }
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(this.getDouble(hashtable, string));
            arrayList.add(this.getDouble(hashtable2, string));
            arrayList.add(this.getDouble(hashtable3, string));
            arrayList.add(this.getDouble(hashtable4, string));
            arrayList.add(this.getDouble(hashtable5, string));
            arrayList.add(this.getDouble(hashtable6, string));
            arrayList.add(this.getDouble(hashtable7, string));
            arrayList.add(this.getDouble(hashtable8, string));
            arrayList.add(this.getDouble(hashtable9, string));
            this.addNewMeasure(string, arrayList);
        }
    }

    private Double getDouble(Hashtable hashtable, String string) {
        Double d = (Double)hashtable.get(string);
        if (d == null) {
            d = new Double(-5.0);
        }
        return d;
    }
}

