/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnector;

public class IBMWLPBase
extends GenericTest {
    private JMXConnector jmxConnector = null;
    private RMIConnector rmiConnector = null;
    protected JMXServiceURL url = null;
    protected MBeanServerConnection beanServerConnection = null;
    protected String sysOS = "";
    protected String logMessage = null;
    protected static final double DEFAULT_MINUS_FIVE = -5.0;
    protected static final double BYTES_TO_GB = 1.073741824E9;
    protected static final double BYTES_TO_MB = 1048576.0;
    protected static final double KB_TO_GB = 1048576.0;
    protected static final double KB_TO_MB = 1024.0;
    protected static final double MICROSEC_TO_MILLISEC = 1000.0;
    protected static final double NANO_TO_SECONDS = 1.0E9;
    protected static final double NANO_TO_MILLISEC = 1000000.0;
    protected static final double MILLISEC_TO_SECONDS = 1000.0;
    protected static final long SECONDS_TO_HOURS = 3600L;
    protected static String myDatePattern = "dd/MM/yy hh:mm:ss a";
    protected static SimpleDateFormat mySDF = new SimpleDateFormat(myDatePattern);
    protected static String fieldSep = new String("");
    protected static String sync0 = new String("x");
    private String serviceURLPath = null;
    private File file = null;
    private DataInputStream dis = null;
    private static final String LOCAL_CONNECTOR_SERVICE_FILE_NAME = "com.ibm.ws.jmx.local.address";
    private boolean isFirstTime = true;
    String jmxURL = null;

    public IBMWLPBase(String[] stringArray) {
        super(stringArray);
        this.isNewDynamicInfoTest = true;
        this.serviceURLPath = this.getValueForParam("service_URL_path");
        if (this.serviceURLPath == null || this.serviceURLPath.equalsIgnoreCase("none") || this.serviceURLPath.trim().length() == 0) {
            String string = "Service URL path is empty, Please provide the valid path";
            this.printOut(string);
            this.putWarningMessageToLogfile(string);
        }
        this.sysOS = System.getProperty("os.name");
        if (this.sysOS == null) {
            this.putErrorMessageToLogfile("Operating System Name not Found");
        }
        this.printOut("Operating System :" + this.sysOS);
        this.sysOS = this.sysOS.trim().toUpperCase();
        if (this.sysOS.trim().startsWith("WIN")) {
            this.serviceURLPath.replace('/', '\\');
            if (!this.serviceURLPath.endsWith("\\")) {
                this.serviceURLPath = this.serviceURLPath + "\\";
            }
        } else {
            this.serviceURLPath.replace('\\', '/');
            if (!this.serviceURLPath.endsWith("/")) {
                this.serviceURLPath = this.serviceURLPath + "/";
            }
        }
    }

    protected JMXServiceURL buildJMXURL(String string) {
        JMXServiceURL jMXServiceURL = null;
        try {
            jMXServiceURL = new JMXServiceURL(string);
        }
        catch (Exception exception) {
            this.logMessage = "JMXServiceURL : " + string + " \n Error in JMXServiceURL :  " + exception.toString();
            this.printOut(this.logMessage);
            this.putErrorMessageToLogfile(this.logMessage);
            this.logMessage = "";
            this.printOutStackTrace(exception);
            exception.printStackTrace();
            this.disconnect();
            return null;
        }
        return jMXServiceURL;
    }

    protected void connect() {
        String string = null;
        this.printOut("Host " + this.targetHost);
        this.printOut("Serivce url name :com.ibm.ws.jmx.local.address");
        string = this.serviceURLPath + "" + LOCAL_CONNECTOR_SERVICE_FILE_NAME;
        this.printOut("Service url path :" + string);
        if (this.jmxURL == null || this.jmxURL.trim().length() == 0) {
            this.jmxURL = this.readServiceURL(string);
        }
        if (this.jmxURL == null || this.jmxURL.trim().length() == 0) {
            this.logMessage = "Local connector Service file :'com.ibm.ws.jmx.local.address' not found, Server might not started";
            this.printOut(this.logMessage);
            this.putErrorMessageToLogfile(this.logMessage);
            this.logMessage = "";
            return;
        }
        try {
            JMXServiceURL jMXServiceURL = this.buildJMXURL(this.jmxURL);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("jmx.remote.protocol.provider.pkgs", "com.sun.jmx.remote.protocol");
            try {
                this.jmxConnector = JMXConnectorFactory.connect(jMXServiceURL, hashMap);
                this.printOut("jmxConnector " + this.jmxConnector);
            }
            catch (Exception exception) {
                this.jmxURL = this.readServiceURL(string);
                if (this.jmxURL == null || this.jmxURL.trim().length() == 0) {
                    this.logMessage = "Local connector Service file :'com.ibm.ws.jmx.local.address' not found, Server might not started";
                    this.printOut(this.logMessage);
                    this.putErrorMessageToLogfile(this.logMessage);
                    this.logMessage = "";
                    return;
                }
                jMXServiceURL = this.buildJMXURL(this.jmxURL);
                try {
                    this.jmxConnector = JMXConnectorFactory.connect(jMXServiceURL, hashMap);
                    this.printOut("jmxConnector " + this.jmxConnector);
                }
                catch (Exception exception2) {
                    this.logMessage = "JMX connection error  " + exception2.toString();
                    this.printOut(this.logMessage);
                    this.putErrorMessageToLogfile(this.logMessage);
                    this.logMessage = "";
                    this.printOutStackTrace(exception2);
                    exception2.printStackTrace();
                    this.disconnect();
                    return;
                }
            }
            try {
                this.beanServerConnection = this.jmxConnector.getMBeanServerConnection();
                this.printOut("beanServerConnection : " + this.beanServerConnection);
            }
            catch (Exception exception) {
                this.logMessage = "JMX beanServerConnection error  " + exception.toString();
                this.printOut(this.logMessage);
                this.putErrorMessageToLogfile(this.logMessage);
                this.logMessage = "";
                this.printOutStackTrace(exception);
                exception.printStackTrace();
                this.disconnect();
                return;
            }
            if (this.beanServerConnection == null) {
                this.logMessage = "beanServerConnection  is null ,Connection to JMX Agent is not established ";
                this.printOut(this.logMessage);
                this.putErrorMessageToLogfile(this.logMessage);
                this.logMessage = "";
                this.disconnect();
                return;
            }
        }
        catch (Exception exception) {
            this.logMessage = "Error in creation server connecetion " + exception.toString();
            this.printOut(this.logMessage);
            this.putErrorMessageToLogfile(this.logMessage);
            this.logMessage = "";
            this.printOutStackTrace(exception);
            exception.printStackTrace();
            this.disconnect();
            return;
        }
    }

    protected void disconnect() {
        try {
            if (this.beanServerConnection != null) {
                this.beanServerConnection = null;
            }
        }
        catch (Exception exception) {
            this.logMessage = "Error in closing beanServerConnection " + exception.toString();
            this.printOut(this.logMessage);
            this.putErrorMessageToLogfile(this.logMessage);
            this.logMessage = "";
            this.printOutStackTrace(exception);
            exception.printStackTrace();
            return;
        }
        try {
            if (this.jmxConnector != null) {
                this.jmxConnector.close();
            }
        }
        catch (Exception exception) {
            this.logMessage = "Error in closing connection in jmxConnector " + exception.toString();
            this.printOut(this.logMessage);
            this.putErrorMessageToLogfile(this.logMessage);
            this.logMessage = "";
            this.printOutStackTrace(exception);
            exception.printStackTrace();
            return;
        }
        try {
            if (this.rmiConnector != null) {
                this.rmiConnector.close();
            }
        }
        catch (Exception exception) {
            this.logMessage = "Error in closing connection in rmiConnector  " + exception.toString();
            this.printOut(this.logMessage);
            this.putErrorMessageToLogfile(this.logMessage);
            this.logMessage = "";
            this.printOutStackTrace(exception);
            exception.printStackTrace();
            return;
        }
    }

    protected Hashtable getData(ObjectName objectName, ArrayList arrayList) {
        Hashtable hashtable = new Hashtable();
        Set<ObjectInstance> set = null;
        Iterator<ObjectInstance> iterator = null;
        if (arrayList == null || arrayList.isEmpty() || arrayList.size() == 0) {
            return hashtable;
        }
        try {
            set = this.beanServerConnection.queryMBeans(objectName, null);
            iterator = set.iterator();
            while (iterator != null && iterator.hasNext()) {
                ObjectInstance objectInstance = iterator.next();
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                objectName = objectInstance.getObjectName();
                this.printOut("ObjectName " + objectName);
                String string = objectName.toString();
                MBeanInfo mBeanInfo = this.beanServerConnection.getMBeanInfo(objectName);
                MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
                this.printOut("MbeanInfo " + mBeanInfo);
                this.printOut("MbeanAttri " + mBeanAttributeInfoArray);
                for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
                    String string2 = mBeanAttributeInfoArray[i].getName();
                    String string3 = "" + this.beanServerConnection.getAttribute(objectName, string2);
                    this.printOut("Attribute name : " + string2 + " and value " + string3);
                    if (!arrayList.contains(string2)) continue;
                    hashtable2.put(string2, string3);
                }
                hashtable.put(string, hashtable2);
                this.printOut("MbeanData Hash : " + hashtable);
            }
        }
        catch (Exception exception) {
            this.logMessage = "Error itrating mbeandata  " + exception.toString();
            this.printOut(this.logMessage);
            this.putErrorMessageToLogfile(this.logMessage);
            this.logMessage = "";
            this.printOutStackTrace(exception);
            exception.printStackTrace();
        }
        return hashtable;
    }

    public void printOut(String string) {
        this.printOut(string, true);
    }

    public void printOut(String string, boolean bl) {
        if (bl) {
            System.out.println(" >> [ " + this.entity + " ] : [ " + this.reportingName + " ] : [ " + mySDF.format(new Date()) + " ] : >> " + string);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
    }

    public void putInfoMessageToLogfile(String string) {
        this.logToErrorFile("INFO :", this.reportingName + " : " + this.entity, string);
    }

    public void putWarningMessageToLogfile(String string) {
        this.logToErrorFile("WARNING :", this.reportingName + " : " + this.entity, string);
    }

    public void printOutStackTrace(Exception exception) {
        String string = exception.toString() + "\n";
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            string = string + stackTraceElementArray[i].toString() + "\n";
        }
        string = "[StackTrace] :" + string;
        System.out.println(" >> [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + mySDF.format(new Date()) + " ] : >> " + string);
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
    }

    public double removeExpAndRound(double d) {
        String string = "0.0";
        double d2 = 0.0;
        try {
            BigDecimal bigDecimal = new BigDecimal(d);
            double d3 = bigDecimal.doubleValue();
            DecimalFormat decimalFormat = new DecimalFormat("#.##");
            try {
                string = decimalFormat.format(d3).toString();
                d2 = Double.parseDouble(string);
            }
            catch (Exception exception) {
                string = "0.0";
                d2 = Double.parseDouble(string);
            }
        }
        catch (Exception exception) {
            string = "0.0";
            d2 = Double.parseDouble(string);
            return d2;
        }
        return d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String readServiceURL(String string) {
        this.file = new File(string);
        String string2 = null;
        try {
            if (!this.file.exists()) {
                String string3 = string2;
                return string3;
            }
            this.dis = new DataInputStream(new FileInputStream(this.file));
            String string4 = null;
            while ((string4 = this.dis.readLine()) != null) {
                string2 = string4;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (this.dis != null) {
                    this.dis.close();
                }
            }
            catch (Exception exception) {
                this.printOut("Error in closing DataInputStream ");
                exception.printStackTrace();
            }
            this.dis = null;
        }
        return string2;
    }

    protected double getDoubleValue(String string) {
        double d = -5.0;
        if (string == null || string.trim().length() == 0) {
            return d;
        }
        string = string.trim();
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }
}

