/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgUtils;
import com.egurkha.util.EgStreamReaderThread;
import com.egurkha.util.LogFileReader;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class JvmMemPoolGCTest
extends JVMInstrumentation {
    private String JVM_Version = null;
    private String JVM_1_3_1_MinorGC = "[GC";
    private String JVM_1_3_1_FullGC = "[Full GC ";
    private boolean measure_mode = true;
    private Hashtable prev_infoFileName = new Hashtable();
    private Hashtable logFileSizeLast = new Hashtable();
    private Hashtable logFileTimestampLast = new Hashtable();

    public JvmMemPoolGCTest(String[] args) {
        super(args);
        String measureMode = this.getValueForParam("measure_mode");
        if (measureMode == null || measureMode.equalsIgnoreCase("false")) {
            this.measure_mode = false;
        }
        this.isNewDynamicInfoTest = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void computeMeasures(Hashtable paramList) {
        this.getJvmGuid();
        if (this.mode_type.equalsIgnoreCase("Log File")) {
            ArrayList<String> patterns = new ArrayList<String>();
            patterns.add(this.JVM_1_3_1_MinorGC);
            patterns.add(this.JVM_1_3_1_FullGC);
            if (this.JVM_Version == null) {
                String jdkHome = (String)paramList.get("JREHome");
                this.JVM_Version = this.getJVMVersion(jdkHome);
                if (this.JVM_Version.equals("-1")) {
                    this.logToErrorFile("Error", "JvmMemPoolGCTest.computeMeasures", "jdkHome is " + jdkHome);
                    this.logToErrorFile("Error", "JvmMemPoolGCTest.computeMeasures", "Could not find JVM version; can't run JVMGCTest");
                    return;
                }
            } else if (this.JVM_Version.equals("-1")) {
                return;
            }
            String fileName = (String)paramList.get("LogFileName");
            StringTokenizer stok = new StringTokenizer(fileName, ",");
            boolean serversWithNoLabel = false;
            while (stok.hasMoreTokens()) {
                String tmp = stok.nextToken();
                StringTokenizer st = new StringTokenizer(tmp, "@");
                String displayLabel = "NONE";
                if (st.countTokens() == 2) {
                    displayLabel = st.nextToken();
                } else {
                    if (serversWithNoLabel) continue;
                    serversWithNoLabel = true;
                }
                fileName = st.nextToken();
                File input = new File(fileName);
                File f = null;
                if (input.isDirectory()) {
                    File[] fileList = input.listFiles();
                    int index = 0;
                    if (fileList != null && fileList.length > 0) {
                        long max = 0L;
                        int i = 0;
                        while (i < fileList.length) {
                            if (fileList[i].lastModified() > max) {
                                index = i;
                                max = fileList[i].lastModified();
                            }
                            ++i;
                        }
                        f = fileList[index];
                    }
                    if (f == null) {
                        this.logToErrorFile("Error", "JvmMemPoolGCTest.computeMeasures", "Unable to find files inside the dir " + input);
                        continue;
                    }
                } else {
                    f = input;
                }
                String oldFileName = (String)this.prev_infoFileName.get(displayLabel);
                if (!f.exists()) {
                    this.logToErrorFile("Error", "JvmMemPoolGCTest.computeMeasures", "Log file " + f.toString() + " does not exist for " + displayLabel);
                    continue;
                }
                if (oldFileName != null && !oldFileName.equals(f.toString())) {
                    this.uploadValues(displayLabel, "[Full GC]", -1);
                    this.uploadValues(displayLabel, "[Minor GC]", -1);
                    this.prev_infoFileName.put(displayLabel, f.toString());
                    this.logFileSizeLast.put(displayLabel, String.valueOf(f.length()));
                    this.logFileTimestampLast.put(displayLabel, String.valueOf(f.lastModified()));
                    continue;
                }
                if (f.length() == 0L) {
                    this.logToErrorFile("Error", "JvmMemPoolGCTest.computeMeasures", "Log file " + f.toString() + " is empty for " + displayLabel);
                    this.uploadValues(displayLabel, "[Full GC]", -1);
                    this.uploadValues(displayLabel, "[Minor GC]", -1);
                    this.prev_infoFileName.put(displayLabel, f.toString());
                    continue;
                }
                if (this.timeSinceLastTest == -1.0) {
                    this.logFileSizeLast.put(displayLabel, String.valueOf(f.length()));
                    this.logFileTimestampLast.put(displayLabel, String.valueOf(f.lastModified()));
                    this.uploadValues(displayLabel, "[Full GC]", -1);
                    this.uploadValues(displayLabel, "[Minor GC]", -1);
                    this.prev_infoFileName.put(displayLabel, f.toString());
                    continue;
                }
                ArrayList gcOutput = this.getGCOutputFromLogFile(f, patterns, displayLabel);
                if (gcOutput == null || gcOutput.size() == 0) {
                    this.uploadValues(displayLabel, "[Full GC]", 0);
                    this.uploadValues(displayLabel, "[Minor GC]", 0);
                    this.prev_infoFileName.put(displayLabel, f.toString());
                    continue;
                }
                double F_totalHeapSizeBefore = 0.0;
                double F_totalHeapSizeAfter = 0.0;
                double F_totalGcTime = 0.0;
                double F_numberOfGc = 0.0;
                double F_maxGcPause = 0.0;
                double M_totalHeapSizeBefore = 0.0;
                double M_totalHeapSizeAfter = 0.0;
                double M_totalGcTime = 0.0;
                double M_numberOfGc = 0.0;
                double M_maxGcPause = 0.0;
                int numberOfGc = 0;
                if (gcOutput != null) {
                    numberOfGc = gcOutput.size();
                }
                String timestamp = "";
                Vector<String> fullGc_dd = new Vector<String>();
                Vector<String> minorGc_dd = new Vector<String>();
                String heapBefore = null;
                String heapAfter = null;
                String totalGC = null;
                int i = 0;
                while (i < numberOfGc) {
                    StringTokenizer st1;
                    String line = (String)gcOutput.get(i);
                    String parsedValues = this.parseValues(line);
                    if (!this.JVM_Version.startsWith("1.3")) {
                        timestamp = parsedValues.substring(0, parsedValues.indexOf(","));
                        parsedValues = parsedValues.substring(parsedValues.indexOf(",") + 1);
                    }
                    if ((st1 = new StringTokenizer(parsedValues, ",")).countTokens() == 4) {
                        double l1 = Double.parseDouble(st1.nextToken().trim());
                        double l2 = Double.parseDouble(st1.nextToken().trim());
                        double l3 = Double.parseDouble(st1.nextToken().trim());
                        String gcType = st1.nextToken().trim();
                        NumberFormat form = NumberFormat.getInstance();
                        form.setMaximumFractionDigits(3);
                        if (gcType.equals("F")) {
                            F_numberOfGc += 1.0;
                            F_totalHeapSizeBefore += l1;
                            F_totalHeapSizeAfter += l2;
                            F_totalGcTime += l3;
                            if (l3 > F_maxGcPause) {
                                F_maxGcPause = l3;
                            }
                            if (!this.JVM_Version.startsWith("1.3")) {
                                heapBefore = this.filterComma(form.format(this.convertToMBs(String.valueOf(l1))));
                                heapAfter = this.filterComma(form.format(this.convertToMBs(String.valueOf(l2))));
                                totalGC = this.filterComma(form.format(l3));
                                fullGc_dd.add(String.valueOf(timestamp) + "," + heapBefore + "(MB)," + heapAfter + "(MB)," + totalGC + "(Secs)");
                            } else {
                                heapBefore = this.filterComma(form.format(this.convertToMBs(String.valueOf(l1))));
                                heapAfter = this.filterComma(form.format(this.convertToMBs(String.valueOf(l2))));
                                totalGC = this.filterComma(form.format(l3));
                                fullGc_dd.add("NONE," + heapBefore + "(MB)," + heapAfter + "(MB)," + totalGC + "(Secs)");
                            }
                        } else {
                            M_numberOfGc += 1.0;
                            M_totalHeapSizeBefore += l1;
                            M_totalHeapSizeAfter += l2;
                            M_totalGcTime += l3;
                            if (l3 > M_maxGcPause) {
                                M_maxGcPause = l3;
                            }
                            if (!this.JVM_Version.startsWith("1.3")) {
                                heapBefore = this.filterComma(form.format(this.convertToMBs(String.valueOf(l1))));
                                heapAfter = this.filterComma(form.format(this.convertToMBs(String.valueOf(l2))));
                                totalGC = this.filterComma(form.format(l3));
                                minorGc_dd.add(String.valueOf(timestamp) + "," + heapBefore + "(MB)," + heapAfter + "(MB)," + totalGC + "(Secs)");
                            } else {
                                heapBefore = this.filterComma(form.format(this.convertToMBs(String.valueOf(l1))));
                                heapAfter = this.filterComma(form.format(this.convertToMBs(String.valueOf(l2))));
                                totalGC = this.filterComma(form.format(l3));
                                minorGc_dd.add("NONE," + heapBefore + "(MB)," + heapAfter + "(MB)," + totalGC + "(Secs)");
                            }
                        }
                    }
                    ++i;
                }
                ArrayList<Double> al = null;
                if (F_numberOfGc > 0.0) {
                    double F_averageGcPause = F_totalGcTime / F_numberOfGc;
                    double averageGCFrequency = this.timeSinceLastTest / F_numberOfGc;
                    al = new ArrayList<Double>();
                    al.add(new Double(F_numberOfGc));
                    al.add(new Double(F_totalGcTime));
                    al.add(new Double(averageGCFrequency));
                    al.add(new Double(F_averageGcPause));
                    al.add(new Double(F_averageGcPause / averageGCFrequency * 100.0));
                    al.add(new Double(F_maxGcPause));
                    al.add(new Double(F_totalHeapSizeBefore / F_numberOfGc / 1024.0));
                    al.add(new Double(F_totalHeapSizeAfter / F_numberOfGc / 1024.0));
                    if (displayLabel.equals("NONE")) {
                        this.addNewMeasure("[Full GC]", al);
                    } else {
                        this.addNewMeasure(String.valueOf(displayLabel) + "[Full GC]", al);
                    }
                } else if (F_numberOfGc == 0.0) {
                    this.uploadValues(displayLabel, "[Full GC]", 0);
                }
                if (M_numberOfGc > 0.0) {
                    double M_averageGcPause = M_totalGcTime / M_numberOfGc;
                    double averageGCFrequency = this.timeSinceLastTest / M_numberOfGc;
                    al = new ArrayList();
                    al.add(new Double(M_numberOfGc));
                    al.add(new Double(M_totalGcTime));
                    al.add(new Double(averageGCFrequency));
                    al.add(new Double(M_averageGcPause));
                    al.add(new Double(M_averageGcPause / averageGCFrequency * 100.0));
                    al.add(new Double(M_maxGcPause));
                    al.add(new Double(M_totalHeapSizeBefore / M_numberOfGc / 1024.0));
                    al.add(new Double(M_totalHeapSizeAfter / M_numberOfGc / 1024.0));
                    if (displayLabel.equals("NONE")) {
                        this.addNewMeasure("[Minor GC]", al);
                    } else {
                        this.addNewMeasure(String.valueOf(displayLabel) + "[Minor GC]", al);
                    }
                } else if (M_numberOfGc == 0.0) {
                    this.uploadValues(displayLabel, "[Minor GC]", 0);
                }
                this.prev_infoFileName.put(displayLabel, f.toString());
            }
            return;
        }
        if (this.mode_type.equalsIgnoreCase("Jmx")) {
            Hashtable gcInfo = null;
            JvmHelperThread helperThread = new JvmHelperThread(this.entity, this, this.urlStr, this.userName, this.password);
            long totalSleepTime = 0L;
            long tt = this.timeout;
            long sleepTime = 250L;
            int ccount = 0;
            int statusCode = 0;
            long sstime = System.currentTimeMillis();
            boolean statusFlag = false;
            while (true) {
                this.suspendForPeriod(sleepTime);
                if (helperThread.isDone()) {
                    statusCode = helperThread.getStatusCode();
                    statusFlag = helperThread.isStatus();
                    gcInfo = helperThread.getResult();
                    break;
                }
                if (++ccount >= 5) {
                    ccount = 0;
                    totalSleepTime = System.currentTimeMillis() - sstime;
                } else {
                    totalSleepTime += sleepTime;
                }
                if (totalSleepTime >= tt || sleepTime <= 0L) {
                    helperThread.closeJVMconnectionWhenInterrupt();
                    break;
                }
                long remain = tt - totalSleepTime;
                if (remain >= sleepTime) continue;
                sleepTime = remain;
            }
            if (statusCode != 100 || !statusFlag) return;
            try {
                this.getMeasures(gcInfo);
                return;
            }
            catch (Exception e) {
                System.out.println(String.valueOf(e.toString()) + " in " + this.entity + " JMX mode...");
                e.printStackTrace();
            }
            return;
        }
        if (!this.mode_type.equalsIgnoreCase("Jar")) return;
        Hashtable<String, Hashtable> finalResult = new Hashtable<String, Hashtable>();
        Hashtable collectorNameHash = null;
        try {
            Hashtable resultTable;
            ArrayList resultInfo = this.getJarModeData();
            if (resultInfo != null && resultInfo.size() > 0 && (resultTable = (Hashtable)resultInfo.get(0)) != null) {
                collectorNameHash = (Hashtable)resultTable.get("collectorNames");
            }
            if (collectorNameHash == null || collectorNameHash.size() <= 0) return;
            Set keySet = collectorNameHash.keySet();
            Iterator iter = keySet.iterator();
            String prevCounts = this.getPreviousValue();
            StringBuilder currCountBuilder = new StringBuilder();
            HashMap<String, String> previousDetails = new HashMap<String, String>();
            if (prevCounts != null && prevCounts.length() > 0) {
                try {
                    StringTokenizer stc = new StringTokenizer(prevCounts, "#");
                    while (stc.hasMoreTokens()) {
                        String tok = stc.nextToken();
                        if (tok == null || tok.indexOf("|") <= -1) continue;
                        String name = tok.substring(0, tok.indexOf("|"));
                        String value = tok.substring(tok.indexOf("|") + 1);
                        previousDetails.put(name, value);
                    }
                }
                catch (Exception stc) {}
            }
            while (iter.hasNext()) {
                int len;
                long collectionCount;
                String collectorName;
                Hashtable localHt;
                Hashtable data;
                block70: {
                    block69: {
                        String colname = iter.next().toString();
                        if (colname == null || colname.length() <= 0) continue;
                        data = (Hashtable)collectorNameHash.get(colname);
                        long startTime = 0L;
                        long endTime = 0L;
                        localHt = new Hashtable();
                        collectorName = null;
                        try {
                            collectorName = data.get("collectorName").toString();
                            if (collectorName == null) {
                            }
                            break block69;
                        }
                        catch (Exception ee) {
                            System.out.println("[JvmMemPoolGCTest] collectorName is not available in the result data " + data);
                        }
                        continue;
                    }
                    collectionCount = 0L;
                    try {
                        if (!data.containsKey("CollectionCount")) break block70;
                        collectionCount = (Long)data.get("CollectionCount");
                        long prevCount = 0L;
                        String previousValue = (String)previousDetails.get(collectorName);
                        if (previousValue != null) {
                            try {
                                prevCount = Long.parseLong(previousValue);
                            }
                            catch (Exception M_totalHeapSizeBefore) {
                                // empty catch block
                            }
                        }
                        long collectionsCnt = 0L;
                        if (prevCount > 0L && prevCount <= collectionCount) {
                            collectionsCnt = collectionCount - prevCount;
                        }
                        localHt.put("CollectionCount", new Long(collectionsCnt));
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                }
                if ((len = currCountBuilder.length()) > 0) {
                    currCountBuilder.append("#");
                }
                currCountBuilder.append(collectorName).append("|").append(collectionCount);
                Hashtable fullGcTable = (Hashtable)data.get("fullGcTable");
                if (fullGcTable == null || fullGcTable.size() == 0) continue;
                String[] memoryPoolNames = null;
                try {
                    memoryPoolNames = (String[])data.get("memoryPoolNames");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                localHt = JvmMemPoolGCTest.getDataFromFullGCTable(fullGcTable, localHt, memoryPoolNames);
                finalResult.put(collectorName, localHt);
            }
            this.setCurrentValue(currCountBuilder.toString());
            this.getMeasures(finalResult);
            return;
        }
        catch (Exception e) {
            System.out.println(String.valueOf(e.toString()) + " in " + this.entity + " JAR mode...");
            e.printStackTrace();
        }
    }

    public void getMeasures(Hashtable resultHashTable) {
        try {
            if (resultHashTable != null && resultHashTable.size() > 0) {
                Enumeration keys = resultHashTable.keys();
                while (keys.hasMoreElements()) {
                    Hashtable ht1;
                    String infoStr = "";
                    String key = (String)keys.nextElement();
                    if (key != null) {
                        infoStr = String.valueOf(key) + ":";
                    }
                    if ((ht1 = (Hashtable)resultHashTable.get(key)) == null) continue;
                    double startTime = ((Long)ht1.get("startTime")).doubleValue();
                    double endTime = ((Long)ht1.get("endTime")).doubleValue();
                    double collectionCount = ((Long)ht1.get("CollectionCount")).doubleValue();
                    double pct_collected = -5.0;
                    double gcTime = -5.0;
                    double memInitB4Gc = -5.0;
                    double memInitArGc = -5.0;
                    double memMaxB4Gc = -5.0;
                    double memMaxArGc = -5.0;
                    double memCommittedB4Gc = -5.0;
                    double memCommittedArGc = -5.0;
                    double memUsedB4Gc = -5.0;
                    double memUsedArGc = -5.0;
                    double hasCollHappened = 0.0;
                    if (!ht1.containsKey("memoryBeforeGc") || !ht1.containsKey("memoryAfterGc")) continue;
                    Hashtable ht2 = (Hashtable)ht1.get("memoryBeforeGc");
                    Hashtable ht3 = (Hashtable)ht1.get("memoryAfterGc");
                    Set memPools = ht2.keySet();
                    Iterator itr = memPools.iterator();
                    while (itr.hasNext()) {
                        ArrayList<Double> measures = new ArrayList<Double>();
                        String poolName = (String)itr.next();
                        if (poolName == null) continue;
                        String info = String.valueOf(infoStr) + poolName;
                        if (collectionCount > 0.0) {
                            hasCollHappened = 1.0;
                            gcTime = (endTime - startTime) / 1000.0;
                            Hashtable memBefore = (Hashtable)ht2.get(poolName);
                            Hashtable memAfter = (Hashtable)ht3.get(poolName);
                            Long tmp = (Long)memBefore.get("init");
                            String strTmp = tmp.toString();
                            strTmp = EgUtils.convertMemoryValues(strTmp, "B", "MB");
                            memInitB4Gc = Double.parseDouble(strTmp);
                            tmp = (Long)memAfter.get("init");
                            strTmp = tmp.toString();
                            strTmp = EgUtils.convertMemoryValues(strTmp, "B", "MB");
                            memInitArGc = Double.parseDouble(strTmp);
                            tmp = (Long)memBefore.get("max");
                            strTmp = tmp.toString();
                            strTmp = EgUtils.convertMemoryValues(strTmp, "B", "MB");
                            memMaxB4Gc = Double.parseDouble(strTmp);
                            tmp = (Long)memAfter.get("max");
                            strTmp = tmp.toString();
                            strTmp = EgUtils.convertMemoryValues(strTmp, "B", "MB");
                            memMaxArGc = Double.parseDouble(strTmp);
                            tmp = (Long)memBefore.get("committed");
                            strTmp = tmp.toString();
                            strTmp = EgUtils.convertMemoryValues(strTmp, "B", "MB");
                            memCommittedB4Gc = Double.parseDouble(strTmp);
                            tmp = (Long)memAfter.get("committed");
                            strTmp = tmp.toString();
                            strTmp = EgUtils.convertMemoryValues(strTmp, "B", "MB");
                            memCommittedArGc = Double.parseDouble(strTmp);
                            tmp = (Long)memBefore.get("used");
                            strTmp = tmp.toString();
                            strTmp = EgUtils.convertMemoryValues(strTmp, "B", "MB");
                            memUsedB4Gc = Double.parseDouble(strTmp);
                            tmp = (Long)memAfter.get("used");
                            strTmp = tmp.toString();
                            memUsedArGc = Double.parseDouble(strTmp = EgUtils.convertMemoryValues(strTmp, "B", "MB"));
                            pct_collected = memUsedB4Gc > memUsedArGc ? (memUsedB4Gc - memUsedArGc) / memMaxB4Gc * 100.0 : -5.0;
                            measures.add(new Double(hasCollHappened));
                            measures.add(new Double(collectionCount));
                            measures.add(new Double(memInitB4Gc));
                            measures.add(new Double(memInitArGc));
                            measures.add(new Double(memMaxB4Gc));
                            measures.add(new Double(memMaxArGc));
                            measures.add(new Double(memCommittedB4Gc));
                            measures.add(new Double(memCommittedArGc));
                            measures.add(new Double(memUsedB4Gc));
                            measures.add(new Double(memUsedArGc));
                            measures.add(new Double(pct_collected));
                            measures.add(new Double(gcTime));
                            this.addNewMeasure(info, measures);
                            continue;
                        }
                        measures.add(new Double(hasCollHappened));
                        measures.add(new Double(collectionCount));
                        measures.add(new Double(memInitB4Gc));
                        measures.add(new Double(memInitArGc));
                        measures.add(new Double(memMaxB4Gc));
                        measures.add(new Double(memMaxArGc));
                        measures.add(new Double(memCommittedB4Gc));
                        measures.add(new Double(memCommittedArGc));
                        measures.add(new Double(memUsedB4Gc));
                        measures.add(new Double(memUsedArGc));
                        measures.add(new Double(pct_collected));
                        measures.add(new Double(gcTime));
                        this.addNewMeasure(info, measures);
                    }
                }
            } else {
                this.measures.add(new Double(-5.0));
                this.measures.add(new Double(-5.0));
                this.measures.add(new Double(-5.0));
                this.measures.add(new Double(-5.0));
                this.measures.add(new Double(-5.0));
                this.measures.add(new Double(-5.0));
                this.measures.add(new Double(-5.0));
                this.measures.add(new Double(-5.0));
                this.measures.add(new Double(-5.0));
                this.measures.add(new Double(-5.0));
                this.measures.add(new Double(-5.0));
                this.measures.add(new Double(-5.0));
                this.addNewMeasure(this.measures);
            }
        }
        catch (Exception e) {
            System.out.println(String.valueOf(e.toString()) + " in " + this.entity + " " + this.mode_type + " mode...");
            e.printStackTrace();
        }
    }

    private String filterComma(String str) {
        StringBuffer sb = new StringBuffer(str);
        while (str.indexOf(",") > -1) {
            sb = sb.deleteCharAt(str.indexOf(","));
            str = sb.toString();
        }
        return str;
    }

    /*
     * Unable to fully structure code
     */
    private ArrayList getGCOutputFromLogFile(File f, ArrayList patterns, String key) {
        block23: {
            logFileTimestamp = f.lastModified();
            logFileSize = f.length();
            s = (String)this.logFileSizeLast.get(key);
            logFileSize_last = 0L;
            logFileTimestamp_last = 0L;
            if (s != null) {
                logFileSize_last = Long.parseLong(s);
            }
            if ((s = (String)this.logFileTimestampLast.get(key)) != null) {
                logFileTimestamp_last = Long.parseLong(s);
            }
            if (logFileTimestamp == logFileTimestamp_last && logFileSize == logFileSize_last) {
                return null;
            }
            if (logFileSize < logFileSize_last) {
                logFileSize_last = logFileSize;
            }
            gcOutput = new ArrayList<String>();
            try {
                try {
                    lfr = new LogFileReader(f, logFileSize_last);
                    line = "";
                    if (!this.JVM_Version.startsWith("1.3")) ** GOTO lbl68
                    block7: while ((line = lfr.readLine()) != null) {
                        if (line.indexOf("[GC") <= -1 && line.indexOf("[Full GC ") <= -1) continue;
                        if (line.indexOf("->") > -1) {
                            gcOutput.add(line);
                            continue;
                        }
                        isItFullGC = false;
                        if (line.indexOf("[Full GC") > -1) {
                            isItFullGC = true;
                        }
                        while ((line = lfr.readLine()) != null) {
                            if (line.indexOf("->") <= -1) continue;
                            line = isItFullGC != false ? "[Full GC " + line : "[GC " + line;
                            gcOutput.add(line);
                            continue block7;
                        }
                    }
                    break block23;
lbl-1000:
                    // 1 sources

                    {
                        if (line.indexOf("[GC") <= -1 && line.indexOf("[Full GC ") <= -1 && line.indexOf("[Full GC") <= -1) continue;
                        if (line.indexOf("->") > -1) {
                            gcOutput.add(line);
                            continue;
                        }
                        isItFullGC = false;
                        if (line.indexOf("[Full GC") > -1) {
                            isItFullGC = true;
                        }
                        timeStamp = null;
                        if (!line.startsWith("[GC") && !line.startsWith("[Full GC")) {
                            tmpString1 = null;
                            GCType = ": [GC ";
                            if (isItFullGC) {
                                GCType = ": [Full GC ";
                            }
                            if ((indexWhereTimeStampEnds = line.indexOf(GCType)) > -1) {
                                tmpString1 = line.substring(0, indexWhereTimeStampEnds);
                                indexWhereTimeStampStarts = tmpString1.lastIndexOf(" ");
                                timeStamp = indexWhereTimeStampStarts > -1 ? tmpString1.substring(indexWhereTimeStampStarts + 1, indexWhereTimeStampEnds) : tmpString1.substring(0, indexWhereTimeStampEnds);
                            }
                            if (timeStamp != null) {
                                try {
                                    Double.parseDouble(timeStamp);
                                }
                                catch (NumberFormatException nfe) {
                                    timeStamp = null;
                                }
                            }
                        }
                        while ((line = lfr.readLine()) != null) {
                            if (line.indexOf("->") <= -1) continue;
                            line = isItFullGC ? (timeStamp != null ? String.valueOf(timeStamp) + ":[Full GC " + line : "[Full GC " + line) : (timeStamp != null ? String.valueOf(timeStamp) + ":[GC " + line : "[GC " + line);
                            gcOutput.add(line);
                            continue block9;
                        }
lbl68:
                        // 5 sources

                        ** while ((line = lfr.readLine()) != null)
                    }
lbl69:
                    // 1 sources

                }
                catch (IOException ex) {
                    System.out.println("Error while skipping N char in the file:" + ex.toString());
                    this.logFileTimestampLast.put(key, String.valueOf(logFileTimestamp));
                    this.logFileSizeLast.put(key, String.valueOf(logFileSize));
                }
            }
            finally {
                this.logFileTimestampLast.put(key, String.valueOf(logFileTimestamp));
                this.logFileSizeLast.put(key, String.valueOf(logFileSize));
            }
        }
        return gcOutput;
    }

    private String parseValues(String line) {
        String GCType = "M";
        if (line.indexOf("[Full GC") > -1) {
            GCType = "F";
        }
        int positionOfArrow = 0;
        positionOfArrow = line.lastIndexOf("K->");
        if (positionOfArrow == -1) {
            return null;
        }
        String beforeGC = line.substring(0, positionOfArrow);
        int endOfJunk = beforeGC.lastIndexOf(" ");
        if (endOfJunk == -1) {
            return null;
        }
        beforeGC = beforeGC.substring(endOfJunk);
        String tmp = line.substring(positionOfArrow + 3);
        int endOfAfterGC = tmp.indexOf("K(");
        if (endOfAfterGC == -1) {
            return null;
        }
        String afterGC = tmp.substring(0, endOfAfterGC);
        int endOfHeapSize = tmp.indexOf(" ");
        int endOfGCTime = (tmp = tmp.substring(endOfHeapSize + 1)).indexOf(" secs]");
        if (endOfGCTime == -1) {
            return null;
        }
        String GCTime = tmp.substring(0, endOfGCTime);
        String toBeReturned = "";
        if (this.JVM_Version.startsWith("1.3")) {
            toBeReturned = String.valueOf(beforeGC) + "," + afterGC + "," + GCTime + "," + GCType;
        } else {
            String timestamp = "NONE";
            if (line.indexOf(":") > -1) {
                timestamp = line.substring(0, line.indexOf(":"));
            }
            toBeReturned = String.valueOf(timestamp) + "," + beforeGC.trim() + "," + afterGC + "," + GCTime + "," + GCType;
        }
        return toBeReturned;
    }

    private String getJVMVersion(String jdkHome) {
        System.out.println("jdkHome is : " + jdkHome);
        jdkHome = jdkHome.endsWith(System.getProperty("file.separator")) ? jdkHome : String.valueOf(jdkHome) + System.getProperty("file.separator");
        String java = String.valueOf(jdkHome) + "bin" + System.getProperty("file.separator") + "java";
        System.out.println("java is " + java);
        String os = System.getProperty("os.name").toLowerCase();
        String javaWithQuates = "\"" + java + "\"";
        File f = new File(java);
        System.out.println("java now is " + java);
        if (!f.exists() && !(f = new File(String.valueOf(java) + ".exe")).exists()) {
            System.out.println("Java executable is not found at " + f.toString());
            return "-1";
        }
        String command = "";
        if (System.getProperty("os.name").toLowerCase().indexOf("win") > -1) {
            command = "cmd /c ";
            java = "\"" + java + "\"";
        }
        command = String.valueOf(command) + java + " -version";
        try {
            String line;
            Runtime r = Runtime.getRuntime();
            Process p = r.exec(command);
            EgStreamReaderThread inputStream = new EgStreamReaderThread(p.getInputStream());
            EgStreamReaderThread errorStream = new EgStreamReaderThread(p.getErrorStream());
            inputStream.start();
            errorStream.start();
            p.waitFor();
            ArrayList outData = inputStream.getData();
            String version = null;
            int tmp = outData.size();
            int i = 0;
            while (i < tmp) {
                line = (String)outData.get(i);
                System.out.println("Line : " + line);
                if (line.startsWith("java version")) {
                    version = line.substring(line.indexOf("\"") + 1, line.length() - 2);
                    break;
                }
                ++i;
            }
            outData = errorStream.getData();
            tmp = outData.size();
            i = 0;
            while (i < tmp) {
                line = (String)outData.get(i);
                System.out.println("Line 111 : " + line);
                if (line.startsWith("java version")) {
                    version = line.substring(line.indexOf("\"") + 1, line.length() - 2);
                    break;
                }
                ++i;
            }
            return version;
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "-1";
    }

    private void uploadValues(String label, String descriptor, int i) {
        ArrayList<Double> al = new ArrayList<Double>();
        Double tmp = new Double(i);
        al.add(tmp);
        al.add(tmp);
        al.add(tmp);
        al.add(tmp);
        al.add(tmp);
        al.add(tmp);
        al.add(tmp);
        al.add(tmp);
        if (label.equals("NONE")) {
            this.addNewMeasure(descriptor, al);
        } else {
            this.addNewMeasure(String.valueOf(label) + descriptor, al);
        }
    }

    protected double convertToMBs(String valueInKB) {
        try {
            double d = Double.parseDouble(valueInKB);
            return d / 1024.0;
        }
        catch (NumberFormatException nfe) {
            return -1.0;
        }
    }
}

