/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

class MPTaskStackTest
extends EgSnmpGenericTest {
    private static final int MPTASKSTACKTEST_MEASURE = 4;

    public MPTaskStackTest(String[] stringArray) {
        super(stringArray);
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
        this.setMeasureCount(4);
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            Hashtable hashtable2 = this.getMeasure(".1.3.6.1.4.1.5651.3.20.1.1.2.1.1.1");
            Hashtable hashtable3 = this.getMeasure(".1.3.6.1.4.1.5651.3.20.1.1.2.1.1.11");
            Hashtable hashtable4 = this.getMeasure(".1.3.6.1.4.1.5651.3.20.1.1.2.1.1.12");
            if (hashtable2 == null || hashtable2.isEmpty() || hashtable2.size() == 0) {
                this.logToErrorFile("Info", this.entity + ",No data available for Info", this.targetHost);
                return;
            }
            Enumeration enumeration = hashtable2.keys();
            while (enumeration != null && enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable2.get(string);
                String string3 = (String)hashtable3.get(string);
                String string4 = (String)hashtable4.get(string);
                double d = this.stringToDouble(string3);
                double d2 = this.stringToDouble(string4);
                double d3 = -5.0;
                double d4 = -5.0;
                if (d2 >= 0.0 && d > 0.0) {
                    d3 = d - d2;
                    if (d3 < 0.0) {
                        d3 = -5.0;
                    }
                    d4 = Math.round(d2 / d * 100.0);
                } else {
                    d = -5.0;
                    d2 = -5.0;
                }
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(d));
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d4));
                this.addNewMeasure(string2, arrayList);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error:", this.entity + ",Error occur in compute measure", exception.toString());
            exception.printStackTrace();
        }
    }

    private double stringToDouble(String string) {
        double d = -5.0;
        if (string != null && string.trim().length() > 0) {
            try {
                d = Double.parseDouble(string);
            }
            catch (Exception exception) {
                d = -5.0;
                exception.printStackTrace();
            }
        }
        return d;
    }

    public Hashtable getMeasure(String string) {
        boolean bl = this.runSnmpCmdForOid(string);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = "";
        String string3 = "";
        try {
            if (bl) {
                for (int i = 0; i < this.lhs.length; ++i) {
                    if (this.lhs[i].startsWith(".")) continue;
                    string2 = this.lhs[i];
                    string3 = this.rhs[i];
                    hashtable.put(string2, string3);
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error:", this.entity + ",Error occur in getmeasure", exception.toString());
            exception.printStackTrace();
        }
        return hashtable;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host", "192.168.8.247", "-port", "NULL", "-snmpPort", "161", "-snmpversion", "v1", "-snmpCommunity", "public"};
        MPTaskStackTest mPTaskStackTest = new MPTaskStackTest(stringArray2);
        mPTaskStackTest.computeMeasures(new Hashtable());
    }
}

