/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IPV6Helper;
import com.egurkha.util.EgUtilities;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class MsSqlValidator
extends EgServerValidator {
    public String reportingName = "";
    public String test = "";
    public String host = "";
    public String port = "";
    public String sid = "";
    public String user = "";
    public String password = "";
    public String domain = "";
    public String isAgentLess = "";
    public String oracle_homeDir = "";
    public String alMode = "";
    public String alUser = "";
    public String alPassword = "";
    public String NTLMv2 = "";
    public String sqlVersion = "";
    public boolean isConnectivityOk = true;
    public boolean isSqlInstanceOk = false;
    public boolean isTableInfoComing = true;
    public boolean isExternalTest = false;
    public boolean isAdminRole = true;
    public boolean meAgentLess = false;
    public boolean isNTLMv2 = false;
    public boolean isSystemAdminRole = false;
    private String instance = "default";
    private String ssl = "false";
    private String dbName = "master";
    public String connectivityMsg = "";
    public String subject = "WORKING_TESTS";
    public String key = "";
    public String errorMsg = "error";
    public String validationMsg = "";
    public String validationErrorMsg = "";
    public boolean isFromManager = false;
    public boolean isTargetIp = true;
    public ArrayList validationMsgs = null;
    public Hashtable validationErrorMap = new Hashtable();
    private boolean isInstanceBased = false;
    private boolean isPrivilegeFailed = false;

    public MsSqlValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = string.substring(0, string.indexOf(":"));
                String string3 = string.substring(string.indexOf(":") + 1);
                if ((string2 = string2.trim()) != null && string2.equalsIgnoreCase("-host")) {
                    this.host = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-port")) {
                    this.port = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-instance")) {
                    this.instance = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-rptname")) {
                    this.reportingName = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-test")) {
                    this.test = string3;
                    String string4 = string3.substring(0, string3.indexOf("@"));
                    if (!string4.equalsIgnoreCase("MsSqlSpaceTest") && !string4.equalsIgnoreCase("MsSqlEngineTest")) continue;
                    this.isSystemAdminRole = true;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-user")) {
                    this.user = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-password")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.password = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-domain")) {
                    this.domain = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-agentless")) {
                    this.isAgentLess = string3;
                    if (this.isAgentLess != null && this.isAgentLess.equalsIgnoreCase("y")) {
                        this.meAgentLess = true;
                        continue;
                    }
                    this.isAgentLess = "false";
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-almode")) {
                    this.alMode = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-aluser")) {
                    this.alUser = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-alpassword")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.alPassword = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-ssl")) {
                    this.ssl = string3;
                    continue;
                }
                if (string2 == null || !string2.equalsIgnoreCase("-isntlmv2")) continue;
                this.NTLMv2 = string3;
                if (this.NTLMv2 == null || !this.NTLMv2.trim().equalsIgnoreCase("true") && !this.NTLMv2.trim().equalsIgnoreCase("yes")) continue;
                this.isNTLMv2 = true;
            }
        }
        if (!this.isIpAddress(this.host)) {
            this.isTargetIp = false;
        }
        this.key = this.test + "#~#" + this.reportingName + ":" + this.port + ":" + this.instance;
        this.validationMsgs = new ArrayList();
        this.validate();
        this.isFromManager = bl;
    }

    public void validate() {
        try {
            if (!this.checkMsSqlConnectivity()) {
                this.subject = "ERROR_TESTS";
                this.logMsgToStatusFile(this.subject, this.key, this.errorMsg);
                if (this.isInstanceBased) {
                    if (!this.isIPReachable()) {
                        this.validationMsgs.add("SQL Server Connectivity$#$Failed");
                        this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + this.host + "' is invalid or Host IP/Name is unreachable");
                        this.validationMsgs.add("Port$#$NA");
                    } else if (this.isPrivilegeFailed) {
                        this.validationMsgs.add("SQL Server Connectivity$#$OK");
                        this.validationMsgs.add("Host IP/Name$#$OK");
                        this.validationMsgs.add("Port$#$NA");
                        String string = (String)this.validationErrorMap.get("Sql_Connectivity");
                        this.validationMsgs.add("Privilege Validation$#$" + string);
                        this.validationMsgs.add("INFO:$#$Specific Msg:Refer the pre-requisities for monitoring SQL SERVER");
                    } else {
                        String string = (String)this.validationErrorMap.get("Sql_Connectivity");
                        this.validationMsgs.add("SQL Server Connectivity$#$" + string);
                        this.validationMsgs.add("Host IP/Name$#$OK");
                        this.validationMsgs.add("Port$#$NA");
                    }
                } else if (!this.isIPReachable()) {
                    this.validationMsgs.add("SQL Server Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + this.host + "' is invalid or Host IP/Name is unreachable");
                    this.validationMsgs.add("Port$#$NA");
                } else if (this.port != null && !this.port.equalsIgnoreCase("NULL") && !this.isPortReachable()) {
                    this.validationMsgs.add("SQL Server Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$Port settings is incorrect or doesn't exist");
                } else if (this.isPrivilegeFailed) {
                    this.validationMsgs.add("SQL Server Connectivity$#$OK");
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$OK");
                    String string = (String)this.validationErrorMap.get("Sql_Connectivity");
                    this.validationMsgs.add("Privilege Validation$#$" + string);
                    this.validationMsgs.add("INFO:$#$Specific Msg:Refer the pre-requisities for monitoring SQL SERVER");
                } else {
                    String string = (String)this.validationErrorMap.get("Sql_Connectivity");
                    this.validationMsgs.add("SQL Server Connectivity$#$" + string);
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$OK");
                }
                if (!this.isFromManager) {
                    return;
                }
            } else {
                this.validationMsgs.add("SQL Server Connectivity$#$OK");
                this.validationMsgs.add("Host IP/Name$#$OK");
                if (this.isInstanceBased) {
                    this.validationMsgs.add("Port$#$NA");
                } else {
                    this.validationMsgs.add("Port$#$OK");
                }
                this.validationMsgs.add("Privilege Validation$#$OK");
                String string = (String)this.validationErrorMap.get("Sql_Connectivity");
                if (string != null && string.trim().length() > 0) {
                    this.validationMsgs.add("INFO:$#$Specific Msg:" + string);
                }
            }
            this.logMsgToStatusFile(this.subject, this.key, "OK#" + this.getCurrentTime());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkMsSqlConnectivity() {
        String string;
        String string2;
        String string3;
        this.host = IPV6Helper.getValidIPAddress(this.host);
        boolean bl = false;
        boolean bl2 = false;
        String string4 = "";
        ResultSet resultSet = null;
        Statement statement = null;
        Connection connection = null;
        String string5 = "";
        String string6 = "";
        String string7 = "SELECT IS_SRVROLEMEMBER('sysadmin')";
        try {
            String string8;
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
            Properties properties = new Properties();
            if (!this.domain.equalsIgnoreCase("none")) {
                properties.put("user", this.user);
                properties.put("password", this.password);
                properties.put("domain", this.domain);
                properties.put("useNTLMv2", this.isNTLMv2 + "");
            } else {
                properties.put("user", this.user);
                properties.put("password", this.password);
            }
            if (this.instance == null || this.instance.length() == 0 || this.instance.equalsIgnoreCase("default") || this.instance.equalsIgnoreCase("none")) {
                string5 = "jdbc:jtds:sqlserver://" + this.host + ":" + this.port + "/" + this.dbName;
            } else {
                this.isInstanceBased = true;
                if (this.port == null || this.port.equalsIgnoreCase("NULL")) {
                    string5 = "jdbc:jtds:sqlserver://" + this.host + "/" + this.dbName + ";INSTANCE=" + this.instance;
                } else {
                    string5 = "jdbc:jtds:sqlserver://" + this.host + "/" + this.dbName + ";INSTANCE=" + this.instance;
                    if ("true".equalsIgnoreCase(this.ssl)) {
                        string5 = string5 + ";ssl=request";
                    }
                    string6 = string5;
                    try {
                        connection = DriverManager.getConnection(string6, properties);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (connection == null) {
                        string5 = "jdbc:jtds:sqlserver://" + this.host + ":" + this.port + "/" + this.dbName;
                    }
                }
            }
            if (connection == null) {
                if ("true".equalsIgnoreCase(this.ssl)) {
                    string5 = string5 + ";ssl=request";
                }
                string6 = string5;
                connection = DriverManager.getConnection(string6, properties);
            }
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(1);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string7);
            if (resultSet.next() && (string3 = resultSet.getString(1)).equalsIgnoreCase("1")) {
                bl2 = true;
            }
            resultSet.close();
            if (bl2) return this.isConnectivityOk;
            string3 = "SELECT * FROM fn_my_permissions(NULL, 'SERVER')";
            string2 = "select IS_ROLEMEMBER ('db_datareader')";
            try {
                resultSet = statement.executeQuery(string3);
                System.out.println(" MsSqlValidator perQuery :" + string3);
            }
            catch (Exception exception) {
                System.out.println(" MsSqlValidator error in perQuery :" + exception.toString());
                exception.printStackTrace();
            }
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            while (resultSet.next()) {
                string = resultSet.getString(3);
                if (string == null || string.trim().length() == 0) continue;
                if (string.equalsIgnoreCase("VIEW SERVER STATE")) {
                    bl3 = true;
                }
                if (string.equalsIgnoreCase("VIEW ANY DATABASE")) {
                    bl5 = true;
                }
                if (!string.equalsIgnoreCase("VIEW ANY DEFINITION")) continue;
                bl4 = true;
            }
            resultSet.close();
            System.out.println(" MsSqlValidator isViewServerPerm :" + bl3);
            System.out.println(" MsSqlValidator isViewDatabasePerm :" + bl5);
            System.out.println(" MsSqlValidator isViewDefPerm :" + bl4);
            string = "";
            if (!bl3) {
                string = "'VIEW SERVER STATE'";
                System.out.println(" Give Permission to '" + string + "'");
            }
            if (!bl5) {
                string = string != null && string.trim().length() > 0 ? string + ", 'VIEW ANY DATABASE'" : "'VIEW ANY DATABASE'";
                System.out.println(" Give Permission to '" + string + "'");
            }
            if (!bl4) {
                string = string != null && string.trim().length() > 0 ? string + ", 'VIEW ANY DEFINITION'" : "'VIEW ANY DEFINITION'";
                System.out.println(" Give Permission to '" + string + "'");
            }
            System.out.println("MsSqlValidator messageForViewParam :" + string);
            try {
                resultSet = statement.executeQuery(string2);
                System.out.println(" MsSqlValidator rollMemQuery :" + string2);
            }
            catch (Exception exception) {
                System.out.println(" MsSqlValidator error in rollMemQuery :" + exception.toString());
                exception.printStackTrace();
            }
            boolean bl6 = false;
            if (resultSet.next() && (string8 = resultSet.getString(1)).equalsIgnoreCase("1")) {
                bl6 = true;
            }
            resultSet.close();
            statement.close();
            connection.commit();
            connection.close();
            if (string.trim().length() == 0 && !bl6) {
                string = string + "'db_datareader'";
                this.errorMsg = "Coulnot enable " + string.trim() + "#Stack Trace:" + "#" + this.getCurrentTime();
                this.validationErrorMsg = "User '" + this.user + "' doesn't have " + string + " role" + " (Enable db_datareader privilege on each of the databases to be monitored)";
                this.validationErrorMap.put("Sql_Connectivity", this.validationErrorMsg);
                this.isPrivilegeFailed = true;
                boolean bl7 = false;
                return bl7;
            }
            if (string != null && string.trim().length() > 0 && !bl6) {
                string = string + ", 'db_datareader'";
                this.errorMsg = "Coulnot enable " + string.trim() + "#Stack Trace:" + "#" + this.getCurrentTime();
                if (string.trim().length() > 20) {
                    this.validationErrorMsg = "User '" + this.user + "' doesn't have " + string + " roles" + " (Enable db_datareader privilege on each of the databases to be monitored)";
                    this.validationErrorMap.put("Sql_Connectivity", this.validationErrorMsg);
                    this.isPrivilegeFailed = true;
                } else {
                    this.validationErrorMsg = "User '" + this.user + "' doesn't have " + string + " role" + " (Enable db_datareader privilege on each of the databases to be monitored)";
                    this.validationErrorMap.put("Sql_Connectivity", this.validationErrorMsg);
                    this.isPrivilegeFailed = true;
                }
                boolean bl8 = false;
                return bl8;
            }
            if (string != null && string.trim().length() > 0) {
                this.errorMsg = "Coulnot enable " + string.trim() + "#Stack Trace:" + "#" + this.getCurrentTime();
                if (string.trim().length() > 20) {
                    this.validationErrorMsg = "User '" + this.user + "' doesn't have " + string + " roles" + " (Also check db_datareader privilege on each of the databases to be monitored is enabled)";
                    this.validationErrorMap.put("Sql_Connectivity", this.validationErrorMsg);
                    this.isPrivilegeFailed = true;
                } else {
                    this.validationErrorMsg = "User '" + this.user + "' doesn't have " + string + " role" + " (Also check dbdatareader privilege on each of the databases to be monitored is enabled)";
                    this.validationErrorMap.put("Sql_Connectivity", this.validationErrorMsg);
                    this.isPrivilegeFailed = true;
                }
                boolean bl9 = false;
                return bl9;
            }
            this.validationErrorMsg = "Db&#95;datareader privilege on each of the databases to be monitored must be in enabled state";
            this.validationErrorMap.put("Sql_Connectivity", this.validationErrorMsg);
            return this.isConnectivityOk;
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            string2 = sQLException.getMessage();
            this.isConnectivityOk = false;
            String string9 = this.getStackTraceAsString(sQLException);
            switch (n) {
                case 0: {
                    if (string2.indexOf("has no instance") > -1) {
                        string2 = " SQL Instance '" + this.instance + "' not running or unavailable";
                        bl = true;
                        break;
                    }
                    if (string2.indexOf("Unable to get information from SQL Server:") > -1) {
                        string2 = " Unable to get Infomation from SQL server due to some errors";
                        bl = true;
                        break;
                    }
                    if (string2.indexOf("DB server closed connection") > -1) {
                        string2 = "DB server closed connection due to some errors";
                        bl = true;
                        break;
                    }
                    if (string2.indexOf("SQL Server Browser service is not running") <= -1) break;
                    string2 = "SQL Server Browser service is not running or unavailable";
                    bl = true;
                    break;
                }
                case 18456: {
                    System.out.println("inside error code 18456 ");
                    string2 = "Invalid username/password; logon denied";
                    bl = true;
                    break;
                }
                case 18452: {
                    string2 = "Invalid username/password; or Domain Doesn't Exist ; logon denied";
                    bl = true;
                    break;
                }
            }
            string4 = string9.substring(0, string9.indexOf("at"));
            this.validationErrorMsg = bl ? string2.trim() : string4;
            if (this.validationErrorMsg != null && this.validationErrorMsg.indexOf(":") > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.validationErrorMsg, ":");
                StringBuffer stringBuffer = new StringBuffer();
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    stringBuffer.append(string.trim() + " ");
                }
                this.validationErrorMsg = stringBuffer.toString();
                this.validationErrorMsg = this.validationErrorMsg.trim();
            }
            this.validationErrorMap.put("Sql_Connectivity", this.validationErrorMsg);
            this.errorMsg = string2.trim() + "#Stack Trace:" + sQLException.getMessage().trim() + " " + string9.trim() + "#" + this.getCurrentTime();
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                connection.close();
                return this.isConnectivityOk;
            }
            catch (Exception exception) {
                // empty catch block
                return this.isConnectivityOk;
            }
        }
        catch (Exception exception) {
            this.isConnectivityOk = false;
            string3 = this.getStackTraceAsString(exception);
            this.validationErrorMsg = string4;
            this.validationErrorMap.put("Sql_Connectivity", this.validationErrorMsg);
            this.errorMsg = "Stack Trace:" + exception.getMessage().trim() + " " + string3.trim() + "#" + this.getCurrentTime();
            return this.isConnectivityOk;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkMsSqlVersion() {
        this.host = IPV6Helper.getValidIPAddress(this.host);
        ResultSet resultSet = null;
        Statement statement = null;
        Connection connection = null;
        String string = "select @@version";
        String string2 = "Microsoft SQL Server ";
        String string3 = "";
        try {
            String string4;
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
            Properties properties = new Properties();
            if (!this.domain.equalsIgnoreCase("none")) {
                properties.put("user", this.user);
                properties.put("password", this.password);
                properties.put("domain", this.domain);
                properties.put("useNTLMv2", this.isNTLMv2 + "");
            } else {
                properties.put("user", this.user);
                properties.put("password", this.password);
            }
            if (this.instance == null || this.instance.length() == 0 || this.instance.equalsIgnoreCase("default") || this.instance.equalsIgnoreCase("none")) {
                string4 = "jdbc:jtds:sqlserver://" + this.host + ":" + this.port + "/" + this.dbName;
            } else if (this.port == null || this.port.equalsIgnoreCase("NULL")) {
                string4 = "jdbc:jtds:sqlserver://" + this.host + "/" + this.dbName + ";INSTANCE=" + this.instance;
            } else {
                string4 = "jdbc:jtds:sqlserver://" + this.host + ":" + this.port + "/" + this.dbName;
                if ("true".equalsIgnoreCase(this.ssl)) {
                    string4 = string4 + ";ssl=request";
                }
                string3 = string4;
                try {
                    connection = DriverManager.getConnection(string3, properties);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (connection == null) {
                    string4 = "jdbc:jtds:sqlserver://" + this.host + "/" + this.dbName + ";INSTANCE=" + this.instance;
                }
            }
            if (connection == null) {
                if ("true".equalsIgnoreCase(this.ssl)) {
                    string4 = string4 + ";ssl=request";
                }
                string3 = string4;
                connection = DriverManager.getConnection(string3, properties);
            }
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(1);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                string2 = resultSet.getString(1);
            }
            resultSet.close();
            statement.close();
            connection.commit();
            connection.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
            try {
                connection.close();
            }
            catch (Exception exception4) {
                // empty catch block
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return string2;
    }

    public boolean isIpAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return false;
        }
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            try {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 <= 255 && n2 >= 0) continue;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public String getNBTName(String string) {
        EgUtilities egUtilities = EgUtilities.createInstance();
        String string2 = !this.isTargetIp ? "nbtstat -a " + string : "nbtstat -A " + string;
        String string3 = string;
        ArrayList arrayList = egUtilities.getExecOutputLines(string2);
        ArrayList arrayList2 = null;
        String string4 = null;
        if (arrayList != null && (arrayList2 = (ArrayList)arrayList.get(0)) != null) {
            int n = arrayList2.size();
            if (n <= 0) {
                return string3;
            }
            for (int i = 0; i < n; ++i) {
                int n2;
                StringTokenizer stringTokenizer;
                int n3;
                string4 = (String)arrayList2.get(i);
                if (string4 == null || string4.length() == 0 || string4.equalsIgnoreCase("Name") || string4.startsWith("-") || (n3 = (stringTokenizer = new StringTokenizer(string4)).countTokens()) < 3 || string4.indexOf("<00>") <= 0 || string4.indexOf("UNIQUE") <= 0) continue;
                string3 = stringTokenizer.nextToken();
                if (string3.endsWith("<00>")) {
                    n2 = string3.indexOf("<00>");
                    string3 = string3.substring(0, n2);
                }
                if (string3.indexOf("~") >= 0) continue;
                n2 = string3.indexOf("~");
                string3 = string3.toLowerCase().trim();
                break;
            }
        }
        return string3;
    }

    public ArrayList getValidationMsgs() {
        System.out.println("########getting Validation Hashtable---->" + this.validationMsgs);
        return this.validationMsgs;
    }
}

