/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;

public class MySqlTest
extends GenericTest {
    private String st_db = null;
    private String st_userName = null;
    private String st_password = null;
    private double d_availability = -5.0;
    private double d_connectionTime = -5.0;
    private double d_queryTime = -5.0;
    private double d_responseTime = -5.0;
    private double d_connAvailable = -5.0;
    private double d_queryAvailability = -5.0;
    private int d_noOfrecords = -5;
    public ArrayList errorList = new ArrayList();
    private boolean isSSL = false;
    private String trustCertificate = "";
    private String trustCertificatePassword = "";
    private String verifyCA = "";
    private boolean isVerifyCA = false;
    private String keyCertificate = "";
    private String keyCertificatePassword = "";
    private Properties props = new Properties();
    private String mysqlURL = "";
    private String allowPublicKey = null;
    private boolean isAllowPublicKey = false;

    public MySqlTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.st_db = this.getValueForParam("db");
        this.st_userName = this.getValueForParam("userName");
        this.st_password = this.getValueForParam("password");
        String string = this.getValueForParam("ssl");
        this.verifyCA = this.getValueForParam("verify_ca");
        this.trustCertificatePassword = this.getValueForParam("truststore_password");
        this.keyCertificatePassword = this.getValueForParam("keystore_password");
        this.allowPublicKey = this.getValueForParam("allow_public_key");
        this.isAllowPublicKey = this.allowPublicKey != null && (this.allowPublicKey.trim().equalsIgnoreCase("true") || this.allowPublicKey.trim().equalsIgnoreCase("y") || this.allowPublicKey.trim().equalsIgnoreCase("yes"));
        if (string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("y") || string.trim().equalsIgnoreCase("yes"))) {
            this.isSSL = true;
        }
        this.needAgentlessDD = true;
        if (this.verifyCA != null && (this.verifyCA.trim().equalsIgnoreCase("true") || this.verifyCA.trim().equalsIgnoreCase("y") || this.verifyCA.trim().equalsIgnoreCase("yes"))) {
            this.isVerifyCA = true;
        }
        System.out.println(" isSSL ::" + this.isSSL);
        if (this.isSSL) {
            System.out.println(" isVerifyCA ::" + this.isVerifyCA);
            this.mysqlURL = this.isVerifyCA ? "jdbc:mysql://" + this.targetHost + ":" + this.portNo + "/" + this.st_db + "?verifyServerCertificate=true&useSSL=true&requireSSL=true&serverTimezone=UTC" : "jdbc:mysql://" + this.targetHost + ":" + this.portNo + "/" + this.st_db + "?verifyServerCertificate=false&useSSL=true&requireSSL=true&serverTimezone=UTC";
        } else {
            this.mysqlURL = "jdbc:mysql://" + this.targetHost + ":" + this.portNo + "/" + this.st_db + "?useSSL=false&serverTimezone=UTC";
        }
        this.mysqlURL = this.isAllowPublicKey ? this.mysqlURL + "&allowPublicKeyRetrieval=true" : this.mysqlURL + "&allowPublicKeyRetrieval=false";
        this.props.setProperty("user", this.st_userName);
        this.props.setProperty("password", this.st_password);
        if (this.isSSL && this.isVerifyCA) {
            String string2 = System.getProperty("os.name");
            if ((string2 = string2.toLowerCase()).indexOf("win") > -1) {
                this.trustCertificate = EgInstallInfo.getInstallDir() + "\\JRE\\lib\\security\\" + "cacerts";
                this.keyCertificate = EgInstallInfo.getInstallDir() + "\\JRE\\lib\\security\\" + "keystore";
            } else if (string2.indexOf("nix") > -1 || string2.indexOf("nux") > -1 || string2.indexOf("aix") > -1) {
                this.trustCertificate = EgInstallInfo.getInstallDir() + "/JRE/lib/security/" + "cacerts";
                this.keyCertificate = EgInstallInfo.getInstallDir() + "/JRE/lib/security/" + "keystore";
            }
            if (this.trustCertificate == null || this.trustCertificate.equalsIgnoreCase("none") || this.trustCertificate.equalsIgnoreCase("NULL")) {
                this.trustCertificate = "";
                this.logToErrorFile("Error : ", this.entity + "trustCertificate key file is null or empty.", "targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
            }
            if (this.trustCertificatePassword == null || this.trustCertificatePassword.equalsIgnoreCase("none") || this.trustCertificatePassword.equalsIgnoreCase("NULL")) {
                this.trustCertificatePassword = "";
                this.logToErrorFile("Error : ", this.entity + "trustCertificatePassword is null or empty.", "targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
            }
            if (this.keyCertificate == null || this.keyCertificate.equalsIgnoreCase("none") || this.keyCertificate.equalsIgnoreCase("NULL")) {
                this.keyCertificate = "";
            }
            if (this.keyCertificatePassword == null || this.keyCertificatePassword.equalsIgnoreCase("none") || this.keyCertificatePassword.equalsIgnoreCase("NULL")) {
                this.keyCertificatePassword = "";
            }
            this.props.setProperty("trustCertificateKeyStoreUrl", "file:" + this.trustCertificate);
            this.props.setProperty("trustCertificateKeyStorePassword", this.trustCertificatePassword);
            if (this.keyCertificatePassword != null && this.keyCertificatePassword.trim().length() > 0 && this.keyCertificate != null) {
                this.props.setProperty("clientCertificateKeyStoreUrl", "file:" + this.keyCertificate);
                this.props.setProperty("clientCertificateKeyStorePassword", this.keyCertificatePassword);
            }
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        String string;
        this.initialize();
        Connection connection = null;
        long l = 0L;
        Statement statement = null;
        ResultSet resultSet = null;
        boolean bl = true;
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            l = System.currentTimeMillis();
            try {
                connection = DriverManager.getConnection(this.mysqlURL, this.props);
            }
            catch (Exception exception) {
                this.d_connAvailable = 0.0;
                this.d_connectionTime = -5.0;
                bl = false;
                string = EgInstallInfo.getStackTraceAsString(exception).toString();
                this.errorList.add(string);
            }
            if (connection != null) {
                this.d_connAvailable = 100.0;
                long l2 = System.currentTimeMillis();
                this.d_connectionTime = (double)(l2 - l) / 1000.0;
            } else {
                this.d_connAvailable = 0.0;
                this.d_connectionTime = -5.0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
            string = EgInstallInfo.getStackTraceAsString(exception).toString();
            this.errorList.add(string);
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
        if (bl) {
            boolean bl2 = true;
            long l3 = System.currentTimeMillis();
            try {
                statement = connection.createStatement();
                if (statement != null) {
                    resultSet = statement.executeQuery("show status");
                }
                try {
                    while (resultSet.next()) {
                        ++this.d_noOfrecords;
                    }
                }
                catch (Exception exception) {
                    this.d_noOfrecords = 0;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl2 = false;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception4) {
                    // empty catch block
                }
            }
            long l4 = System.currentTimeMillis();
            if (bl2) {
                this.d_queryAvailability = 100.0;
                this.d_queryTime = (double)(l4 - l3) / 1000.0;
                this.d_availability = this.d_connAvailable == 100.0 && this.d_queryAvailability == 100.0 ? 100.0 : 0.0;
                this.d_responseTime = this.d_availability == 100.0 ? (double)(l4 - l) / 1000.0 : -5.0;
            } else {
                this.d_queryAvailability = -5.0;
                this.d_queryTime = -5.0;
            }
        }
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(this.d_availability));
        arrayList.add(new Double(this.d_connectionTime));
        arrayList.add(new Double(this.d_queryTime));
        arrayList.add(new Double(this.d_responseTime));
        if (this.measureCount >= 5) {
            arrayList.add(new Double(this.d_connAvailable));
            arrayList.add(new Double(this.d_queryAvailability));
            arrayList.add(new Double(this.d_noOfrecords));
        }
        System.out.println(" al_measuresToIcMySqlTest :" + arrayList);
        this.addNewMeasure(arrayList);
        arrayList = null;
    }

    private void initialize() {
        this.d_availability = 0.0;
        this.d_connectionTime = -5.0;
        this.d_queryTime = -5.0;
        this.d_responseTime = -5.0;
        this.d_queryAvailability = -5.0;
        this.d_noOfrecords = -5;
    }

    public void freeTest() {
        this.errorList = new ArrayList();
    }
}

