/*
 * Decompiled with CFR 0.152.
 */
import com.eg.snmpgetsubtree;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class NasSnmpTest
extends EgTest {
    int numEngs = 0;
    String[] engNames;
    int[] nasDiffRequests = new int[1];
    double[] nasAvgReqTime = new double[1];
    int[] nasPerActThreads = new int[1];
    int[] nasBytesSent = new int[1];
    int[] nasBytesRecv = new int[1];
    int[] nasEngKesPort = new int[1];
    int[] nasEngPort = new int[1];
    int[] nasThreadsUsed = new int[1];
    int[] nasThreadsIdle = new int[1];
    String mibName;
    public String community = "public";
    public String username = "none";
    public String authPass = "none";
    public String authType = "none";
    public String snmpVersion = "v1";
    public String encryptType = "none";
    public String encryptPass = "none";
    public boolean isEncryptionEnabled = false;
    private String snmpWalkCmd = "snmpgetsubtree";
    private int[] prev_requests = new int[1];
    private int[] prev_bytesSent = new int[1];
    private int[] prev_bytesRecv = new int[1];
    private String nasEngPortOid = ".1.3.6.1.4.1.1450.3.21.1.2";
    private String nasEngKesPortOid = ".1.3.6.1.4.1.1450.3.21.1.1";
    private String nasEngNameOid = ".1.3.6.1.4.1.1450.3.21.1.5";
    private String nasTotRequestsOid = ".1.3.6.1.4.1.1450.3.21.1.13";
    private String nasAvgReqTimeOid = ".1.3.6.1.4.1.1450.3.21.1.17";
    private String nasThreadsUsedOid = ".1.3.6.1.4.1.1450.3.21.1.18";
    private String nasThreadsIdleOid = ".1.3.6.1.4.1.1450.3.21.1.19";
    private String nasBytesSentOid = ".1.3.6.1.4.1.1450.3.21.1.27";
    private String nasBytesRecvOid = ".1.3.6.1.4.1.1450.3.21.1.29";
    private String[] lhs;
    private String[] rhs;
    private int reqsPerSecIndex = 0;
    private int avgReqTimeIndex = 1;
    private int percentActThreadsIndex = 2;
    private int kbytesSentPerSecIndex = 3;
    private int kbytesRecvPerSecIndex = 4;
    private String snmpPortNo = "161";
    int timeOut = 10;

    public NasSnmpTest(String[] stringArray) {
        super(stringArray);
        String string;
        int n;
        this.numOutputFields = 5;
        boolean bl = false;
        if (stringArray.length < 2 || !stringArray[0].equalsIgnoreCase("-host")) {
            System.err.println("Usage: EgSnmpTest -host <targetHost> -port <Port> -snmpPort <snmpPort> -snmpCommunity <community>");
        }
        this.targetHost = new String(stringArray[1]);
        if (stringArray.length > 2) {
            for (n = 2; n < stringArray.length; ++n) {
                if (!stringArray[n].equalsIgnoreCase("-snmpversion")) continue;
                if (++n < stringArray.length) {
                    this.snmpVersion = new String(stringArray[n]);
                    continue;
                }
                System.err.println("Usage: EgSnmpTest -host <targetHost> -port <Port> -snmpPort <snmpPort> -snmpCommunity <community>");
                return;
            }
        }
        if (stringArray.length > 2) {
            for (n = 2; n < stringArray.length; ++n) {
                if (stringArray[n].equalsIgnoreCase("-port")) {
                    if (++n < stringArray.length) {
                        this.portNo = new String(stringArray[n]);
                        continue;
                    }
                    System.err.println("Usage: EgSnmpTest -host <targetHost> -port <Port> -snmpPort <snmpPort> -snmpCommunity <community>");
                    return;
                }
                if (stringArray[n].equalsIgnoreCase("-snmpPort")) {
                    if (++n < stringArray.length) {
                        this.snmpPortNo = new String(stringArray[n]);
                        continue;
                    }
                    System.err.println("Usage: EgSnmpTest -host <targetHost> -port <Port> -snmpPort <snmpPort> -snmpCommunity <community>");
                    return;
                }
                if (stringArray[n].equalsIgnoreCase("-snmpCommunity")) {
                    if (++n < stringArray.length) {
                        this.community = new String(stringArray[n]);
                        continue;
                    }
                    System.err.println("Usage: EgSnmpTest -host <targetHost> -port <Port> -snmpPort <snmpPort> -snmpCommunity <community>");
                    return;
                }
                if (stringArray[n].equalsIgnoreCase("-timeout")) {
                    if (++n >= stringArray.length) continue;
                    this.timeOut = Integer.parseInt(stringArray[n + 1]);
                    bl = true;
                    continue;
                }
                if (!this.snmpVersion.equalsIgnoreCase("v3")) continue;
                if (stringArray[n].equalsIgnoreCase("-username")) {
                    if (++n < stringArray.length) {
                        this.username = new String(stringArray[n]);
                    } else {
                        System.err.println("Usage:\njava com/eg/snmpgetsubtree -o -w 2 -v 3 -u <username> -a <md5> -A <authpass> -x <encrypttype> -X <encryptpass> targethost oid");
                        return;
                    }
                }
                if (stringArray[n].equalsIgnoreCase("-authpass")) {
                    if (++n < stringArray.length) {
                        this.authPass = EgCrypt.decrypt(new String(stringArray[n]));
                    } else {
                        System.err.println("Usage:\njava com/eg/snmpgetsubtree -o -w 2 -v 3 -u <username> -a <md5> -A <authpass> -x <encrypttype> -X <encryptpass> targethost oid");
                        return;
                    }
                }
                if (stringArray[n].equalsIgnoreCase("-authtype")) {
                    if (++n < stringArray.length) {
                        this.authType = new String(stringArray[n]);
                    } else {
                        System.err.println("Usage:\njava com/eg/snmpgetsubtree -o -w 2 -v 3 -u <username> -a <md5> -A <authpass> -x <encrypttype> -X <encryptpass> targethost oid");
                        return;
                    }
                }
                if (stringArray[n].equalsIgnoreCase("-encryptflag")) {
                    if (++n < stringArray.length) {
                        this.isEncryptionEnabled = new Boolean(stringArray[n]);
                    } else {
                        System.err.println("Usage:\njava com/eg/snmpgetsubtree -o -w 2 -v 3 -u <username> -a <md5> -A <authpass> -x <encrypttype> -X <encryptpass> targethost oid");
                        return;
                    }
                }
                if (!this.isEncryptionEnabled) continue;
                if (stringArray[n].equalsIgnoreCase("-encrypttype")) {
                    if (++n < stringArray.length) {
                        this.encryptType = new String(stringArray[n]);
                    } else {
                        System.err.println("Usage:\njava com/eg/snmpgetsubtree -o -w 2 -v 3 -u <username> -a <md5> -A <authpass> -x <encrypttype> -X <encryptpass> targethost oid");
                        return;
                    }
                }
                if (!stringArray[n].equalsIgnoreCase("-encryptpassword")) continue;
                if (++n < stringArray.length) {
                    this.encryptPass = EgCrypt.decrypt(new String(stringArray[n]));
                    continue;
                }
                System.err.println("Usage:\njava com/eg/snmpgetsubtree -o -w 2 -v 3 -u <username> -a <md5> -A <authpass> -x <encrypttype> -X <encryptpass> targethost oid");
                return;
            }
        }
        if (!bl && (string = System.getProperty("SNMPTIMEOUT")) != null) {
            int n2 = 10;
            try {
                n2 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.timeOut = n2;
        }
        this.findNasEngines();
    }

    public void findNasEngines() {
        int n;
        this.runSnmpCmdForOid(this.nasEngNameOid);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n = 0; n < this.rhs.length; ++n) {
            if (!this.lhs[n].startsWith(this.portNo + ".")) continue;
            arrayList.add(this.rhs[n]);
            arrayList2.add(this.lhs[n]);
        }
        this.engNames = new String[arrayList.size()];
        this.numEngs = this.engNames.length;
        this.nasEngKesPort = new int[this.numEngs];
        this.nasDiffRequests = new int[this.numEngs];
        this.nasAvgReqTime = new double[this.numEngs];
        this.nasPerActThreads = new int[this.numEngs];
        this.nasBytesSent = new int[this.numEngs];
        this.nasBytesRecv = new int[this.numEngs];
        this.nasEngKesPort = new int[this.numEngs];
        this.nasEngPort = new int[this.numEngs];
        this.nasThreadsUsed = new int[this.numEngs];
        this.nasThreadsIdle = new int[this.numEngs];
        this.prev_requests = new int[this.numEngs];
        this.prev_bytesSent = new int[this.numEngs];
        this.prev_bytesRecv = new int[this.numEngs];
        for (n = 0; n < arrayList2.size(); ++n) {
            this.engNames[n] = new String((String)arrayList.get(n));
            StringTokenizer stringTokenizer = new StringTokenizer((String)arrayList2.get(n), ".");
            this.nasEngKesPort[n] = Integer.parseInt(stringTokenizer.nextToken());
            this.nasEngPort[n] = Integer.parseInt(stringTokenizer.nextToken());
        }
        for (n = 0; n < this.numEngs; ++n) {
            this.prev_requests[n] = -1;
            this.prev_bytesSent[n] = -1;
            this.prev_bytesRecv[n] = -1;
        }
    }

    public boolean runSnmpCmdForOid(String string) {
        String[] stringArray = null;
        stringArray = this.snmpVersion.equalsIgnoreCase("v1") || this.snmpVersion.equalsIgnoreCase("v2") ? new String[]{"-p", "" + this.snmpPortNo, "-c", this.community, "-o", "-v", this.snmpVersion.equalsIgnoreCase("v1") ? "1" : "2", this.targetHost, string} : (!this.isEncryptionEnabled ? new String[]{"-o", "-w", "2", "-v", "3", "-p", "" + this.snmpPortNo, "-u", this.username, "-a", this.authType, "-A", this.authPass, this.targetHost, string} : new String[]{"-o", "-w", "2", "-v", "3", "-p", "" + this.snmpPortNo, "-u", this.username, "-a", this.authType, "-A", this.authPass, "-x", this.encryptType, "-X", this.encryptPass, this.targetHost, string});
        snmpgetsubtree snmpgetsubtree2 = new snmpgetsubtree(stringArray, this.timeOut);
        ArrayList arrayList = snmpgetsubtree2.getSubTree();
        this.lhs = null;
        this.rhs = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        this.mibName = string;
        if (arrayList != null && arrayList.size() > 0) {
            int n;
            int n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                int n3;
                String string2 = ((String)arrayList.get(n)).trim();
                if (!string2.startsWith(string) || (n3 = string2.indexOf(61)) < 0) continue;
                String string3 = string2.substring(0, n3);
                String string4 = string2.substring(n3 + 1);
                String string5 = this.replace(string3, string, "");
                if (string5.length() > 0) {
                    string5 = new String(string5.substring(1));
                }
                if (string4.startsWith("\"")) {
                    String string6;
                    int n4 = string4.lastIndexOf("\"");
                    while (n4 <= 0 && ++n < n2 && (string6 = (String)arrayList.get(n)) != null) {
                        string4 = string4 + " " + string6;
                        n4 = string4.lastIndexOf("\"");
                    }
                    string4 = new String(string4.substring(1, n4));
                }
                arrayList2.add(string4);
                arrayList3.add(string5);
            }
            Object[] objectArray = arrayList2.toArray();
            this.rhs = new String[objectArray.length];
            for (n = 0; n < objectArray.length; ++n) {
                this.rhs[n] = objectArray[n].toString();
            }
            objectArray = arrayList3.toArray();
            this.lhs = new String[objectArray.length];
            for (n = 0; n < objectArray.length; ++n) {
                this.lhs[n] = objectArray[n].toString();
            }
            return this.lhs.length > 0;
        }
        StringBuffer stringBuffer = new StringBuffer("java com/eg/snmpgetsubtree");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(" ");
            stringBuffer.append(stringArray[i]);
        }
        this.errorMsg = new String("Failed to run " + stringBuffer + " for " + this.reportingName + " with community " + this.community + " and MIB=" + this.mibName);
        System.out.println("From EgSnmpTest :" + this.errorMsg);
        return false;
    }

    public boolean executeTest() {
        int n;
        int n2;
        String string;
        StringTokenizer stringTokenizer;
        int n3;
        int n4 = 0;
        int n5 = 0;
        this.initTest();
        if (!this.runSnmpCmdForOid(this.nasTotRequestsOid)) {
            this.updateAllResultSets();
            return false;
        }
        for (n3 = 0; n3 < this.numEngs; ++n3) {
            this.nasDiffRequests[n3] = -1;
        }
        for (n3 = 0; n3 < this.lhs.length; ++n3) {
            stringTokenizer = new StringTokenizer(this.lhs[n3], ".");
            string = stringTokenizer.nextToken();
            if (!string.equals(this.portNo)) continue;
            n5 = Integer.parseInt(string);
            n4 = Integer.parseInt(stringTokenizer.nextToken());
            n2 = -1;
            for (n = 0; n < this.numEngs; ++n) {
                if (this.nasEngPort[n] != n4 || this.nasEngKesPort[n] != n5) continue;
                n2 = n;
                break;
            }
            if (n2 >= 0) {
                this.nasDiffRequests[n2] = Integer.parseInt(this.rhs[n3]);
                if (this.prev_requests[n2] >= 0 && this.prev_requests[n2] <= this.nasDiffRequests[n2]) {
                    n = this.nasDiffRequests[n2];
                    this.nasDiffRequests[n2] = n - this.prev_requests[n2];
                    this.prev_requests[n2] = n;
                    continue;
                }
                this.prev_requests[n2] = this.nasDiffRequests[n2];
                this.nasDiffRequests[n2] = -1;
                continue;
            }
            this.findNasEngines();
            this.updateAllResultSets();
            return true;
        }
        if (!this.runSnmpCmdForOid(this.nasAvgReqTimeOid)) {
            this.updateAllResultSets();
            return false;
        }
        for (n3 = 0; n3 < this.numEngs; ++n3) {
            this.nasAvgReqTime[n3] = -1.0;
        }
        for (n3 = 0; n3 < this.lhs.length; ++n3) {
            stringTokenizer = new StringTokenizer(this.lhs[n3], ".");
            string = stringTokenizer.nextToken();
            if (!string.equals(this.portNo)) continue;
            n5 = Integer.parseInt(string);
            n4 = Integer.parseInt(stringTokenizer.nextToken());
            n2 = -1;
            for (n = 0; n < this.numEngs; ++n) {
                if (this.nasEngPort[n] != n4 || this.nasEngKesPort[n] != n5) continue;
                n2 = n;
                break;
            }
            if (n2 >= 0) {
                this.nasAvgReqTime[n2] = (double)Integer.parseInt(this.rhs[n3]) / 1000.0;
                continue;
            }
            this.findNasEngines();
            this.updateAllResultSets();
            return true;
        }
        if (!this.runSnmpCmdForOid(this.nasThreadsUsedOid)) {
            this.updateAllResultSets();
            return false;
        }
        for (n3 = 0; n3 < this.numEngs; ++n3) {
            this.nasThreadsUsed[n3] = -1;
        }
        for (n3 = 0; n3 < this.lhs.length; ++n3) {
            stringTokenizer = new StringTokenizer(this.lhs[n3], ".");
            string = stringTokenizer.nextToken();
            if (!string.equals(this.portNo)) continue;
            n5 = Integer.parseInt(string);
            n4 = Integer.parseInt(stringTokenizer.nextToken());
            n2 = -1;
            for (n = 0; n < this.numEngs; ++n) {
                if (this.nasEngPort[n] != n4 || this.nasEngKesPort[n] != n5) continue;
                n2 = n;
                break;
            }
            if (n2 >= 0) {
                this.nasThreadsUsed[n2] = Integer.parseInt(this.rhs[n3]);
                continue;
            }
            this.findNasEngines();
            this.updateAllResultSets();
            return true;
        }
        if (!this.runSnmpCmdForOid(this.nasThreadsIdleOid)) {
            this.updateAllResultSets();
            return false;
        }
        for (n3 = 0; n3 < this.numEngs; ++n3) {
            this.nasThreadsIdle[n3] = -1;
        }
        for (n3 = 0; n3 < this.lhs.length; ++n3) {
            stringTokenizer = new StringTokenizer(this.lhs[n3], ".");
            string = stringTokenizer.nextToken();
            if (!string.equals(this.portNo)) continue;
            n5 = Integer.parseInt(string);
            n4 = Integer.parseInt(stringTokenizer.nextToken());
            n2 = -1;
            for (n = 0; n < this.numEngs; ++n) {
                if (this.nasEngPort[n] != n4 || this.nasEngKesPort[n] != n5) continue;
                n2 = n;
                break;
            }
            if (n2 >= 0) {
                this.nasThreadsIdle[n2] = Integer.parseInt(this.rhs[n3]);
                continue;
            }
            this.findNasEngines();
            this.updateAllResultSets();
            return true;
        }
        for (n3 = 0; n3 < this.numEngs; ++n3) {
            this.nasPerActThreads[n3] = this.nasThreadsUsed[n3] < 0 || this.nasThreadsIdle[n3] < 0 ? -1 : (this.nasThreadsUsed[n3] - this.nasThreadsIdle[n3]) * 100 / this.nasThreadsUsed[n3];
        }
        if (!this.runSnmpCmdForOid(this.nasBytesSentOid)) {
            this.updateAllResultSets();
            return false;
        }
        for (n3 = 0; n3 < this.numEngs; ++n3) {
            this.nasBytesSent[n3] = -1;
        }
        for (n3 = 0; n3 < this.lhs.length; ++n3) {
            stringTokenizer = new StringTokenizer(this.lhs[n3], ".");
            string = stringTokenizer.nextToken();
            if (!string.equals(this.portNo)) continue;
            n5 = Integer.parseInt(string);
            n4 = Integer.parseInt(stringTokenizer.nextToken());
            n2 = -1;
            for (n = 0; n < this.numEngs; ++n) {
                if (this.nasEngPort[n] != n4 || this.nasEngKesPort[n] != n5) continue;
                n2 = n;
                break;
            }
            if (n2 >= 0) {
                this.nasBytesSent[n2] = Integer.parseInt(this.rhs[n3]);
                if (this.prev_bytesSent[n2] >= 0 && this.prev_bytesSent[n2] <= this.nasBytesSent[n2]) {
                    n = this.nasBytesSent[n2];
                    this.nasBytesSent[n2] = n - this.prev_bytesSent[n2];
                    this.prev_bytesSent[n2] = n;
                    continue;
                }
                this.prev_bytesSent[n2] = this.nasBytesSent[n2];
                this.nasBytesSent[n2] = -1;
                continue;
            }
            this.findNasEngines();
            this.updateAllResultSets();
            return true;
        }
        if (!this.runSnmpCmdForOid(this.nasBytesRecvOid)) {
            this.updateAllResultSets();
            return false;
        }
        for (n3 = 0; n3 < this.numEngs; ++n3) {
            this.nasBytesRecv[n3] = -1;
        }
        for (n3 = 0; n3 < this.lhs.length; ++n3) {
            stringTokenizer = new StringTokenizer(this.lhs[n3], ".");
            string = stringTokenizer.nextToken();
            if (!string.equals(this.portNo)) continue;
            n5 = Integer.parseInt(string);
            n4 = Integer.parseInt(stringTokenizer.nextToken());
            n2 = -1;
            for (n = 0; n < this.numEngs; ++n) {
                if (this.nasEngPort[n] != n4 || this.nasEngKesPort[n] != n5) continue;
                n2 = n;
                break;
            }
            if (n2 >= 0) {
                this.nasBytesRecv[n2] = Integer.parseInt(this.rhs[n3]);
                if (this.prev_bytesRecv[n2] >= 0 && this.prev_bytesRecv[n2] <= this.nasBytesRecv[n2]) {
                    n = this.nasBytesRecv[n2];
                    this.nasBytesRecv[n2] = n - this.prev_bytesRecv[n2];
                    this.prev_bytesRecv[n2] = n;
                    continue;
                }
                this.prev_bytesRecv[n2] = this.nasBytesRecv[n2];
                this.nasBytesRecv[n2] = -1;
                continue;
            }
            this.findNasEngines();
            this.updateAllResultSets();
            return true;
        }
        this.computeResults();
        return true;
    }

    private void computeResults() {
        for (int i = 0; i < this.numEngs; ++i) {
            double d;
            double d2;
            double d3;
            if (this.timeSinceLastTest <= 0.0) {
                d3 = -1.0;
                d2 = -1.0;
                d = -1.0;
            } else {
                d3 = this.nasDiffRequests[i] >= 0 ? (double)this.nasDiffRequests[i] / this.timeSinceLastTest : -1.0;
                d2 = this.nasBytesSent[i] >= 0 ? (double)this.nasBytesSent[i] / this.timeSinceLastTest : -1.0;
                d = this.nasBytesRecv[i] >= 0 ? (double)this.nasBytesRecv[i] / this.timeSinceLastTest : -1.0;
            }
            String string = this.siteName + siteAndInfoSeparator + infoFieldSeparator + this.engNames[i];
            d3 = d3 < 0.0 ? -1.0 : d3;
            d2 = d2 < 0.0 ? -1.0 : d2;
            d = d < 0.0 ? -1.0 : d;
            this.addValueToResultSet(string, this.reqsPerSecIndex, d3);
            this.addValueToResultSet(string, this.avgReqTimeIndex, this.nasAvgReqTime[i]);
            this.addValueToResultSet(string, this.percentActThreadsIndex, this.nasPerActThreads[i]);
            if (d2 != -1.0) {
                d2 /= 1024.0;
            }
            this.addValueToResultSet(string, this.kbytesSentPerSecIndex, d2);
            if (d != -1.0) {
                d /= 1024.0;
            }
            this.addValueToResultSet(string, this.kbytesRecvPerSecIndex, d);
        }
        this.updateAllResultSets();
    }

    private String replace(String string, String string2, String string3) {
        int n;
        do {
            if ((n = string.indexOf(string2)) == -1) continue;
            String string4 = string.substring(0, n);
            string4 = string4 + string3;
            string = string4 = string4 + string.substring(n + string2.length());
        } while (n != -1);
        return string;
    }

    public static void main(String[] stringArray) {
        NasSnmpTest nasSnmpTest = new NasSnmpTest(stringArray);
        nasSnmpTest.executeTest();
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        nasSnmpTest.executeTest();
    }
}

