/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import netapp.manage.NaElement;
import netapp.manage.NaServer;

class NetCluFcpAdaptTest
extends NAUSDCluBase {
    public NetCluFcpAdaptTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(1);
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        NaServer naServer = null;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        try {
            naServer = this.getConnection();
            if (naServer == null) {
                this.closeConnection(naServer);
                this.logToErrorFile("Error :", "NetCluFcpAdaptTest ", "Connection is null");
                this.printOut("Error", "NetCluFcpAdaptTest Connection is null");
                return;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "NetCluFcpAdaptTest error occured while connecting ", exception.toString());
            this.printOut("Error", "NetCluFcpAdaptTest error occured while connecting:" + exception.toString());
            exception.printStackTrace();
        }
        try {
            NaElement naElement = new NaElement("fcp-adapter-get-iter");
            Iterator iterator = null;
            String string = "";
            while (string != null) {
                NaElement naElement2;
                naElement = new NaElement("fcp-adapter-get-iter");
                naElement.addNewChild("max-records", "10");
                if (!string.equals("")) {
                    naElement.addNewChild("tag", string);
                }
                if ((naElement2 = this.execONTAPI(naServer, naElement)) == null) {
                    this.closeConnection(naServer);
                    this.printOut("DEBUG", "NetCluFcpAdaptTest output is null");
                    return;
                }
                string = naElement2.getChildContent("next-tag");
                int n = naElement2.getChildIntValue("num-records", 0);
                if (n > 0) {
                    List list = naElement2.getChildByName("attributes-list").getChildren();
                    iterator = list.iterator();
                    while (iterator.hasNext()) {
                        NaElement naElement3 = (NaElement)iterator.next();
                        String string2 = naElement3.getChildContent("adapter");
                        String string3 = naElement3.getChildContent("node");
                        String string4 = naElement3.getChildContent("state");
                        if (string4 == null) continue;
                        String string5 = null;
                        if (string3 == null || string3.trim().length() <= 0 || string2 == null || string2.trim().length() <= 0) continue;
                        string3 = string3.trim();
                        string2 = string2.trim();
                        string5 = string3 + "/" + string2;
                        arrayList = new ArrayList();
                        if (string4.equals("startup")) {
                            arrayList.add(new Double(0.0));
                        } else if (string4.equals("online")) {
                            arrayList.add(new Double(1.0));
                        } else if (string4.equals("initializing firmware")) {
                            arrayList.add(new Double(2.0));
                        } else if (string4.equals("waiting for link up")) {
                            arrayList.add(new Double(3.0));
                        } else if (string4.equals("uninitialized")) {
                            arrayList.add(new Double(4.0));
                        } else if (string4.equals("resetting")) {
                            arrayList.add(new Double(5.0));
                        } else if (string4.equals("link not connected")) {
                            arrayList.add(new Double(6.0));
                        } else if (string4.equals("link disconnected")) {
                            arrayList.add(new Double(7.0));
                        } else if (string4.equals("offlined by user/system")) {
                            arrayList.add(new Double(8.0));
                        } else if (string4.equals("offline")) {
                            arrayList.add(new Double(9.0));
                        }
                        this.addNewMeasure(string5, arrayList);
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "NetCluFcpAdaptTest error occured in computeMeasure ", exception.toString());
            this.printOut("Error", "NetCluFcpAdaptTest error occured in computeMeasure:" + exception.toString());
            exception.printStackTrace();
        }
        this.closeConnection(naServer);
    }

    public static void main(String[] stringArray) {
        NetCluFcpAdaptTest netCluFcpAdaptTest = new NetCluFcpAdaptTest(stringArray);
        netCluFcpAdaptTest.computeMeasures(new Hashtable());
    }
}

