/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class NfsMountTest
extends GenericTest {
    private static final int numMeasures = 5;
    private long commandTimeOut = 30L;
    private ArrayList aListExcludesNfs = new ArrayList();
    private String strReportByFS = null;

    public NfsMountTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(5);
        this.isNewDynamicInfoTest = true;
        String string = this.getValueForParam("timeout");
        try {
            this.commandTimeOut = Integer.parseInt(string);
            this.commandTimeOut *= 1000L;
        }
        catch (Exception exception) {
            this.commandTimeOut = 30000L;
        }
        String string2 = this.getValueForParam("exclude_file_systems");
        if (string2 != null && !string2.equalsIgnoreCase("none")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3 == null) continue;
                string3 = string3.trim();
                this.aListExcludesNfs.add(string3);
            }
        }
        this.strReportByFS = this.getValueForParam("report_By_File_system");
        if (this.strReportByFS == null || this.strReportByFS.equals("") || this.strReportByFS.equalsIgnoreCase("NONE") || this.strReportByFS.equalsIgnoreCase("DEFAULT")) {
            this.strReportByFS = "remote";
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        String string = "";
        String string2 = "";
        HashMap hashMap = null;
        ArrayList arrayList = null;
        TimeExecThread timeExecThread = null;
        string = "/sbin/mount -v";
        EgUtilities egUtilities = EgUtilities.createInstance();
        ArrayList arrayList2 = egUtilities.getExecOutputLines(string);
        if (arrayList2 == null || arrayList2.size() < 2) {
            this.addNewMeasure(null);
            this.errorMsg = new String("NfsMountTest : Unable to execute \"/sbin/mount -v\" command");
            return;
        }
        arrayList = (ArrayList)arrayList2.get(0);
        if (arrayList == null || arrayList.size() <= 0) {
            this.addNewMeasure(null);
            this.errorMsg = new String("NfsMountTest : Unable to execute \"/sbin/mount -v\" command");
            return;
        }
        hashMap = this.getNFSNames(arrayList);
        if (hashMap == null || hashMap.size() == 0) {
            this.addNewMeasure(null);
            this.errorMsg = new String("NfsMountTest : Unable to execute \"/sbin/mount -v\" command");
            return;
        }
        for (String string3 : hashMap.keySet()) {
            String string4 = (String)hashMap.get(string3);
            if (this.strReportByFS.equalsIgnoreCase("LOCAL")) {
                string4 = string3;
            }
            string = "df -k " + string4;
            ArrayList arrayList3 = new ArrayList();
            timeExecThread = new TimeExecThread(string, this.commandTimeOut);
            while (true) {
                if (timeExecThread.isDone()) break;
                try {
                    Thread.currentThread();
                    Thread.sleep(250L);
                }
                catch (Exception exception) {}
            }
            arrayList = timeExecThread.getOutput();
            if (arrayList == null || arrayList.size() < 2) {
                arrayList3.add(new Double(0.0));
                arrayList3.add(new Double(-5.0));
                arrayList3.add(new Double(-5.0));
                arrayList3.add(new Double(-5.0));
                arrayList3.add(new Double(-5.0));
            } else {
                ArrayList arrayList4 = (ArrayList)arrayList.get(0);
                if (arrayList4 == null || arrayList4.size() == 0) {
                    arrayList3.add(new Double(0.0));
                    arrayList3.add(new Double(-5.0));
                    arrayList3.add(new Double(-5.0));
                    arrayList3.add(new Double(-5.0));
                    arrayList3.add(new Double(-5.0));
                } else {
                    arrayList3 = this.parseOutput(arrayList4);
                }
            }
            this.addNewMeasure(string3, arrayList3);
        }
    }

    public ArrayList parseOutput(ArrayList arrayList) {
        int n;
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        String string = "";
        String string2 = "";
        String string3 = "";
        if (arrayList == null || arrayList.size() == 0) {
            arrayList2.add(new Double(0.0));
            arrayList2.add(new Double(-5.0));
            arrayList2.add(new Double(-5.0));
            arrayList2.add(new Double(-5.0));
            arrayList2.add(new Double(-5.0));
            return arrayList2;
        }
        int n2 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            string2 = (String)arrayList.get(n);
            if (n2 > 2) {
                n2 = 0;
                continue;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            String string4 = stringTokenizer.nextToken().trim();
            arrayList3.add(string4);
            ++n2;
        }
        for (n = 0; n < arrayList3.size(); n += 3) {
            string = "";
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            double d = 0.0;
            string = (String)arrayList3.get(n);
            try {
                l2 = Long.parseLong(((String)arrayList3.get(n + 1)).trim());
                l3 = Long.parseLong(((String)arrayList3.get(n + 2)).trim());
            }
            catch (Exception exception) {
                continue;
            }
            if (l2 == 0L) {
                arrayList2.add(new Double(0.0));
                arrayList2.add(new Double(-5.0));
                arrayList2.add(new Double(-5.0));
                arrayList2.add(new Double(-5.0));
                arrayList2.add(new Double(-5.0));
                continue;
            }
            l = l2 + l3;
            d = (double)l2 * 100.0 / (double)l;
            arrayList2.add(new Double(100.0));
            arrayList2.add(new Double((double)l / 1024.0));
            arrayList2.add(new Double((double)l2 / 1024.0));
            arrayList2.add(new Double((double)l3 / 1024.0));
            arrayList2.add(new Double(d));
        }
        if (arrayList2 == null || arrayList2.size() == 0) {
            arrayList2.add(new Double(0.0));
            arrayList2.add(new Double(-5.0));
            arrayList2.add(new Double(-5.0));
            arrayList2.add(new Double(-5.0));
            arrayList2.add(new Double(-5.0));
        }
        return arrayList2;
    }

    public HashMap getNFSNames(ArrayList arrayList) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            if (arrayList == null || arrayList.size() == 0) {
                return null;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = (String)arrayList.get(i);
                if (string == null || string.indexOf(" on") <= -1) continue;
                String string2 = string.substring(0, string.indexOf(" on"));
                String string3 = string.substring(string.indexOf("on ") + "on ".length(), string.indexOf(" type"));
                int n = string.indexOf("type ") + "type ".length();
                String string4 = string.substring(n, string.indexOf(" ", n));
                string4.trim();
                if (string4 == null || !string4.equalsIgnoreCase("NFS")) continue;
                string2.trim();
                string3.trim();
                if (this.isExcludeNFS(string2, string3)) continue;
                if (this.strReportByFS.equalsIgnoreCase("LOCAL")) {
                    hashMap.put(string3, string2);
                    continue;
                }
                if (this.strReportByFS.equalsIgnoreCase("BOTH")) {
                    hashMap.put(string3 + "(" + string2 + ")", string3);
                    continue;
                }
                hashMap.put(string2, string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return hashMap;
    }

    public boolean isExcludeNFS(String string, String string2) {
        String string3 = "";
        try {
            if (this.aListExcludesNfs == null || this.aListExcludesNfs.size() == 0) {
                return false;
            }
            for (int i = 0; i < this.aListExcludesNfs.size(); ++i) {
                String string4 = (String)this.aListExcludesNfs.get(i);
                if (string4.startsWith("*") || string4.endsWith("*")) {
                    if (string4.startsWith("*")) {
                        string4 = string4.substring(1);
                    }
                    if (string4.endsWith("*")) {
                        string4 = string4.substring(0, string4.length() - 1);
                    }
                    if (string.indexOf(string4) <= -1 && string2.indexOf(string4) <= -1) continue;
                    return true;
                }
                if (!string.equals(string4) && !string2.equals(string4)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        NfsMountTest nfsMountTest = new NfsMountTest(stringArray);
        nfsMountTest.computeMeasures(new Hashtable());
    }
}

