/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class NimblePerfTest
extends EgSnmpGenericTest {
    private double prev_RandomIOReadBytes = -5.0;
    private double prev_RandomIOWriteBytes = -5.0;
    private double prev_SeqIOReadBytes = -5.0;
    private double prev_SeqIOWriteBytes = -5.0;
    double randomIOReadBytes = -5.0;
    double randomIOWriteBytes = -5.0;
    private double byteToMB = 1048576.0;

    public NimblePerfTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(5);
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            double d = this.getMeasure(".1.3.6.1.4.1.37447.1.3.8.0");
            double d2 = this.getMeasure(".1.3.6.1.4.1.37447.1.3.10.0");
            double d3 = this.getMeasure(".1.3.6.1.4.1.37447.1.3.9.0");
            double d4 = this.getMeasure(".1.3.6.1.4.1.37447.1.3.11.0");
            this.randomIOReadBytes = d >= 0.0 && d3 >= 0.0 ? d - d3 : -5.0;
            this.randomIOWriteBytes = d2 >= 0.0 && d4 >= 0.0 ? d2 - d4 : -5.0;
            double d5 = this.getDiff(this.randomIOReadBytes, this.prev_RandomIOReadBytes);
            double d6 = this.getDiff(this.randomIOWriteBytes, this.prev_RandomIOWriteBytes);
            double d7 = this.getDiff(d3, this.prev_SeqIOReadBytes);
            double d8 = this.getDiff(d4, this.prev_SeqIOWriteBytes);
            double d9 = -5.0;
            d9 = d5 >= 0.0 && d6 >= 0.0 && d7 >= 0.0 && d8 >= 0.0 ? d5 + d6 + d7 + d8 : -5.0;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d7));
            arrayList.add(new Double(d8));
            arrayList.add(new Double(d5));
            arrayList.add(new Double(d6));
            arrayList.add(new Double(d9));
            System.out.println("[NimblePerfTest]  measureList===>" + arrayList);
            this.addNewMeasure(arrayList);
            this.prev_RandomIOReadBytes = this.randomIOReadBytes;
            this.prev_RandomIOWriteBytes = this.randomIOWriteBytes;
            this.prev_SeqIOReadBytes = d3;
            this.prev_SeqIOWriteBytes = d4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public double getMeasure(String string) {
        boolean bl = this.runSnmpCmdForOid(string);
        String string2 = "";
        double d = -5.0;
        if (bl) {
            for (int i = 0; i < this.lhs.length; ++i) {
                string2 = this.rhs[i];
                try {
                    d = Double.parseDouble(string2);
                    continue;
                }
                catch (Exception exception) {
                    d = -5.0;
                    exception.printStackTrace();
                }
            }
        }
        return d;
    }

    private double getDiff(double d, double d2) {
        double d3 = -5.0;
        if (d > 0.0 && d2 > 0.0) {
            d3 = d - d2;
            if (d3 > 0.0) {
                d3 /= this.byteToMB;
            }
            if (this.timeSinceLastTest > 0.0 && d3 >= 0.0) {
                d3 /= this.timeSinceLastTest;
            }
            if (d3 < 0.0) {
                d3 = -5.0;
            }
        }
        return d3;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host", "192.168.8.206", "-port", "NULL", "-snmpPort", "161", "-snmpversion", "v1", "-snmpCommunity", "public"};
        NimblePerfTest nimblePerfTest = new NimblePerfTest(stringArray2);
        try {
            while (true) {
                nimblePerfTest.computeMeasures(new Hashtable());
                Thread.sleep(1000L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

