/*
 * Decompiled with CFR 0.152.
 */
import com.eg.apm.NodeBTMLogger;
import com.eg.apm.NodeError;
import com.eg.apm.NodeInfra;
import com.eg.apm.NodeInfraCluster;
import com.eg.org.slf4j.Logger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class NodeErrorTest_DD
extends EgTest_DD {
    protected static final Logger logger = NodeBTMLogger.nodeLogger;
    public static final int MAX_MESSAGE_LENGTH = 256;
    public static final int MAX_STACK_LENGTH = 2000;
    public String prefix = "[NodejsErrorTest_DD]";

    public NodeErrorTest_DD(String entity) {
        super(entity);
        logger.info("{} is started", (Object)this.prefix);
    }

    public boolean getStatusDescriptor(EgTest test, String siteId, String info) {
        block7: {
            NodeErrorTest nodeErrorTest = (NodeErrorTest)test;
            NodeInfraCluster nodeErrorCluster = nodeErrorTest.getNodeErrorCluster();
            if (nodeErrorCluster == null) break block7;
            ArrayList<NodeInfra> errorList = nodeErrorCluster.getErrorList();
            if (errorList != null && errorList.size() > 0) {
                int index = 0;
                while (index < errorList.size()) {
                    NodeInfra nodeInfra = errorList.get(index);
                    NodeError nodeError = nodeInfra.getError();
                    String msg = nodeError.getMessage();
                    String stack = nodeError.getStack();
                    String processID = nodeInfra.getProcessID();
                    long errorTime = nodeError.getErrorTime();
                    if (msg.length() > 256) {
                        msg = String.valueOf(msg.substring(0, 253)) + "...";
                    }
                    if ((stack = NodeErrorTest_DD.parseStack(stack)).length() > 2000) {
                        stack = String.valueOf(stack.substring(0, 1997)) + "...";
                    }
                    this.addLine(String.valueOf(processID) + fieldSep + NodeErrorTest_DD.convertTime(errorTime) + fieldSep + msg + fieldSep + stack);
                    logger.trace("{} NodeErrorTest_DD Addline info:{} {} {} {} {}", new Object[]{this.prefix, NodeErrorTest_DD.convertTime(errorTime), fieldSep, msg, fieldSep, stack});
                    ++index;
                }
            }
            errorList.clear();
            return true;
        }
        try {
            logger.debug("{} Site id not available", (Object)this.prefix);
        }
        catch (Exception e) {
            logger.error("{} getStatusDiscriptor() Exception occcured {}", (Object)this.prefix, (Object)e);
        }
        return false;
    }

    public static String convertTime(long time) {
        Date date = new Date(time);
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss", Locale.US);
        return dateFormat.format((Object)date);
    }

    public static String parseStack(String stack) {
        if (stack == null || stack.isEmpty()) {
            return "";
        }
        String[] lines = stack.split("\\r?\\n");
        if (lines.length <= 0) {
            return stack;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < lines.length) {
            buffer.append(lines[i]).append(";").append("  ");
            ++i;
        }
        return buffer.toString();
    }

    public void Number_of_Errors_dd(String methodName, String measureName, String targetHost, String reportingName, String portNo, String siteName, String info, String msmtHost, String msmtTime, String state, EgTest test) {
        logger.debug("{} methodName={} \t measureName={} \t targetHost={}  \t reportingName={} \t  portNo={}\t siteName={} \t info={}  \t msmtHost={}  \t msmtTime={}  \t state={}  \t ", new Object[]{this.prefix, methodName, measureName, targetHost, reportingName, portNo, siteName, info, msmtHost, msmtTime, state});
        try {
            boolean success = this.getStatusDescriptor(test, String.valueOf(msmtHost) + '_' + portNo, info);
            if (success) {
                this.uploadResults(methodName, measureName, reportingName, portNo, siteName, info, msmtHost, msmtTime, state);
            }
        }
        catch (Exception e) {
            logger.error("{} while upload results {}", (Object)this.prefix, (Object)e);
            return;
        }
    }
}

