/*
 * Decompiled with CFR 0.152.
 */
import com.eg.apm.NodeInfra;
import com.eg.apm.NodeInfraCluster;
import com.eg.apm.NodeThreadCpuUsage;
import com.eg.apm.NodeThreadEventloop;
import com.eg.apm.NodeThreadGcSummary;
import com.eg.apm.NodeThreadMemory;
import com.eg.apm.NodeUtils;
import com.eg.apm.NodeWorkerThread;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeWrkerThreadTest
extends NodeBase {
    private static final Double minusFive = new Double(-5.0);
    private HashMap<String, String> threadDD = new HashMap();

    public NodeWrkerThreadTest(String[] args) {
        super(args);
        this.isNewDynamicInfoTest = true;
        try {
            logger.info("{} Initializing NodeWorkerThreadTest ...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            logger.info("{} NodeWorkerThreadTest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception initException) {
            logger.error("{} Exception while initializing {}", (Object)this.logPrefix, (Object)initException);
        }
    }

    @Override
    public void computeMeasures(Hashtable params) {
        this.getJvmGuid();
        logger.debug("{} - Node Worker Thread Test cycle starting ", (Object)this.logPrefix);
        String siteId = "[" + this.reportingName + ":" + this.portNo + "]";
        try {
            HashMap<String, NodeInfra> workers;
            NodeWorkerThread[] masterThread;
            logger.debug("{} - params : {} nodeJvmGUID : {} ", new Object[]{this.logPrefix, params.toString(), this.apmComponentGUID});
            if (!this.nodeRepository.isInfraIdExists(this.apmComponentGUID)) {
                logger.debug("{} nodeJvmGUID: {} is not available", (Object)this.logPrefix, (Object)this.apmComponentGUID);
                return;
            }
            NodeInfraCluster nodeInfraCluster = this.nodeRepository.getInfraById(this.apmComponentGUID);
            NodeInfra master = nodeInfraCluster.getMaster();
            if (master != null && master.isMaster() && (masterThread = master.getWorkerThreads()) != null) {
                int totalNoOfThread = masterThread.length;
                String discriptorName = "Master";
                int index = 0;
                while (index < totalNoOfThread) {
                    String innerDiscriptorName = String.valueOf(discriptorName) + ":" + "Thread_" + masterThread[index].getThreadId();
                    NodeThreadCpuUsage cpuObj = masterThread[index].getCpuUsage();
                    NodeThreadEventloop eventloop = masterThread[index].getEventloop();
                    NodeThreadMemory memory = masterThread[index].getMemoryUsage();
                    NodeThreadGcSummary gcSummary = masterThread[index].getGcSummary();
                    long upTime = masterThread[index].getUptime();
                    this.addMeasures(innerDiscriptorName, cpuObj, eventloop, memory, gcSummary, upTime);
                    masterThread[index].setCpuUsage(null);
                    masterThread[index].setEventloop(null);
                    masterThread[index].setMemoryUsage(null);
                    masterThread[index].setGcSummary(null);
                    masterThread[index].setUptime(-5L);
                    this.threadDD.put("+" + innerDiscriptorName, masterThread[index].getWorkerPath());
                    masterThread[index].setWorkerPath(null);
                    ++index;
                }
                master.setWorkerThreads(null);
                String summaryDiscriptor = String.valueOf(discriptorName) + ":" + "Summary";
                ArrayList<Double> summaryDetails = this.prepareSummaryDiscriptorDetails(totalNoOfThread);
                this.addNewMeasure(summaryDiscriptor, summaryDetails);
            }
            if ((workers = nodeInfraCluster.getWorkers()) != null && workers.size() > 0) {
                Set<Map.Entry<String, NodeInfra>> set = workers.entrySet();
                for (Map.Entry<String, NodeInfra> mEntry : set) {
                    String key = mEntry.getKey();
                    NodeInfra infraByPid = mEntry.getValue();
                    NodeWorkerThread[] nodeWorker = infraByPid.getWorkerThreads();
                    if (nodeWorker == null || nodeWorker.length <= 0) continue;
                    String discriptorName = infraByPid.getMode().equalsIgnoreCase("STANDALONE") ? key : "Worker_" + key;
                    int totalNoOfThread = nodeWorker.length;
                    int index = 0;
                    while (index < totalNoOfThread) {
                        String innerDiscriptorName = String.valueOf(discriptorName) + ":" + "Thread_" + nodeWorker[index].getThreadId();
                        NodeThreadCpuUsage cpuObj = nodeWorker[index].getCpuUsage();
                        NodeThreadEventloop eventloop = nodeWorker[index].getEventloop();
                        NodeThreadMemory memory = nodeWorker[index].getMemoryUsage();
                        NodeThreadGcSummary gcSummary = nodeWorker[index].getGcSummary();
                        long upTime = nodeWorker[index].getUptime();
                        this.addMeasures(innerDiscriptorName, cpuObj, eventloop, memory, gcSummary, upTime);
                        nodeWorker[index].setCpuUsage(null);
                        nodeWorker[index].setEventloop(null);
                        nodeWorker[index].setMemoryUsage(null);
                        nodeWorker[index].setGcSummary(null);
                        nodeWorker[index].setUptime(-5L);
                        this.threadDD.put("+" + innerDiscriptorName, nodeWorker[index].getWorkerPath());
                        nodeWorker[index].setWorkerPath(null);
                        ++index;
                    }
                    infraByPid.setWorkerThreads(null);
                    ArrayList<Double> summaryDetails = this.prepareSummaryDiscriptorDetails(totalNoOfThread);
                    String summaryDiscriptor = String.valueOf(discriptorName) + ":" + "Summary";
                    this.addNewMeasure(summaryDiscriptor, summaryDetails);
                }
            } else {
                logger.debug("{} Node Worker Thread Test - incoming data is null", (Object)siteId);
            }
        }
        catch (Exception e) {
            logger.error("{} Exception occurred while collecting Node Worker Thread Test object : {}", (Object)this.logPrefix, (Object)e);
        }
    }

    private ArrayList<Double> prepareSummaryDiscriptorDetails(double totalNoOfThread) {
        ArrayList<Double> summaryList = new ArrayList<Double>();
        int i = 1;
        while (i < this.measureCount) {
            summaryList.add(minusFive);
            ++i;
        }
        summaryList.add(totalNoOfThread);
        return summaryList;
    }

    private void addMeasures(String discriptorName, NodeThreadCpuUsage cpuObj, NodeThreadEventloop eventloop, NodeThreadMemory memory, NodeThreadGcSummary gcSummary, long upTime) {
        try {
            ArrayList<Double> measures = new ArrayList<Double>();
            if (upTime > 0L) {
                long upTimeInMin = upTime / 1000L / 60L;
                measures.add(NodeUtils.formatDecimal(new Double(upTimeInMin)));
            } else {
                measures.add(minusFive);
            }
            if (eventloop != null) {
                measures.add(NodeUtils.formatDecimal(new Double(eventloop.getMean())));
                measures.add(NodeUtils.formatDecimal(new Double(eventloop.getIdleTime())));
                measures.add(NodeUtils.formatDecimal(new Double(eventloop.getActiveTime())));
                measures.add(NodeUtils.formatDecimal(new Double(eventloop.getUtilization())));
            } else {
                measures.add(minusFive);
                measures.add(minusFive);
                measures.add(minusFive);
                measures.add(minusFive);
            }
            if (gcSummary != null) {
                measures.add(NodeUtils.formatDecimal(Double.valueOf(gcSummary.getFullGcTime())));
                measures.add(NodeUtils.formatDecimal(Double.valueOf(gcSummary.getMinorGcTime())));
                measures.add(NodeUtils.formatDecimal(Double.valueOf(gcSummary.getNoOfFullOfGc())));
                measures.add(NodeUtils.formatDecimal(Double.valueOf(gcSummary.getNoOfMinorOfGc())));
            } else {
                measures.add(minusFive);
                measures.add(minusFive);
                measures.add(minusFive);
                measures.add(minusFive);
            }
            if (memory != null) {
                double maxHeap = memory.getMaxHeap();
                double heapUsed = memory.getHeapUsed();
                double heapUsedPct = heapUsed / maxHeap * 100.0;
                measures.add(NodeUtils.formatDecimal(NodeUtils.convertMemoryValues(memory.getHeapUsed(), "B", "MB")));
                measures.add(NodeUtils.formatDecimal(NodeUtils.convertMemoryValues(memory.getMaxHeap(), "B", "MB")));
                measures.add(NodeUtils.formatDecimal(NodeUtils.convertMemoryValues(memory.getFreeHeap(), "B", "MB")));
                if (maxHeap > 0.0 && heapUsed > 0.0) {
                    double percentage = heapUsed * 100.0 / maxHeap;
                    measures.add(NodeUtils.formatDecimal(heapUsedPct));
                } else {
                    measures.add(minusFive);
                }
            } else {
                measures.add(minusFive);
                measures.add(minusFive);
                measures.add(minusFive);
                measures.add(minusFive);
            }
            if (cpuObj != null) {
                measures.add(NodeUtils.formatDecimal(cpuObj.getThreadCpuPct()));
            } else {
                measures.add(minusFive);
            }
            measures.add(minusFive);
            this.addNewMeasure(discriptorName, measures);
            logger.debug("{} Added measures for {} : {}", new Object[]{this.logPrefix, discriptorName, measures});
        }
        catch (Exception e) {
            logger.error("{} Exception occurred while adding measures for Node worker thread test : {}", (Object)this.logPrefix, (Object)e);
        }
    }

    public HashMap<String, String> getWorkerPathDetails() {
        return this.threadDD;
    }
}

