/*
 * Decompiled with CFR 0.152.
 */
import com.eg.ConnectionThread;
import com.eg.EgSSL;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class NutanixDiscovery {
    private int connTimeOut = 600000;
    private int readTimeout = 900000;
    String prefixcl = "/api/nutanix/v3/clusters/list";
    String payload = "{\"kind\":\"cluster\",\"length\":100,\"offset\":0}";
    public String prefix = "/PrismGateway/services/rest/v1/";
    public HttpURLConnection connection = null;
    public String strAcropolisIp = "";
    public String strCtrollVmIp = "";
    public String userName = "";
    public String password = "";
    public String strWebPort = "";
    public String strSSL = "";
    public String strCVMIp = "";
    public boolean connState = true;

    public Hashtable getNutanixServersFromPrismCenter(String string, String string2, String string3, String string4, String string5) {
        NutanixDiscovery nutanixDiscovery = new NutanixDiscovery();
        Hashtable hashtable = new Hashtable();
        this.strCVMIp = string;
        this.userName = string2;
        this.password = string3;
        this.strWebPort = string4;
        this.strSSL = string5;
        String string6 = "";
        try {
            String string7;
            ArrayList arrayList = new ArrayList();
            Hashtable hashtable2 = new Hashtable();
            string6 = this.strSSL.equalsIgnoreCase("true") || this.strSSL.equalsIgnoreCase("yes") ? "https://" + this.strCVMIp + ":" + this.strWebPort + this.prefixcl : "http://" + this.strCVMIp + ":" + this.strWebPort + this.prefixcl;
            if (string6 != null && string6.length() > 0) {
                arrayList = this.getData(this.userName, this.password, string6, this.payload);
            }
            if (arrayList != null && arrayList.size() > 0) {
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    string7 = (String)arrayList.get(i);
                    hashtable2 = this.parseV3clusterData(string7);
                }
            }
            if (hashtable2 != null && hashtable2.size() > 0) {
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    String string8 = (String)enumeration.nextElement();
                    string7 = (String)hashtable2.get(string8);
                    Hashtable hashtable3 = nutanixDiscovery.getNutanixServers(string7, string2, string3, string4, string5, string8);
                    if (hashtable3 == null || hashtable3.size() <= 0) continue;
                    hashtable.putAll(hashtable3);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return hashtable;
    }

    public Hashtable parseV3clusterData(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            ArrayList arrayList = new ArrayList();
            Map map = this.stringToJSON(string);
            JSONArray jSONArray = (JSONArray)map.get("entities");
            Iterator iterator = jSONArray.iterator();
            Map map2 = null;
            String string2 = null;
            String string3 = null;
            while (iterator.hasNext()) {
                map2 = (Map)iterator.next();
                try {
                    JSONObject jSONObject;
                    JSONObject jSONObject2;
                    if (map2 == null || map2.size() == 0) {
                        return null;
                    }
                    if (map2 == null || map2.get("status") == null) continue;
                    JSONObject jSONObject3 = (JSONObject)map2.get("status");
                    if (jSONObject3 != null && jSONObject3.get((Object)"name") != null) {
                        string2 = (String)jSONObject3.get((Object)"name");
                    }
                    if (jSONObject3 == null || jSONObject3.get((Object)"resources") == null || (jSONObject2 = (JSONObject)jSONObject3.get((Object)"resources")) == null || jSONObject2.get((Object)"network") == null || (jSONObject = (JSONObject)jSONObject2.get((Object)"network")) == null || jSONObject.get((Object)"external_ip") == null) continue;
                    string3 = (String)jSONObject.get((Object)"external_ip");
                }
                catch (Exception exception) {}
            }
            hashtable.put(string2, string3);
            System.out.println(" [NutanicDiscovery] ht_prism_cluster : " + hashtable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return hashtable;
    }

    public ArrayList getData(String string, String string2, String string3, String string4) {
        Object object;
        ConnectionThread connectionThread;
        Object object2;
        String string5;
        Object object3;
        Object object4;
        System.out.println(" [NutanicDiscovery] wsdlUrl = " + string3 + "\tuserName =" + string);
        URL uRL = null;
        int n = 0;
        ArrayList arrayList = null;
        try {
            if (string3.startsWith("https")) {
                object4 = EgSSL.getInstance();
                EgSSL.enableSSL();
                object3 = (SSLSocketFactory)SSLSocketFactory.getDefault();
                string5 = null;
                object2 = new MyX509TrustManager();
                connectionThread = null;
                TrustManager[] trustManagerArray = new TrustManager[]{object2};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init((KeyManager[])connectionThread, trustManagerArray, new SecureRandom());
                object = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory((SSLSocketFactory)object);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            uRL = new URL(string3);
            object4 = string + ":" + string2;
            object3 = Base64.encodeBase64((byte[])((String)object4).getBytes());
            string5 = new String((byte[])object3);
            this.connection = (HttpURLConnection)uRL.openConnection();
            this.connection.setRequestMethod("POST");
            this.connection.setDoInput(true);
            this.connection.setDoOutput(true);
            this.connection.setConnectTimeout(this.connTimeOut);
            this.connection.setReadTimeout(this.readTimeout);
            this.connection.setRequestProperty("Authorization", "Basic " + string5);
            this.connection.setRequestProperty("Cache-Control", "no-cache");
            this.connection.setRequestProperty("Content-Type", "application/json");
            this.connection.setRequestProperty("Accept", "application/json; charset=UTF-8");
            object2 = null;
            try {
                object2 = new OutputStreamWriter(this.connection.getOutputStream());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            System.out.println(" Out : " + object2);
            if (object2 != null) {
                ((Writer)object2).write(string4);
                ((OutputStreamWriter)object2).close();
            }
            connectionThread = new ConnectionThread(this.connection, false, (ArrayList)null);
            boolean bl = false;
            boolean bl2 = this.checkForTimeout(connectionThread);
            object = new StringBuilder();
            if (bl2) {
                n = connectionThread.code;
                System.out.println(" [NutanicDiscovery] responseCode ==> " + n);
                if (n != 200) {
                    System.err.println("Error in [NutanicDiscovery] getData method REST URL connection ..." + n);
                }
                arrayList = connectionThread.data;
            }
            System.out.println(" [NutanicDiscovery] output ==> " + arrayList);
        }
        catch (Exception exception) {
            System.out.println(" [NutanicDiscovery] exception occured while connecting to the nutanix server for " + string3 + "\tuser =" + string);
            exception.printStackTrace();
        }
        return arrayList;
    }

    public Hashtable getNutanixServers(String string, String string2, String string3, String string4, String string5, String string6) {
        this.strCVMIp = string;
        this.userName = string2;
        this.password = string3;
        this.strWebPort = string4;
        this.strSSL = string5;
        String string7 = "";
        String string8 = "";
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        try {
            String string9;
            int n;
            int n2;
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            if (this.strSSL.equalsIgnoreCase("true") || this.strSSL.equalsIgnoreCase("yes")) {
                string7 = "https://" + this.strCVMIp + ":" + this.strWebPort + this.prefix + "hosts";
                string8 = "https://" + this.strCVMIp + ":" + this.strWebPort + this.prefix + "vms";
            } else {
                string7 = "http://" + this.strCVMIp + ":" + this.strWebPort + this.prefix + "hosts";
                string8 = "http://" + this.strCVMIp + ":" + this.strWebPort + this.prefix + "vms";
            }
            if (string7 != null && string7.length() > 0) {
                arrayList = this.getData(this.userName, this.password, string7);
            }
            if (arrayList != null && string8 != null && string8.length() > 0) {
                arrayList2 = this.getData(this.userName, this.password, string8);
            }
            if (arrayList != null && arrayList.size() > 0) {
                n2 = arrayList.size();
                for (n = 0; n < n2; ++n) {
                    string9 = (String)arrayList.get(n);
                    hashtable = this.parseData(string9);
                }
            }
            if (arrayList2 != null && arrayList2.size() > 0) {
                n2 = arrayList2.size();
                for (n = 0; n < n2; ++n) {
                    string9 = (String)arrayList2.get(n);
                    hashtable2 = this.parseVMData(string9, hashtable);
                }
            }
            Hashtable<String, Hashtable> hashtable3 = new Hashtable<String, Hashtable>();
            if (hashtable2 != null) {
                String string10 = string;
                if (string6 != null && string6.length() > 0 && !string6.equalsIgnoreCase(string)) {
                    string10 = string + "#egsep#" + string6;
                }
                hashtable3.put(string10, hashtable2);
            }
            return hashtable3;
        }
        catch (Exception exception) {
            System.out.println("[NutanixDiscovery] exception occured while calling getData");
            exception.printStackTrace();
            return null;
        }
    }

    public ArrayList getData(String string, String string2, String string3) {
        Object object;
        Object object2;
        String string4;
        Object object3;
        Object object4;
        this.connState = true;
        URL uRL = null;
        int n = 0;
        ArrayList arrayList = null;
        String string5 = EgCrypt.decrypt(string2);
        try {
            if (string3.startsWith("https")) {
                object4 = EgSSL.getInstance();
                EgSSL.enableSSL();
                object3 = (SSLSocketFactory)SSLSocketFactory.getDefault();
                string4 = null;
                object2 = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{object2};
                object = SSLContext.getInstance("SSL");
                ((SSLContext)object).init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory = ((SSLContext)object).getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.connState = false;
        }
        try {
            uRL = new URL(string3);
            object4 = string + ":" + string5;
            object3 = Base64.encodeBase64((byte[])((String)object4).getBytes());
            string4 = new String((byte[])object3);
            this.connection = (HttpURLConnection)uRL.openConnection();
            this.connection.setRequestMethod("GET");
            this.connection.setDoInput(true);
            this.connection.setDoOutput(true);
            this.connection.setConnectTimeout(60000);
            this.connection.setReadTimeout(60000);
            this.connection.setRequestProperty("Authorization", "Basic " + string4);
            this.connection.setRequestProperty("Cache-Control", "no-cache");
            object2 = new ConnectionThread(this.connection, false, (ArrayList)null);
            boolean bl = false;
            boolean bl2 = this.checkForTimeout((ConnectionThread)object2);
            object = new StringBuilder();
            if (bl2) {
                n = ((ConnectionThread)object2).code;
                if (n != 200) {
                    System.err.println("Error in [NutanixDiscovery] getData method REST URL connection ..." + string3);
                    this.connState = false;
                }
                arrayList = ((ConnectionThread)object2).data;
            }
        }
        catch (Exception exception) {
            this.connState = false;
            System.out.println(" [NutanixDiscovery] exception occured while connecting to the nutanix server for " + string3 + "\tuser =" + string);
            exception.printStackTrace();
        }
        return arrayList;
    }

    public void disconnect() {
        try {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        long l4 = 2L * EgConfigInfo.msecPerMin;
        do {
            if (l3 < 250L) {
                l3 = 250L;
            }
            this.suspendForPeriod(l3);
            if (connectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= l4) {
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                return false;
            }
            l = l3;
            if (l4 - l2 >= l) continue;
            l = l4 - l2;
        } while ((l3 = l) > 0L);
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    public Hashtable parseVMData(String string, Hashtable hashtable) {
        try {
            Object object;
            Object object2;
            Object object3;
            Map map = this.stringToJSON(string);
            JSONArray jSONArray = (JSONArray)map.get("entities");
            Iterator iterator = jSONArray.iterator();
            Map map2 = null;
            Hashtable<Object, ArrayList> hashtable2 = new Hashtable<Object, ArrayList>();
            while (iterator.hasNext()) {
                map2 = (Map)iterator.next();
                object3 = "";
                object2 = "";
                object = "";
                try {
                    ArrayList arrayList;
                    String string2;
                    boolean bl;
                    if (map2 == null || map2.size() == 0 || map2.containsKey("controllerVm") && (bl = ((Boolean)map2.get("controllerVm")).booleanValue()) || map2.containsKey("acropolisVm") && (bl = ((Boolean)map2.get("acropolisVm")).booleanValue()) || map2.containsKey("powerState") && ((string2 = (String)map2.get("powerState")).equalsIgnoreCase("off") || string2.equalsIgnoreCase("suspended"))) continue;
                    if (map2.containsKey("guestOperatingSystem")) {
                        object = (String)map2.get("guestOperatingSystem");
                    }
                    if (map2.containsKey("hostName")) {
                        object3 = (String)map2.get("hostName");
                    }
                    if (map2.containsKey("hostId")) {
                        object2 = (String)map2.get("hostId");
                    }
                    if (hashtable2 != null && hashtable2.containsKey(object3)) {
                        arrayList = (ArrayList)hashtable2.get(object3);
                        arrayList.add(object);
                        hashtable2.put(object3, arrayList);
                        continue;
                    }
                    arrayList = new ArrayList();
                    arrayList.add(object);
                    hashtable2.put(object3, arrayList);
                }
                catch (Exception exception) {}
            }
            object3 = new Hashtable();
            if (hashtable != null && hashtable.size() > 0) {
                object2 = new Hashtable();
                object = new Hashtable();
                Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
                Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    Hashtable hashtable5 = null;
                    if (string3.equalsIgnoreCase("Nutanix_Acropolis")) {
                        hashtable5 = (Hashtable)hashtable.get(string3);
                        ((Hashtable)object3).put("Nutanix_Acropolis", hashtable5);
                        continue;
                    }
                    hashtable5 = (Hashtable)hashtable.get(string3);
                    if (hashtable5 == null || hashtable5.size() <= 0) continue;
                    Enumeration enumeration2 = hashtable5.keys();
                    while (enumeration2.hasMoreElements()) {
                        String string4 = (String)enumeration2.nextElement();
                        String string5 = (String)hashtable5.get(string4);
                        boolean bl = false;
                        if (hashtable2 != null && hashtable2.containsKey(string4)) {
                            ArrayList arrayList = (ArrayList)hashtable2.get(string4);
                            if (arrayList != null && arrayList.size() > 0) {
                                int n = 0;
                                int n2 = 0;
                                for (int i = 0; i < arrayList.size(); ++i) {
                                    String string6 = (String)arrayList.get(i);
                                    if ((string6 = string6.toLowerCase()) != null && (string6.indexOf("2008") > 0 || string6.indexOf("2010") > 0 || string6.indexOf("2012") > 0 || string6.indexOf("2016") > 0 || string6.indexOf("2019") > 0 || string6.indexOf("2022") > 0 || string6.indexOf("linux") >= 0 || string6.indexOf("centos") >= 0 || string6.indexOf("server") > 0 || string6.indexOf("other") >= 0 || string6.indexOf("freebsd") >= 0)) {
                                        ++n;
                                        continue;
                                    }
                                    ++n2;
                                }
                                bl = n >= n2;
                            } else {
                                bl = true;
                            }
                        }
                        if (string3.equalsIgnoreCase("VmEsx_i_server")) {
                            if (bl) {
                                ((Hashtable)object2).put(string4, string5);
                                continue;
                            }
                            ((Hashtable)object).put(string4, string5);
                            continue;
                        }
                        if (!string3.equalsIgnoreCase("Hyperv_server")) continue;
                        if (bl) {
                            hashtable3.put(string4, string5);
                            continue;
                        }
                        hashtable4.put(string4, string5);
                    }
                }
                if (object2 != null && ((Hashtable)object2).size() > 0) {
                    ((Hashtable)object3).put("VmEsx_i_server", object2);
                }
                if (object != null && ((Hashtable)object).size() > 0) {
                    ((Hashtable)object3).put("VmVdi_i_server", object);
                }
                if (hashtable3 != null && hashtable3.size() > 0) {
                    ((Hashtable)object3).put("Hyperv_server", hashtable3);
                }
                if (hashtable4 != null && hashtable4.size() > 0) {
                    ((Hashtable)object3).put("HyperV_VDI_server", hashtable4);
                }
            }
            System.out.println("[NutanixDiscovery] ht_allHostServer : " + object3);
            return object3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Hashtable parseData(String string) {
        try {
            Object object;
            Hashtable hashtable = new Hashtable();
            ArrayList arrayList = new ArrayList();
            Map map = this.stringToJSON(string);
            JSONArray jSONArray = (JSONArray)map.get("entities");
            Iterator iterator = jSONArray.iterator();
            Map map2 = null;
            Vector vector = new Vector();
            Hashtable hashtable2 = new Hashtable();
            Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
            Hashtable<String, Object> hashtable4 = new Hashtable<String, Object>();
            Hashtable<String, Object> hashtable5 = new Hashtable<String, Object>();
            while (iterator.hasNext()) {
                map2 = (Map)iterator.next();
                try {
                    if (map2 == null || map2.size() == 0) {
                        return null;
                    }
                    object = (String)map2.get("hypervisorAddress");
                    String string2 = (String)map2.get("name");
                    String string3 = (String)map2.get("hypervisorType");
                    if (string3 != null && string3.equalsIgnoreCase("kKvm")) {
                        hashtable3.put(string2, object);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("kVMware")) {
                        hashtable4.put(string2, object);
                        continue;
                    }
                    if (!string3.equalsIgnoreCase("kHyperv")) continue;
                    hashtable5.put(string2, object);
                }
                catch (Exception exception) {}
            }
            object = new Hashtable();
            if (hashtable3 != null && hashtable3.size() > 0) {
                hashtable.put("Nutanix_Acropolis", hashtable3);
            }
            if (hashtable4 != null && hashtable4.size() > 0) {
                hashtable.put("VmEsx_i_server", hashtable4);
            }
            if (hashtable5 != null && hashtable5.size() > 0) {
                hashtable.put("Hyperv_server", hashtable5);
            }
            return hashtable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Map stringToJSON(String string) {
        JSONParser jSONParser = new JSONParser();
        Object object = null;
        try {
            object = jSONParser.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
        return (JSONObject)object;
    }

    public boolean isConnected() {
        return this.connState;
    }

    public static void main(String[] stringArray) {
        if (stringArray == null || stringArray.length < 5) {
            System.out.println("Format should be : java NutanixDiscovery cvmip user pass webPort ssl");
            return;
        }
        NutanixDiscovery nutanixDiscovery = new NutanixDiscovery();
        Hashtable hashtable = nutanixDiscovery.getNutanixServers(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], null);
        System.out.println(" output =" + hashtable);
    }
}

