/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class PoolDataAggrTest
extends SapWasGenericTest {
    private static final String TOTAL_MEM_ALLOC = "\"/Kernel/Pool Manager/Aggregated Data/TotalMemoryAllocated\"";
    private static final String TOTAL_MEM_USED = "\"/Kernel/Pool Manager/Aggregated Data/TotalMemoryUsed\"";
    private static final double MB = 1048576.0;
    ArrayList keysList;

    public PoolDataAggrTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(2);
        this.isDynamicInfoTest = true;
        if (this.keysList == null) {
            this.keysList = new ArrayList();
            this.keysList.add(TOTAL_MEM_ALLOC);
            this.keysList.add(TOTAL_MEM_USED);
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        Hashtable hashtable2 = null;
        try {
            this.storeMeasures();
            hashtable2 = this.getMeasures(this.keysList, 0);
            this.procHash(hashtable2);
            Enumeration enumeration = hashtable2.keys();
            String string = "";
            double d = 0.0;
            while (enumeration.hasMoreElements()) {
                ArrayList arrayList = new ArrayList();
                string = (String)enumeration.nextElement();
                arrayList = (ArrayList)hashtable2.get(string);
                if (arrayList == null || arrayList.size() == 0) continue;
                for (int i = 0; i < arrayList.size(); ++i) {
                    d = (Double)arrayList.get(i);
                    if (d >= 0.0) {
                        d /= 1048576.0;
                    }
                    arrayList.set(i, new Double(d));
                }
                this.addNewMeasure(string, arrayList);
                this.printOut("Got new measure for descriptor " + string + " measures : " + arrayList);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", this.entity, "Error in computeMeasures() : " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void displayMeasures() {
        Hashtable hashtable = null;
        try {
            this.storeMeasures();
            hashtable = this.getMeasures(this.keysList, 0);
            this.procHash(hashtable);
            Enumeration enumeration = hashtable.keys();
            String string = "";
            double d = 0.0;
            while (enumeration.hasMoreElements()) {
                ArrayList arrayList = new ArrayList();
                string = (String)enumeration.nextElement();
                arrayList = (ArrayList)hashtable.get(string);
                if (arrayList == null || arrayList.size() == 0) continue;
                for (int i = 0; i < arrayList.size(); ++i) {
                    d = (Double)arrayList.get(i);
                    if (d >= 0.0) {
                        d /= 1048576.0;
                    }
                    arrayList.set(i, new Double(d));
                }
                this.printOut("Got new measure for descriptor " + string + " measures : " + arrayList);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", this.entity, "Error in computeMeasures() : " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        PoolDataAggrTest poolDataAggrTest = new PoolDataAggrTest(stringArray);
        poolDataAggrTest.decryptPassword();
        String string = poolDataAggrTest.getValueForParam("debug");
        boolean bl = false;
        bl = Boolean.valueOf(string);
        poolDataAggrTest.printOut("debug value is " + bl);
        if (bl) {
            poolDataAggrTest.displayMeasures();
            poolDataAggrTest.printOut("Keys : " + poolDataAggrTest.keysList);
        } else {
            poolDataAggrTest.computeMeasures(new Hashtable());
        }
    }
}

