/*
 * Decompiled with CFR 0.152.
 */
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoFunction;
import java.util.ArrayList;

public class R3ConnectionJco3Test
extends AsAbapJco3Base {
    double defValue = -1.0;

    public R3ConnectionJco3Test(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(3);
        if (this.isPassive) {
            this.defValue = -5.0;
        }
    }

    protected boolean executeCmd() {
        this.printOut("executeCommand : ");
        this.setSessID();
        JCoDestination jCoDestination = R3ConnectionJco3Test.getDestination(this.destName);
        if (jCoDestination == null) {
            this.endSession();
            return false;
        }
        try {
            JCoFunction jCoFunction = this.getFunction("STFC_CONNECTION");
            if (jCoFunction == null) {
                this.endSession();
                return false;
            }
            jCoFunction.getImportParameterList().setValue("REQUTEXT", this.destName);
            this.printOut("DEBUG: executeCommand : Set request text to " + this.destName);
            this.executeFunction(jCoFunction, false);
            this.printOut("DEBUG : Got echotext " + jCoFunction.getExportParameterList().getValue("ECHOTEXT"));
            this.printOut("DEBUG : Got resptext " + jCoFunction.getExportParameterList().getValue("RESPTEXT"));
            this.printOut("executeCommand succeeded");
            this.endSession();
            return true;
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", this.entity + "  " + this.thisServer, "Exception in executeCommand method : " + exception.toString());
            this.printOut("ERROR : Exception in executeCommand method : " + exception.toString());
            this.endSession();
            return false;
        }
    }

    public ArrayList getMeasList() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        long l = System.currentTimeMillis();
        if (this.getConnection()) {
            this.printOut("Got connection");
            d3 = 100.0;
            long l2 = System.currentTimeMillis();
            boolean bl = this.executeCmd();
            this.printOut("executeCommand returned " + bl);
            d2 = (double)(System.currentTimeMillis() - l2) / 1000.0;
            d = (double)(l2 - l) / 1000.0;
            if (!bl) {
                this.printOut("Could not process executeCommand  method ");
                this.logToErrorFile("ERROR :", this.reportingName + " " + this.entity, "Could not process executeCommand  method");
                arrayList.add(new Double(0.0));
                arrayList.add(new Double(0.0));
                arrayList.add(new Double(0.0));
                this.printOut("Got measure " + arrayList.toString());
                return arrayList;
            }
            arrayList.add(new Double(d3));
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            this.printOut("Got measure " + arrayList.toString());
            return arrayList;
        }
        this.printOut("Didn't get connection");
        if (this.isPassive) {
            arrayList.add(new Double(this.defValue));
            arrayList.add(new Double(this.defValue));
            arrayList.add(new Double(this.defValue));
            this.printOut("Got measure " + arrayList.toString());
            return arrayList;
        }
        arrayList.add(new Double(0.0));
        arrayList.add(new Double(0.0));
        arrayList.add(new Double(0.0));
        this.printOut("Got measure " + arrayList.toString());
        return arrayList;
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("-password")) continue;
            stringArray[i + 1] = EgCrypt.decrypt(stringArray[i + 1]);
            break;
        }
        R3ConnectionJco3Test r3ConnectionJco3Test = new R3ConnectionJco3Test(stringArray);
        r3ConnectionJco3Test.decryptPassword();
        System.out.println("Measures List : " + r3ConnectionJco3Test.getMeasList());
    }
}

