/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class RUMBrowserTest
extends EgRUMBase {
    private Hashtable ddDataTable = null;
    private Hashtable ddResourceDataTable = null;
    private static Hashtable serviceInfoTable = new Hashtable();
    private Hashtable measureDDAvailabilityMap = null;
    private boolean reportAllMetrics = false;

    public RUMBrowserTest(String[] args) {
        super(args);
        this.setMeasureCount(this.measureCount);
        String reportAllMet = this.getValueForParam("report_all_metrics");
        if (reportAllMet != null && (reportAllMet.equals("true") || reportAllMet.equals("yes"))) {
            this.reportAllMetrics = true;
        }
        logger.debug("[" + this.reportingName + "][" + this.entity + "] Report all metrics is : " + this.reportAllMetrics);
        logger.info("[" + this.reportingName + "][" + this.entity + "] Test is initilized !!!");
    }

    public void computeMeasures(Hashtable paramList) {
        logger.debug("[" + this.reportingName + "][" + this.entity + "] #########################################");
        logger.debug("[" + this.reportingName + "][" + this.entity + "] IS STARTING !!!");
        this.isAppTestFinishedExecution();
        this.measureDDAvailabilityMap = new Hashtable();
        this.ddResourceDataTable = new Hashtable();
        boolean newCollectorUsed = false;
        try {
            newCollectorUsed = this.computeValues();
        }
        catch (Exception e) {
            logger.error("[" + this.reportingName + "][" + this.entity + "] Error occured during computingmeasurs method : " + e.getMessage());
            logger.trace("[" + this.reportingName + "][" + this.entity + "] Error occured during computingmeasurs method : ", (Throwable)e);
        }
        EgRUMBase.siteRumTimeMap.put(String.valueOf(this.entity) + ":" + this.reportingName, new Long(System.currentTimeMillis()));
        ArrayList measuresList = new ArrayList();
        if (this.isPerDayLimitExceeded()) {
            int i = 0;
            while (i < this.measureCount) {
                measuresList.add(minusFive);
                ++i;
            }
            measuresList = RUMBrowserTest.removeExtraMeasure(this.measureCount, measuresList);
            this.addNewMeasure(this.serviceName, measuresList);
            return;
        }
        HashSet<String> infoSet = (HashSet<String>)serviceInfoTable.get(this.serviceName);
        if (infoSet == null) {
            infoSet = new HashSet<String>();
        }
        this.dataForReportAllMetrics(measuresList, infoSet);
        if (newCollectorUsed) {
            try {
                Map browserStatsMap = this.getBrowserStatisticsMap();
                logger.debug("[{}][{}] browserStatisticsMap is = {}", new Object[]{this.reportingName, this.entity, browserStatsMap});
                this.updateDataFromNewCollector(browserStatsMap, this.measureDDAvailabilityMap, 13, infoSet, 34);
            }
            catch (Exception ee) {
                logger.error("[{}][{}] Iteration of specified hashMap failed : ", new Object[]{this.reportingName, this.entity, ee.getMessage()});
            }
            serviceInfoTable.put(this.serviceName, infoSet);
            return;
        }
        this.ddDataTable = new Hashtable();
        try {
            Hashtable browserStats = this.getBrowserStatistics();
            if (browserStats != null) {
                for (String key : browserStats.keySet()) {
                    RUMSummaryData data = (RUMSummaryData)browserStats.get(key);
                    double normalRequestCount = data.getSatisfiedRequestCount();
                    double toleratedRequestCount = data.getToleratedRequestCount();
                    Double apdex = new Double(-5.0);
                    if (data.getRequestCount() != 0.0) {
                        double totalapdex = (normalRequestCount + toleratedRequestCount / 2.0) / data.getRequestCount();
                        apdex = RUMBrowserTest.getDoubleValue(formatter.format(totalapdex), apdex);
                    }
                    measuresList = new ArrayList();
                    measuresList.add(data.getRequestCount());
                    measuresList.add(data.getSlowRequestCount());
                    measuresList.add(data.getErrorRequestCount());
                    measuresList.add(data.getAveragePageLoadTime());
                    measuresList.add(data.getAverageFrontEndTime());
                    measuresList.add(data.getPageRenderingTime());
                    measuresList.add(data.getAverageDocumentReadyTime());
                    measuresList.add(data.getDomDownloadTime());
                    measuresList.add(data.getDomProcessingTime());
                    measuresList.add(data.getAverageFirstByteTime());
                    measuresList.add(data.getAverageResponseAvailableTime());
                    measuresList.add(data.getAverageNetworkTime());
                    measuresList.add(data.getDNSLookUpTime());
                    measuresList.add(data.getTCPConnectionTime());
                    measuresList.add(data.getRequestPerMinute());
                    measuresList.add(data.getNormalPercentage());
                    measuresList.add(data.getSlowPercentage());
                    measuresList.add(data.getErrorPercentage());
                    measuresList.add(new Double(Double.parseDouble(data.getUserSession())));
                    measuresList.add(data.getSatisfiedRequestCount());
                    measuresList.add(data.getToleratedRequestCount());
                    measuresList.add(data.getFrustratedRequestCount());
                    measuresList.add(apdex);
                    measuresList.add(data.getAverageSslHandshakeTime());
                    measuresList.add(data.getAverageAppCacheTime());
                    measuresList.add(data.getAverageRedirectionTime());
                    measuresList.add(data.getAverageBrowserWaitTime());
                    measuresList.add(data.getAverageBrowserInitialReqTime());
                    infoSet.add(key);
                    this.ddDataTable.put(key, data.getDDDataList());
                    this.ddResourceDataTable.put(this.serviceName, data.getDDResourceData());
                    if (this.healthyTopNDD_Limit != 0 && data.getRequestCount() > 0.0) {
                        this.measureDDAvailabilityMap.put("All:" + key, new Boolean(true));
                    }
                    if (data.getSlowRequestCount() > 0.0) {
                        this.measureDDAvailabilityMap.put("Slow:" + key, new Boolean(true));
                    }
                    if (data.getErrorRequestCount() > 0.0) {
                        this.measureDDAvailabilityMap.put("Error:" + key, new Boolean(true));
                    }
                    if (data.getSatisfiedRequestCount() > 0.0) {
                        this.measureDDAvailabilityMap.put("Satisfied:" + key, new Boolean(true));
                    }
                    if (data.getToleratedRequestCount() > 0.0) {
                        this.measureDDAvailabilityMap.put("Tolerating:" + key, new Boolean(true));
                    }
                    if (data.getFrustratedRequestCount() > 0.0) {
                        this.measureDDAvailabilityMap.put("Frustrated:" + key, new Boolean(true));
                    }
                    measuresList = RUMBrowserTest.removeExtraMeasure(this.measureCount, measuresList);
                    this.addNewMeasure(key, measuresList);
                }
            }
        }
        catch (Exception e) {
            logger.error("[" + this.reportingName + "][" + this.entity + "] Exception in computing the measures : " + e.getMessage());
            logger.trace("[" + this.reportingName + "][" + this.entity + "] Exception in computing the measures : ", (Throwable)e);
        }
        serviceInfoTable.put(this.serviceName, infoSet);
    }

    private void dataForReportAllMetrics(ArrayList measuresList, HashSet infoSet) {
        if (this.reportAllMetrics) {
            int i = 0;
            while (i < this.measureCount) {
                if (i == 18 || i == 22) {
                    measuresList.add(minusFive);
                } else {
                    measuresList.add(zeroDouble);
                }
                ++i;
            }
            measuresList = RUMBrowserTest.removeExtraMeasure(this.measureCount, measuresList);
            Iterator infoItr = infoSet.iterator();
            while (infoItr.hasNext()) {
                this.addNewMeasure((String)infoItr.next(), measuresList);
            }
        }
    }

    public boolean isDDAvailable(String measureColanInfo) {
        if (!this.measureDDAvailabilityMap.containsKey(measureColanInfo)) {
            return false;
        }
        return (Boolean)this.measureDDAvailabilityMap.get(measureColanInfo) != false;
    }

    public ArrayList getDDData(String info) {
        ArrayList dd = null;
        if (!this.isDDSent(this.entity)) {
            dd = (ArrayList)this.ddDataTable.remove(info);
        }
        return dd;
    }

    public ArrayList getDDResourceData(String info) {
        ArrayList dd = null;
        if (!this.isDDSent(this.entity)) {
            dd = (ArrayList)this.ddResourceDataTable.remove(info);
        }
        return dd;
    }
}

