/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;

public class RbtSteelUptimeTest
extends EgSnmpGenericTest {
    private double currSysuptime = 0.0;
    private double prevSysuptime = 0.0;
    private DataOutputStream dos = null;
    private DataInputStream dis = null;
    private File f = null;
    private String installdir = EgInstallInfo.getInstallDir() + "/agent/logs/SteelHeadSysUptime_" + this.reportingName + ".log";

    public RbtSteelUptimeTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(3);
        this.isDynamicInfoTest = true;
        this.f = new File(this.installdir);
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            double d = this.getMeasures(".1.3.6.1.2.1.1.3");
            double d2 = d / 100.0;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            if (d2 <= 0.0) {
                this.currSysuptime = 0.0;
                arrayList.add(new Double(-5.0));
                arrayList.add(new Double(-5.0));
                arrayList.add(new Double(-5.0));
                this.addNewMeasure(arrayList);
                return;
            }
            if (this.currSysuptime == 0.0 && !this.f.exists()) {
                this.currSysuptime = d2;
                arrayList.add(new Double(0.0));
                arrayList.add(new Double(-5.0));
                double d3 = this.currSysuptime / 60.0;
                arrayList.add(new Double(d3));
                this.addNewMeasure(arrayList);
                this.writeDoubleToFile(this.currSysuptime);
                return;
            }
            if (!this.f.exists()) {
                this.currSysuptime = d2;
                arrayList.add(new Double(0.0));
                arrayList.add(new Double(-5.0));
                double d4 = this.currSysuptime / 60.0;
                arrayList.add(new Double(d4));
                this.addNewMeasure(arrayList);
                this.writeDoubleToFile(this.currSysuptime);
                return;
            }
            this.currSysuptime = d2;
            this.prevSysuptime = this.readDoubleFromFile();
            if (this.currSysuptime < this.prevSysuptime) {
                arrayList.add(new Double(1.0));
                arrayList.add(new Double(this.currSysuptime));
                double d5 = this.currSysuptime / 60.0;
                arrayList.add(new Double(d5));
            } else {
                arrayList.add(new Double(0.0));
                arrayList.add(new Double(this.currSysuptime - this.prevSysuptime));
                double d6 = this.currSysuptime / 60.0;
                arrayList.add(new Double(d6));
            }
            this.prevSysuptime = this.currSysuptime;
            this.writeDoubleToFile(this.currSysuptime);
            this.addNewMeasure(arrayList);
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "RbtSteelUptimeTest Exception occured in computeMeasures method for ", this.targetHost);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void writeDoubleToFile(double d) {
        block9: {
            this.dos = new DataOutputStream(new FileOutputStream(this.f));
            this.dos.writeDouble(d);
            this.dos.flush();
            Object var5_2 = null;
            try {
                this.dos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dos = null;
            {
                break block9;
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var5_3 = null;
                    try {
                        this.dos.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    this.dos = null;
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    this.dos.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.dos = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private double readDoubleFromFile() {
        double d;
        block13: {
            block10: {
                d = 0.0;
                if (this.f.exists()) break block10;
                double d2 = -5.0;
                Object var6_4 = null;
                try {
                    this.dis.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.dis = null;
                return d2;
            }
            this.dis = new DataInputStream(new FileInputStream(this.f));
            d = this.dis.readDouble();
            Object var6_5 = null;
            try {
                this.dis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dis = null;
            {
                break block13;
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var6_6 = null;
                    try {
                        this.dis.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    this.dis = null;
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    this.dis.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.dis = null;
                throw throwable;
            }
        }
        return d;
    }

    private double getMeasures(String string) {
        double d = -5.0;
        try {
            boolean bl = this.runSnmpCmdForOid(string);
            if (bl) {
                for (int i = 0; i < this.lhs.length; ++i) {
                    if (this.rhs[i] != null && this.rhs[i].trim().length() > 0) {
                        String string2 = this.rhs[i].trim();
                        d = Double.parseDouble(string2);
                        continue;
                    }
                    d = -5.0;
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "RbtSteelUptimeTest Exception occured in getMeasures method for ", this.targetHost);
            d = -5.0;
        }
        return d;
    }

    public static void main(String[] stringArray) {
        RbtSteelUptimeTest rbtSteelUptimeTest = new RbtSteelUptimeTest(stringArray);
        rbtSteelUptimeTest.computeMeasures(new Hashtable());
    }
}

