/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class RedisClntGrpTest
extends RedisBase {
    boolean uploadStatus = false;
    public static final Hashtable flagDiscriptionTable = new Hashtable();

    public RedisClntGrpTest(String[] stringArray) {
        super(stringArray);
        try {
            this.needAgentlessDD = true;
            logger.info("{} Initializing RedisClientByGroupTest ...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            logger.info("{} RedisClientByGroupTest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception exception) {
            logger.warn("{} Exception while initializing RedisClientByGroupTest {}", (Object)this.logPrefix, (Object)exception);
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testStart);
            this.getClientListByGroup();
        }
        catch (Exception exception) {
            logger.warn("{} Exception occured in computeMeasures method {}", (Object)this.logPrefix, (Object)exception);
        }
        finally {
            logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testEnd);
        }
    }

    public ArrayList getClientDetails() {
        String string = this.getclientList();
        logger.debug("[RedisClientByGroupTest] [getClientDetails] The Client List is :  \n {}", (Object)string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        ArrayList arrayList = new ArrayList();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.contains("cmd=replconf")) continue;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " ");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            while (stringTokenizer2.hasMoreTokens()) {
                String string3 = stringTokenizer2.nextToken();
                int n = string3.indexOf("=");
                if (n <= 0) continue;
                String string4 = string3.substring(0, n);
                String string5 = string3.substring(n + 1);
                hashMap.put(string4, string5);
            }
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    public boolean getClientListByGroup() {
        ArrayList arrayList = null;
        boolean bl = false;
        try {
            arrayList = this.getClientDetails();
            if (arrayList == null || arrayList.size() == 0) {
                this.addNewMeasure(this.finalMeasures(this.measureCount));
                logger.info("{} Redis Client List Details is null or empty, hence sending -5 values for all measures ", (Object)this.logPrefix);
                return bl;
            }
            logger.debug("[{}:{}][RedisClientByGroupTest] [getClientListByGroup] The ClientDetails are {}", new Object[]{this.reportingName, this.portNo, arrayList});
            for (int i = 0; i < arrayList.size(); ++i) {
                String string;
                String string2;
                String string3;
                String string4;
                String string5;
                String string6;
                String string7;
                String string8;
                String string9;
                String string10;
                ArrayList arrayList2 = this.finalMeasures(this.measureCount);
                HashMap hashMap = (HashMap)arrayList.get(i);
                String string11 = (String)hashMap.get("id");
                if (string11 == null || string11.length() == 0) {
                    string11 = "-5";
                }
                String string12 = (String)hashMap.get("addr");
                String string13 = string12.substring(0, string12.indexOf(58));
                String string14 = string12.substring(string12.indexOf(58) + 1);
                if (string12 == null || string12.length() == 0) {
                    string13 = "-5";
                    string14 = "-5";
                }
                if ((string10 = (String)hashMap.get("fd")) == null || string10.length() == 0) {
                    string10 = "-5";
                }
                if ((string9 = (String)hashMap.get("name")) == null || string9.length() == 0) {
                    string9 = "-";
                }
                if ((string8 = (String)hashMap.get("age")) == null || string8.length() == 0) {
                    string8 = "-5";
                }
                if ((string7 = (String)hashMap.get("idle")) == null || string7.length() == 0) {
                    string7 = "-5";
                }
                String string15 = (String)hashMap.get("flags");
                if ((string15 = (String)flagDiscriptionTable.get(string15)) == null || string15.length() == 0) {
                    string15 = "-";
                }
                if ((string6 = (String)hashMap.get("db")) == null || string6.length() == 0) {
                    string6 = "-5";
                }
                if ((string5 = (String)hashMap.get("sub")) == null || string5.length() == 0) {
                    string5 = "-5";
                }
                if ((string4 = (String)hashMap.get("psub")) == null || string4.length() == 0) {
                    string4 = "-5";
                }
                if ((string3 = (String)hashMap.get("multi")) == null || string3.length() == 0) {
                    string3 = "-";
                }
                String string16 = (String)hashMap.get("qbuf");
                if ((string16 = EgUtils.convertMemoryValues(string16, "B", "MB")) == null || string16.length() == 0) {
                    string16 = "-";
                }
                String string17 = (String)hashMap.get("qbuf-free");
                string17 = EgUtils.convertMemoryValues(string16, "B", "MB");
                if (string17 == null || string17.length() == 0) {
                    string17 = "-5";
                }
                String string18 = (String)hashMap.get("obl");
                if ((string18 = EgUtils.convertMemoryValues(string18, "B", "MB")) == null || string18.length() == 0) {
                    string18 = "-5";
                }
                if ((string2 = (String)hashMap.get("oll")) == null || string2.length() == 0) {
                    string2 = "-5";
                }
                String string19 = (String)hashMap.get("omem");
                if ((string19 = EgUtils.convertMemoryValues(string19, "B", "MB")) == null || string19.length() == 0) {
                    string19 = "-5";
                }
                if ((string = (String)hashMap.get("events")) == null || string.length() == 0) {
                    string = "-";
                } else if (string.equals("r")) {
                    string = "readable";
                } else if (string.equals("w")) {
                    string = "writable";
                }
                String string20 = (String)hashMap.get("cmd");
                if (string20 == null || string20.length() == 0) {
                    string20 = "-";
                }
                arrayList2.set(0, new Double(string11));
                arrayList2.set(1, new Double(-5.0));
                arrayList2.set(2, new Double(string14));
                arrayList2.set(3, new Double(string10));
                arrayList2.set(4, new Double(string6));
                arrayList2.set(5, new Double(string8));
                arrayList2.set(6, new Double(string7));
                arrayList2.set(7, new Double(string5));
                arrayList2.set(8, new Double(string4));
                arrayList2.set(9, new Double(string16));
                arrayList2.set(10, new Double(string17));
                arrayList2.set(11, new Double(string18));
                arrayList2.set(12, new Double(string2));
                arrayList2.set(13, new Double(string19));
                if (!string9.equals("-")) {
                    this.addNewMeasure(string13 + ":" + string9, arrayList2);
                    logger.info("[{}:{}][RedisClientByGroupTest] [getClientListByGroup] {} Client Name: {} : The ArrayList measure contains = {}", new Object[]{this.reportingName, this.portNo, string13, string9, arrayList2});
                    continue;
                }
                this.addNewMeasure(string13 + ":" + string11, arrayList2);
                logger.info("[{}:{}][RedisClientByGroupTest] [getClientListByGroup]  {} Client ID: {} : The ArrayList measure contains = {}", new Object[]{this.reportingName, this.portNo, string13, string11, arrayList2});
            }
            bl = true;
        }
        catch (Exception exception) {
            logger.warn("[{}:{}][RedisClientByGroupTest] [getClientListByGroup] Exception while fetching the values {}", new Object[]{this.reportingName, this.portNo, exception});
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        RedisClntGrpTest redisClntGrpTest = new RedisClntGrpTest(null);
        redisClntGrpTest.computeMeasures(new Hashtable());
    }

    static {
        flagDiscriptionTable.put("O", "Slave in monitor mode");
        flagDiscriptionTable.put("S", "Normal slave server");
        flagDiscriptionTable.put("M", "Master");
        flagDiscriptionTable.put("x", "MULTI/EXEC context");
        flagDiscriptionTable.put("b", "Waiting in a blocking operation");
        flagDiscriptionTable.put("i", "Waiting for a VM I/O");
        flagDiscriptionTable.put("d", "A watched keys has been modified - EXEC will fail");
        flagDiscriptionTable.put("c", "Connection to be closed after writing entire reply");
        flagDiscriptionTable.put("u", "Unblocked");
        flagDiscriptionTable.put("U", "Connected via a Unix domain socket");
        flagDiscriptionTable.put("r", "Readonly mode against a cluster node");
        flagDiscriptionTable.put("A", "Connection to be closed ASAP");
        flagDiscriptionTable.put("N", "No specific flag set");
    }
}

