/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class RedisCmdStatsTest
extends RedisBase {
    private static final String REDIS_CMDSTATS_COMMAND = "Commandstats";
    private static final String indexSubject = "REDIS_COMMANDSTAT_MEASURE_INDEX";
    private static final String nameSubject = "REDIS_COMMANDSTAT_MEASURE";
    private static Hashtable measureIndexTable = new Hashtable();
    private static Hashtable measureNameTable = new Hashtable();
    private static ArrayList redisNameList = new ArrayList();
    private long lastModifiedTime = 0L;
    private Hashtable previousMeasureTable = new Hashtable();
    boolean isDiscriptorName = false;
    private static final boolean isInfoBased = true;
    private static String iniFilePath = "/agent/config/eg_measures.ini";
    private boolean firstTime = false;

    public RedisCmdStatsTest(String[] stringArray) {
        super(stringArray);
        try {
            this.needAgentlessDD = true;
            logger.info("{} Initializing RedisCmdStatsTest ...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            measureIndexTable = this.getIndexTable(indexSubject);
            measureNameTable = this.getNameTable(nameSubject);
            redisNameList = this.getNameList(nameSubject);
            this.lastModifiedTime = this.getModifiedTime();
            logger.info("{} RedisCmdStatsTest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception exception) {
            logger.warn("{} Exception while initializing RedisCmdStatsTest", (Object)this.logPrefix, (Object)exception);
        }
        this.firstTime = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        try {
            logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testStart);
            String string = this.getMetrics(REDIS_CMDSTATS_COMMAND);
            if (string == null || string.length() <= 0) {
                this.addNewMeasure(this.finalMeasures(this.measureCount));
                logger.info("{} Redis Command Stats Details is null or empty, hence sending -5 values for all measures ", (Object)this.logPrefix);
            } else {
                Hashtable hashtable2 = this.parseMetrics(string, true);
                this.getRedisMeasureForCommandStats(hashtable2);
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception occured in computeMeasures method {}", (Object)this.logPrefix, (Object)exception);
        }
        finally {
            logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testEnd);
        }
    }

    public void getRedisMeasureForCommandStats(Hashtable hashtable) {
        block23: {
            if (hashtable == null || hashtable.size() == 0) {
                logger.debug("{} [getRedisMeasureForCommandStats]  metricObject is null or empty ,thus returning null", (Object)this.logPrefix);
                return;
            }
            try {
                long l = this.getModifiedTime();
                if (l - this.lastModifiedTime > 0L) {
                    this.updateINIFileObject();
                    measureIndexTable = this.getIndexTable(indexSubject);
                    measureNameTable = this.getNameTable(nameSubject);
                    redisNameList = this.getNameList(nameSubject);
                    this.lastModifiedTime = l;
                }
                logger.debug("{} [getRedisMeasureForCommandStats] metricObject : {}", (Object)this.logPrefix, (Object)hashtable);
                logger.debug("{} [getRedisMeasureForCommandStats] measureIndexTable : {}", (Object)this.logPrefix, (Object)measureIndexTable);
                logger.debug("{} [getRedisMeasureForCommandStats] measureNameTable  : {}", (Object)this.logPrefix, (Object)measureNameTable);
                logger.debug("{} [getRedisMeasureForCommandStats] redisNameList     : {}", (Object)this.logPrefix, (Object)redisNameList);
                if (this.firstTime) {
                    this.firstTime = false;
                    logger.info("{} [getRedisMeasureForCommandStats] The test is running for the first time", (Object)this.logPrefix);
                    if (hashtable == null || hashtable.size() <= 0) break block23;
                    Hashtable hashtable2 = (Hashtable)hashtable.get(REDIS_CMDSTATS_COMMAND);
                    Set set = hashtable2.keySet();
                    for (String string : set) {
                        Hashtable hashtable3 = (Hashtable)hashtable2.get(string);
                        string = string.replace("cmdstat_", "");
                        logger.debug("{} [getRedisMeasureForCommandStats]The discriptor : {} and its value : {}", new Object[]{this.logPrefix, string, hashtable3});
                        Iterator iterator = (Iterator)((Object)hashtable3.keys());
                        ArrayList arrayList = this.finalMeasures(this.measureCount);
                        while (iterator.hasNext()) {
                            String string2 = (String)iterator.next();
                            Object object = null;
                            try {
                                object = hashtable3.get(string2);
                            }
                            catch (Exception exception) {
                                logger.debug("{} [getRedisMeasureForCommandStats] Exception occured while iterating the metric value {}", (Object)this.logPrefix, (Object)exception);
                            }
                            if (!redisNameList.contains(string2)) continue;
                            String string3 = (String)measureNameTable.get(string2);
                            int n = Integer.parseInt(measureIndexTable.get(string3).toString());
                            try {
                                double d = Double.parseDouble(object.toString());
                                double d2 = 0.0;
                                d2 = Double.parseDouble(object.toString());
                                arrayList.set(n, new Double(d2));
                                logger.debug("{} [getRedisMeasureForCommandStats] discriptor : {} index : {} ==> metric name : {} value : {}", new Object[]{this.logPrefix, string, n, string2, object});
                            }
                            catch (Exception exception) {
                                logger.warn("{} [getRedisMeasureForCommandStats] Error while parsing the String to Double {}", (Object)this.logPrefix, (Object)exception);
                            }
                        }
                        logger.info("{} [getRedisMeasureForCommandStats]  The ArrayList  measure contains = {}", (Object)this.logPrefix, (Object)arrayList);
                        this.addNewMeasure(string, arrayList);
                    }
                    this.previousMeasureTable = hashtable2;
                    break block23;
                }
                boolean bl = false;
                logger.info("{} [getRedisMeasureForCommandStats] The test is already running", (Object)this.logPrefix);
                if (hashtable == null || hashtable.size() <= 0) break block23;
                Hashtable hashtable4 = (Hashtable)hashtable.get(REDIS_CMDSTATS_COMMAND);
                Set set = hashtable4.keySet();
                for (String string : set) {
                    Hashtable hashtable5 = (Hashtable)hashtable4.get(string);
                    Hashtable hashtable6 = (Hashtable)this.previousMeasureTable.get(string);
                    ArrayList arrayList = this.finalMeasures(this.measureCount);
                    string = string.replace("cmdstat_", "");
                    logger.debug("{} [getRedisMeasureForCommandStats]The discriptor : {} and its value : {} and its previous value : {}", new Object[]{this.logPrefix, string, hashtable5, hashtable6});
                    if (hashtable6 == null || hashtable6.size() <= 0) continue;
                    Iterator iterator = (Iterator)((Object)hashtable5.keys());
                    while (iterator.hasNext()) {
                        String string4 = (String)iterator.next();
                        Object object = null;
                        Object object2 = null;
                        try {
                            object = hashtable5.get(string4);
                            object2 = hashtable6.get(string4);
                        }
                        catch (Exception exception) {
                            logger.debug("{} [getRedisMeasureForCommandStats] Exception occured while iterating the metric value {}", (Object)this.logPrefix, (Object)exception);
                        }
                        if (!redisNameList.contains(string4)) continue;
                        String string5 = (String)measureNameTable.get(string4);
                        int n = Integer.parseInt(measureIndexTable.get(string5).toString());
                        try {
                            double d = Double.parseDouble(object.toString());
                            double d3 = Double.parseDouble(object2.toString());
                            double d4 = 0.0;
                            if (d3 > 0.0 && d3 < d && n != 0) {
                                logger.debug("{} [getRedisMeasureForCommandStats] Current Value is greater than previous value and the metric is not Usec_Per_Call", (Object)this.logPrefix);
                                d4 = d - d3;
                                bl = true;
                            } else if (n == 0) {
                                d4 = d;
                            } else if (d < d3) {
                                logger.debug("{} [getRedisMeasureForCommandStats] Current Value is lesser than previous value.", (Object)this.logPrefix);
                                if (this.isRedisRestarted()) {
                                    d4 = d;
                                    logger.debug("{} [getRedisMeasureForCommandStats] Redis Server has been restarted......", (Object)this.logPrefix);
                                }
                            }
                            arrayList.set(n, new Double(d4));
                            logger.debug("{} [getRedisMeasureForCommandStats] discriptor : {} \n index : {} ==> metric name : {} value : {}", new Object[]{this.logPrefix, string, n, string4, object});
                        }
                        catch (Exception exception) {
                            logger.warn("{} [getRedisMeasureForCommandStats] Exception occured while parsing the String to Double", (Object)this.logPrefix, (Object)exception);
                        }
                    }
                    logger.info("{} [getRedisMeasureForCommandStats]  The ArrayList  measure contains = {}", (Object)this.logPrefix, (Object)arrayList);
                    if (!bl) continue;
                    this.addNewMeasure(string, arrayList);
                    bl = false;
                }
                this.previousMeasureTable = hashtable4;
            }
            catch (Exception exception) {
                logger.warn("{} Exception occured inside [getRedisMeasureForCommandStats] ", (Object)this.logPrefix, (Object)exception);
            }
        }
    }

    public static void main(String[] stringArray) {
        RedisCmdStatsTest redisCmdStatsTest = new RedisCmdStatsTest(stringArray);
        redisCmdStatsTest.computeMeasures(new Hashtable());
    }
}

