/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import redis.clients.jedis.Jedis;

public class RedisKeySpaceTest
extends RedisBase {
    private static final String REDIS_KEYSPACE_COMMAND = "Keyspace";
    private static final String indexSubject = "REDIS_KEYSPACE_MEASURE_INDEX";
    private static final String nameSubject = "REDIS_KEYSPACE_MEASURE";
    private static Hashtable measureIndexTable = new Hashtable();
    private static Hashtable measureNameTable = new Hashtable();
    private static ArrayList redisNameList = new ArrayList();
    private long lastModifiedTime = 0L;
    private static String discriptorName = "";
    private static Date modifiedDate;
    private static final boolean isInfoBased = true;
    private double totalDbsWithKey = 0.0;
    private double totalKeys = 0.0;
    private double totalExpireKeys = 0.0;
    private double totalDBs = 0.0;
    private double avgExpireTime = 0.0;
    private double expireTimeDbCount = 0.0;

    public RedisKeySpaceTest(String[] stringArray) {
        super(stringArray);
        try {
            this.needAgentlessDD = true;
            logger.info("{} Initializing RedisKeySpaceTest ...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            measureIndexTable = this.getIndexTable(indexSubject);
            measureNameTable = this.getNameTable(nameSubject);
            redisNameList = this.getNameList(nameSubject);
            this.lastModifiedTime = this.getModifiedTime();
            logger.info("{} RedisKeySpaceTest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception exception) {
            logger.warn("{} Exception while initializing RedisKeySpaceTest", (Object)this.logPrefix, (Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        try {
            logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testStart);
            String string = this.getMetrics(REDIS_KEYSPACE_COMMAND);
            if (string == null || string.length() <= 0) {
                this.addNewMeasure(this.finalMeasures(this.measureCount));
                logger.info("{} Redis KeySpace Details is null or empty, hence sending -5 values for all measures ", (Object)this.logPrefix);
            } else {
                Hashtable hashtable2 = this.parseMetrics(string, true);
                this.getRedisMeasureInfoBased(hashtable2, nameSubject, indexSubject, measureIndexTable, measureNameTable, redisNameList, this.lastModifiedTime);
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception occured in computeMeasures method {}", (Object)this.logPrefix, (Object)exception);
        }
        finally {
            logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testEnd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRedisMeasureInfoBased(Hashtable hashtable, String string, String string2, Hashtable hashtable2, Hashtable hashtable3, ArrayList arrayList, long l) {
        if (hashtable == null || hashtable.size() == 0) {
            logger.debug("{} [getRedisMeasureInfoBased]  metricObject is null or empty ,thus returning null", (Object)this.logPrefix);
            return;
        }
        try {
            Object object;
            Object object2;
            Hashtable hashtable4;
            Object object3;
            long l2 = this.getModifiedTime();
            if (l2 - l > 0L) {
                modifiedDate = new Date(l2);
                this.updateINIFileObject();
                hashtable2 = this.getIndexTable(string2);
                hashtable3 = this.getNameTable(string);
                arrayList = this.getNameList(string);
                l = l2;
            }
            logger.debug(" metricObject      : {}", (Object)hashtable);
            logger.debug(" measureIndexTable : {}", (Object)hashtable2);
            logger.debug(" measureNameTable  : {}", (Object)hashtable3);
            logger.debug(" redisNameList     : {}", (Object)arrayList);
            ArrayList arrayList2 = this.finalMeasures(this.measureCount);
            Iterator iterator = (Iterator)((Object)hashtable.keys());
            while (iterator.hasNext()) {
                object3 = (String)iterator.next();
                logger.debug("{} [getRedisMeasureInfoBased] The Test Name is  : {}", (Object)this.logPrefix, object3);
                hashtable4 = null;
                try {
                    hashtable4 = (Hashtable)hashtable.get(object3);
                    logger.debug("{} [getRedisMeasureInfoBased] The Discriptor Table is : {}", (Object)this.logPrefix, (Object)hashtable4);
                }
                catch (Exception exception) {
                    logger.warn("{} [getRedisMeasureInfoBased] Exception occured while fetching the values from testTable {}", (Object)this.logPrefix, (Object)exception);
                }
                if (hashtable4 == null || hashtable4.size() <= 0) continue;
                object2 = (Iterator)((Object)hashtable4.keys());
                while (object2.hasNext()) {
                    String string3 = (String)object2.next();
                    object = null;
                    try {
                        object = (Hashtable)hashtable4.get(string3);
                        this.totalDbsWithKey = string3.contains("db") ? this.totalDbsWithKey + 1.0 : this.totalDbsWithKey;
                    }
                    catch (Exception exception) {
                        logger.warn("{} [getRedisMeasureInfoBased] Exception occured while getting fetching the values from discriptor table {}", (Object)this.logPrefix, (Object)exception);
                    }
                    discriptorName = string3;
                    if (object == null || ((Hashtable)object).size() <= 0) continue;
                    Iterator iterator2 = (Iterator)((Object)((Hashtable)object).keys());
                    while (iterator2.hasNext()) {
                        String string4 = (String)iterator2.next();
                        Object object4 = null;
                        try {
                            object4 = ((Hashtable)object).get(string4);
                            if (string4.equals("keys")) {
                                this.totalKeys += Double.parseDouble(object4.toString());
                            } else if (string4.equals("expires")) {
                                this.totalExpireKeys += Double.parseDouble(object4.toString());
                            } else if (string4.equals("avg_ttl")) {
                                this.avgExpireTime += Double.parseDouble(object4.toString());
                                if (Double.parseDouble(object4.toString()) > 0.0) {
                                    this.expireTimeDbCount += 1.0;
                                }
                            }
                        }
                        catch (Exception exception) {
                            logger.warn("{} [getRedisMeasureInfoBased] Exception occured while getting fetching the values from metric table {}", new Object[]{this.logPrefix, object, exception});
                        }
                        if (!arrayList.contains(string4)) continue;
                        String string5 = (String)hashtable3.get(string4);
                        int n = Integer.parseInt(hashtable2.get(string5).toString());
                        try {
                            double d = Double.parseDouble(object4.toString());
                            arrayList2.set(n, new Double(d));
                            logger.debug("{} [getRedisMeasureInfoBased] discriptor : {} index : {} ==> metric name : {} value : {}", new Object[]{this.logPrefix, discriptorName, n, string4, d});
                        }
                        catch (Exception exception) {
                            logger.warn("{} [getRedisMeasureInfoBased] Exception occured while parsing String to Double", (Object)this.logPrefix, (Object)exception);
                        }
                    }
                    logger.info("{} [getRedisMeasureInfoBased] " + discriptorName + ",The ArrayList measure contains = {}", (Object)this.logPrefix, (Object)arrayList2);
                    this.addNewMeasure(discriptorName, arrayList2);
                }
            }
            object3 = this.finalMeasures(this.measureCount);
            ((ArrayList)object3).set(3, new Double(this.totalDbsWithKey));
            ((ArrayList)object3).set(4, new Double(this.totalKeys));
            ((ArrayList)object3).set(5, new Double(this.totalExpireKeys));
            if (this.expireTimeDbCount > 0.0) {
                ((ArrayList)object3).set(6, new Double(new DecimalFormat("##").format(this.avgExpireTime / this.expireTimeDbCount)));
            } else {
                ((ArrayList)object3).set(6, new Double(0.0));
            }
            hashtable4 = null;
            try {
                hashtable4 = this.getConnection();
                object2 = hashtable4.configGet("*");
                if (object2.size() > 0) {
                    int n = object2.indexOf("databases");
                    object = (String)object2.get(n + 1);
                    this.totalDBs = !((String)object).isEmpty() ? Double.parseDouble((String)object) : -5.0;
                }
            }
            catch (Exception exception) {
                logger.warn("{} Exception occered in [getRedisMeasureNonInfoBased] - while getting config from Redis server  ", (Object)this.logPrefix, (Object)exception);
            }
            finally {
                this.closeConnection((Jedis)hashtable4);
            }
            ((ArrayList)object3).set(7, new Double(this.totalDBs));
            this.addNewMeasure("Summary", (ArrayList)object3);
            logger.info("{} [getRedisMeasureInfoBased] Summary, The ArrayList - summaryMeasure contains = {}", (Object)this.logPrefix, object3);
            this.totalKeys = 0.0;
            this.totalExpireKeys = 0.0;
            this.avgExpireTime = 0.0;
            this.totalDbsWithKey = 0.0;
            this.expireTimeDbCount = 0.0;
        }
        catch (Exception exception) {
            logger.warn("{} Exception occered in [getRedisMeasureNonInfoBased] ", (Object)this.logPrefix, (Object)exception);
        }
    }

    public static void main(String[] stringArray) throws InterruptedException {
        RedisKeySpaceTest redisKeySpaceTest = new RedisKeySpaceTest(stringArray);
        while (true) {
            redisKeySpaceTest.computeMeasures(new Hashtable());
            Thread.sleep(60000L);
        }
    }
}

