/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import redis.clients.jedis.Jedis;

public class RedisServerTest
extends RedisBase {
    private static final String REDIS_HITRATIO_COMMAND = "Stats";
    private static final String indexSubject = "REDIS_HITRATIO_MEASURE_INDEX";
    private static final String nameSubject = "REDIS_HITRATIO_MEASURE";
    private static Hashtable measureIndexTable = new Hashtable();
    private static Hashtable measureNameTable = new Hashtable();
    private static ArrayList redisNameList = new ArrayList();
    private long lastModifiedTime = 0L;
    private static final boolean isInfoBased = false;
    private double previousHitValue = 0.0;
    private double previousMissValue = 0.0;

    public RedisServerTest(String[] stringArray) {
        super(stringArray);
        try {
            this.needAgentlessDD = true;
            logger.info("{} Initializing RedisServerTest ...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            measureIndexTable = this.getIndexTable(indexSubject);
            measureNameTable = this.getNameTable(nameSubject);
            redisNameList = this.getNameList(nameSubject);
            this.lastModifiedTime = this.getModifiedTime();
            logger.info("{} RedisClientTest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception exception) {
            logger.warn("{} Exception while initializing RedisServerTest", (Object)this.logPrefix, (Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        try {
            logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testStart);
            String string = this.getMetrics(REDIS_HITRATIO_COMMAND);
            if (string == null || string.length() <= 0) {
                this.addNewMeasure(this.finalMeasures(this.measureCount));
                logger.info("{} Redis HitRatio Details is null or empty, hence sending -5 values for all measures ", (Object)this.logPrefix);
            } else {
                ArrayList arrayList = this.finalMeasures(this.measureCount);
                Hashtable hashtable2 = this.parseMetrics(string, false);
                arrayList.set(0, this.getRedisMeasureForHitRatio(hashtable2));
                arrayList.set(1, this.getRedisLatency());
                this.addNewMeasure(arrayList);
                logger.info("{} [getRedisMeasureForHitRatio]  The ArrayList  measure contains = {}", (Object)this.logPrefix, (Object)arrayList);
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception occured in computeMeasures method", (Object)this.logPrefix, (Object)exception);
        }
        finally {
            logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testEnd);
        }
    }

    public Double getRedisMeasureForHitRatio(Hashtable hashtable) {
        Double d = new Double(-5.0);
        if (hashtable == null || hashtable.size() == 0) {
            logger.debug("{} [getRedisMeasureForHitRatio]  metricObject is null or empty ,thus returning null", (Object)this.logPrefix);
            return d;
        }
        try {
            long l = this.getModifiedTime();
            if (l - this.lastModifiedTime > 0L) {
                this.updateINIFileObject();
                measureIndexTable = this.getIndexTable(indexSubject);
                measureNameTable = this.getNameTable(nameSubject);
                redisNameList = this.getNameList(nameSubject);
                this.lastModifiedTime = l;
            }
            logger.debug("{} metricObject : {}", (Object)this.logPrefix, (Object)hashtable);
            logger.debug("{} measureIndexTable : {}", (Object)this.logPrefix, (Object)measureIndexTable);
            logger.debug("{} measureNameTable  : {}", (Object)this.logPrefix, (Object)measureNameTable);
            logger.debug("{} redisNameList     : {}", (Object)this.logPrefix, (Object)redisNameList);
            double d2 = 0.0;
            double d3 = 0.0;
            Iterator iterator = (Iterator)((Object)hashtable.keys());
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Hashtable hashtable2 = null;
                try {
                    hashtable2 = (Hashtable)hashtable.get(string);
                    logger.debug("{} [getRedisMeasureForHitRatio] The Metric key and value table is : {}", (Object)this.logPrefix, (Object)hashtable2);
                }
                catch (Exception exception) {
                    logger.warn("{} [getRedisMeasureForHitRatio] Exception occured while fetching the values from testTable {}", (Object)this.logPrefix, (Object)exception);
                }
                if (hashtable2 == null || hashtable2.size() <= 0) continue;
                Iterator iterator2 = (Iterator)((Object)hashtable2.keys());
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    Object object = null;
                    try {
                        object = hashtable2.get(string2);
                    }
                    catch (Exception exception) {
                        logger.warn("{} [getRedisMeasureForHitRatio] Exception occured while getting fetching the values from metricTable {}", (Object)this.logPrefix, (Object)exception);
                    }
                    if (!redisNameList.contains(string2)) continue;
                    String string3 = (String)measureNameTable.get(string2);
                    int n = Integer.parseInt(measureIndexTable.get(string3).toString());
                    try {
                        if (n == 0) {
                            d2 = Double.parseDouble(object.toString());
                            logger.debug("{} [getRedisMeasureForHitRatio] Previous hit value : {} The new hit value is  : {}", new Object[]{this.logPrefix, this.previousHitValue, d2});
                            continue;
                        }
                        if (n != 1) continue;
                        d3 = Double.parseDouble(object.toString());
                        logger.debug("{} [getRedisMeasureForHitRatio] Previous hit value : {} The new miss value is  : {}", new Object[]{this.logPrefix, this.previousMissValue, d3});
                    }
                    catch (Exception exception) {
                        logger.warn("{} [getRedisMeasureForHitRatio] Exception occured while parsing String to Double", (Object)this.logPrefix);
                    }
                }
            }
            if (this.previousHitValue < d2 || this.previousMissValue < d3) {
                double d4 = d2 - this.previousHitValue;
                double d5 = d3 - this.previousMissValue;
                double d6 = d4 / (d4 + d5) * 100.0;
                d = new Double(new DecimalFormat("##").format(d6));
                this.previousHitValue = d2;
                this.previousMissValue = d3;
            } else if (this.isRedisRestarted()) {
                if (d2 > 0.0 && d3 >= 0.0) {
                    double d7 = d2 / (d2 + d3) * 100.0;
                    d = new Double(new DecimalFormat("##").format(d7));
                } else {
                    logger.info("{} [getRedisMeasureForHitRatio] No Hit Rate right now... ", (Object)this.logPrefix);
                }
            } else {
                d = new Double(-5.0);
                logger.info("{} [getRedisMeasureForHitRatio] No Hit Rate right now... ", (Object)this.logPrefix);
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception occered in [getRedisMeasureForHitRatio] {}", (Object)this.logPrefix, (Object)exception);
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getRedisLatency() {
        Double d;
        block8: {
            d = new Double(-5.0);
            Jedis jedis = null;
            try {
                jedis = this.getConnection();
                List list = jedis.time();
                jedis.info();
                List list2 = jedis.time();
                this.closeConnection(jedis);
                double d2 = Double.parseDouble((String)list.get(1));
                logger.debug("{} [getRedisLatency] Starting Time : {}", (Object)this.logPrefix, (Object)d2);
                double d3 = Double.parseDouble((String)list2.get(1));
                logger.debug("{} [getRedisLatency] Ending Time : {}", (Object)this.logPrefix, (Object)d3);
                try {
                    String string = new DecimalFormat("##.##").format((d3 - d2) / 1000.0);
                    if (string != null) {
                        d = new Double(string);
                        break block8;
                    }
                    d = new Double(-5.0);
                }
                catch (Exception exception) {
                    logger.warn("{} Exception occured while parsing String to Double {}", (Object)this.logPrefix, (Object)exception);
                }
            }
            catch (Exception exception) {
                logger.warn("{} Exception occered in getRedisMeasure {}", (Object)this.logPrefix, (Object)exception);
            }
            finally {
                this.closeConnection(jedis);
            }
        }
        return d;
    }

    public static void main(String[] stringArray) throws InterruptedException {
        RedisServerTest redisServerTest = new RedisServerTest(stringArray);
        while (true) {
            redisServerTest.computeMeasures(new Hashtable());
            Thread.sleep(10000L);
        }
    }
}

