/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import redis.clients.jedis.Jedis;

public class RedisSlowLogTest
extends RedisBase {
    public static int previousSlowLogID = 0;
    public static final int firstLine = 1;
    int slowLogEntriesCount = 0;

    public RedisSlowLogTest(String[] stringArray) {
        super(stringArray);
        try {
            this.needAgentlessDD = true;
            logger.info("{} Initializing RedisSlowLogTest ...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            logger.info("{} RedisSlowLogTest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception exception) {
            logger.warn("{} Exception while initializing RedisSlowLogTest {}", (Object)this.logPrefix, (Object)exception);
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testStart);
            this.getRedisSlowLog();
        }
        catch (Exception exception) {
            logger.warn("{} Exception occured inside {}", (Object)this.logPrefix, (Object)exception);
        }
        finally {
            logger.debug("{},{}", (Object)this.logPrefix, (Object)this.testEnd);
        }
    }

    public int getRedisSlowLogCount(Jedis jedis) {
        try {
            List list = jedis.slowlogGet(1L);
            int n = 0;
            if (list.size() > 0) {
                String string = list.get(0).toString().trim();
                String string2 = string.substring(0, string.indexOf(","));
                n = Integer.parseInt(string2);
                this.slowLogEntriesCount = n - previousSlowLogID;
            }
            logger.info("{} New slowlog ID : {} ,Previous slowlog ID : {} Difference is : {}", new Object[]{this.logPrefix, n, previousSlowLogID, this.slowLogEntriesCount});
            previousSlowLogID = n;
        }
        catch (Exception exception) {
            logger.warn("{} Exception : {}", (Object)this.logPrefix, (Object)exception);
        }
        return this.slowLogEntriesCount;
    }

    public Set getUniqueSlowLogCmdsList(Jedis jedis) {
        TreeSet<String> treeSet = new TreeSet<String>();
        try {
            if (this.slowLogEntriesCount > 0) {
                List list = jedis.slowlogGet((long)this.slowLogEntriesCount);
                for (int i = 0; i < list.size(); ++i) {
                    String string = list.get(i).toString().trim();
                    if ((string = string.substring(string.indexOf("[") + 1, string.indexOf("]"))).contains(",")) {
                        string = string.substring(0, string.indexOf(","));
                    }
                    treeSet.add(string);
                }
                logger.info("{} [getUniqueSlowLogCmdsList] Unique commands List = {}", (Object)this.logPrefix, treeSet);
            }
        }
        catch (Exception exception) {
            logger.warn("Error", (Object)"Exception while getting cmdList [RedisSlowLogTest][getUniqueSlowLogCmdsList]");
        }
        return treeSet;
    }

    public double getMaxLength(Jedis jedis) {
        List list = null;
        double d = 0.0;
        try {
            list = jedis.configGet("slowlog-max-len");
            d = -5.0;
            String string = (String)list.get(1);
            if (string != null) {
                try {
                    d = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.warn("{} Exception occurred in getRedisSlowLog {}", (Object)this.logPrefix, (Object)numberFormatException);
                }
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception : {}", (Object)this.logPrefix, (Object)exception);
        }
        logger.debug("{} [getMaxLength] Slowlog maximum length : {}", (Object)this.logPrefix, (Object)list);
        return d;
    }

    public String getSlowLogTreshold(Jedis jedis) {
        String string = "";
        try {
            List list = jedis.configGet("slowlog-log-slower-than");
            string = "";
            if (list.size() > 0) {
                string = (String)list.get(1);
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception : {}", (Object)this.logPrefix, (Object)exception);
        }
        logger.debug("{} Slowlog threshold(Microseconds) : {}", (Object)this.logPrefix, (Object)string);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRedisSlowLog() {
        int n = -5;
        int n2 = -5;
        int n3 = 0;
        Jedis jedis = null;
        try {
            jedis = this.getConnection();
            this.slowLogEntriesCount = this.getRedisSlowLogCount(jedis);
            ArrayList<Double> arrayList = new ArrayList<Double>();
            Set set = this.getUniqueSlowLogCmdsList(jedis);
            double d = this.getMaxLength(jedis);
            String string = this.getSlowLogTreshold(jedis);
            int n4 = -5;
            List list = jedis.slowlogGet((long)this.slowLogEntriesCount);
            if (this.slowLogEntriesCount > 0) {
                logger.debug("{} Result for REDIS Command [Slowlog get] : {}", (Object)this.logPrefix, (Object)list);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    int n5;
                    ArrayList<Double> arrayList2 = new ArrayList<Double>();
                    int n6 = 0;
                    int n7 = 0;
                    String string2 = iterator.next().toString();
                    int n8 = 0;
                    for (n5 = 0; n5 < list.size(); ++n5) {
                        String string3 = list.get(n5).toString().trim();
                        String[] stringArray = string3.split(",");
                        int n9 = Integer.parseInt(stringArray[2]);
                        n8 += n9;
                        if (!string3.contains(string2)) continue;
                        n7 += n9;
                        n4 = n8;
                        ++n6;
                    }
                    n3 += n6;
                    n = n6;
                    n5 = 0;
                    if (n <= 0) continue;
                    n2 = n5 = n7 / n;
                    arrayList2.add(new Double(n));
                    arrayList2.add(new Double(n2));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                    logger.info("{} [getRedisSlowLog] {},The ArrayList  measure contains = {}", new Object[]{this.logPrefix, string2, arrayList2});
                    this.addNewMeasure(string2, arrayList2);
                }
            } else {
                logger.debug("{} [getRedisSlowLog] No slowlog commands... ", (Object)this.logPrefix);
                this.addNewMeasure(this.finalMeasures(this.measureCount));
            }
            int n10 = 0;
            if (n3 > 0) {
                n10 = n4 / n3;
            }
            arrayList.add(new Double(n3));
            arrayList.add(new Double(n10));
            arrayList.add(new Double(d));
            string = !string.isEmpty() ? string : "0";
            arrayList.add(new Double(string));
            logger.info("{} [getRedisSlowLog] Summary,The ArrayList  measure contains = {}", (Object)this.logPrefix, arrayList);
            this.addNewMeasure("Summary", arrayList);
        }
        catch (Exception exception) {
            logger.warn("{} Exception occurred in getRedisMeasure", (Object)this.logPrefix, (Object)exception);
            this.addNewMeasure(this.finalMeasures(this.measureCount));
            logger.trace("{} [getRedisSlowLog] Sending -5 ", (Object)this.logPrefix);
        }
        finally {
            this.closeConnection(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getRedisSlowLogDd() {
        Hashtable hashtable = new Hashtable();
        ArrayList<String> arrayList = null;
        String string2 = null;
        Jedis jedis = null;
        try {
            jedis = this.getConnection();
            List list = jedis.slowlogGet((long)this.slowLogEntriesCount);
            Set set = this.getUniqueSlowLogCmdsList(jedis);
            if (this.slowLogEntriesCount > 0) {
                for (String string2 : set) {
                    arrayList = new ArrayList<String>();
                    for (int i = 0; i < list.size(); ++i) {
                        String string3 = list.get(i).toString().trim();
                        if (!string3.contains(string2)) continue;
                        arrayList.add(string3);
                    }
                    if (arrayList == null) continue;
                    hashtable.put(string2, arrayList);
                }
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception occered in getRedisSlowLogDd {}", (Object)this.logPrefix, (Object)exception);
        }
        finally {
            this.closeConnection(jedis);
        }
        logger.info("{} [getRedisSlowLogDd] [getRedisSlowLogDd] cmdsTest = {}", (Object)this.logPrefix, hashtable);
        return hashtable;
    }

    public static void main(String[] stringArray) throws InterruptedException {
        RedisSlowLogTest redisSlowLogTest = new RedisSlowLogTest(stringArray);
        redisSlowLogTest.computeMeasures(new Hashtable());
        while (true) {
            redisSlowLogTest.computeMeasures(new Hashtable());
            Thread.sleep(100000L);
        }
    }
}

