/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;

public class RedisStatsTest
extends RedisBase {
    private static final String REDIS_STATS_COMMAND = "Stats";
    private static final String indexSubject = "REDIS_STATS_MEASURE_INDEX";
    private static final String nameSubject = "REDIS_STATS_MEASURE";
    private static Hashtable measureIndexTable = new Hashtable();
    private static Hashtable measureNameTable = new Hashtable();
    private static ArrayList redisNameList = new ArrayList();
    private long lastModifiedTime = 0L;
    private static final boolean isInfoBased = false;
    private double previousValueOfCommands = 0.0;
    private double previousValueOfRejectedConnections = 0.0;
    private double previousValueOfEvictedKeys = 0.0;
    private double previousValueOfConnections = 0.0;
    private double previousValueOfHit = 0.0;
    private double previousValueOfMiss = 0.0;
    private double previousValueOfNetInput = 0.0;
    private double previousValueOfNetOutput = 0.0;
    private double previousValueOfExpiredKeys = 0.0;

    public RedisStatsTest(String[] stringArray) {
        super(stringArray);
        try {
            this.needAgentlessDD = true;
            logger.info("{} Initializing RedisStatsTest ...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            measureIndexTable = this.getIndexTable(indexSubject);
            measureNameTable = this.getNameTable(nameSubject);
            redisNameList = this.getNameList(nameSubject);
            this.lastModifiedTime = this.getModifiedTime();
            logger.info("{} RedisStatsTest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception exception) {
            logger.warn("{} Exception while initializing RedisStatsTest {}", (Object)this.logPrefix, (Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        try {
            logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testStart);
            String string = this.getMetrics(REDIS_STATS_COMMAND);
            if (string == null || string.length() <= 0) {
                this.addNewMeasure(this.finalMeasures(this.measureCount));
                logger.info("{} Redis Stats Details is null or empty, hence sending -5 values for all measures ", (Object)this.logPrefix);
            } else {
                Hashtable hashtable2 = this.parseMetrics(string, false);
                this.getRedisMeasureForStats(hashtable2);
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception occured in computeMeasures method", (Object)this.logPrefix, (Object)exception);
        }
        finally {
            logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testEnd);
        }
    }

    public void getRedisMeasureForStats(Hashtable hashtable) {
        if (hashtable == null || hashtable.size() == 0) {
            logger.debug("{} [getRedisMeasureForStats]  metricObject is null or empty ,thus returning null", (Object)this.logPrefix);
            return;
        }
        try {
            long l = this.getModifiedTime();
            if (l - this.lastModifiedTime > 0L) {
                new Date(l);
                this.updateINIFileObject();
                measureIndexTable = this.getIndexTable(indexSubject);
                measureNameTable = this.getNameTable(nameSubject);
                redisNameList = this.getNameList(nameSubject);
                this.lastModifiedTime = l;
            }
            logger.debug("{} metricObject : {}", (Object)this.logPrefix, (Object)hashtable);
            logger.debug("{} measureIndexTable : {}", (Object)this.logPrefix, (Object)measureIndexTable);
            logger.debug("{} measureNameTable  : {}", (Object)this.logPrefix, (Object)measureNameTable);
            logger.debug("{} redisNameList     : {}", (Object)this.logPrefix, (Object)redisNameList);
            ArrayList arrayList = this.finalMeasures(this.measureCount);
            Iterator iterator = (Iterator)((Object)hashtable.keys());
            while (iterator.hasNext()) {
                Object object;
                String string = (String)iterator.next();
                Hashtable hashtable2 = null;
                try {
                    hashtable2 = (Hashtable)hashtable.get(string);
                    logger.debug("{} [getRedisMeasureForStats] The Metric key and value table is : {}", (Object)this.logPrefix, (Object)hashtable2);
                }
                catch (Exception exception) {
                    logger.warn("{} [getRedisMeasureForStats] Exception occured while fetching the values from testTable {}", (Object)this.logPrefix, (Object)exception);
                }
                if (hashtable2 == null || hashtable2.size() <= 0) continue;
                Iterator iterator2 = (Iterator)((Object)hashtable2.keys());
                double d = 0.0;
                double d2 = 0.0;
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    Object object2 = null;
                    try {
                        object2 = hashtable2.get(string2);
                    }
                    catch (Exception exception) {
                        logger.warn("{} [getRedisMeasureForStats] Exception occured while getting fetching the values from metricTable {}", (Object)this.logPrefix, (Object)exception);
                    }
                    if (!redisNameList.contains(string2)) continue;
                    object = (String)measureNameTable.get(string2);
                    int n = Integer.parseInt(measureIndexTable.get(object).toString());
                    double d3 = 0.0;
                    try {
                        if (n != 0 && n != 1 && n != 2 && n != 3 && n != 4 && n != 5 && n != 6 && n != 7 && n != 8 && n != 19) {
                            d3 = Double.parseDouble(object2.toString());
                            arrayList.set(n, new Double(d3));
                            logger.debug("{} [getRedisMeasureForStats] index : {} ==> metric name : {} value : {}", new Object[]{this.logPrefix, n, string2, d3});
                            continue;
                        }
                        if (n == 0) {
                            double d4 = Double.parseDouble(object2.toString());
                            d3 = d4 >= this.previousValueOfHit ? d4 - this.previousValueOfHit : d4;
                            logger.debug("{} [getRedisMeasureForStats] {}-index:{}==> previousValueOfHit :{} HitsKeyValue : {}", new Object[]{this.logPrefix, string2, n, this.previousValueOfHit, d4});
                            this.previousValueOfHit = d4;
                            d = d3;
                        } else if (n == 1) {
                            double d5 = Double.parseDouble(object2.toString());
                            d3 = d5 >= this.previousValueOfMiss ? d5 - this.previousValueOfMiss : d5;
                            logger.debug("{} [getRedisMeasureForStats] {}-index:{}==> previousValueOfMissValue : {} missedKeyValue : {}", new Object[]{this.logPrefix, string2, n, this.previousValueOfMiss, d5});
                            this.previousValueOfMiss = d5;
                            d2 = d3;
                        } else if (n == 2) {
                            double d6 = Double.parseDouble(object2.toString());
                            d3 = d6 >= this.previousValueOfExpiredKeys ? d6 - this.previousValueOfExpiredKeys : d6;
                            logger.debug("{} [getRedisMeasureForStats] {}-index:{} ==> previousValueOfExpiredKeys : {} expiredKeyValue : {}", new Object[]{this.logPrefix, string2, n, this.previousValueOfExpiredKeys, d6});
                            this.previousValueOfExpiredKeys = d6;
                        } else if (n == 3) {
                            double d7 = Double.parseDouble(object2.toString());
                            d3 = d7 >= this.previousValueOfEvictedKeys ? d7 - this.previousValueOfEvictedKeys : d7;
                            logger.debug("{} [getRedisMeasureForStats] {}-index:{} ==> previousValueOfEvictedKeys : {} evictedKeyValue : {}", new Object[]{this.logPrefix, string2, n, this.previousValueOfEvictedKeys, d7});
                            this.previousValueOfEvictedKeys = d7;
                        } else if (n == 4) {
                            double d8 = Double.parseDouble(object2.toString());
                            d3 = d8 >= this.previousValueOfRejectedConnections ? d8 - this.previousValueOfRejectedConnections : d8;
                            logger.debug("{} [getRedisMeasureForStats] {}-index:{} ==> previousValueOfRejectedConnections : {} rejectecdConnValue : {}", new Object[]{this.logPrefix, string2, n, this.previousValueOfRejectedConnections, d8});
                            this.previousValueOfRejectedConnections = d8;
                        } else if (n == 5) {
                            double d9 = Double.parseDouble(object2.toString());
                            d3 = d9 >= this.previousValueOfConnections ? d9 - this.previousValueOfConnections : d9;
                            logger.debug("{} [getRedisMeasureForStats] {}-index:{} ==> previousValueOfConnections : {} connValue : {}", new Object[]{this.logPrefix, string2, n, this.previousValueOfConnections, d9});
                            this.previousValueOfConnections = d9;
                        } else if (n == 6) {
                            double d10 = Double.parseDouble(object2.toString());
                            d3 = d10 >= this.previousValueOfCommands ? d10 - this.previousValueOfCommands : d10;
                            logger.debug("{} [getRedisMeasureForStats] {}-index:{} ==> previousValueOfCommands : {} cmdValue : {}", new Object[]{this.logPrefix, string2, n, this.previousValueOfCommands, d10});
                            this.previousValueOfCommands = d10;
                        } else if (n == 7) {
                            double d11 = Double.parseDouble(EgUtils.convertMemoryValues(object2.toString(), "B", "MB"));
                            d3 = d11 >= this.previousValueOfNetInput ? d11 - this.previousValueOfNetInput : d11;
                            logger.debug("{} [getRedisMeasureForStats] {}-index:{} ==> previousValueOfNetInput : {} totalNetIns : {}", new Object[]{this.logPrefix, string2, n, this.previousValueOfNetInput, d11});
                            this.previousValueOfNetInput = d11;
                        } else if (n == 8) {
                            double d12 = Double.parseDouble(EgUtils.convertMemoryValues(object2.toString(), "B", "MB"));
                            d3 = d12 >= this.previousValueOfNetOutput ? d12 - this.previousValueOfNetOutput : d12;
                            logger.debug("{} [getRedisMeasureForStats] {}-index:{} ==> previousValueOfNetOutput :{} new totalNetOuts : {}", new Object[]{this.logPrefix, string2, n, this.previousValueOfNetOutput, d12});
                            this.previousValueOfNetOutput = d12;
                        }
                        arrayList.set(n, new Double(d3));
                        logger.debug("{} [getRedisMeasureForStats] index : {} ==> metric name : {} value : {}", new Object[]{this.logPrefix, n, string2, d3});
                    }
                    catch (Exception exception) {
                        logger.warn("{} [getRedisMeasureForStats] Exception occured while parsing String to Double {}", (Object)this.logPrefix, (Object)exception);
                    }
                }
                double d13 = d + d2;
                object = null;
                object = d13 > 0.0 && this.measurePeriod > 0L ? new Double(new DecimalFormat("##").format(d13 / (double)this.measurePeriod * 1000.0)) : new Double(0.0);
                arrayList.set(19, object);
                logger.debug("{} [getRedisMeasureForStats] index : 19\t ==> metric name : lookups per second  value : {}", (Object)this.logPrefix, object);
                logger.info("{} [getRedisMeasureForStats] The ArrayList  measure contains = {}", (Object)this.logPrefix, (Object)arrayList);
                this.addNewMeasure(arrayList);
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception occered in [getRedisMeasureForStats] ", (Object)this.logPrefix, (Object)exception);
        }
    }

    public static void main(String[] stringArray) throws InterruptedException {
        while (true) {
            RedisStatsTest redisStatsTest = new RedisStatsTest(stringArray);
            redisStatsTest.computeMeasures(new Hashtable());
            Thread.sleep(60000L);
        }
    }
}

