/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class RedisUptimeTest
extends RedisBase {
    private static final String REDIS_SERVER_COMMAND = "Server";
    private static final String indexSubject = "REDIS_UPTIME_MEASURE_INDEX";
    private static final String nameSubject = "REDIS_UPTIME_MEASURE";
    private static Hashtable measureIndexTable = new Hashtable();
    private static Hashtable measureNameTable = new Hashtable();
    private static ArrayList redisNameList = new ArrayList();
    private long lastModifiedTime = 0L;
    private static final boolean isInfoBased = false;

    public RedisUptimeTest(String[] stringArray) {
        super(stringArray);
        try {
            this.needAgentlessDD = true;
            logger.info("{} Initializing RedisUptimeTest ...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            measureIndexTable = this.getIndexTable(indexSubject);
            measureNameTable = this.getNameTable(nameSubject);
            redisNameList = this.getNameList(nameSubject);
            this.lastModifiedTime = this.getModifiedTime();
            logger.info("{} RedisUptimeTest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception exception) {
            logger.warn("{} Exception while initializing RedisUptimeTest {}", (Object)this.logPrefix, (Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        try {
            logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testStart);
            String string = this.getMetrics(REDIS_SERVER_COMMAND);
            if (string == null || string.length() <= 0) {
                this.addNewMeasure(this.finalMeasures(this.measureCount));
                logger.info("{} Redis Server Details is null or empty, hence sending -5 values for all measures ", (Object)this.logPrefix);
            } else {
                Hashtable hashtable2 = this.parseMetrics(string, false);
                this.getRedisMeasureNonInfoBased(hashtable2, nameSubject, indexSubject, measureIndexTable, measureNameTable, redisNameList, this.lastModifiedTime);
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception occured in computeMeasures method {}", (Object)this.logPrefix, (Object)exception);
        }
        finally {
            logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testEnd);
        }
    }

    public void getRedisMeasureNonInfoBased(Hashtable hashtable, String string, String string2, Hashtable hashtable2, Hashtable hashtable3, ArrayList arrayList, long l) {
        if (hashtable == null || hashtable.size() == 0) {
            logger.debug("{} [getRedisMeasureNonInfoBased]  metricObject is null or empty ,thus returning null", (Object)this.logPrefix);
            return;
        }
        try {
            long l2 = this.getModifiedTime();
            if (l2 - l > 0L) {
                this.updateINIFileObject();
                hashtable2 = this.getIndexTable(string2);
                hashtable3 = this.getNameTable(string);
                arrayList = this.getNameList(string);
            }
            logger.debug("{} metricObject : {}", (Object)this.logPrefix, (Object)hashtable);
            logger.debug("{} measureIndexTable : {}", (Object)this.logPrefix, (Object)hashtable2);
            logger.debug("{} measureNameTable  : {}", (Object)this.logPrefix, (Object)hashtable3);
            logger.debug("{} redisNameList     : {}", (Object)this.logPrefix, (Object)arrayList);
            ArrayList arrayList2 = this.finalMeasures(this.measureCount);
            Iterator iterator = (Iterator)((Object)hashtable.keys());
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                Hashtable hashtable4 = null;
                try {
                    hashtable4 = (Hashtable)hashtable.get(string3);
                    logger.debug("{} [getRedisMeasureNonInfoBased] The Metric key and value table is : {}", (Object)this.logPrefix, (Object)hashtable4);
                }
                catch (Exception exception) {
                    logger.warn("{} [getRedisMeasureNonInfoBased] Exception occured while fetching the values from testTable ", (Object)this.logPrefix, (Object)exception);
                }
                if (hashtable4 == null || hashtable4.size() <= 0) continue;
                Iterator iterator2 = (Iterator)((Object)hashtable4.keys());
                while (iterator2.hasNext()) {
                    String string4 = (String)iterator2.next();
                    Object object = null;
                    try {
                        object = hashtable4.get(string4);
                    }
                    catch (Exception exception) {
                        logger.warn("{} [getRedisMeasureNonInfoBased] Exception occured while getting fetching the values from metricTable ", (Object)this.logPrefix, (Object)exception);
                    }
                    if (!arrayList.contains(string4)) continue;
                    String string5 = (String)hashtable3.get(string4);
                    int n = Integer.parseInt(hashtable2.get(string5).toString());
                    try {
                        double d = Double.parseDouble(object.toString());
                        if (n == 0) {
                            arrayList2.set(n, new Double(new DecimalFormat("##").format(d /= 60.0)));
                        } else {
                            arrayList2.set(n, new Double(d));
                        }
                        logger.debug("{} [getRedisMeasureNonInfoBased] index : {} ==> metric name : {} value: {}", new Object[]{this.logPrefix, n, string4, d});
                    }
                    catch (Exception exception) {
                        logger.warn("{} [getRedisMeasureNonInfoBased] Exception occured while parsing String to Double {}", (Object)this.logPrefix, (Object)exception);
                    }
                }
                logger.info("{} [getRedisMeasureNonInfoBased]  The ArrayList  measure contains = {}", (Object)this.logPrefix, (Object)arrayList2);
                this.addNewMeasure(arrayList2);
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception occered in [getRedisMeasureNonInfoBased] {}", (Object)this.logPrefix, (Object)exception);
        }
    }

    public static void main(String[] stringArray) {
        RedisUptimeTest redisUptimeTest = new RedisUptimeTest(stringArray);
        redisUptimeTest.computeMeasures(new Hashtable());
    }
}

