/*
 * Decompiled with CFR 0.152.
 */
import ch.ethz.ssh2.Connection;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class SSHThread
extends Thread {
    private String hostName = "";
    private String userName = "";
    private String password = "";
    private int port = 22;
    private String cmd = "";
    private String encryptType = "";
    private String keyFileName = "";
    private Connection conn = null;
    private int timeOut = (int)(EgConfigInfo.msecPerMin * 1L);
    public boolean done = false;
    public ArrayList data = null;
    private static Hashtable syncHash = new Hashtable();
    private static Hashtable connHash = new Hashtable();
    private static String syncFlag = new String("Conn");
    private Vector syncFlag2 = new Vector();
    private static Hashtable lastTimeHash = new Hashtable();
    public String errorMsg = "";

    public SSHThread(String string, String string2, String string3) {
        this.hostName = string;
        this.userName = string2;
        this.password = string3;
        this.port = 22;
    }

    public SSHThread(String string, String string2, String string3, int n) {
        this.hostName = string;
        this.userName = string2;
        this.password = string3;
        this.port = n;
    }

    public void setTimeOut(long l) {
        this.timeOut = (int)l;
    }

    public void setEncryptionType(String string) {
        this.encryptType = string;
    }

    public void setKeyFile(String string) {
        this.keyFileName = string;
    }

    public void executeCommand(String string) {
        this.cmd = string;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        try {
            this.conn = this.port == 22 ? new Connection(this.hostName) : new Connection(this.hostName, this.port);
            this.conn.connect(null, this.timeOut, this.timeOut);
        }
        catch (Exception exception) {
            System.out.println("[SSHThread]Failed to establish a ssh connection with server :" + this.hostName + " " + exception);
            this.errorMsg = "Not get connection";
            this.done = true;
            if (this.conn != null) {
                this.conn.close();
                Vector vector = this.syncFlag2;
                synchronized (vector) {
                    connHash.remove(this.hostName);
                    lastTimeHash.remove(this.hostName);
                }
            }
            return;
        }
    }

    public void run() {
        try {
            this.executeCommand();
            this.done = true;
            return;
        }
        catch (Exception exception) {
            System.err.println("Exception occured during command execution" + exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnFromHash() {
        try {
            Vector vector = this.syncFlag2;
            synchronized (vector) {
                this.conn = (Connection)connHash.get(this.hostName);
                if (this.conn != null) {
                    this.conn.close();
                }
                connHash.remove(this.hostName);
                lastTimeHash.remove(this.hostName);
            }
        }
        catch (Exception exception) {
            System.err.println("Exception occured in SSHTHread during close connection from hash :" + exception + " for the host " + this.hostName);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getConnectionObject() {
        block26: {
            try {
                Object object;
                this.connect();
                if (this.done) {
                    return;
                }
                boolean bl = false;
                String string = EgMainAgent.Ssh_key_file_location;
                boolean bl2 = true;
                boolean bl3 = false;
                if (this.encryptType != null) {
                    if (this.encryptType.equalsIgnoreCase("keybased")) {
                        bl2 = false;
                        bl3 = true;
                    } else if (this.encryptType.equalsIgnoreCase("password")) {
                        bl2 = true;
                        bl3 = true;
                    }
                }
                if (bl2) {
                    try {
                        bl = this.conn.authenticateWithPassword(this.userName, this.password);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        bl = false;
                    }
                }
                if (!bl && bl2 && !bl3) {
                    this.closeConnFromHash();
                    this.connect();
                    bl2 = false;
                }
                if (!bl2) {
                    object = "";
                    if (this.keyFileName != null && this.keyFileName.length() > 0 && !this.keyFileName.equalsIgnoreCase("none")) {
                        object = EgInstallInfo.getInstallDir() + "/agent/sshkeys/" + this.keyFileName;
                    } else if (string != null && string.length() > 0 && !string.equalsIgnoreCase("none")) {
                        object = EgInstallInfo.getInstallDir() + "/" + string;
                    } else {
                        System.out.println(" [SSHThread] in keybased authentication keyfilename =" + this.keyFileName + " or location =" + string + " is not set");
                    }
                    if (((String)object).length() > 0) {
                        File file = new File((String)object);
                        String string2 = "";
                        if (this.password != null && !this.password.equalsIgnoreCase("none") && this.password.length() > 0) {
                            string2 = this.password.trim();
                        }
                        try {
                            bl = this.conn.authenticateWithPublicKey(this.userName, file, string2);
                        }
                        catch (Exception exception) {
                            System.err.println("[SSHThread] authenticateWithPublicKey failed for " + this.hostName);
                            exception.printStackTrace();
                            bl = false;
                        }
                    }
                }
                if (!bl) {
                    this.errorMsg = "Authentication failed";
                    if (this.conn != null) {
                        this.conn.close();
                        this.conn = null;
                    }
                    throw new IOException("Authentication failed.");
                }
                if (this.conn == null || connHash.containsKey(this.hostName)) break block26;
                object = this.syncFlag2;
                synchronized (object) {
                    if (!connHash.containsKey(this.hostName)) {
                        connHash.put(this.hostName, this.conn);
                        lastTimeHash.put(this.hostName, new Long(System.currentTimeMillis()));
                        this.conn = null;
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("Exception occured in SSHTHread during get connection :" + exception + " for the host " + this.hostName);
                this.done = true;
                this.data = new ArrayList(2);
                ArrayList arrayList = new ArrayList();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add(exception.toString());
                this.data.add(arrayList);
                this.data.add(arrayList2);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand() {
        try {
            Object object;
            Vector vector = null;
            vector = (Vector)syncHash.get(this.hostName);
            if (vector == null) {
                object = syncFlag;
                synchronized (object) {
                    vector = (Vector)syncHash.get(this.hostName);
                    if (vector == null) {
                        vector = new Vector();
                        syncHash.put(this.hostName, vector);
                    }
                }
            }
            if (vector == null) {
                return;
            }
            this.syncFlag2 = vector;
            object = vector;
            synchronized (object) {
                this.checkTimeOut();
                Connection connection = null;
                connection = (Connection)connHash.get(this.hostName);
                if (connection == null) {
                    this.getConnectionObject();
                }
            }
            if (this.done) {
                return;
            }
            this.executeRealCommad();
        }
        catch (Exception exception) {
            System.err.println("Exception occured in SSHTHread during executeCommand :" + exception + " for the host " + this.hostName);
            return;
        }
    }

    private void checkTimeOut() {
        try {
            if (lastTimeHash.containsKey(this.hostName)) {
                long l;
                long l2;
                Long l3 = (Long)lastTimeHash.get(this.hostName);
                long l4 = 0L;
                if (l3 != null) {
                    l4 = l3;
                }
                if ((l2 = (l = System.currentTimeMillis()) - l4) >= 86400000L) {
                    this.closeConnFromHash();
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Exception occured in SSHTHread during checkTimeOut :" + exception + " for the host " + this.hostName);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRealCommad() {
        block19: {
            this.data = new ArrayList(2);
            try {
                String string;
                Object object;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                Connection connection = null;
                Vector vector = this.syncFlag2;
                synchronized (vector) {
                    connection = (Connection)connHash.get(this.hostName);
                }
                vector = null;
                if (connection == null) break block19;
                try {
                    vector = connection.openSession();
                }
                catch (Exception exception) {
                    if (connHash != null && connHash.size() > 0 && connHash.containsKey(this.hostName)) {
                        this.closeConnFromHash();
                    }
                    System.err.println("Exception occured in SSHTHread during command execution while io for the host " + this.hostName);
                    this.getConnectionObject();
                    object = this.syncFlag2;
                    synchronized (object) {
                        connection = (Connection)connHash.get(this.hostName);
                    }
                    vector = connection.openSession();
                }
                vector.execCommand(this.cmd);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(vector.getStdout()));
                while ((object = bufferedReader.readLine()) != null) {
                    arrayList.add(object);
                }
                object = new BufferedReader(new InputStreamReader(vector.getStderr()));
                while ((string = ((BufferedReader)object).readLine()) != null) {
                    arrayList2.add(string);
                }
                this.data.add(arrayList);
                this.data.add(arrayList2);
                try {
                    ((BufferedReader)object).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                vector.close();
            }
            catch (IOException iOException) {
                if (connHash != null && connHash.size() > 0 && connHash.containsKey(this.hostName)) {
                    this.closeConnFromHash();
                }
                System.err.println("Exception occured in SSHTHread during command execution while io :" + iOException + " for the host " + this.hostName);
                return;
            }
            catch (Exception exception) {
                ArrayList arrayList = new ArrayList();
                ArrayList<String> arrayList3 = new ArrayList<String>();
                arrayList3.add(exception.toString());
                this.data.add(arrayList);
                this.data.add(arrayList3);
                System.err.println("Exception occured in SSHTHread during command execution :" + exception + " for the host " + this.hostName);
                exception.printStackTrace();
                return;
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = stringArray[2];
            string = EgCrypt.decrypt(string);
            int n = Integer.parseInt(stringArray[4]);
            SSHThread sSHThread = new SSHThread(stringArray[0], stringArray[1], string, n);
            if (stringArray.length >= 6) {
                sSHThread.setEncryptionType(stringArray[5]);
            }
            if (stringArray.length >= 7) {
                sSHThread.setKeyFile(stringArray[6]);
            }
            sSHThread.executeCommand(stringArray[3]);
        }
        catch (Exception exception) {
            System.out.println("java SSHThread HostIp username password Command portNo");
            System.out.println("----------------- OR ---------------------------------");
            System.out.println("java SSHThread HostIp username password Command portNo authenticationtype keyfilename");
        }
    }
}

