/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class SilverStreamTest
extends EgTest {
    int serverUsageMetricIndex = 0;
    int usedThreadPctIndex = 1;
    int idleThreadPctIndex = 2;
    int requestRateIndex = 3;
    int meanResponseTimeIndex = 4;
    int maxResponseTimeIndex = 5;
    int dataXmitRateIndex = 6;
    int memoryUtilIndex = 7;
    int totalSessCountIndex = 8;
    int idleSessCountIndex = 9;
    int serverUsageMetric;
    double usedThreadPct;
    double idleThreadPct;
    double requestRate;
    long meanResponseTime;
    long maxResponseTime;
    double dataXmitRate;
    double memoryUtil;
    int totalSessCount;
    int idleSessCount;
    private boolean isAuthenticated = false;
    private String user = "";
    private String pass = "";
    private long prevEmittedBytes = -1L;
    private long emittedBytes;
    private long hitCount;
    private long prevHitCount = -1L;
    private boolean wrongArgs = false;
    private boolean apiFound = true;
    private String s = "";
    private String javaPath;
    private String param;
    private String[] argumentsForTest;
    private String cPath;
    private String silverRootPath = "";
    private String osType;

    public SilverStreamTest(String[] stringArray) {
        super(stringArray);
        this.numOutputFields = 10;
        if (stringArray.length < 2 || !stringArray[0].equalsIgnoreCase("-host")) {
            System.err.println("Usage: SilverStreamTest -host <targetHost> -port <Port> -rootPath <RootPath> -isAuthenticated <Y/N> -user <user> -password <password> -adminPort <adminPort>");
            this.wrongArgs = true;
            return;
        }
        if (stringArray.length > 2 && !stringArray[2].equalsIgnoreCase("-port")) {
            System.err.println("Usage: SilverStreamTest -host <targetHost> -port <Port> -rootPath <RootPath> -isAuthenticated <Y/N> -user <user> -password <password> -adminPort <adminPort>");
            this.wrongArgs = true;
            return;
        }
        if (stringArray.length > 4 && !stringArray[4].equalsIgnoreCase("-rootPath")) {
            System.err.println("Usage: SilverStreamTest -host <targetHost> -port <Port> -rootPath <RootPath> -isAuthenticated <Y/N> -user <user> -password <password> -adminPort <adminPort>");
            this.wrongArgs = true;
            return;
        }
        if (stringArray.length > 6 && !stringArray[6].equalsIgnoreCase("-isAuthenticated")) {
            System.err.println("Usage: SilverStreamTest -host <targetHost> -port <Port> -rootPath <RootPath> -isAuthenticated <Y/N> -user <user> -password <password> -adminPort <adminPort>");
            this.wrongArgs = true;
            return;
        }
        if (stringArray.length > 8 && !stringArray[8].equalsIgnoreCase("-user")) {
            System.err.println("Usage: SilverStreamTest -host <targetHost> -port <Port> -rootPath <RootPath> -isAuthenticated <Y/N> -user <user> -password <password> -adminPort <adminPort>");
            this.wrongArgs = true;
            return;
        }
        if (stringArray.length > 10 && !stringArray[10].equalsIgnoreCase("-password")) {
            System.err.println("Usage: SilverStreamTest -host <targetHost> -port <Port> -rootPath <RootPath> -isAuthenticated <Y/N> -user <user> -password <password> -adminPort <adminPort>");
            this.wrongArgs = true;
            return;
        }
        if (stringArray.length > 12 && !stringArray[12].equalsIgnoreCase("-adminPort")) {
            System.err.println("Usage: SilverStreamTest -host <targetHost> -port <Port> -rootPath <RootPath> -isAuthenticated <Y/N> -user <user> -password <password> -adminPort <adminPort>");
            this.wrongArgs = true;
            return;
        }
        this.silverRootPath = stringArray[5];
        File file = new File(this.silverRootPath + "/lib/SilverAdmin.jar");
        if (!file.exists()) {
            this.apiFound = false;
            return;
        }
        file = new File(this.silverRootPath + "/lib/SilverRuntime.zip");
        if (!file.exists()) {
            this.apiFound = false;
            return;
        }
        this.targetHost = new String(stringArray[1]);
        this.portNo = stringArray[3];
        this.osType = new EgAgentTimer(null, null, null).getOSName();
        this.javaPath = System.getProperty("java.home");
        boolean bl = System.getProperty("java.version").compareTo("1.5") > 0;
        String string = EgInstallInfo.getInstallDir() + "/lib/eg_agent.jar";
        if (this.osType.equalsIgnoreCase("Linux") || this.osType.equalsIgnoreCase("Solaris") || this.osType.equalsIgnoreCase("AIX") || this.osType.equalsIgnoreCase("HPUX")) {
            this.javaPath = this.osType.equalsIgnoreCase("AIX") ? this.javaPath + "/bin/java" : (bl ? this.javaPath + "/bin/java -client" : this.javaPath + "/bin/java");
            this.param = " -cp " + string + ":" + this.silverRootPath + "/lib/SilverAdmin.jar:" + this.silverRootPath + "/lib/SilverRuntime.zip:";
        } else if (this.osType.startsWith("Windows")) {
            this.javaPath = bl ? this.javaPath + "\\bin\\java -client" : this.javaPath + "\\bin\\java";
            this.param = " -cp \"" + string + ";" + this.silverRootPath + "\\lib\\SilverAdmin.jar;" + this.silverRootPath + "\\lib\\SilverRuntime.zip;" + "\"";
        }
        this.argumentsForTest = stringArray;
        if (!stringArray[7].equalsIgnoreCase("Y") && !stringArray[7].equalsIgnoreCase("N")) {
            System.err.println("Usage: SilverStreamTest -host <targetHost> -port <Port> -rootPath <RootPath> -isAuthenticated <Y/N> -user <user> -password <password> -adminPort <adminPort>");
            this.wrongArgs = true;
            return;
        }
    }

    public void getEnvParameters() {
        Properties properties = System.getProperties();
        boolean bl = false;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)properties.get(string);
            if (string.indexOf("separator") >= 0 || string2.equals("")) continue;
            if (string2.endsWith("\\")) {
                int n = string2.length();
                string2 = string2.substring(0, n - 1);
            }
            if (string.indexOf("sun.boot.library.path") < 0 && string.indexOf(") java.runtime.version") < 0 && string.indexOf("java.home") < 0 && string.indexOf("java.version") < 0 && string.indexOf("java.ext.dirs") < 0 && string.indexOf("sun.boot.class.path") < 0) continue;
            if (this.s.equals("")) {
                this.s = "-D" + string + "=\"" + string2 + "\"";
                continue;
            }
            this.s = this.s + " -D" + string + "=\"" + string2 + "\"";
        }
    }

    public boolean executeTest() {
        if (!this.apiFound) {
            this.errorMsg = "SilverStream API not found. ";
            this.updateAllResultSets();
            this.prevHitCount = -1L;
            this.prevEmittedBytes = -1L;
            return false;
        }
        this.initTest();
        String string = this.siteName + siteAndInfoSeparator + infoFieldSeparator;
        String string2 = null;
        this.osType = this.osType.toUpperCase();
        if (this.osType.equalsIgnoreCase("Linux") || this.osType.equalsIgnoreCase("Solaris") || this.osType.equalsIgnoreCase("HPUX") || this.osType.equalsIgnoreCase("AIX")) {
            string2 = this.javaPath + this.param + " EgSilverStream ";
        } else if (this.osType.startsWith("WINDOWS")) {
            string2 = "cmd.exe /c " + this.javaPath + this.param + " " + this.s + " EgSilverStream ";
        }
        for (int i = 0; i < this.argumentsForTest.length; ++i) {
            string2 = string2 + this.argumentsForTest[i] + " ";
        }
        BufferedReader[] bufferedReaderArray = this.executeProgram(string2);
        if (bufferedReaderArray == null || bufferedReaderArray.length == 0) {
            this.errorMsg = "Failed to run " + string2;
            this.updateAllResultSets();
            this.prevHitCount = -1L;
            this.prevEmittedBytes = -1L;
            return false;
        }
        if (bufferedReaderArray.length < 2) {
            this.closeReader(bufferedReaderArray[1]);
            if (this.process != null) {
                this.destroy(this.process);
            }
            this.errorMsg = "Failed to run " + string2;
            this.updateAllResultSets();
            this.prevHitCount = -1L;
            this.prevEmittedBytes = -1L;
            return false;
        }
        if (bufferedReaderArray[1] == null) {
            this.closeReader(bufferedReaderArray[2]);
            if (this.process != null) {
                this.destroy(this.process);
            }
            this.errorMsg = "Failed to run " + string2;
            this.updateAllResultSets();
            this.prevHitCount = -1L;
            this.prevEmittedBytes = -1L;
            return false;
        }
        String string3 = null;
        try {
            string3 = bufferedReaderArray[1].readLine();
            if (string3 != null) {
                // empty if block
            }
            if (string3 == null) {
                this.errorMsg = "Failed to Execute SilverStreamTest. No line Returned by EgSilverstream";
                this.updateAllResultSets();
                this.prevHitCount = -1L;
                this.prevEmittedBytes = -1L;
                return false;
            }
            if (string3.indexOf("ErrorMsg") != -1) {
                this.errorMsg = "Failed to Execute SilverStreamTest";
                this.updateAllResultSets();
                this.prevHitCount = -1L;
                this.prevEmittedBytes = -1L;
                return false;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            int n = stringTokenizer.countTokens();
            String[] stringArray = new String[n];
            String[] stringArray2 = new String[n];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                stringArray2[n2] = string4.substring(string4.indexOf("=") + 1);
                ++n2;
            }
            this.serverUsageMetric = Integer.parseInt(stringArray2[0]);
            this.usedThreadPct = Double.parseDouble(stringArray2[1]);
            this.idleThreadPct = Double.parseDouble(stringArray2[2]);
            this.hitCount = Long.parseLong(stringArray2[3]);
            this.meanResponseTime = Long.parseLong(stringArray2[4]);
            this.maxResponseTime = Long.parseLong(stringArray2[5]);
            this.emittedBytes = Long.parseLong(stringArray2[6]);
            this.memoryUtil = Double.parseDouble(stringArray2[7]);
            this.totalSessCount = Integer.parseInt(stringArray2[8]);
            this.idleSessCount = Integer.parseInt(stringArray2[9]);
            if (this.timeSinceLastTest == 0.0 || this.timeSinceLastTest == -1.0 || this.prevHitCount < 0L) {
                this.requestRate = -1.0;
            } else {
                this.requestRate = (double)(this.hitCount - this.prevHitCount) / this.timeSinceLastTest;
                double d = this.requestRate = this.requestRate < 0.0 ? -1.0 : this.requestRate;
            }
            if (this.timeSinceLastTest == 0.0 || this.timeSinceLastTest == -1.0 || this.prevEmittedBytes < 0L) {
                this.dataXmitRate = -1.0;
            } else {
                this.dataXmitRate = (double)(this.emittedBytes - this.prevEmittedBytes) / (1024.0 * this.timeSinceLastTest);
                this.dataXmitRate = this.dataXmitRate < 0.0 ? -1.0 : this.dataXmitRate;
            }
            this.addValueToResultSet(string, this.serverUsageMetricIndex, this.serverUsageMetric);
            this.addValueToResultSet(string, this.usedThreadPctIndex, this.usedThreadPct);
            this.addValueToResultSet(string, this.idleThreadPctIndex, this.idleThreadPct);
            this.addValueToResultSet(string, this.requestRateIndex, this.requestRate);
            this.addValueToResultSet(string, this.meanResponseTimeIndex, this.meanResponseTime);
            this.addValueToResultSet(string, this.maxResponseTimeIndex, this.maxResponseTime);
            this.addValueToResultSet(string, this.dataXmitRateIndex, this.dataXmitRate);
            this.addValueToResultSet(string, this.memoryUtilIndex, this.memoryUtil);
            this.addValueToResultSet(string, this.totalSessCountIndex, this.totalSessCount);
            this.addValueToResultSet(string, this.idleSessCountIndex, this.idleSessCount);
            this.prevHitCount = this.hitCount;
            this.prevEmittedBytes = this.emittedBytes;
            this.updateAllResultSets();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.updateAllResultSets();
            this.errorMsg = new String("SilverStreamTest could not be executed");
            this.prevHitCount = -1L;
            this.prevEmittedBytes = -1L;
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        SilverStreamTest silverStreamTest = new SilverStreamTest(stringArray);
        if (!silverStreamTest.wrongArgs && silverStreamTest.apiFound) {
            for (int i = 0; i < 20; ++i) {
                silverStreamTest.executeTest();
                System.out.println("**************************************************");
                try {
                    Thread.sleep(30000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                silverStreamTest.timeSinceLastTest = 30.0;
            }
        }
    }
}

