/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IniFile;
import com.egurkha.util.EgUtilities;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class SolrValidator
extends EgServerValidator {
    protected String userName = null;
    protected String password = null;
    protected String reportingName = null;
    protected static final String NULL = "null";
    protected static final String NONE = "none";
    protected static final String PROTOTYPE_HTTP = "http";
    protected static final String PROTOTYPE_HTTPS = "https";
    protected boolean isSSL = false;
    protected static final int DEFAULT_CONNECTION_TIMEOUT = 15000;
    protected static final int DEFAULT_READ_TIMEOUT = 60000;
    protected static final int ASCII_CODE_FOR_SPACE = 32;
    protected static final String SPACE = new String(" ");
    protected static final String BASIC = "Basic" + SPACE;
    protected static long collectionTimeout = 120L;
    String logMessage = "";
    String strLogSizeLimitInMB = null;
    protected static final String TEST_NAME = "SolrValidatorRESTExecutor";
    protected static final String LOG_FILE_NAME = "SolrValidatorLog";
    protected static final String INI_ENTRY_FOR_LOG_FILE_SIZE = "SolrValidatorRESTExecutorLogSizeLimitInMB";
    protected static final String DEBUG_LOG_LOCATION = EgInstallInfo.getInstallDir() + "/agent/logs/" + "SolrValidatorLog";
    protected static final String SOLR_BASE_REST_EXECUTOR_CLASS = SPACE + "SolrValidatorRESTExecutor" + SPACE;
    protected static final String DEBUG = "DEBUG    ";
    protected static final String ERROR = "ERROR    ";
    protected static final String INFO = "INFO     ";
    protected static final String CRITICAL = "CRITICAL ";
    protected static final String WARNING = "WARNING  ";
    protected static final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    protected static final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    protected static final double MB_TO_BYTES = 1048576.0;
    protected static final double DEBUG_LOG_FILE_SIZE_IN_MB = 1.0;
    protected double debugLogSizeLimitInMB = 1048576.0;
    String protoType = "";
    boolean deep_debug = false;
    String port = null;
    String tmp_timeout = null;
    String entity = this.getClass().getName();
    EgUtilities egutil = EgUtilities.createInstance();
    String javaOptions = "java";
    String heapDumpPath = null;
    public String validationMsg = "";
    public String validationErrorResponseMsg = "";
    public String validationErrorMsg = "";
    public ArrayList validationMsgs = null;
    public boolean isFromManager = false;
    String className = this.getClass().getName();

    public SolrValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        String string = "Constructor";
        string = this.methodNameTemplate(string);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2;
                String string3 = stringArray[i];
                this.printOut(string + string3);
                String string4 = string3.substring(0, string3.indexOf(":"));
                String string5 = string3.substring(string3.indexOf(":") + 1);
                string4 = string4.trim();
                if (string4 != null && string4.equalsIgnoreCase("-host")) {
                    this.host = string5.trim();
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-port")) {
                    if (this.port != null && this.port.trim().length() != 0 && !this.port.equalsIgnoreCase(NULL) && !this.port.equalsIgnoreCase(NONE)) continue;
                    this.port = string5.trim();
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-username")) {
                    this.userName = string5.trim();
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-password")) {
                    if ((string5 = EgCrypt.decrypt(string5)).indexOf("~EG~") != -1) {
                        string5 = string5.substring(0, string5.indexOf("~EG~"));
                    }
                    this.password = string5;
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-ssl")) {
                    string2 = string5.trim();
                    if (string2 != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("y"))) {
                        this.isSSL = true;
                        this.protoType = PROTOTYPE_HTTPS;
                        this.printOut(string + "Transport type is HTTPS");
                        continue;
                    }
                    this.isSSL = false;
                    this.protoType = PROTOTYPE_HTTP;
                    this.printOut(string + "Transport type is HTTP");
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-rptname")) {
                    this.reportingName = string5.trim();
                    continue;
                }
                if ((string4 == null || !string4.equalsIgnoreCase("-timeout")) && !string4.equalsIgnoreCase("-timeout(secs)") && !string4.equalsIgnoreCase("-timeout_seconds")) continue;
                string2 = string5.trim();
                this.printOut(string + "Timeout string is " + string2);
                if (string2 != null && !string2.equals("120")) {
                    try {
                        collectionTimeout = Integer.parseInt(string2);
                        this.printOut(string + "Timeout in Milliseconds is " + (collectionTimeout *= 1000L));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.printOut(string + "Could not parse specified timeout " + string2 + ". Using 120 seconds");
                        collectionTimeout = 120000L;
                    }
                    continue;
                }
                collectionTimeout = 120000L;
            }
            IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini", false);
            this.strLogSizeLimitInMB = iniFile.getValue("AGENT_SETTINGS", INI_ENTRY_FOR_LOG_FILE_SIZE);
            if (this.strLogSizeLimitInMB != null && this.strLogSizeLimitInMB.length() > 0) {
                this.strLogSizeLimitInMB = this.strLogSizeLimitInMB.trim();
                try {
                    this.debugLogSizeLimitInMB = Double.parseDouble(this.strLogSizeLimitInMB);
                    this.debugLogSizeLimitInMB *= 1048576.0;
                    this.printOut(string + "strLogSizeLimitInMB value in bytes : " + this.debugLogSizeLimitInMB);
                }
                catch (Exception exception) {
                    this.debugLogSizeLimitInMB = 1048576.0;
                }
            } else {
                this.debugLogSizeLimitInMB = 1048576.0;
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace("[" + this.className + "]: [Constructor ]: error ", exception);
        }
        this.entity = this.className;
        this.validationMsgs = new ArrayList();
        this.validate();
        this.isFromManager = bl;
    }

    public void validate() {
        String string = "validate";
        string = this.methodNameTemplate(string);
        this.printOut(string + "*******************************************************************************");
        this.printOut(string + "Solr host       :" + this.host);
        this.printOut(string + "Solr port       :" + this.port);
        this.printOut(string + "Solr username   :" + this.userName);
        this.printOut(string + "Solr password   :**********");
        this.printOut(string + "VALIDATION PROCESS STARTED ");
        int n = 0;
        if (!this.isIPReachable()) {
            this.validationMsgs.add(0, "Host IP/Name$#$Host IP/Name is invalid or Host IP/Name is unreachable");
            this.validationMsgs.add(1, "Port$#$NA");
        } else if (!this.isSpecificPortReachable(this.port)) {
            this.validationMsgs.add(0, "Host IP/Name$#$OK");
            this.validationMsgs.add(1, "Port$#$Port " + this.port + " is down or listener is down");
        } else {
            this.validationMsgs.add(0, "Host IP/Name$#$OK");
            this.validationMsgs.add(1, "Port$#$OK");
            if (this.isStringNull(this.userName) && this.isStringNull(this.password)) {
                this.validationMsgs.add("User/Password$#$Access denied. Please provide valid Username/Password");
                this.validationMsgs.add("Solr Server Connectivity$#$NA");
            } else {
                n = this.getResponseDataFromExe();
                this.checkSolrConnectivity(n);
            }
        }
        this.printOut(string + "VALIDATION PROCESS ENDED");
        if (!this.isFromManager) {
            return;
        }
    }

    public void checkSolrConnectivity(int n) {
        String string = "checkSolrConnectivity";
        string = this.methodNameTemplate(string);
        int n2 = n;
        this.printOut(string + "Response code :" + n2);
        if (n2 == 200) {
            this.validationErrorMsg = "code 200 - Server is running normal";
            this.validationMsgs.add("User/Password$#$OK");
            this.validationMsgs.add("Solr Server Connectivity$#$OK");
            this.printOut(string + "Added Validation Messages for Response Code :" + n2);
        } else if (n2 == 500) {
            this.validationErrorMsg = "Error 500 - No Response from server due to internal server error";
            this.validationMsgs.add("User/Password$#$NA");
            this.validationMsgs.add("Solr Server Connectivity$#$No Response from server due to internal server error");
            this.printOut(string + "Added Validation Messages for Response Code :" + n2);
        } else if (n2 == 404) {
            this.validationErrorMsg = "Error 404 - No Response from server";
            this.validationMsgs.add("User/Password$#$NA");
            this.validationMsgs.add("Solr Server Connectivity$#$No Response from server");
            this.printOut(string + "Added Validation Messages for Response Code :" + n2);
        } else if (n2 == 503) {
            this.validationErrorMsg = "Error 503 - The server is currently unavailable or not started";
            this.validationMsgs.add("User/Password$#$NA");
            this.validationMsgs.add("Solr Server Connectivity$#$The server is currently unavailable or not started");
            this.printOut(string + "Added Validation Messages for Response Code :" + n2);
        } else if (n2 == 401) {
            this.validationErrorMsg = "Error 401 - Unauthorized: Access is denied due to invalid credentials";
            this.validationMsgs.add("User/Password$#$ Access denied. Please check Username/Password");
            this.validationMsgs.add("Solr Server Connectivity$#$NA");
            this.printOut(string + "Added Validation Messages for Response Code :" + n2);
        } else {
            this.validationMsgs.add("Validation error $#$" + this.validationErrorResponseMsg);
            this.printOut(string + "Executional error occured for Response Code :" + n2);
        }
    }

    public int getResponseDataFromExe() {
        String string;
        String string2;
        Object object;
        String string3 = "getResponseDataFromExe";
        string3 = this.methodNameTemplate(string3);
        int n = 0;
        this.heapDumpPath = null;
        this.javaOptions = "java";
        try {
            object = System.getProperty("os.name");
            string2 = System.getProperty("java.version");
            string = System.getProperty("os.arch");
            if (string2.compareTo("10.0") > 0) {
                this.heapDumpPath = "-XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null -XX:-CreateCoredumpOnCrash";
                if (object != null && ((String)object).toLowerCase().indexOf("win") >= 0) {
                    this.heapDumpPath = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL -XX:-CreateCoredumpOnCrash";
                }
                this.printOut(string3 + "JavaVersion 10.0 HeapDumpPath :" + this.heapDumpPath);
            } else if (string2.compareTo("1.7") > 0) {
                this.heapDumpPath = "-XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null -XX:-CreateMinidumpOnCrash";
                if (object != null && ((String)object).toLowerCase().indexOf("win") >= 0) {
                    this.heapDumpPath = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL -XX:-CreateMinidumpOnCrash";
                }
                this.printOut(string3 + "JavaVersion 1.7  HeapDumpPath :" + this.heapDumpPath);
            } else if (string2.compareTo("1.6") > 0) {
                this.heapDumpPath = "-XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null";
                if (object != null && ((String)object).toLowerCase().indexOf("win") >= 0) {
                    this.heapDumpPath = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL";
                }
                this.printOut(string3 + "JavaVersion 1.6 HeapDumpPath :" + this.heapDumpPath);
            }
            if (this.heapDumpPath != null) {
                this.printOut(string3 + "HeapDumpPath :" + this.heapDumpPath);
                this.javaOptions = this.javaOptions + " " + this.heapDumpPath;
                this.printOut(string3 + "HeapDumpPath :" + this.heapDumpPath + " java options : " + this.javaOptions);
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace(string3 + "Error while set the heapDumpPath to call rexec process  :", exception);
        }
        this.printOut(string3 + "JavaOptions " + this.javaOptions);
        object = new ArrayList();
        string2 = " -host " + this.host + " -port " + this.port + " -username " + this.userName + " -password " + this.password + " -ssl " + this.isSSL + " -timeout " + collectionTimeout + " -reportingName " + this.reportingName + " -entity " + this.entity + " -log_size " + this.debugLogSizeLimitInMB;
        string = "";
        String string4 = "";
        boolean bl = false;
        String string5 = "";
        try {
            boolean bl2;
            String string6 = System.getProperty("os.name").toLowerCase();
            boolean bl3 = bl2 = System.getProperty("java.version").compareTo("1.5") > 0;
            if (string6.indexOf("win") >= 0) {
                bl = true;
            }
            if (bl) {
                string4 = EgInstallInfo.getInstallDir() + "\\jre\\bin\\";
                string5 = EgInstallInfo.getInstallDir() + "\\lib\\eg_agent.jar;" + EgInstallInfo.getInstallDir() + "\\lib\\eg_util.jar;";
                string = bl2 ? "cmd.exe /c " + string4 + this.javaOptions + " -client -cp \"" + string5 + "\"" + SOLR_BASE_REST_EXECUTOR_CLASS + string2 : "cmd.exe /c " + string4 + this.javaOptions + " -cp \"" + string5 + "\"" + SOLR_BASE_REST_EXECUTOR_CLASS + string2;
            } else if (string6.indexOf("aix") >= 0) {
                string5 = EgInstallInfo.getInstallDir() + "/lib/eg_agent.jar:" + EgInstallInfo.getInstallDir() + "/lib/eg_util.jar";
                string = "/opt/egurkha/jre/bin/" + this.javaOptions + " -cp " + string5 + SOLR_BASE_REST_EXECUTOR_CLASS + string2;
            } else if (bl2) {
                string5 = EgInstallInfo.getInstallDir() + "/lib/eg_agent.jar:" + EgInstallInfo.getInstallDir() + "/lib/eg_util.jar";
                string = "/opt/egurkha/jre/bin/" + this.javaOptions + " -client -cp " + string5 + SOLR_BASE_REST_EXECUTOR_CLASS + string2;
            } else {
                string5 = EgInstallInfo.getInstallDir() + "/lib/eg_agent.jar:" + EgInstallInfo.getInstallDir() + "/lib/eg_util.jar";
                string = "/opt/egurkha/jre/bin/" + this.javaOptions + " -cp " + string5 + SOLR_BASE_REST_EXECUTOR_CLASS + string2;
            }
            this.printOut(string3 + "Inside execute program " + string);
            this.printOut(string3 + "Going to call getExecOutputLines to execute" + SOLR_BASE_REST_EXECUTOR_CLASS);
            ArrayList arrayList = this.egutil.getExecOutputLines(string);
            this.printOut(string3 + "Completed  getExecOutputLines method call for" + SOLR_BASE_REST_EXECUTOR_CLASS);
            if (arrayList == null || arrayList.size() < 2) {
                this.logMessage = string3 + "Rexec process returned null or some exception " + arrayList;
                this.printOut(this.logMessage);
                this.logMessage = "";
            } else {
                this.logMessage = string3 + "Rexec process returned Values  :" + arrayList;
                this.printOut(this.logMessage);
                this.logMessage = "";
                object = (ArrayList)arrayList.clone();
                String string7 = ((ArrayList)object).get(0).toString();
                this.printOut(string3 + "Response Value from exe :" + string7);
                if (string7.startsWith("[SOLR_RESPONSE:") && string7.length() > 0) {
                    String string8 = string7.substring(string7.indexOf("[") + 1, string7.indexOf("]"));
                    string8 = string8.replace("SOLR_RESPONSE:", "");
                    this.printOut(string3 + "Response  :" + string8);
                    try {
                        n = Integer.parseInt(string8);
                    }
                    catch (Exception exception) {
                        this.logMessage = "Error occured while parsing String to Integer";
                        this.printOutStackTrace(this.logMessage, exception);
                        this.logMessage = "";
                        n = 0;
                    }
                } else if (string7.startsWith("[SOLR_ERROR:")) {
                    String string9 = string7.substring(string7.indexOf("[") + 1, string7.indexOf("]"));
                    this.validationErrorResponseMsg = string9 = string9.replace("SOLR_ERROR:", "");
                    this.printOut(string3 + "Validation Error Response:" + this.validationErrorResponseMsg);
                }
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace(string3 + "Error while rexec process :", exception);
        }
        return n;
    }

    protected boolean isStringNull(String string) {
        return string == null || string.trim().length() == 0 || string.equalsIgnoreCase(NULL) || string.equalsIgnoreCase(NONE);
    }

    protected boolean isArrayListNull(ArrayList arrayList) {
        return arrayList == null || arrayList.isEmpty() || arrayList.size() == 0;
    }

    protected boolean isHashtableNull(Hashtable hashtable) {
        return hashtable == null || hashtable.isEmpty() || hashtable.size() == 0;
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, true);
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string);
    }

    public void printOut(String string, boolean bl) {
        if (this.debugLogSizeLimitInMB > 0.0) {
            SolrValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            SolrValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putInfoMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            SolrValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putWarningMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            SolrValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.putErrorMessageToLogfile(string2 + string3);
    }

    public static synchronized void debugLogToFile(String string, double d) {
        try {
            PrintWriter printWriter = null;
            String string2 = DEBUG_LOG_LOCATION;
            File file = new File(string2);
            if (file.exists() && (double)file.length() >= d) {
                String string3 = string2 + ".1";
                File file2 = new File(string3);
                if (file2.exists()) {
                    file2.delete();
                }
                EgInstallInfo.fileRename(string2, string3);
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string2, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            SolrValidator.debugLogToFile("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    public ArrayList getValidationMsgs() {
        String string = "getValidationMsgs";
        string = this.methodNameTemplate(string);
        this.printOut(string + "validation ArrayList :" + this.validationMsgs);
        this.printOut(string + "*******************************************************************************");
        return this.validationMsgs;
    }

    public static void main(String[] stringArray) {
        SolrValidator solrValidator = new SolrValidator(stringArray, new Boolean(false));
        solrValidator.getValidationMsgs();
    }
}

