/*
 * Decompiled with CFR 0.152.
 */
import com.eg.Base64Coder;
import com.eg.EgSSL;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.StringTokenizer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class SolrValidatorRESTExecutor {
    protected String userName = null;
    protected String password = null;
    protected static final String HYPHEN = "-";
    protected static final String NULL = "null";
    protected static final String NONE = "none";
    protected static final String PROTOTYPE_HTTP = "http";
    protected static final String PROTOTYPE_HTTPS = "https";
    protected boolean isSSL = false;
    protected boolean isSSLEnabaled = false;
    protected static final int DEFAULT_CONNECTION_TIMEOUT = 15000;
    protected static final int DEFAULT_READ_TIMEOUT = 60000;
    protected static final String COLONS = ":";
    protected static final int ASCII_CODE_FOR_SPACE = 32;
    protected static final String SPACE = new String(" ");
    protected static final String BASIC = "Basic" + SPACE;
    protected static final String CONTENT_TYPE_KEY = "Content-Type";
    protected static final String CONTENT_TYPE_VALUE = "application/x-www-form-urlencoded";
    protected static final String CONTENT_TYPE_VALUE_JSON = "application/json";
    protected static final String GRANT_TYPE_KEY = "grant_type";
    protected static final String GRANT_TYPE_VALUE = "password";
    protected static final String USERNAME_KEY = "username";
    protected static final String PASSWORD_KEY = "password";
    private long collectionTimeout = 120L;
    protected static final String REQUEST_METHOD_GET = "GET";
    protected static final String AUTHORIZATION = "Authorization";
    protected static final String CACHE_CONTROL = "Cache-Control";
    protected static final String CACHE_CONTROL_NO_CACHE = "no-cache";
    protected String protoType = "";
    boolean deep_debug = false;
    protected String baseURLString = null;
    protected String port = null;
    String logMessage = "";
    String strLogSizeLimitInMB = null;
    protected static final String TEST_NAME = "SolrValidatorRESTExecutor";
    protected static final String LOG_FILE_NAME = "SolrValidatorLog";
    protected static final String INI_ENTRY_FOR_LOG_FILE_SIZE = "SolrValidatorRESTExecutorLogSizeLimitInMB";
    protected static final String DEBUG_LOG_LOCATION = EgInstallInfo.getInstallDir() + "/agent/logs/" + "SolrValidatorLog";
    protected static final String DEBUG = "DEBUG    ";
    protected static final String ERROR = "ERROR    ";
    protected static final String INFO = "INFO     ";
    protected static final String CRITICAL = "CRITICAL ";
    protected static final String WARNING = "WARNING  ";
    protected static final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    protected static final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    protected static final double MB_TO_BYTES = 1048576.0;
    protected static final double DEBUG_LOG_FILE_SIZE_IN_MB = 1.0;
    protected double debugLogSizeLimitInMB = 1048576.0;
    private static final String SOLR_DOCUMENT_CACHE_SUFFIX = "/solr/admin/metrics?group=core&prefix=CACHE.searcher.documentCache";
    private static final String SOLR_DOCUMENT_CACHE_PREFIX = "SOLR_DOCUMENT_CACHE:";
    String className = this.getClass().getName();
    String targetHost = null;
    private static final int j = 124;
    String tmp_timeout = null;
    String reportingName = null;
    String entity = null;

    public SolrValidatorRESTExecutor(String[] stringArray) {
        String string = "Constructor";
        string = this.methodNameTemplate(string);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2;
                if (stringArray[i].equals("-reportingName") && i + 1 < stringArray.length) {
                    this.reportingName = new String(stringArray[++i]);
                    if (this.reportingName == null) continue;
                    this.reportingName = this.reportingName.trim();
                    continue;
                }
                if (stringArray[i].equals("-host") && i + 1 < stringArray.length) {
                    this.targetHost = new String(stringArray[++i]);
                    if (this.targetHost != null) {
                        this.targetHost = this.targetHost.trim();
                    }
                    this.logMessage = string + "Host        :" + this.targetHost;
                    this.printOut(this.logMessage);
                    this.logMessage = "";
                    continue;
                }
                if (stringArray[i].equals("-port") && i + 1 < stringArray.length) {
                    this.port = new String(stringArray[++i]);
                    if (this.isStringNull(this.port)) {
                        this.logMessage = string + "port is null or empty ";
                        this.putWarningMessageToLogfile(this.logMessage);
                        this.logMessage = "";
                        continue;
                    }
                    this.logMessage = string + "port        :" + this.port;
                    this.printOut(this.logMessage);
                    this.logMessage = "";
                    continue;
                }
                if (stringArray[i].equals("-username") && i + 1 < stringArray.length) {
                    this.userName = new String(stringArray[++i]);
                    if (this.isStringNull(this.userName)) {
                        this.logMessage = string + "User name is null or empty ";
                        this.putWarningMessageToLogfile(this.logMessage);
                        this.logMessage = "";
                        continue;
                    }
                    this.logMessage = string + "User name   :" + this.userName;
                    this.printOut(this.logMessage);
                    this.logMessage = "";
                    continue;
                }
                if (stringArray[i].equals("-password") && i + 1 < stringArray.length) {
                    this.password = new String(stringArray[++i]);
                    if (this.isStringNull(this.password)) {
                        this.logMessage = string + "Password is null or empty ";
                        this.putWarningMessageToLogfile(this.logMessage);
                        this.logMessage = "";
                        continue;
                    }
                    this.password = this.password.trim();
                    this.password = this.decrypt(this.password);
                    this.logMessage = string + "Password    :*******";
                    this.printOut(this.logMessage);
                    this.logMessage = "";
                    continue;
                }
                if (stringArray[i].equals("-timeout") && i + 1 < stringArray.length) {
                    string2 = new String(stringArray[++i]);
                    this.printOut(string + "Timeout string is " + string2);
                    if (string2 != null && !string2.equals("120")) {
                        try {
                            this.collectionTimeout = Integer.parseInt(string2);
                            this.collectionTimeout *= 1000L;
                            this.printOut(string + "Timeout in Milliseconds is " + this.collectionTimeout);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.printOut(string + "Could not parse specified timeout " + string2 + ". Using 120 seconds");
                            this.collectionTimeout = 120000L;
                        }
                        continue;
                    }
                    this.collectionTimeout = 120000L;
                    continue;
                }
                if (stringArray[i].equals("-ssl") && i + 1 < stringArray.length) {
                    if ((string2 = new String(stringArray[++i])) != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("y"))) {
                        this.isSSL = true;
                        this.protoType = PROTOTYPE_HTTPS;
                        this.printOut(string + "Transport type is HTTPS");
                        continue;
                    }
                    this.isSSL = false;
                    this.protoType = PROTOTYPE_HTTP;
                    this.printOut(string + "Transport type is HTTP");
                    continue;
                }
                if (stringArray[i].equals("-entity") && i + 1 < stringArray.length) {
                    this.entity = new String(stringArray[++i]);
                    if (this.entity == null) continue;
                    this.entity = this.entity.trim();
                    continue;
                }
                if (!stringArray[i].equals("-log_size") || i + 1 >= stringArray.length) continue;
                if ((string2 = new String(stringArray[++i])) != null && string2.length() > 0) {
                    string2 = string2.trim();
                    try {
                        this.debugLogSizeLimitInMB = Double.parseDouble(string2);
                        this.debugLogSizeLimitInMB *= 1048576.0;
                    }
                    catch (Exception exception) {
                        this.printOut("[" + this.className + "]: [Constructor ]: strLogSizeLimitInMB : " + string2 + " ,exception :" + exception.toString());
                        this.debugLogSizeLimitInMB = 5000000.0;
                    }
                }
                this.printOut("[" + this.className + "]: [Constructor ]: debugLogSizeLimitInMB : " + this.debugLogSizeLimitInMB);
            }
            this.baseURLString = this.protoType + "://" + this.targetHost + COLONS + this.port + "";
        }
        catch (Exception exception) {
            this.printOutStackTrace("[" + this.className + "]: [Constructor ]: error ", exception);
        }
    }

    protected void runThread(MonitoredThread monitoredThread, String string, long l) throws Exception {
        String string2 = "runThread";
        string2 = this.methodNameTemplate(string2);
        monitoredThread.start();
        long l2 = System.currentTimeMillis();
        long l3 = 20L;
        try {
            Thread.sleep(l3);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            this.printOutStackTrace(string2, interruptedException);
        }
        long l4 = System.currentTimeMillis() - l2;
        while (monitoredThread.isAlive() && l4 < this.collectionTimeout) {
            this.printOut(string2 + "Thread " + string + " still alive");
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            l4 = System.currentTimeMillis() - l2;
        }
        boolean bl = false;
        String string3 = "";
        this.printOut(string2 + "mt.status   :" + monitoredThread.status);
        this.printOut(string2 + "mt.isAlive   :" + monitoredThread.isAlive());
        if (monitoredThread.isAlive()) {
            if (monitoredThread.status == -1) {
                bl = true;
                string3 = " timed out with exception.";
            } else {
                bl = true;
                string3 = " timed out.";
            }
        } else if (monitoredThread.status != 1) {
            if (monitoredThread.status == -1) {
                bl = true;
                string3 = " got done with exception.";
            } else {
                bl = true;
                string3 = " aborted without exception";
            }
        }
        this.printOut(string2 + "interruptThread   :" + bl);
        if (bl) {
            monitoredThread.interrupt();
            Thread.currentThread();
            Thread.yield();
            this.printOut(string2 + "Error: Thread " + string + " " + string3);
            this.putErrorMessageToLogfile("Thread " + string + string3);
            throw new Exception("Thread " + string + " " + string3);
        }
    }

    protected void collectDataFromSolrServer() {
        String string = "collectDataFromSolrServer";
        string = this.methodNameTemplate(string);
        String string2 = "";
        int n = 0;
        this.enableSSLForApacheSolrRESTAPI();
        long l = System.currentTimeMillis();
        this.printOut(string + "------------------------------------------------------------------------------------------------------------");
        try {
            DataCollectionThread dataCollectionThread = new DataCollectionThread(SOLR_DOCUMENT_CACHE_SUFFIX);
            this.runThread(dataCollectionThread, "createAndConnect", 20L);
            string2 = dataCollectionThread.getResponseString();
            n = dataCollectionThread.responseCode;
            string2 = SOLR_DOCUMENT_CACHE_PREFIX + string2;
            this.printOut(string + "Client created and connected to " + this.targetHost + " service in " + (System.currentTimeMillis() - l) + "ms.");
            this.printOut(string + "Solr Document Cache JSON response >> " + string2);
            System.out.println("SOLR_RESPONSE:" + n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace("Error while getting JSON response ,Exception details ", exception);
            return;
        }
    }

    public String replaceAll(String string, String string2, String string3) {
        String string4 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        try {
            string4 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            return string;
        }
        while (stringTokenizer.hasMoreTokens()) {
            string4 = string4 + string3 + stringTokenizer.nextToken();
        }
        return string4;
    }

    public String decrypt(String string) {
        int n;
        if (string != null && string.length() < 2) {
            return string;
        }
        if (string != null && string.indexOf(COLONS) == -1) {
            return string;
        }
        ArrayList arrayList = this.myTokenizer(string, COLONS);
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        int n2 = n = arrayList.size();
        byte[] byArray = new byte[n];
        String string2 = null;
        int n3 = n - 1;
        for (int i = 0; i < n2; ++i) {
            string2 = (String)arrayList.get(i);
            int n4 = 0;
            try {
                n4 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                return string;
            }
            int n5 = 124 - n4 + n3 * 3;
            --n3;
            byArray[--n] = (byte)n5;
        }
        String string3 = new String(byArray);
        return string3;
    }

    private ArrayList myTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 >= 0) {
            string3 = string.substring(n, n2);
            arrayList.add(string3);
            n = n2 + 1;
            n2 = string.indexOf(string2, n);
        }
        string3 = string.substring(n);
        arrayList.add(string3);
        return arrayList;
    }

    protected boolean isStringNull(String string) {
        return string == null || string.trim().length() == 0 || string.equalsIgnoreCase(NULL) || string.equalsIgnoreCase(NONE);
    }

    protected boolean isArrayListNull(ArrayList arrayList) {
        return arrayList == null || arrayList.isEmpty() || arrayList.size() == 0;
    }

    protected boolean isHashtableNull(Hashtable hashtable) {
        return hashtable == null || hashtable.isEmpty() || hashtable.size() == 0;
    }

    void enableSSLForApacheSolrRESTAPI() {
        if (this.isSSL && !this.isSSLEnabaled) {
            String string = null;
            EgSSL egSSL = EgSSL.getInstance();
            egSSL.enableSSL();
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Object var4_4 = null;
            MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
            SSLContext sSLContext = null;
            try {
                sSLContext = SSLContext.getInstance("SSL");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                string = "[enableSSLForApacheSolrRESTAPI]";
                this.printOutStackTrace(string, noSuchAlgorithmException);
            }
            try {
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            }
            catch (KeyManagementException keyManagementException) {
                string = "[enableSSLForApacheSolrRESTAPI]";
                this.printOutStackTrace(string, keyManagementException);
            }
            SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
            HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
            this.isSSLEnabaled = true;
        }
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, true);
    }

    public void printOut(String string, boolean bl) {
        SolrValidatorRESTExecutor.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string, this.debugLogSizeLimitInMB);
    }

    public void putInfoMessageToLogfile(String string) {
        SolrValidatorRESTExecutor.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string, this.debugLogSizeLimitInMB);
    }

    public void putWarningMessageToLogfile(String string) {
        SolrValidatorRESTExecutor.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string, this.debugLogSizeLimitInMB);
    }

    public void putErrorMessageToLogfile(String string) {
        SolrValidatorRESTExecutor.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string, this.debugLogSizeLimitInMB);
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.putErrorMessageToLogfile(string2 + string3);
    }

    public static synchronized void debugLogToFile(String string, double d) {
        try {
            PrintWriter printWriter = null;
            String string2 = DEBUG_LOG_LOCATION;
            File file = new File(string2);
            if (file.exists() && (double)file.length() >= d) {
                String string3 = string2 + ".1";
                File file2 = new File(string3);
                if (file2.exists()) {
                    file2.delete();
                }
                EgInstallInfo.fileRename(string2, string3);
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string2, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            SolrValidatorRESTExecutor.debugLogToFile("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    public static void main(String[] stringArray) {
        SolrValidatorRESTExecutor solrValidatorRESTExecutor = new SolrValidatorRESTExecutor(stringArray);
        solrValidatorRESTExecutor.collectDataFromSolrServer();
    }

    class DataCollectionThread
    extends MonitoredThread {
        public String responseString = null;
        public int responseCode = 0;
        String urlSuffix = "";

        DataCollectionThread(String string) {
            this.urlSuffix = string;
        }

        public void run() {
            String string = "DataCollectionThread::run";
            string = SolrValidatorRESTExecutor.this.methodNameTemplate(string);
            try {
                this.setName("createAndConnect");
                String string2 = SolrValidatorRESTExecutor.this.baseURLString + this.urlSuffix;
                SolrValidatorRESTExecutor.this.printOut(string + "URL String   :" + string2);
                HttpURLConnection httpURLConnection = null;
                URL uRL = new URL(null, string2);
                String string3 = SolrValidatorRESTExecutor.this.userName + SolrValidatorRESTExecutor.COLONS + SolrValidatorRESTExecutor.this.password;
                String string4 = Base64Coder.encodeString(string3);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestMethod(SolrValidatorRESTExecutor.REQUEST_METHOD_GET);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setConnectTimeout(15000);
                httpURLConnection.addRequestProperty(SolrValidatorRESTExecutor.CONTENT_TYPE_KEY, SolrValidatorRESTExecutor.CONTENT_TYPE_VALUE_JSON);
                httpURLConnection.setRequestProperty(SolrValidatorRESTExecutor.AUTHORIZATION, BASIC + string4);
                httpURLConnection.setRequestProperty(SolrValidatorRESTExecutor.CACHE_CONTROL, SolrValidatorRESTExecutor.CACHE_CONTROL_NO_CACHE);
                try {
                    httpURLConnection.connect();
                }
                catch (Exception exception) {
                    System.out.println("SOLR_ERROR:" + exception);
                    SolrValidatorRESTExecutor.this.printOutStackTrace(string + "Error while connect the server", exception);
                    return;
                }
                int n = 0;
                try {
                    n = httpURLConnection.getResponseCode();
                    SolrValidatorRESTExecutor.this.logMessage = string + " and its Response code :" + n + " for the URL  :" + string2;
                    this.responseCode = n;
                    SolrValidatorRESTExecutor.this.printOut(SolrValidatorRESTExecutor.this.logMessage);
                    if (n > 300) {
                        SolrValidatorRESTExecutor.this.putInfoMessageToLogfile(SolrValidatorRESTExecutor.this.logMessage);
                    }
                    SolrValidatorRESTExecutor.this.logMessage = "";
                }
                catch (Exception exception) {
                    SolrValidatorRESTExecutor.this.printOutStackTrace(string + "Error while get the response code the server", exception);
                }
                InputStream inputStream = null;
                try {
                    inputStream = n == 200 ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream();
                    this.responseString = this.decodeResponse(inputStream);
                    this.status = 1;
                }
                catch (Exception exception) {
                    SolrValidatorRESTExecutor.this.printOutStackTrace(string + "Error while get the response info from the server", exception);
                }
                if (inputStream != null) {
                    this.status = 1;
                    Map<String, List<String>> map = httpURLConnection.getHeaderFields();
                    SolrValidatorRESTExecutor.this.printOut(string + "getHeaderFields : " + map);
                    try {
                        inputStream.close();
                        inputStream = null;
                    }
                    catch (Exception exception) {
                        SolrValidatorRESTExecutor.this.printOutStackTrace(string + "Error while close the response", exception);
                    }
                }
                try {
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    SolrValidatorRESTExecutor.this.printOutStackTrace(string + "Error while disconnect", exception);
                }
                if (SolrValidatorRESTExecutor.this.deep_debug) {
                    SolrValidatorRESTExecutor.this.logMessage = string + " responseString :" + this.responseString;
                    SolrValidatorRESTExecutor.this.printOut(SolrValidatorRESTExecutor.this.logMessage);
                    SolrValidatorRESTExecutor.this.logMessage = "";
                }
            }
            catch (Exception exception) {
                SolrValidatorRESTExecutor.this.printOutStackTrace("Exception while delete the session ", exception);
                this.status = -1;
                exception.printStackTrace();
            }
        }

        protected String decodeResponse(InputStream inputStream) {
            String string = "decodeResponse";
            string = SolrValidatorRESTExecutor.this.methodNameTemplate(string);
            try {
                if (inputStream != null && inputStream.toString().trim().length() > 0) {
                    Scanner scanner = new Scanner(inputStream);
                    scanner.useDelimiter("\\A");
                    return scanner.hasNext() ? scanner.next() : "";
                }
                SolrValidatorRESTExecutor.this.logMessage = string + " Response is null or empty";
                SolrValidatorRESTExecutor.this.printOut(SolrValidatorRESTExecutor.this.logMessage);
                SolrValidatorRESTExecutor.this.putWarningMessageToLogfile(SolrValidatorRESTExecutor.this.logMessage);
                SolrValidatorRESTExecutor.this.logMessage = "";
            }
            catch (Exception exception) {
                SolrValidatorRESTExecutor.this.printOutStackTrace("Exception while decoding the  response", exception);
                exception.printStackTrace();
            }
            return null;
        }

        public String getResponseString() {
            String string = "getResponseString";
            string = SolrValidatorRESTExecutor.this.methodNameTemplate(string);
            this.responseString = SolrValidatorRESTExecutor.this.replaceAll(this.responseString, System.lineSeparator(), "");
            SolrValidatorRESTExecutor.this.printOut(string + "After decode for the method  " + string + "  ====> Response  : " + this.responseString);
            return this.responseString;
        }
    }

    abstract class MonitoredThread
    extends Thread {
        protected static final int UNSET = 0;
        protected static final int SUCCESS = 1;
        protected static final int ERR = -1;
        protected int status = 0;

        MonitoredThread() {
        }

        public abstract void run();
    }
}

