/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IniFile;
import com.egurkha.util.EgUtilities;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;

public class VNXeValidator
extends EgServerValidator {
    EgUtilities egu;
    protected String spaIP = "";
    protected String username = "";
    protected String password = "";
    protected String cliPath = "";
    protected String sysOS = "";
    protected String strTimeout = "";
    protected String cmdPath = null;
    protected String cmdPathDebug = null;
    protected int intervalCLI = 60;
    protected int egTestFreq = 0;
    protected long tmp_timeout = 300L;
    public String reportingName = null;
    public String entity = null;
    public String timeout = null;
    public String validationMsg = null;
    public String validationErrorMsg = null;
    protected static final int DEFAULT_MINUS_ONE = -1;
    protected static final String DEBUG = "DEBUG    ";
    protected static final String ERROR = "ERROR    ";
    protected static final String INFO = "INFO     ";
    protected static final String CRITICAL = "CRITICAL ";
    protected static final String WARNING = "WARNING  ";
    private boolean isFromManager = false;
    public ArrayList validationMsgs = null;
    private String strVNXeValidatorLogSizeLimitInMB = null;
    private static final double MB_TO_BYTES = 1048576.0;
    private static final double DEBUG_LOG_FILE_SIZE_IN_MB = 1.0;
    protected double vnxeValidatorLogSizeLimitInMB = 1048576.0;
    protected static final String LOG_FILE_NAME = "VNXeValidatorLog";
    protected static final String DEBUG_LOG_LOCATION = EgInstallInfo.getInstallDir() + "/agent/logs/" + "VNXeValidatorLog";
    private static final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss";
    private static final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    String className = this.getClass().getName();

    public VNXeValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        String string = "Constructor";
        string = this.methodNameTemplate(string);
        this.entity = this.className;
        this.egu = EgUtilities.createInstance((boolean)true);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2.substring(0, string2.indexOf(":"));
                String string4 = string2.substring(string2.indexOf(":") + 1);
                if ((string3 = string3.trim()) != null && string3.equalsIgnoreCase("-host")) {
                    this.spaIP = string4.trim();
                } else if (string3 != null && string3.equalsIgnoreCase("-username")) {
                    this.username = string4.trim();
                } else if (string3 != null && string3.equalsIgnoreCase("-password")) {
                    if ((string4 = EgCrypt.decrypt(string4)).indexOf("~EG~") != -1) {
                        string4 = string4.substring(0, string4.indexOf("~EG~"));
                    }
                    this.password = string4.trim();
                } else if (string3 != null && string3.equalsIgnoreCase("-unisphere_cli_path")) {
                    this.cliPath = string4.trim();
                } else if (string3 != null && string3.equalsIgnoreCase("-rptname")) {
                    this.reportingName = string4.trim();
                } else if (string3 != null && string3.equalsIgnoreCase("-timeout")) {
                    this.strTimeout = string4.trim();
                }
                this.sysOS = System.getProperty("os.name");
                if (this.sysOS != null) continue;
                this.putErrorMessageToLogfile("Operating System Name not Found");
                return;
            }
            this.sysOS = this.sysOS.trim().toUpperCase();
            if (this.sysOS.trim().startsWith("WIN")) {
                this.cliPath.replace('/', '\\');
                if (!this.cliPath.endsWith("\\")) {
                    this.cliPath = this.cliPath + "\\";
                }
                this.cmdPath = "\"" + this.cliPath + "uemcli" + "\"" + " -d " + this.spaIP + " -u " + this.username + " -p " + this.password + " /metrics/service show";
                this.printOut(string + "Command line path for Windows OS : " + "\"" + this.cliPath + "uemcli" + "\"" + " -d " + this.spaIP + " -u " + this.username + " -p ****** /metrics/service show");
            } else {
                this.cliPath.replace('\\', '/');
                if (!this.cliPath.endsWith("/")) {
                    this.cliPath = this.cliPath + "/";
                }
                this.cmdPath = this.cliPath + "uemcli" + " -d " + this.spaIP + " -u " + this.username + " -p " + this.password + " /metrics/service show";
                this.printOut(string + "Command line path for Linux OS : " + this.cliPath + "uemcli" + " -d " + this.spaIP + " -u " + this.username + " -p ****** /metrics/service show");
            }
            if (this.strTimeout == null || this.strTimeout.trim().length() == 0 || this.strTimeout.equalsIgnoreCase("none")) {
                this.tmp_timeout = 300L;
            } else {
                try {
                    this.tmp_timeout = Long.parseLong(this.strTimeout);
                }
                catch (Exception exception) {
                    this.tmp_timeout = 300L;
                    this.printOutStackTrace(string, exception);
                }
            }
            if (this.spaIP == null) {
                this.spaIP = "";
            }
            IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini", false);
            this.strVNXeValidatorLogSizeLimitInMB = iniFile.getValue("AGENT_SETTINGS", "VNXeValidatorLogSizeLimitInMB");
            if (this.strVNXeValidatorLogSizeLimitInMB != null && this.strVNXeValidatorLogSizeLimitInMB.length() > 0) {
                this.strVNXeValidatorLogSizeLimitInMB = this.strVNXeValidatorLogSizeLimitInMB.trim();
                try {
                    this.vnxeValidatorLogSizeLimitInMB = Double.parseDouble(this.strVNXeValidatorLogSizeLimitInMB);
                    this.vnxeValidatorLogSizeLimitInMB *= 1048576.0;
                    this.printOut(string + "VNXeValidatorLogSizeLimitInMB value in bytes : " + this.vnxeValidatorLogSizeLimitInMB);
                }
                catch (Exception exception) {
                    this.printOut(string + "Conversion error for strVNXeValidatorLogSizeLimitInMB value to bytes : " + this.strVNXeValidatorLogSizeLimitInMB + " ,exception :" + exception.toString());
                    this.vnxeValidatorLogSizeLimitInMB = 1048576.0;
                }
            } else {
                this.vnxeValidatorLogSizeLimitInMB = 1048576.0;
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace(string, exception);
        }
        this.validationMsgs = new ArrayList();
        this.validate();
        this.isFromManager = bl;
    }

    public void validate() {
        String string = "validate";
        string = this.methodNameTemplate(string);
        this.printOut(string + "Host Name        :" + this.spaIP);
        this.printOut(string + "User name        :" + this.username);
        this.printOut(string + "Password         :*******");
        this.printOut(string + "Unisphere path   :" + this.cliPath);
        this.printOut(string + "Timeout          :" + this.tmp_timeout);
        this.printOut(string + "Reporting name   :" + this.reportingName);
        this.printOut(string + "VALIDATION PROCESS STARTED ");
        if (this.isFileExist(this.cliPath)) {
            this.validationMsgs.add(0, "CLI Path$#$OK");
            if (!this.isIPReachable()) {
                this.validationMsgs.add(1, "Host IP/Name$#$Host IP/Name is invalid or Host IP/Name is unreachable");
                this.validationMsgs.add(2, "User/Password$#$NA");
                this.validationMsgs.add(3, "Performance monitoring$#$NA");
            } else if (this.ifStringIsNull(this.username) || this.ifStringIsNull(this.password)) {
                this.validationErrorMsg = "Please provide valid credentials.";
                this.validationMsgs.add(1, "Host IP/Name$#$OK");
                this.validationMsgs.add(2, "User/Password$#$" + this.validationErrorMsg);
                this.validationMsgs.add(3, "Performance monitoring$#$NA");
            } else {
                this.validationMsgs.add(1, "Host IP/Name$#$OK");
                this.getCMDResponse(this.cmdPath);
            }
        } else {
            this.validationErrorMsg = "Please provide valid CLI path";
            this.validationMsgs.add(0, "CLI Path$#$" + this.validationErrorMsg);
            this.validationMsgs.add(1, "Host IP/Name$#$NA");
            this.validationMsgs.add(2, "User/Password$#$NA");
            this.validationMsgs.add(3, "Performance monitoring$#$NA");
            this.printOut(string + "Unisphere path is not valid ");
        }
        this.printOut(string + "VALIDATION PROCESS ENDED");
        if (!this.isFromManager) {
            return;
        }
    }

    public void getCMDResponse(String string) {
        String string2 = "getCMDResponse";
        string2 = this.methodNameTemplate(string2);
        String string3 = string;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n = 0;
        ArrayList arrayList = this.egu.getExecOutputLines(string3, this.tmp_timeout, string3, "UTF-16");
        this.printOut(string2 + "Response from CMD execution :" + arrayList);
        if (arrayList != null && !arrayList.isEmpty() && arrayList.size() >= 2) {
            ArrayList arrayList2 = (ArrayList)arrayList.get(0);
            ArrayList arrayList3 = (ArrayList)arrayList.get(1);
            if (arrayList3 != null && !arrayList3.isEmpty() && arrayList3.size() > 0) {
                this.printOut(string2 + "[Error] OutputArrayList error line " + arrayList3 + " OutputArrayList lines " + arrayList2);
                this.printOut(string2 + "Error in execute command");
                this.validationErrorMsg = "Error in execute command";
                this.validationMsgs.add(2, "User/Password$#$" + this.validationErrorMsg);
                this.validationMsgs.add(3, "Performance monitoring$#$NA");
            } else if (arrayList2 == null || arrayList2.isEmpty() || arrayList2.size() == 0) {
                this.printOut(string2 + "[Error] OutputArrayList error line " + arrayList3 + " OutputArrayList lines " + arrayList2);
                this.printOut(string2 + "Error in execution, command output null");
                this.validationErrorMsg = "Error in execution, command output null";
                this.validationMsgs.add(2, "User/Password$#$" + this.validationErrorMsg);
                this.validationMsgs.add(3, "Performance monitoring$#$NA");
                return;
            }
            if (arrayList2 != null && !arrayList2.isEmpty() && arrayList2.size() > 0) {
                n = arrayList2.size();
                for (int i = 0; i < n; ++i) {
                    string4 = (String)arrayList2.get(i);
                    if (string4 == null || string4.trim().length() == 0) continue;
                    string4 = string4.trim();
                    string5 = string4.toLowerCase();
                    this.printOut("OutputLine-------> :" + string4);
                    this.printOut("OutputTmpLine-------> :" + string5);
                    if (string5.startsWith("the system was unable to connect to the storage server")) {
                        this.printOut(string4);
                        this.putErrorMessageToLogfile(string4);
                        this.validationErrorMsg = "The system was unable to connect to the storage server";
                        this.validationMsgs.remove(1);
                        this.validationMsgs.add(1, "Host IP/Name$#$" + this.validationErrorMsg);
                        this.validationMsgs.add(2, "User/Password$#$NA");
                        this.validationMsgs.add(3, "Performance monitoring$#$NA");
                        return;
                    }
                    if (string5.startsWith("you do not have access to perform the requested operation")) {
                        this.printOut("Error in Connection either user/pass incorrect : " + string4);
                        this.validationErrorMsg = "Error in Connection either user/password incorrect  ";
                        this.validationMsgs.add(2, "User/Password$#$" + this.validationErrorMsg);
                        this.validationMsgs.add(3, "Performance monitoring$#$NA");
                        return;
                    }
                    if (string5.startsWith("internal error on server side")) {
                        this.printOut("Error,Internal error on server side : " + string4);
                        this.validationErrorMsg = "Error ,Internal error on server side  ";
                        this.validationMsgs.add(2, "User/Password$#$" + this.validationErrorMsg);
                        this.validationMsgs.add(3, "Performance monitoring$#$NA");
                        return;
                    }
                    if (string5.startsWith("remote server is not available")) {
                        this.printOut("Error Remote server is not available : " + string4);
                        this.validationErrorMsg = "Error,Remote server is not available ";
                        this.validationMsgs.add(2, "User/Password$#$" + this.validationErrorMsg);
                        this.validationMsgs.add(3, "Performance monitoring$#$NA");
                        return;
                    }
                    if (!string5.contains("history enabled")) continue;
                    StringTokenizer stringTokenizer = new StringTokenizer(string5, "=");
                    try {
                        stringTokenizer.nextToken();
                        string6 = stringTokenizer.nextToken().trim();
                        if (string6.equalsIgnoreCase("yes") || string6.equalsIgnoreCase("Y")) {
                            this.printOut(string2 + "History enabled :" + string6);
                            this.validationMsgs.add(2, "User/Password$#$OK");
                            this.validationMsgs.add(3, "Performance monitoring$#$OK");
                            return;
                        }
                        this.printOut(string2 + "History enabled :is null/not enabled ");
                        this.validationErrorMsg = "Performance monitoring not enabled ";
                        this.validationMsgs.add(2, "User/Password$#$OK");
                        this.validationMsgs.add(3, "Performance monitoring$#$" + this.validationErrorMsg);
                        continue;
                    }
                    catch (Exception exception) {
                        this.printOutStackTrace(string2, exception);
                    }
                }
            }
        }
    }

    protected boolean isFileExist(String string) {
        String string2 = "isFileExist";
        string2 = this.methodNameTemplate(string2);
        String string3 = string;
        String string4 = "";
        String string5 = "";
        String string6 = "uemcli.exe";
        String string7 = "uemcli";
        File file = new File(string3);
        if (file.exists()) {
            if (this.sysOS.trim().startsWith("WIN")) {
                string4 = string3 + string6;
                File file2 = new File(string4);
                return file2.exists();
            }
            string5 = string3 + string7;
            File file3 = new File(string5);
            return file3.exists();
        }
        return false;
    }

    public ArrayList getValidationMsgs() {
        String string = "getValidationMsgs";
        string = this.methodNameTemplate(string);
        this.printOut(string + "validation ArrayList :" + this.validationMsgs);
        this.printOut(string + "*******************************************************************************");
        return this.validationMsgs;
    }

    protected boolean ifStringIsNull(String string) {
        return string == null || string.trim().length() == 0 || string.equalsIgnoreCase("NONE") || string.equalsIgnoreCase("null");
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, false);
    }

    public void printOut(String string, boolean bl) {
        VNXeValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string, this.vnxeValidatorLogSizeLimitInMB);
        System.out.println(" >> [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + MY_SDF.format(new Date()) + " ] :>> " + string);
    }

    public void putErrorMessageToLogfile(String string) {
        VNXeValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string, this.vnxeValidatorLogSizeLimitInMB);
    }

    public void putInfoMessageToLogfile(String string) {
        VNXeValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string, this.vnxeValidatorLogSizeLimitInMB);
    }

    public void putWarningMessageToLogfile(String string) {
        VNXeValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string, this.vnxeValidatorLogSizeLimitInMB);
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.putErrorMessageToLogfile(string2 + string3);
    }

    public static synchronized void debugLogToFile(String string, double d) {
        try {
            PrintWriter printWriter = null;
            String string2 = DEBUG_LOG_LOCATION;
            File file = new File(string2);
            if (file.exists() && (double)file.length() >= d) {
                String string3 = string2 + ".1";
                File file2 = new File(string3);
                if (file2.exists()) {
                    file2.delete();
                }
                EgInstallInfo.fileRename(string2, string3);
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string2, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            VNXeValidator.debugLogToFile("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    public static void main(String[] stringArray) {
        VNXeValidator vNXeValidator = new VNXeValidator(stringArray, new Boolean(false));
        vNXeValidator.getValidationMsgs();
    }
}

