/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class VpnSessionTest
extends EgSnmpGenericTest {
    private static String active = ".1.3.6.1.4.1.3076.2.1.2.17.1.1";
    private static String total = ".1.3.6.1.4.1.3076.2.1.2.17.1.2";
    private static String max = ".1.3.6.1.4.1.3076.2.1.2.17.1.4";
    private static String lan2lan = ".1.3.6.1.4.1.3076.2.1.2.17.1.7";
    private static String mgmt = ".1.3.6.1.4.1.3076.2.1.2.17.1.8";
    private static String remote = ".1.3.6.1.4.1.3076.2.1.2.17.1.9";
    private static int numMeasures = 7;
    private double prevTot = -1.0;

    public VpnSessionTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(numMeasures);
    }

    private double getValue() {
        if (this.lhs == null || this.lhs.length == 0) {
            return -5.0;
        }
        double d = -5.0;
        try {
            d = Double.parseDouble(this.rhs[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public void computeMeasures(Hashtable hashtable) {
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = -5.0;
        double d5 = -5.0;
        double d6 = -5.0;
        if (this.runSnmpCmdForOid(active)) {
            d = this.getValue();
        }
        if (this.runSnmpCmdForOid(total)) {
            d2 = this.getValue();
        }
        if (this.runSnmpCmdForOid(max)) {
            d3 = this.getValue();
        }
        if (this.runSnmpCmdForOid(lan2lan)) {
            d4 = this.getValue();
        }
        if (this.runSnmpCmdForOid(mgmt)) {
            d5 = this.getValue();
        }
        if (this.runSnmpCmdForOid(remote)) {
            d6 = this.getValue();
        }
        double d7 = -1.0;
        if (d2 < 0.0) {
            this.prevTot = -1.0;
        } else {
            if (this.prevTot >= 0.0) {
                d7 = d2 - this.prevTot;
            }
            this.prevTot = d2;
            if (d7 < 0.0) {
                d7 = -5.0;
            }
        }
        double d8 = -1.0;
        if (d3 == 0.0) {
            d8 = 0.0;
        } else if (d3 > 0.0 && d >= 0.0) {
            d8 = d * 100.0 / d3;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(d));
        arrayList.add(new Double(d7));
        arrayList.add(new Double(d3));
        arrayList.add(new Double(d8));
        arrayList.add(new Double(d4));
        arrayList.add(new Double(d5));
        arrayList.add(new Double(d6));
        this.addNewMeasure(arrayList);
    }
}

