/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgSSL;
import com.eg.EgURLEncoder;
import com.eg.IPV6Helper;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class WLConnectorTest
extends GenericTest {
    static final String EGURKHA_NAME = "egurkha";
    static final String EGURKHA_MONITOR = "monitoring";
    private static String user = "system";
    private static String password = "weblogic";
    private boolean isSsl = false;
    private String uri = "egurkha/WLConnectorTest.jsp";
    private String server = "";
    private long timeout;
    private int defVersion = 6;
    private int version = 0;
    private String url;
    private String ssl;
    private String host;
    private String port;
    private String protocol = "t3";
    private String s_useWarFile = "Yes";
    private boolean b_useWarFile = true;
    private String weblogicJarLoc = "";
    private String tempHost = "";
    private WebLogicHelperThread sh;
    Hashtable lastMeasures = new Hashtable();
    double connections_created_total_count_last = -5.0;
    double connections_destroyed_total_count_last = -5.0;
    double connections_matched_total_count_last = -5.0;
    double connections_rejected_total_count_last = -5.0;
    double recycled_total_last = -5.0;
    protected boolean useJMX = false;
    protected long jspTimeout;
    boolean useSSLTrustStoreFlag = false;
    String wlSSLTrustKeyStore = null;
    String customTrustKeyStoreFileName = null;
    String customTrustKeyStoreType = null;
    String customTrustKeyStorePassPhrase = null;

    public WLConnectorTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(10);
        this.isDynamicInfoTest = true;
        if (this.timeout == 0L) {
            this.timeout = 2L * EgConfigInfo.msecPerMin;
        }
        long l = this.measurePeriod / 1000L;
        long l2 = l / 3L;
        String string = this.getValueForParam("jspTimeout");
        if (string == null || string.trim().length() == 0 || string.equalsIgnoreCase("null") || string.equalsIgnoreCase("none")) {
            this.jspTimeout = l2;
        } else {
            try {
                this.jspTimeout = Long.parseLong(string);
                if (this.jspTimeout >= l) {
                    this.jspTimeout = l2;
                    System.out.println("[" + this.entity + "] : [" + this.reportingName + "] :  Configured JSP timeout is more than test frequceny, so setting default values " + string);
                    this.logToErrorFile("Info :", "[" + this.entity + "] : [" + this.reportingName + "] :  Configured JSP timeout is more than test frequceny, so setting default values ", string);
                }
            }
            catch (Exception exception) {
                this.jspTimeout = l2;
            }
        }
        System.out.println("[" + this.entity + "] : [" + this.reportingName + "] : JSP timeout " + string);
    }

    public void computeMeasures(Hashtable hashtable) {
        user = (String)hashtable.get("user");
        password = (String)hashtable.get("password");
        this.server = (String)hashtable.get("server");
        this.ssl = (String)hashtable.get("ssl");
        this.url = (String)hashtable.get("url");
        this.s_useWarFile = (String)hashtable.get("useWarFile");
        if (this.s_useWarFile == null || this.s_useWarFile.equalsIgnoreCase("Yes") || this.s_useWarFile.equalsIgnoreCase("true")) {
            this.b_useWarFile = true;
        } else {
            this.b_useWarFile = false;
            this.weblogicJarLoc = this.getValueForParam("weblogicJarLocation");
            if (this.weblogicJarLoc == null || this.weblogicJarLoc.trim().length() == 0) {
                this.weblogicJarLoc = "";
            }
            this.weblogicJarLoc = WLCommandExecute.findAndReplaceString(this.weblogicJarLoc, "\\", "/");
            this.weblogicJarLoc = this.weblogicJarLoc + "/weblogic.jar";
            if (this.ssl != null) {
                this.isSsl = new Boolean(this.ssl);
            }
            if (this.isSsl) {
                this.wlSSLTrustKeyStore = this.getValueForParam("ssl_trust_key_store");
                System.out.println(this.reportingName + ":" + this.entity + " :  wlSSLTrustKeyStore is before check  " + this.wlSSLTrustKeyStore);
                if (this.wlSSLTrustKeyStore == null || this.wlSSLTrustKeyStore.equalsIgnoreCase("none") || this.wlSSLTrustKeyStore.equalsIgnoreCase("null") || this.wlSSLTrustKeyStore.trim().length() == 0) {
                    this.useSSLTrustStoreFlag = false;
                } else {
                    this.useSSLTrustStoreFlag = true;
                    this.wlSSLTrustKeyStore = this.wlSSLTrustKeyStore.trim();
                    System.out.println(this.reportingName + ":" + this.entity + " :  wlSSLTrustKeyStore is " + this.wlSSLTrustKeyStore);
                }
                this.customTrustKeyStoreFileName = this.getValueForParam("custom_trust_key_store_file_name");
                System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStoreFileName is before check  " + this.customTrustKeyStoreFileName);
                if (this.customTrustKeyStoreFileName == null || this.customTrustKeyStoreFileName.equalsIgnoreCase("none") || this.customTrustKeyStoreFileName.equalsIgnoreCase("null") || this.customTrustKeyStoreFileName.trim().length() == 0) {
                    System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStoreFileName is null or none   ");
                } else {
                    this.customTrustKeyStoreFileName = this.customTrustKeyStoreFileName.trim();
                    System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStoreFileName is " + this.customTrustKeyStoreFileName);
                }
                this.customTrustKeyStoreType = this.getValueForParam("custom_trust_key_store_type");
                System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStoreType is before check  " + this.customTrustKeyStoreType);
                if (this.customTrustKeyStoreType == null || this.customTrustKeyStoreType.equalsIgnoreCase("none") || this.customTrustKeyStoreType.equalsIgnoreCase("null") || this.customTrustKeyStoreType.trim().length() == 0) {
                    System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStoreType is null or none  ");
                } else {
                    this.customTrustKeyStoreType = this.customTrustKeyStoreType.trim();
                    System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStoreType is " + this.customTrustKeyStoreType);
                }
                this.customTrustKeyStorePassPhrase = this.getValueForParam("custom_trust_key_store_pass_phrase");
                System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStorePassPhrase is before check  " + this.customTrustKeyStorePassPhrase);
                if (this.customTrustKeyStorePassPhrase == null || this.customTrustKeyStorePassPhrase.equalsIgnoreCase("none") || this.customTrustKeyStorePassPhrase.equalsIgnoreCase("null") || this.customTrustKeyStorePassPhrase.trim().length() == 0) {
                    System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStorePassPhrase is null or none    ");
                } else {
                    this.customTrustKeyStorePassPhrase = this.customTrustKeyStorePassPhrase.trim();
                    System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStorePassPhrase is " + this.customTrustKeyStorePassPhrase);
                }
            }
        }
        String string = this.getValueForParam("encryptPass");
        if (string != null && string.equalsIgnoreCase("true")) {
            password = EgCrypt.encrypt(password, true);
        }
        if (this.server == null) {
            this.server = "";
        }
        if (this.ssl != null) {
            this.isSsl = new Boolean(this.ssl);
        }
        if (this.version == 0) {
            String string2 = this.getValueForParam("version");
            if (!string2.equalsIgnoreCase("none")) {
                int n = string2.indexOf(".");
                if (n >= 0) {
                    string2 = string2.substring(0, n);
                }
                try {
                    this.version = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    this.version = 0;
                }
            }
            if (this.version == 0) {
                this.version = this.discovery();
            }
        }
        this.tempHost = IPV6Helper.getValidIPAddress(this.targetHost);
        if (this.url == null || this.url.equals("")) {
            if (this.isSsl) {
                this.url = "https://" + this.tempHost + ":" + this.portNo;
                this.protocol = "t3s";
            } else {
                this.url = "http://" + this.tempHost + ":" + this.portNo;
                this.protocol = "t3";
            }
        } else {
            this.url = this.url.toLowerCase();
            if (this.isSsl) {
                if (this.url.indexOf("https") < 0) {
                    this.url = this.findAndReplaceString(this.url, "http", "https");
                }
                this.protocol = "t3s";
            }
        }
        if (this.version >= 12) {
            this.useJMX = true;
        }
        if (this.useJMX) {
            this.uri = "egurkha/WLConnectorTestUsingJMX.jsp";
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        String string3 = null;
        if (this.version >= 6) {
            ArrayList arrayList = this.returnMeasures();
            if (arrayList == null || arrayList.size() == 0) {
                this.addNewMeasure(null, null);
                return;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                Object object;
                String string4 = (String)arrayList.get(i);
                if (string4 != null) {
                    object = new StringTokenizer(string4, ":");
                    if (((StringTokenizer)object).countTokens() != 2) {
                        this.addNewMeasure(null, null);
                        return;
                    }
                    ((StringTokenizer)object).nextToken();
                    string4 = ((StringTokenizer)object).nextToken();
                    object = new StringTokenizer(string4, ",");
                    if (((StringTokenizer)object).countTokens() != 11) {
                        this.addNewMeasure(null, null);
                        return;
                    }
                } else {
                    this.addNewMeasure(null, null);
                    return;
                }
                string3 = ((StringTokenizer)object).nextToken();
                d = Double.parseDouble(((StringTokenizer)object).nextToken());
                d2 = Double.parseDouble(((StringTokenizer)object).nextToken());
                d3 = Double.parseDouble(((StringTokenizer)object).nextToken());
                d4 = Double.parseDouble(((StringTokenizer)object).nextToken());
                d5 = Double.parseDouble(((StringTokenizer)object).nextToken());
                d6 = Double.parseDouble(((StringTokenizer)object).nextToken());
                d7 = Double.parseDouble(((StringTokenizer)object).nextToken());
                d8 = Double.parseDouble(((StringTokenizer)object).nextToken());
                d9 = Double.parseDouble(((StringTokenizer)object).nextToken());
                d10 = Double.parseDouble(((StringTokenizer)object).nextToken());
                this.populateLastMeasures(string3);
                object = new ArrayList();
                if (this.connections_created_total_count_last != -5.0) {
                    double d11 = d3 - this.connections_created_total_count_last;
                    ((ArrayList)object).add(new Double(d11 >= 0.0 ? d11 / this.timeSinceLastTest : -5.0));
                    d11 = d4 - this.connections_destroyed_total_count_last;
                    ((ArrayList)object).add(new Double(d11 >= 0.0 ? d11 / this.timeSinceLastTest : -5.0));
                    d11 = d5 - this.connections_matched_total_count_last;
                    ((ArrayList)object).add(new Double(d11 >= 0.0 ? d11 / this.timeSinceLastTest : -5.0));
                    d11 = d6 - this.connections_rejected_total_count_last;
                    ((ArrayList)object).add(new Double(d11 >= 0.0 ? d11 / this.timeSinceLastTest : -5.0));
                    d11 = d9 - this.recycled_total_last;
                    ((ArrayList)object).add(new Double(d11 >= 0.0 ? d11 / this.timeSinceLastTest : -5.0));
                } else {
                    ((ArrayList)object).add(new Double(-5.0));
                    ((ArrayList)object).add(new Double(-5.0));
                    ((ArrayList)object).add(new Double(-5.0));
                    ((ArrayList)object).add(new Double(-5.0));
                    ((ArrayList)object).add(new Double(-5.0));
                }
                this.connections_created_total_count_last = d3;
                this.connections_destroyed_total_count_last = d4;
                this.connections_matched_total_count_last = d5;
                this.connections_rejected_total_count_last = d6;
                this.recycled_total_last = d9;
                ((ArrayList)object).add(new Double(d));
                ((ArrayList)object).add(new Double(d2));
                ((ArrayList)object).add(new Double(d7));
                ((ArrayList)object).add(new Double(d8));
                ((ArrayList)object).add(new Double(d10));
                this.addNewMeasure(string3, (ArrayList)object);
                this.saveLastMeasures(string3);
            }
        }
    }

    private void populateLastMeasures(String string) {
        String string2;
        StringTokenizer stringTokenizer;
        if (!this.lastMeasures.isEmpty() && this.lastMeasures.containsKey(string) && (stringTokenizer = new StringTokenizer(string2 = (String)this.lastMeasures.get(string), ",")).countTokens() == 5) {
            this.connections_created_total_count_last = Double.parseDouble(stringTokenizer.nextToken());
            this.connections_destroyed_total_count_last = Double.parseDouble(stringTokenizer.nextToken());
            this.connections_matched_total_count_last = Double.parseDouble(stringTokenizer.nextToken());
            this.connections_rejected_total_count_last = Double.parseDouble(stringTokenizer.nextToken());
            this.recycled_total_last = Double.parseDouble(stringTokenizer.nextToken());
            return;
        }
        this.connections_created_total_count_last = -5.0;
        this.connections_destroyed_total_count_last = -5.0;
        this.connections_matched_total_count_last = -5.0;
        this.connections_rejected_total_count_last = -5.0;
        this.recycled_total_last = -5.0;
    }

    private void saveLastMeasures(String string) {
        String string2 = this.connections_created_total_count_last + "," + this.connections_destroyed_total_count_last + "," + this.connections_matched_total_count_last + "," + this.connections_rejected_total_count_last + "," + this.recycled_total_last;
        this.lastMeasures.put(string, string2);
    }

    private ArrayList returnMeasures() {
        if (!this.b_useWarFile) {
            if (this.targetHost == null || this.targetHost.trim().length() == 0 || this.portNo == null || this.portNo.trim().length() == 0 || this.server == null || this.server.trim().length() == 0 || user == null || user.trim().length() == 0 || password == null) {
                this.logToErrorFile("Error", "getWLConnectorTest.computeMeasures", "Invalid arguments " + this.targetHost + " " + this.portNo + " " + this.server + " " + user);
                return null;
            }
            WLCommandExecute wLCommandExecute = new WLCommandExecute();
            if (this.useSSLTrustStoreFlag) {
                wLCommandExecute.setWebLogicSSLTrustKeyStore(this.wlSSLTrustKeyStore, this.customTrustKeyStoreFileName, this.customTrustKeyStoreType, this.customTrustKeyStorePassPhrase);
                System.out.println(this.reportingName + ":" + this.entity + " : Calling the method with SSL Truststore and  wlSSLTrustKeyStore is " + this.wlSSLTrustKeyStore);
            }
            if (this.useJMX) {
                return wLCommandExecute.executeProgram(this.weblogicJarLoc, this.targetHost, this.portNo, user, password, this.server, this.protocol, "getWLConnectorTestUsingJMX");
            }
            return wLCommandExecute.executeProgram(this.weblogicJarLoc, this.targetHost, this.portNo, user, password, this.server, this.protocol, "getWLConnectorTest");
        }
        HttpURLConnection httpURLConnection = null;
        Object var2_3 = null;
        Object var3_4 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        try {
            string = this.url + "/" + this.uri + "?name=" + EGURKHA_NAME + "&name1=" + EGURKHA_MONITOR + "&user=" + user + "&password=" + EgURLEncoder.encode(password, "UTF-8") + "&host=" + this.targetHost + "&port=" + this.portNo + "&server=" + this.server + "&timeout=" + this.jspTimeout;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        String string2 = this.url + "/" + this.uri + "?name=" + EGURKHA_NAME + "&name1=" + EGURKHA_MONITOR + "&user=" + user + "&password=*********&host=" + this.targetHost + "&port=" + this.portNo + "&server=" + this.server + "&timeout=" + this.jspTimeout;
        System.out.println("[" + this.reportingName + ":" + this.entity + "]  measureUri : " + string2);
        URL uRL = null;
        if (this.isSsl) {
            EgSSL egSSL = EgSSL.getInstance();
            egSSL.enableSSL();
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Object var10_15 = null;
            try {
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
                uRL = new URL(string);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.connect();
                ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, false);
                ArrayList arrayList2 = null;
                int n = 0;
                boolean bl = this.checkForTimeout(connectionThread);
                if (bl) {
                    n = connectionThread.code;
                    arrayList2 = connectionThread.data;
                }
                connectionThread = null;
                httpURLConnection.disconnect();
                httpURLConnection = null;
                if (!bl || n != 200) {
                    return null;
                }
                if (arrayList2 == null || arrayList2.size() == 0) {
                    return null;
                }
                for (int i = 0; i < arrayList2.size(); ++i) {
                    String string3 = (String)arrayList2.get(i);
                    if (!string3.startsWith("WLConnectorTest")) continue;
                    arrayList.add(string3);
                }
            }
            catch (Exception exception) {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                return null;
            }
        }
        try {
            uRL = new URL(string);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.connect();
            ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, false);
            ArrayList arrayList3 = null;
            int n = 0;
            boolean bl = this.checkForTimeout(connectionThread);
            if (bl) {
                n = connectionThread.code;
                arrayList3 = connectionThread.data;
            }
            connectionThread = null;
            httpURLConnection.disconnect();
            httpURLConnection = null;
            if (!bl || n != 200) {
                return null;
            }
            if (arrayList3 == null || arrayList3.size() == 0) {
                return null;
            }
            for (int i = 0; i < arrayList3.size(); ++i) {
                String string4 = (String)arrayList3.get(i);
                if (!string4.startsWith("WLConnectorTest")) continue;
                arrayList.add(string4);
            }
        }
        catch (Exception exception) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return null;
        }
        return arrayList;
    }

    public int discovery() {
        long l;
        this.sh = new WebLogicHelperThread(this.targetHost, Integer.parseInt(this.portNo), this.isSsl);
        long l2 = 0L;
        long l3 = 5L;
        do {
            if (this.sh.done) {
                return this.sh.version;
            }
            this.suspendForPeriod(l3);
            if ((l2 += l3) >= this.timeout) {
                this.sh.stop();
                this.sh = null;
                return this.defVersion;
            }
            l = l3 * 2L;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        this.sh.stop();
        this.sh = null;
        return this.defVersion;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(l3);
            if (connectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= this.timeout) {
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                return false;
            }
            l = l3;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        return false;
    }

    private String findAndReplaceString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        while (string.indexOf(string2) > -1) {
            stringBuffer.append(string.substring(0, string.indexOf(string2)) + string3);
            string = string.substring(string.indexOf(string2) + string2.length(), string.length());
        }
        if (string.length() > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

