/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgAgentTopoInfo;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;

public class WebSiteTest
extends WebAdapterTest {
    public ArrayList reportingNames = new ArrayList();
    public boolean reread = false;
    private int connectionRateIndex = 0;
    private int requestRateIndex = 1;
    private int kbytesSentRateIndex = 2;
    private int kbytesRecvdRateIndex = 3;
    private int pctErrorsIndex = 4;
    private int pctAbortsIndex = 5;
    private int pct300sIndex = 6;
    private int pct400sIndex = 7;
    private int pct500sIndex = 8;
    private int numCurrentRequestsIndex = 9;
    private int MAX_NUM_CATEGORIES;
    private int MAX_NUM_WEBSITES;
    private int MAX_NUM_ALIASES;
    private int[] aliasSiteCount;
    private String index;
    private double[] webSiteResult;
    private String[] webSites;
    private String[][] categoryName;
    private String[][] categoryInfo;
    private String[][] aliasSites;
    private int monitorPeriod;
    private int numWebSites;
    private int[] categoryCount;
    private long lastModifiedTime;
    private boolean debug;
    private boolean isConfigFileModified;
    private EgAgentTopoInfo topo;
    private long sharedMemPtr;
    private String shmString;
    private String hashCodeString;
    ArrayList objectList;
    private String temp;

    public native boolean detachSharedId(long var1);

    public native long checkShmid(int var1, boolean var2);

    public native boolean sendConfigInfo(int var1, String[] var2, String[] var3, int var4, int var5, int var6, String var7, int var8, String[] var9, int var10, long var11);

    public native boolean getResult(int var1, double[] var2, int var3, int var4, int var5, long var6);

    public static void main(String[] stringArray) {
        WebSiteTest webSiteTest = new WebSiteTest(stringArray);
        webSiteTest.executeTest();
        for (int i = 0; i < 5; ++i) {
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            webSiteTest.executeTest();
        }
    }

    public WebSiteTest(String[] stringArray) {
        super(stringArray);
        this.MAX_NUM_CATEGORIES = WebSiteTest.configInfo.maxCategories;
        this.MAX_NUM_WEBSITES = WebSiteTest.configInfo.maxNumWebSites;
        this.MAX_NUM_ALIASES = WebSiteTest.configInfo.maxAliasSites;
        this.aliasSiteCount = null;
        this.lastModifiedTime = 0L;
        this.debug = false;
        this.isConfigFileModified = false;
        this.topo = null;
        this.sharedMemPtr = -1L;
        this.shmString = null;
        this.hashCodeString = null;
        this.objectList = null;
        this.temp = null;
        if (stringArray.length < 6 || !stringArray[0].equalsIgnoreCase("-host") || !stringArray[2].equalsIgnoreCase("-port")) {
            System.err.println("Usage: WebSiteTest -host <serverName> -port <portNo> -period <period> \n");
            System.exit(-1);
        }
        this.numOutputFields = 10;
        this.webSiteResult = new double[this.numOutputFields];
        this.targetHost = new String(stringArray[1]);
        this.portNo = new String(stringArray[3]);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("-period")) continue;
            try {
                this.monitorPeriod = Integer.parseInt(stringArray[i + 1]);
                break;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        this.hashCodeString = String.valueOf(this.hashCode());
        this.hashCodeString = this.hashCodeString.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTest() {
        if (this.debug) {
            System.out.println("STOPPING TEST with shmid " + this.shmId);
        }
        boolean bl = false;
        Hashtable hashtable = shmIdTestObjects;
        synchronized (hashtable) {
            this.objectList = (ArrayList)shmIdTestObjects.get(this.shmString);
            if (this.objectList != null && this.objectList.size() > 0 && this.objectList.contains(this.hashCodeString)) {
                int n = this.objectList.indexOf(this.hashCodeString);
                if (n != -1) {
                    this.objectList.remove(n);
                }
                if (this.objectList.size() == 0) {
                    bl = true;
                }
            }
        }
        this.shmId = -1;
        if (bl) {
            if (this.sharedMemPtr != -1L) {
                this.detachSharedId(this.sharedMemPtr);
            }
            hashtable = serverSharedId;
            synchronized (hashtable) {
                serverSharedId.remove(this.shmString);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTest() {
        if (this.sharedMemPtr != -1L) {
            this.detachSharedId(this.sharedMemPtr);
        }
        this.shmString = String.valueOf(this.shmId);
        this.shmId = -1;
        Hashtable hashtable = serverSharedId;
        synchronized (hashtable) {
            serverSharedId.remove(this.shmString);
        }
        hashtable = shmIdTestObjects;
        synchronized (hashtable) {
            shmIdTestObjects.remove(this.shmString);
        }
        this.shmString = String.valueOf(this.shmId);
    }

    public boolean getSharedId() {
        this.shmId = -1;
        super.searchFiles();
        this.shmString = String.valueOf(this.shmId);
        this.shmString = this.shmString.trim();
        return this.shmId != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeTest() {
        int n;
        this.initTest();
        if (!this.isFileExist()) {
            this.resetTest();
        }
        if (this.shmId == -1) {
            if (!this.getSharedId()) {
                System.out.println("failed to open  webadapterFile for " + this.reportingName + ":" + this.portNo);
                this.errorMsg = new String("WebAdapterData file for " + this.reportingName + ":" + this.portNo + " could not be opened");
                this.updateAllResultSets();
                return false;
            }
            if (this.shmId == -1) {
                this.updateAllResultSets();
                return true;
            }
            try {
                Properties properties = serverSharedId;
                synchronized (properties) {
                    if (this.getExclusiveAccess()) {
                        if (!this.getAccess()) {
                            this.sharedMemPtr = this.checkShmid(this.shmId, false);
                            if (this.sharedMemPtr != -1L) {
                                String string = String.valueOf(this.sharedMemPtr);
                                serverSharedId.setProperty(this.shmString, string);
                            }
                        }
                    } else {
                        this.shmId = -1;
                        this.errorMsg = "getExclusiveAccess() failed ..";
                        return false;
                    }
                    this.deleteLockFile();
                    if (this.sharedMemPtr == -1L) {
                        this.errorMsg = "Shared memory " + this.shmId + " not available for " + this.reportingName + ":" + this.portNo;
                        this.shmId = -1;
                        this.updateAllResultSets();
                        return false;
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                this.shmId = -1;
                this.errorMsg = "JNI Exception in checkShmid() for " + this.reportingName + ":" + this.portNo;
                this.updateAllResultSets();
                return false;
            }
            if (!this.openConfigFile()) {
                this.resetTest();
                this.updateAllResultSets();
                return true;
            }
            if (this.getExclusiveAccess()) {
                int n2;
                try {
                    if (!this.getAccess()) {
                        this.deleteLockFile();
                        this.shmId = -1;
                        return false;
                    }
                    for (n2 = 0; n2 < this.numWebSites; ++n2) {
                        if (this.sendConfigInfo(n2, this.categoryName[n2], this.categoryInfo[n2], this.categoryCount[n2], this.shmId, this.monitorPeriod, this.webSites[n2], this.numWebSites, this.aliasSites[n2], this.aliasSiteCount[n2], this.sharedMemPtr)) continue;
                        System.out.println("sendConfigInfo is failed in WebSiteTest for shmId =" + this.shmId);
                        this.resetTest();
                        this.errorMsg = "could not send config info for " + this.reportingName + ":" + this.portNo;
                        this.updateAllResultSets();
                        this.deleteLockFile();
                        return false;
                    }
                    this.isConfigFileModified = false;
                }
                catch (RuntimeException runtimeException) {
                    this.resetTest();
                    this.errorMsg = " Jni Return False in sendConfigInfo() for " + this.reportingName + ":" + this.portNo;
                    this.updateAllResultSets();
                    this.deleteLockFile();
                    return false;
                }
                try {
                    if (!this.getAccess()) {
                        this.deleteLockFile();
                        this.shmId = -1;
                        return false;
                    }
                    for (n2 = 0; n2 < this.numWebSites; ++n2) {
                        if (this.getResult(n2, this.webSiteResult, this.numStructures, this.shmId, this.numWebSites - 1, this.sharedMemPtr)) continue;
                        System.out.println("WebSiteTest getResult failed for  shmid = " + this.shmId);
                        this.resetTest();
                        this.errorMsg = new String("Shared memorynot found for " + this.reportingName + ":" + this.portNo);
                        this.updateAllResultSets();
                        this.deleteLockFile();
                        return false;
                    }
                }
                catch (RuntimeException runtimeException) {
                    this.resetTest();
                    this.errorMsg = "Jni Return False in getResult() for " + this.reportingName + ":" + this.portNo;
                    this.updateAllResultSets();
                    this.deleteLockFile();
                    return false;
                }
                this.deleteLockFile();
            }
            this.updateAllResultSets();
            return true;
        }
        if (!this.openConfigFile()) {
            this.resetTest();
            this.updateAllResultSets();
            return true;
        }
        if (this.isConfigFileModified) {
            try {
                if (this.getExclusiveAccess()) {
                    if (!this.getAccess()) {
                        this.deleteLockFile();
                        this.shmId = -1;
                        return false;
                    }
                    for (n = 0; n < this.numWebSites; ++n) {
                        if (this.sendConfigInfo(n, this.categoryName[n], this.categoryInfo[n], this.categoryCount[n], this.shmId, this.monitorPeriod, this.webSites[n], this.numWebSites, this.aliasSites[n], this.aliasSiteCount[n], this.sharedMemPtr)) continue;
                        System.out.println("sendConfigInfo is failed in WebSiteTest for shmId =" + this.shmId);
                        this.resetTest();
                        this.errorMsg = "could not send config info for " + this.reportingName + ":" + this.portNo;
                        this.updateAllResultSets();
                        this.deleteLockFile();
                        return false;
                    }
                    this.deleteLockFile();
                }
            }
            catch (RuntimeException runtimeException) {
                this.resetTest();
                this.errorMsg = "Jni returns false in sendConfigInfo " + this.reportingName + ":" + this.portNo;
                this.updateAllResultSets();
                return false;
            }
        }
        try {
            if (this.getExclusiveAccess()) {
                if (!this.getAccess()) {
                    this.deleteLockFile();
                    this.shmId = -1;
                    return false;
                }
                for (n = 0; n < this.numWebSites; ++n) {
                    if (this.getResult(n, this.webSiteResult, this.numStructures, this.shmId, this.numWebSites - 1, this.sharedMemPtr)) {
                        double d;
                        double d2;
                        double d3;
                        double d4;
                        double d5;
                        if (this.isConfigFileModified) continue;
                        String string = this.webSites[n] + siteAndInfoSeparator + infoFieldSeparator;
                        if (this.webSiteResult[1] != 0.0) {
                            d5 = this.webSiteResult[3] * 100.0 / this.webSiteResult[1];
                            d4 = this.webSiteResult[2] * 100.0 / this.webSiteResult[1];
                            d3 = this.webSiteResult[7] * 100.0 / this.webSiteResult[1];
                            d2 = this.webSiteResult[8] * 100.0 / this.webSiteResult[1];
                            d = this.webSiteResult[9] * 100.0 / this.webSiteResult[1];
                        } else {
                            d5 = 0.0;
                            d4 = 0.0;
                            d3 = 0.0;
                            d2 = 0.0;
                            d = 0.0;
                        }
                        if (this.timeSinceLastTest > 0.0) {
                            double d6 = this.webSiteResult[0] / this.timeSinceLastTest;
                            if (d6 < 0.0) {
                                d6 = -5.0;
                            }
                            this.addValueToResultSet(string, this.connectionRateIndex, d6);
                            d6 = this.webSiteResult[1] / this.timeSinceLastTest;
                            if (d6 < 0.0) {
                                d6 = -5.0;
                            }
                            this.addValueToResultSet(string, this.requestRateIndex, d6);
                            d6 = this.webSiteResult[4] / (this.timeSinceLastTest * 1024.0);
                            if (d6 < 0.0) {
                                d6 = -5.0;
                            }
                            this.addValueToResultSet(string, this.kbytesSentRateIndex, d6);
                            d6 = this.webSiteResult[5] / (this.timeSinceLastTest * 1024.0);
                            if (d6 < 0.0) {
                                d6 = -5.0;
                            }
                            this.addValueToResultSet(string, this.kbytesRecvdRateIndex, d6);
                        } else {
                            this.addValueToResultSet(string, this.connectionRateIndex, -1.0);
                            this.addValueToResultSet(string, this.requestRateIndex, -1.0);
                            this.addValueToResultSet(string, this.kbytesSentRateIndex, -1.0);
                            this.addValueToResultSet(string, this.kbytesRecvdRateIndex, -1.0);
                        }
                        this.addValueToResultSet(string, this.pctAbortsIndex, d4 > 100.0 ? 100.0 : d4);
                        this.addValueToResultSet(string, this.pctErrorsIndex, d5 > 100.0 ? 100.0 : d5);
                        this.addValueToResultSet(string, this.numCurrentRequestsIndex, -5.0);
                        this.addValueToResultSet(string, this.pct300sIndex, d3 > 100.0 ? 100.0 : d3);
                        this.addValueToResultSet(string, this.pct400sIndex, d2 > 100.0 ? 100.0 : d2);
                        this.addValueToResultSet(string, this.pct500sIndex, d > 100.0 ? 100.0 : d);
                        continue;
                    }
                    this.resetTest();
                    this.errorMsg = new String("Shared memorynot found for " + this.reportingName + ":" + this.portNo);
                    this.updateAllResultSets();
                    this.deleteLockFile();
                    return false;
                }
                this.deleteLockFile();
            }
        }
        catch (RuntimeException runtimeException) {
            this.resetTest();
            this.updateAllResultSets();
            this.errorMsg = new String("JNI Exception Errorin getResult() for " + this.reportingName + ":" + this.portNo);
            return false;
        }
        if (!this.isConfigFileModified) {
            this.updateAllResultSets();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getAccess() {
        if (serverSharedId.containsKey(this.shmString)) {
            this.temp = serverSharedId.getProperty(this.shmString);
            this.sharedMemPtr = Long.parseLong(this.temp);
            Hashtable hashtable = shmIdTestObjects;
            synchronized (hashtable) {
                if (shmIdTestObjects.containsKey(this.shmString)) {
                    this.objectList = (ArrayList)shmIdTestObjects.get(this.shmString);
                    if (this.objectList != null && !this.objectList.contains(this.hashCodeString)) {
                        this.objectList.add(this.hashCodeString);
                    }
                } else {
                    this.objectList = new ArrayList();
                    this.objectList.add(this.hashCodeString);
                    shmIdTestObjects.put(this.shmString, this.objectList);
                }
            }
            return true;
        }
        return false;
    }

    void printResult(int n) {
        if (this.debug) {
            System.out.println("Print Result from java for site=" + this.webSites[n]);
            for (int i = 0; i < 10; ++i) {
                System.out.print(this.webSiteResult[i] + "\t");
            }
            System.out.println();
        }
    }

    void printandcopy(String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
    }

    public boolean openConfigFile() {
        int n;
        if (!this.reread && this.topo != null && !this.topo.checkForUpdate()) {
            this.isConfigFileModified = false;
            return true;
        }
        this.reread = false;
        if (this.topo == null) {
            this.topo = new EgAgentTopoInfo("agent");
        }
        this.isConfigFileModified = true;
        this.lastModifiedTime = this.topo.lastModified();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.srvrAddress.length; ++i) {
            if (!this.srvrAddress[i].equals("*") && !this.srvrAddress[i].equals(this.hostIpAddress) && !this.srvrAddress[i].equals("_default_")) continue;
            for (n = 0; n < arrayList.size() && !((String)arrayList.get(n)).equals(this.srvrPorts[i]); ++n) {
            }
            if (n != arrayList.size()) continue;
            arrayList.add(this.srvrPorts[i]);
        }
        if (arrayList.size() == 0) {
            arrayList.add(this.portNo);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n = 0; n < arrayList.size(); ++n) {
            for (int i = 0; i < this.reportingNames.size(); ++i) {
                String string = (String)this.reportingNames.get(i);
                String[] stringArray = this.topo.getWebSitesForServer(string + ":" + (String)arrayList.get(n));
                if (stringArray == null || stringArray.length == 0) continue;
                for (int j = 0; j < stringArray.length; ++j) {
                    int n2;
                    for (n2 = 0; n2 < arrayList2.size() && !stringArray[j].equals((String)arrayList2.get(n2)); ++n2) {
                    }
                    if (n2 != arrayList2.size()) continue;
                    arrayList2.add(stringArray[j]);
                }
            }
        }
        if (arrayList2.size() == 0) {
            if (this.debug) {
                System.out.println("WebSiteTest:  No WebSites to Monitor for " + this.reportingName + ":" + this.portNo);
            }
            return true;
        }
        this.webSites = new String[arrayList2.size()];
        for (n = 0; n < arrayList2.size(); ++n) {
            this.webSites[n] = (String)arrayList2.get(n);
        }
        this.numWebSites = this.webSites.length;
        if (this.numWebSites > this.MAX_NUM_WEBSITES) {
            this.errorMsg = new String("Number of websites exceed theconfigInfo.maxNumWebSites " + this.MAX_NUM_WEBSITES + " for " + this.reportingName + ":" + this.portNo);
            this.numWebSites = this.MAX_NUM_WEBSITES;
        }
        this.aliasSites = new String[this.numWebSites][this.MAX_NUM_ALIASES];
        this.aliasSiteCount = new int[this.numWebSites];
        for (n = 0; n < this.numWebSites; ++n) {
            String[] stringArray = this.topo.getSiteAlias(this.webSites[n]);
            if (stringArray == null || stringArray.length == 0) {
                this.aliasSiteCount[n] = 0;
                this.aliasSites[n] = null;
                continue;
            }
            int n3 = stringArray.length;
            if (n3 > this.MAX_NUM_ALIASES) {
                n3 = this.MAX_NUM_ALIASES;
            }
            for (int i = 0; i < n3; ++i) {
                this.aliasSites[n][i] = stringArray[i];
                System.out.println("Site Alias =" + this.aliasSites[n][i]);
            }
            this.aliasSiteCount[n] = n3;
        }
        this.categoryCount = new int[this.numWebSites];
        this.categoryName = new String[this.numWebSites][this.MAX_NUM_CATEGORIES];
        this.categoryInfo = new String[this.numWebSites][this.MAX_NUM_CATEGORIES];
        for (n = 0; n < this.numWebSites; ++n) {
            String[] stringArray = this.topo.getTransactionsForWebSite(this.webSites[n]);
            if (stringArray == null) {
                this.categoryCount[n] = 0;
                continue;
            }
            this.categoryCount[n] = stringArray.length;
            this.printandcopy(stringArray, this.categoryName[n]);
        }
        for (n = 0; n < this.numWebSites; ++n) {
            for (int i = 0; i < this.categoryCount[n]; ++i) {
                this.categoryInfo[n][i] = this.topo.getPatternForTransaction(this.webSites[n], this.categoryName[n][i]);
            }
        }
        return true;
    }

    static {
        System.loadLibrary("eg_reptr_site");
    }
}

