/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class WinNetworkTrafficTest
extends GenericTest {
    private EgUtilities egutil = null;
    private static final String command = "/usr/sbin/lanscan";
    private String itfCmd = "/usr/sbin/lanadmin -g ";
    private static final double BToMb = 7.62939453125E-6;
    private Hashtable prev_inBoundOct = new Hashtable();
    private Hashtable prev_outBoundOct = new Hashtable();
    private Hashtable prev_inBoundErrors = new Hashtable();
    private Hashtable prev_outBoundErrors = new Hashtable();

    public WinNetworkTrafficTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            ArrayList arrayList;
            if (this.meAgentless) {
                return;
            }
            if (this.egutil == null) {
                this.egutil = EgUtilities.createInstance();
            }
            if ((arrayList = this.egutil.getExecOutputLines(command)) == null || arrayList.size() < 2) {
                this.prev_inBoundOct = new Hashtable();
                this.prev_outBoundOct = new Hashtable();
                this.prev_inBoundErrors = new Hashtable();
                this.prev_outBoundErrors = new Hashtable();
                return;
            }
            ArrayList arrayList2 = (ArrayList)arrayList.get(0);
            if (arrayList2 == null || arrayList2.size() == 0) {
                this.prev_inBoundOct = new Hashtable();
                this.prev_outBoundOct = new Hashtable();
                this.prev_inBoundErrors = new Hashtable();
                this.prev_outBoundErrors = new Hashtable();
                return;
            }
            Hashtable hashtable2 = this.getInterfaceNameWithId(arrayList2);
            if (hashtable2 == null || hashtable2.size() > 0) {
                this.prev_inBoundOct = new Hashtable();
                this.prev_outBoundOct = new Hashtable();
                this.prev_inBoundErrors = new Hashtable();
                this.prev_outBoundErrors = new Hashtable();
                return;
            }
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                Serializable serializable;
                double d = -5.0;
                double d2 = -5.0;
                double d3 = -5.0;
                double d4 = -5.0;
                double d5 = -5.0;
                double d6 = -5.0;
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable2.get(string);
                ArrayList arrayList3 = this.getInterfaceDataList(this.itfCmd + string);
                if (arrayList3 == null || arrayList3.size() < 6) continue;
                double d7 = (Double)arrayList3.get(0);
                double d8 = (Double)arrayList3.get(1);
                double d9 = (Double)arrayList3.get(2);
                double d10 = (Double)arrayList3.get(3);
                double d11 = (Double)arrayList3.get(4);
                double d12 = (Double)arrayList3.get(5);
                if (d7 >= 0.0 && (d = this.getDiffMeasure(d7, (Double)(serializable = (Double)this.prev_inBoundOct.get(string)))) > 0.0 && this.timeSinceLastTest > 0.0) {
                    d = d * 7.62939453125E-6 / this.timeSinceLastTest;
                }
                if (d8 >= 0.0) {
                    serializable = (Double)this.prev_inBoundErrors.get(string);
                    d2 = this.getDiffMeasure(d8, (Double)serializable);
                }
                if (d9 >= 0.0 && (d3 = this.getDiffMeasure(d9, (Double)(serializable = (Double)this.prev_outBoundOct.get(string)))) > 0.0 && this.timeSinceLastTest > 0.0) {
                    d3 = d3 * 7.62939453125E-6 / this.timeSinceLastTest;
                }
                if (d10 >= 0.0) {
                    serializable = (Double)this.prev_outBoundErrors.get(string);
                    d4 = this.getDiffMeasure(d10, (Double)serializable);
                }
                if (d3 > 0.0) {
                    d6 = d3;
                }
                if (d > 0.0) {
                    if (d6 < 0.0) {
                        d6 = 0.0;
                    }
                    d6 += d;
                }
                if (d6 >= 0.0 && d12 > 0.0) {
                    d5 = d6 / d12 * 100.0;
                }
                if (d5 > 100.0) {
                    d5 = 100.0;
                }
                this.prev_inBoundOct.put(string2, new Double(d7));
                this.prev_outBoundOct.put(string2, new Double(d9));
                this.prev_inBoundErrors.put(string2, new Double(d8));
                this.prev_outBoundErrors.put(string2, new Double(d10));
                serializable = new ArrayList();
                ((ArrayList)serializable).add(new Double(d));
                ((ArrayList)serializable).add(new Double(d3));
                ((ArrayList)serializable).add(new Double(d12));
                ((ArrayList)serializable).add(new Double(d5));
                ((ArrayList)serializable).add(new Double(d11));
                ((ArrayList)serializable).add(new Double(d2));
                ((ArrayList)serializable).add(new Double(d4));
                this.addNewMeasure(string2, (ArrayList)serializable);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private double getStringValue(String string) {
        double d = 0.0;
        try {
            int n = string.indexOf("=");
            String string2 = string.substring(n + 1);
            if (string2 == null || string2.trim().length() == 0) {
                return d;
            }
            d = string2.indexOf("up") >= 0 ? 1.0 : 0.0;
            return d;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return d;
        }
    }

    private double getValue(String string) {
        double d = -5.0;
        try {
            int n = string.indexOf("=");
            String string2 = string.substring(n + 1);
            d = this.getDoubleValue(string2);
            if (d < 0.0) {
                d = -5.0;
            }
            return d;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return d;
        }
    }

    private Hashtable getInterfaceNameWithId(ArrayList arrayList) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                StringTokenizer stringTokenizer;
                int n2;
                String string = (String)arrayList.get(i);
                if (string == null || string.trim().length() == 0 || (string = string.trim()).indexOf("Hardware") >= 0 || string.indexOf("Type") >= 0 || string.indexOf("Support") >= 0 || (n2 = (stringTokenizer = new StringTokenizer(string)).countTokens()) < 10) continue;
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                if (string3 == null || (string3 = string3.trim()).length() == 0 || string3.equalsIgnoreCase("lo")) continue;
                hashtable.put(string2, string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashtable;
    }

    private ArrayList getInterfaceDataList(String string) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        try {
            ArrayList arrayList2 = this.egutil.getExecOutputLines(string);
            if (arrayList2 == null || arrayList2.size() < 2) {
                return arrayList;
            }
            ArrayList arrayList3 = (ArrayList)arrayList2.get(0);
            if (arrayList3 == null || arrayList3.size() == 0) {
                return arrayList;
            }
            double d = -5.0;
            double d2 = -5.0;
            double d3 = -5.0;
            double d4 = -5.0;
            double d5 = -5.0;
            double d6 = -5.0;
            double d7 = 0.0;
            double d8 = 0.0;
            int n = arrayList3.size();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)arrayList3.get(i);
                if (string2 == null || string2.trim().length() == 0) continue;
                if ((string2 = string2.trim()).indexOf("Inbound Octets") >= 0) {
                    d = this.getValue(string2);
                    continue;
                }
                if (string2.indexOf("Inbound Errors") >= 0) {
                    d3 = this.getValue(string2);
                    continue;
                }
                if (string2.indexOf("Outbound Octets") >= 0) {
                    d2 = this.getValue(string2);
                    continue;
                }
                if (string2.indexOf("Outbound Errors") >= 0) {
                    d4 = this.getValue(string2);
                    continue;
                }
                if (string2.indexOf("Outbound Queue Length") >= 0) {
                    d5 = this.getValue(string2);
                    continue;
                }
                if (string2.indexOf("Speed") >= 0) {
                    d6 = this.getValue(string2);
                    if (!(d6 > 0.0)) continue;
                    d6 /= 7.62939453125E-6;
                    continue;
                }
                if (string2.indexOf("Administration Status") >= 0) {
                    d7 = this.getStringValue(string2);
                    continue;
                }
                if (string2.indexOf("Operation Status") < 0) continue;
                d8 = this.getStringValue(string2);
            }
            if (d7 > 0.0 && d8 > 0.0) {
                arrayList.add(new Double(d));
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d4));
                arrayList.add(new Double(d5));
                arrayList.add(new Double(d6));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private double getDiffMeasure(double d, Double d2) {
        double d3 = -5.0;
        try {
            if (d2 != null) {
                double d4 = d2;
                d3 = d - d4;
                d3 = d3 < 0.0 ? -5.0 : d3;
            }
            return d3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return d3;
        }
    }

    private double getDoubleValue(String string) {
        double d = -5.0;
        try {
            if (string == null || string.trim().length() == 0) {
                return d;
            }
            string = string.trim();
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            System.out.println("[WinNetworkTrafficTest] Exception in getDoubleValueMethod:" + exception);
            exception.printStackTrace();
        }
        return d;
    }
}

