/*
 * Decompiled with CFR 0.152.
 */
import com.eg.Base64Coder;
import com.eg.EgSSL;
import com.eg.IPV6Helper;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class WsJvmTest
extends GenericTest {
    private String uri = "egurkha/egurkha/EgWebSphere.jsp";
    private String webServerPort = "80";
    public boolean isSsl = false;
    private String url = "";
    private String ndmanager = "none";
    private String connectorport = "none";
    private String user = "none";
    private String password = "none";
    private String encryptPass = "false";
    private String serverName = null;
    private long timeout = 0L;
    private String ssl;
    private ArrayList measureList;
    private String server = "";
    private String tempHost = "";

    public WsJvmTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(3);
        this.ndmanager = this.getValueForParam("ndmanager");
        this.connectorport = this.getValueForParam("connectorport");
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.serverName = this.getValueForParam("serverHostName");
        this.ssl = this.getValueForParam("ssl");
        this.url = this.getValueForParam("url");
        this.webServerPort = this.getValueForParam("webServerPort");
        this.encryptPass = this.getValueForParam("encryptPass");
        this.server = this.getValueForParam("serverName");
        if (this.serverName == null) {
            this.serverName = "";
        }
        if (this.server == null) {
            this.server = "";
        }
        if (this.ssl != null) {
            this.isSsl = new Boolean(this.ssl);
        }
        if (this.url == null || this.url.equals("")) {
            this.tempHost = IPV6Helper.getValidIPAddress(this.targetHost);
            this.url = this.isSsl ? "https://" + this.tempHost + ":" + this.webServerPort : "http://" + this.tempHost + ":" + this.webServerPort;
        }
        if (this.encryptPass != null && this.encryptPass.equalsIgnoreCase("true")) {
            this.password = EgCrypt.encrypt(this.password, true);
        }
        if (this.timeout == 0L) {
            this.timeout = 2L * EgConfigInfo.msecPerMin;
        }
        this.ndmanager = URLEncoder.encode(this.ndmanager);
        this.serverName = URLEncoder.encode(this.serverName);
        this.server = URLEncoder.encode(this.server);
        this.user = URLEncoder.encode(this.user);
    }

    public void computeMeasures(Hashtable hashtable) {
        String string = "";
        this.measureList = new ArrayList();
        Hashtable hashtable2 = this.returnMeasures();
        if (hashtable2 == null) {
            this.addNewMeasure(null);
            return;
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            ArrayList arrayList = (ArrayList)hashtable2.get(string);
            if (arrayList == null || arrayList.size() == 0) {
                this.addNewMeasure(null);
                continue;
            }
            double d = -5.0;
            double d2 = -5.0;
            double d3 = -5.0;
            for (int i = 0; i < arrayList.size(); ++i) {
                StringTokenizer stringTokenizer;
                String string2 = (String)arrayList.get(i);
                if (string2 == null || (stringTokenizer = new StringTokenizer(string2, "=")).countTokens() < 2) continue;
                stringTokenizer.nextToken();
                try {
                    if (string2.startsWith("totalMemory")) {
                        d = Double.parseDouble(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.startsWith("usedMemory")) {
                        d2 = Double.parseDouble(stringTokenizer.nextToken());
                        continue;
                    }
                    if (!string2.startsWith("freeMemory")) continue;
                    d3 = Double.parseDouble(stringTokenizer.nextToken());
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.measureList.add(new Double(d / 1024.0));
            this.measureList.add(new Double(d2 / 1024.0));
            this.measureList.add(new Double(d3 / 1024.0));
            String string3 = "";
            if (string.indexOf("_") > 0) {
                string3 = string.substring(0, string.indexOf("_"));
            }
            this.addNewMeasure(string3, this.measureList);
        }
    }

    private Hashtable returnMeasures() {
        Object object;
        String string;
        Object object2;
        Object object3;
        Hashtable<String, Object> hashtable;
        HttpURLConnection httpURLConnection = null;
        Object var2_2 = null;
        Object var3_3 = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string2 = this.url + "/" + this.uri + "?module=jvmRuntimeModule&summary=true&hostname=" + this.serverName + "&ndmanager=" + this.ndmanager + "&connectorport=" + this.connectorport + "&user=" + this.user + "&password=" + this.password + "&server=" + this.server;
        URL uRL = null;
        if (this.isSsl) {
            hashtable = EgSSL.getInstance();
            EgSSL.enableSSL();
            object3 = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Object var9_11 = null;
            try {
                Object object4;
                Object object5;
                object2 = new MyX509TrustManager();
                string = null;
                object = new TrustManager[]{object2};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init((KeyManager[])string, (TrustManager[])object, new SecureRandom());
                SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
                uRL = new URL(string2);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                if (this.user != null && !this.user.equalsIgnoreCase("none")) {
                    object5 = this.user + ":" + EgCrypt.decrypt(this.password);
                    object4 = Base64Coder.encodeString((String)object5);
                    httpURLConnection.setRequestProperty("Authorization", "Basic " + (String)object4);
                }
                httpURLConnection.connect();
                object5 = new ConnectionThread(httpURLConnection, false);
                object4 = null;
                int n = 0;
                boolean bl = this.checkForTimeout((ConnectionThread)object5);
                if (bl) {
                    n = ((ConnectionThread)object5).code;
                    object4 = ((ConnectionThread)object5).data;
                }
                object5 = null;
                httpURLConnection.disconnect();
                httpURLConnection = null;
                if (!bl || n != 200) {
                    return null;
                }
                if (object4 == null || ((ArrayList)object4).size() == 0) {
                    return null;
                }
                for (int i = 0; i < ((ArrayList)object4).size(); ++i) {
                    String string3 = (String)((ArrayList)object4).get(i);
                    if (!string3.startsWith("jvmRuntimeModule")) continue;
                    arrayList.add(string3);
                }
            }
            catch (Exception exception) {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                return null;
            }
        }
        try {
            uRL = new URL(string2);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            if (this.user != null && !this.user.equalsIgnoreCase("none")) {
                hashtable = this.user + ":" + EgCrypt.decrypt(this.password);
                object3 = Base64Coder.encodeString((String)((Object)hashtable));
                httpURLConnection.setRequestProperty("Authorization", "Basic " + (String)object3);
            }
            httpURLConnection.connect();
            hashtable = new ConnectionThread(httpURLConnection, false);
            object3 = null;
            int n = 0;
            boolean bl = this.checkForTimeout((ConnectionThread)((Object)hashtable));
            if (bl) {
                n = ((ConnectionThread)((Object)hashtable)).code;
                object3 = ((ConnectionThread)((Object)hashtable)).data;
            }
            hashtable = null;
            httpURLConnection.disconnect();
            httpURLConnection = null;
            if (!bl || n != 200) {
                return null;
            }
            if (object3 == null || ((ArrayList)object3).size() == 0) {
                return null;
            }
            for (int i = 0; i < ((ArrayList)object3).size(); ++i) {
                object = (String)((ArrayList)object3).get(i);
                if (!((String)object).startsWith("jvmRuntimeModule")) continue;
                arrayList.add(object);
            }
        }
        catch (Exception exception) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return null;
        }
        hashtable = new Hashtable<String, Object>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string4 = (String)arrayList.get(i);
            object2 = new StringTokenizer(string4, ":");
            if (((StringTokenizer)object2).countTokens() < 3) continue;
            ((StringTokenizer)object2).nextToken();
            string = new String(((StringTokenizer)object2).nextToken());
            if (hashtable.containsKey(string)) {
                object = (ArrayList)hashtable.get(string);
                ((ArrayList)object).add(((StringTokenizer)object2).nextToken());
                hashtable.put(string, object);
                continue;
            }
            object = new ArrayList();
            ((ArrayList)object).add(((StringTokenizer)object2).nextToken());
            hashtable.put(string, object);
        }
        return hashtable;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(l3);
            if (connectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= this.timeout) {
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                return false;
            }
            l = l3;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        return false;
    }
}

