/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.CRLVerifier;
import com.eg.CertificateVerificationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CertificateVerifier {
    private CertificateVerifier() {
    }

    public static PKIXCertPathBuilderResult verifyCertificate(X509Certificate x509Certificate, Set<X509Certificate> set, boolean bl, X509Certificate x509Certificate2) throws CertificateVerificationException {
        try {
            Set<TrustAnchor> set2;
            if (!bl && CertificateVerifier.isSelfSigned(x509Certificate)) {
                throw new CertificateVerificationException("The certificate is self-signed.");
            }
            HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
            HashSet<X509Certificate> hashSet2 = new HashSet<X509Certificate>();
            for (X509Certificate x509Certificate3 : set) {
                if (CertificateVerifier.isSelfSigned(x509Certificate3)) {
                    hashSet.add(x509Certificate3);
                    continue;
                }
                hashSet2.add(x509Certificate3);
            }
            int n = hashSet.size();
            boolean bl2 = false;
            if (n == 0 && x509Certificate2 != null) {
                Principal principal;
                set2 = CertificateVerifier.getTrustAnchors();
                X509Certificate x509Certificate4 = CertificateVerifier.findAnchor(set2, principal = x509Certificate2.getIssuerDN());
                if (x509Certificate4 == null) {
                    if (CertificateVerifier.isWindows() && (set2 = CertificateVerifier.getWindowsTrustAnchors()) != null && (x509Certificate4 = CertificateVerifier.findAnchor(set2, principal)) != null) {
                        bl2 = true;
                    }
                    if (x509Certificate4 == null) {
                        throw new CertificateVerificationException("Can't be verified as Root CA certificate is not found in cacerts !!!");
                    }
                    if (hashSet.size() == 0) {
                        hashSet.add(x509Certificate4);
                    }
                } else if (hashSet.size() == 0) {
                    hashSet.add(x509Certificate4);
                }
            }
            set2 = CertificateVerifier.verifyCertificate(x509Certificate, hashSet, hashSet2, bl);
            CRLVerifier.verifyCertificateCRLs(x509Certificate);
            if (bl2) {
                throw new CertificateVerificationException("The certificate is from Local CA");
            }
            return set2;
        }
        catch (CertPathBuilderException certPathBuilderException) {
            throw new CertificateVerificationException("Error building certification path: " + x509Certificate.getSubjectX500Principal(), certPathBuilderException);
        }
        catch (CertificateVerificationException certificateVerificationException) {
            throw certificateVerificationException;
        }
        catch (Exception exception) {
            throw new CertificateVerificationException("Error verifying the certificate: " + x509Certificate.getSubjectX500Principal(), exception);
        }
    }

    public static boolean isSelfSigned(X509Certificate x509Certificate) throws CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            PublicKey publicKey = x509Certificate.getPublicKey();
            x509Certificate.verify(publicKey);
            return true;
        }
        catch (SignatureException signatureException) {
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
    }

    private static PKIXCertPathBuilderResult verifyCertificate(X509Certificate x509Certificate, Set<X509Certificate> set, Set<X509Certificate> set2, boolean bl) throws GeneralSecurityException {
        X509CertSelector x509CertSelector = new X509CertSelector();
        x509CertSelector.setCertificate(x509Certificate);
        HashSet<TrustAnchor> hashSet = new HashSet<TrustAnchor>();
        for (X509Certificate object2 : set) {
            hashSet.add(new TrustAnchor(object2, null));
        }
        PKIXBuilderParameters pKIXBuilderParameters = new PKIXBuilderParameters(hashSet, (CertSelector)x509CertSelector);
        pKIXBuilderParameters.setRevocationEnabled(false);
        CertStore certStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(set2));
        pKIXBuilderParameters.addCertStore(certStore);
        CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX");
        PKIXCertPathBuilderResult pKIXCertPathBuilderResult = (PKIXCertPathBuilderResult)certPathBuilder.build(pKIXBuilderParameters);
        return pKIXCertPathBuilderResult;
    }

    private static Set<TrustAnchor> getTrustAnchors() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        String string = System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
        FileInputStream fileInputStream = new FileInputStream(string);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        String string2 = "changeit";
        keyStore.load(fileInputStream, string2.toCharArray());
        PKIXParameters pKIXParameters = new PKIXParameters(keyStore);
        return pKIXParameters.getTrustAnchors();
    }

    private static Set<TrustAnchor> getWindowsTrustAnchors() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyStore keyStore = KeyStore.getInstance("Windows-ROOT");
        keyStore.load(null, null);
        PKIXParameters pKIXParameters = new PKIXParameters(keyStore);
        return pKIXParameters.getTrustAnchors();
    }

    private static boolean isWindows() {
        boolean bl = false;
        String string = System.getProperty("os.name");
        if (string != null && (string = string.toLowerCase()).indexOf("win") >= 0) {
            bl = true;
        }
        return bl;
    }

    private static X509Certificate findAnchor(Set<TrustAnchor> set, Principal principal) {
        for (TrustAnchor trustAnchor : set) {
            if (!((Object)trustAnchor.getTrustedCert().getSubjectDN()).equals(principal)) continue;
            return trustAnchor.getTrustedCert();
        }
        return null;
    }
}

