/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.X509KeyManager;

public class CompositeX509KeyManager
implements X509KeyManager {
    private final List<X509KeyManager> keyManagers;

    public CompositeX509KeyManager(List keyManagers) {
        this.keyManagers = ImmutableList.copyOf((Collection)keyManagers);
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        for (X509KeyManager keyManager : this.keyManagers) {
            String alias = keyManager.chooseClientAlias(keyType, issuers, socket);
            if (alias == null) continue;
            return alias;
        }
        return null;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        for (X509KeyManager keyManager : this.keyManagers) {
            String alias = keyManager.chooseServerAlias(keyType, issuers, socket);
            if (alias == null) continue;
            return alias;
        }
        return null;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        for (X509KeyManager keyManager : this.keyManagers) {
            PrivateKey privateKey = keyManager.getPrivateKey(alias);
            if (privateKey == null) continue;
            return privateKey;
        }
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        for (X509KeyManager keyManager : this.keyManagers) {
            X509Certificate[] chain = keyManager.getCertificateChain(alias);
            if (chain == null || chain.length <= 0) continue;
            return chain;
        }
        return null;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        ImmutableList.Builder aliases = ImmutableList.builder();
        for (X509KeyManager keyManager : this.keyManagers) {
            aliases.add((Object[])keyManager.getClientAliases(keyType, issuers));
        }
        return CompositeX509KeyManager.emptyToNull((String[])Iterables.toArray((Iterable)aliases.build(), String.class));
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        ImmutableList.Builder aliases = ImmutableList.builder();
        for (X509KeyManager keyManager : this.keyManagers) {
            aliases.add((Object[])keyManager.getServerAliases(keyType, issuers));
        }
        return CompositeX509KeyManager.emptyToNull((String[])Iterables.toArray((Iterable)aliases.build(), String.class));
    }

    private static <T> T[] emptyToNull(T[] arr) {
        return arr.length == 0 ? null : arr;
    }
}

