/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigFilesSync;
import com.eg.EgConfigInfo;
import com.eg.EgDiscInfo;
import com.eg.EgInstallInfo;
import com.eg.EgServicesInfo;
import com.eg.IniFile;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class EgControlInfo {
    IniFile controlFilePtr;
    private String controlFileName;
    private File controlFile;
    private String CurrentControls = new String("CURRENT_CONTROLS");
    private String ControlDefaults = new String("CONTROL_DEFAULTS");
    private String ControlSettings = new String("CONTROL_SETTINGS");
    private String entity;
    private long lastModifiedTime;
    private long lastSize;
    Hashtable agentControlMap = new Hashtable();

    public static void main(String[] stringArray) {
    }

    public EgControlInfo(String string) {
        this.entity = string;
        EgConfigInfo egConfigInfo = new EgConfigInfo(string);
        this.controlFileName = egConfigInfo.getControlFile(string);
        egConfigInfo = null;
        this.controlFilePtr = new IniFile(this.controlFileName);
        this.controlFile = new File(this.controlFileName);
        this.lastModifiedTime = this.lastModified();
        this.lastSize = this.lastSize();
    }

    public boolean informAgent(String string) {
        Serializable serializable;
        if (this.agentControlMap.containsKey(string) && (serializable = (Boolean)this.agentControlMap.get(string)) != null) {
            return (Boolean)serializable;
        }
        serializable = this.getAllNamesOf(string);
        int n = ((ArrayList)serializable).size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)((ArrayList)serializable).get(i);
            String string3 = this.getCurrentControl(string2, false);
            if (string3 == null || !string3.equalsIgnoreCase("true")) continue;
            this.agentControlMap.put(string, new Boolean(true));
            return true;
        }
        this.agentControlMap.put(string, new Boolean(false));
        return false;
    }

    public long lastModified() {
        if (this.entity.equalsIgnoreCase("agent")) {
            return this.controlFile.lastModified();
        }
        return IniFile.getLastModified(this.controlFileName);
    }

    public long lastSize() {
        if (this.entity.equalsIgnoreCase("agent")) {
            return this.controlFile.length();
        }
        return IniFile.getLastSize(this.controlFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForUpdate() {
        long l = this.lastModified();
        long l2 = this.lastSize();
        if (l == this.lastModifiedTime && this.lastSize == l2) {
            return false;
        }
        String string = this.CurrentControls;
        synchronized (string) {
            l = this.lastModified();
            l2 = this.lastSize();
            if (l == this.lastModifiedTime && this.lastSize == l2) {
                return false;
            }
            this.lastModifiedTime = l;
            this.lastSize = l2;
            this.controlFilePtr = new IniFile(this.controlFileName);
            this.agentControlMap.clear();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSubjects(String string) {
        String string2 = this.CurrentControls;
        synchronized (string2) {
            return this.controlFilePtr.getSubjects();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String string, String string2, String string3) {
        Object object = EgConfigFilesSync.getInstance(this.controlFileName);
        ((IniFile)object).setValue(string, string2, string3);
        ((IniFile)object).saveFile();
        EgConfigFilesSync.releaseInstance((IniFile)object);
        object = this.CurrentControls;
        synchronized (object) {
            this.controlFilePtr = new IniFile(this.controlFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(String string, String string2) {
        this.checkForUpdate();
        String string3 = this.CurrentControls;
        synchronized (string3) {
            return this.controlFilePtr.getValue(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteValue(String string, String string2) {
        Object object = EgConfigFilesSync.getInstance(this.controlFileName);
        ((IniFile)object).deleteValue(string, string2);
        ((IniFile)object).saveFile();
        EgConfigFilesSync.releaseInstance((IniFile)object);
        object = this.CurrentControls;
        synchronized (object) {
            this.controlFilePtr = new IniFile(this.controlFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getVariables(String string) {
        this.checkForUpdate();
        String string2 = this.CurrentControls;
        synchronized (string2) {
            return this.controlFilePtr.getVariables(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultIdlePeriod() {
        this.checkForUpdate();
        String string = this.CurrentControls;
        synchronized (string) {
            return this.controlFilePtr.getValue(this.ControlDefaults, "IdlePeriod");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultIdlePeriod(String string) {
        Object object = EgConfigFilesSync.getInstance(this.controlFileName);
        ((IniFile)object).setValue(this.ControlDefaults, "IdlePeriod", string);
        ((IniFile)object).saveFile();
        EgConfigFilesSync.releaseInstance((IniFile)object);
        object = this.CurrentControls;
        synchronized (object) {
            this.controlFilePtr = new IniFile(this.controlFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultControlFrequency() {
        this.checkForUpdate();
        String string = this.CurrentControls;
        synchronized (string) {
            return this.controlFilePtr.getValue(this.ControlDefaults, "ControlFrequency");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultControlFrequency(String string) {
        Object object = EgConfigFilesSync.getInstance(this.controlFileName);
        ((IniFile)object).setValue(this.ControlDefaults, "ControlFrequency", string);
        ((IniFile)object).saveFile();
        EgConfigFilesSync.releaseInstance((IniFile)object);
        object = this.CurrentControls;
        synchronized (object) {
            this.controlFilePtr = new IniFile(this.controlFileName);
        }
    }

    public String getCurrentControl(String string) {
        return this.getCurrentControl(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentControl(String string, boolean bl) {
        if (bl) {
            this.checkForUpdate();
        }
        String string2 = this.CurrentControls;
        synchronized (string2) {
            String string3 = this.controlFilePtr.getValue(this.CurrentControls, string);
            if (string3 != null && (string3.trim().equalsIgnoreCase("true") || string3.trim().equalsIgnoreCase("false"))) {
                return string3;
            }
            String[] stringArray = this.controlFilePtr.getVariables(this.CurrentControls);
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string4 = stringArray[i];
                    if (!string4.equalsIgnoreCase(string)) continue;
                    String string5 = this.controlFilePtr.getValue(this.CurrentControls, string4);
                    return string5;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCurrentControl(String string) {
        ArrayList arrayList = this.getAllNamesOf(string);
        Object object = EgConfigFilesSync.getInstance(this.controlFileName);
        String[] stringArray = ((IniFile)object).getVariables(this.CurrentControls);
        if (stringArray != null) {
            int n;
            boolean bl = false;
            for (n = 0; n < stringArray.length; ++n) {
                if (!arrayList.contains(stringArray[n])) continue;
                ((IniFile)object).deleteValue(this.CurrentControls, stringArray[n]);
                bl = true;
            }
            if (bl) {
                ((IniFile)object).saveFile();
            } else if (stringArray != null && arrayList != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    String string2 = stringArray[n];
                    for (int i = 0; i < arrayList.size(); ++i) {
                        String string3 = (String)arrayList.get(i);
                        if (!string2.equalsIgnoreCase(string3)) continue;
                        ((IniFile)object).deleteValue(this.CurrentControls, stringArray[n]);
                        bl = true;
                    }
                }
                if (bl) {
                    ((IniFile)object).saveFile();
                }
            }
        }
        EgConfigFilesSync.releaseInstance((IniFile)object);
        object = this.CurrentControls;
        synchronized (object) {
            this.controlFilePtr = new IniFile(this.controlFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentControl(String string, String string2) {
        ArrayList arrayList = this.getAllNamesOf(string);
        Object object = EgConfigFilesSync.getInstance(this.controlFileName);
        String[] stringArray = ((IniFile)object).getVariables(this.CurrentControls);
        if (stringArray != null) {
            int n;
            boolean bl = false;
            for (n = 0; n < stringArray.length; ++n) {
                if (!arrayList.contains(stringArray[n])) continue;
                ((IniFile)object).setValue(this.CurrentControls, stringArray[n], string2);
                bl = true;
            }
            if (bl) {
                ((IniFile)object).saveFile();
            } else if (stringArray != null && arrayList != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    String string3 = stringArray[n];
                    for (int i = 0; i < arrayList.size(); ++i) {
                        String string4 = (String)arrayList.get(i);
                        if (!string3.equalsIgnoreCase(string4)) continue;
                        ((IniFile)object).setValue(this.CurrentControls, stringArray[n], string2);
                        bl = true;
                    }
                }
                if (bl) {
                    ((IniFile)object).saveFile();
                }
            }
        }
        EgConfigFilesSync.releaseInstance((IniFile)object);
        object = this.CurrentControls;
        synchronized (object) {
            this.controlFilePtr = new IniFile(this.controlFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getControlSettings(String string) {
        this.checkForUpdate();
        ArrayList arrayList = this.getAllNamesOf(string);
        String string2 = this.CurrentControls;
        synchronized (string2) {
            String[] stringArray = this.controlFilePtr.getVariables(this.ControlSettings);
            if (stringArray != null) {
                int n;
                for (n = 0; n < stringArray.length; ++n) {
                    if (!arrayList.contains(stringArray[n])) continue;
                    String string3 = this.controlFilePtr.getValue(this.ControlSettings, stringArray[n]);
                    return stringArray[n] + ":" + string3;
                }
                for (n = 0; n < stringArray.length; ++n) {
                    String string4 = stringArray[n];
                    for (int i = 0; i < arrayList.size(); ++i) {
                        String string5 = (String)arrayList.get(i);
                        if (!string4.equalsIgnoreCase(string5)) continue;
                        String string6 = this.controlFilePtr.getValue(this.ControlSettings, stringArray[n]);
                        return stringArray[n] + ":" + string6;
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setControlSettings(String string, String string2) {
        ArrayList arrayList = this.getAllNamesOf(string);
        Object object = EgConfigFilesSync.getInstance(this.controlFileName);
        String[] stringArray = ((IniFile)object).getVariables(this.ControlSettings);
        if (stringArray != null) {
            int n;
            boolean bl = false;
            for (n = 0; n < stringArray.length; ++n) {
                if (!arrayList.contains(stringArray[n])) continue;
                ((IniFile)object).setValue(this.ControlSettings, stringArray[n], string2);
                bl = true;
            }
            if (bl) {
                ((IniFile)object).saveFile();
            } else if (stringArray != null && arrayList != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    String string3 = stringArray[n];
                    for (int i = 0; i < arrayList.size(); ++i) {
                        String string4 = (String)arrayList.get(i);
                        if (!string3.equalsIgnoreCase(string4)) continue;
                        ((IniFile)object).setValue(this.ControlSettings, stringArray[n], string2);
                        bl = true;
                    }
                }
                if (bl) {
                    ((IniFile)object).saveFile();
                }
            }
        }
        EgConfigFilesSync.releaseInstance((IniFile)object);
        object = this.CurrentControls;
        synchronized (object) {
            this.controlFilePtr = new IniFile(this.controlFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getCommands(String string) {
        this.checkForUpdate();
        Vector<String> vector = new Vector<String>(3);
        ArrayList arrayList = this.getAllNamesOf(string);
        String[] stringArray = null;
        Object object = this.CurrentControls;
        synchronized (object) {
            stringArray = this.controlFilePtr.getSubjects();
        }
        if (stringArray != null) {
            String[] stringArray2;
            int n;
            int n2;
            object = new ArrayList();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                object.add(new Integer(n2));
            }
            Collections.shuffle(object);
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                n = (Integer)object.get(n2);
                if (!arrayList.contains(stringArray[n])) continue;
                String string2 = this.CurrentControls;
                synchronized (string2) {
                    stringArray2 = this.controlFilePtr.getVariables(stringArray[n]);
                    if (stringArray2 != null) {
                        vector.add(stringArray[n]);
                        vector.add(stringArray2[0]);
                        vector.add(this.controlFilePtr.getValue(stringArray[n], stringArray2[0]));
                        return vector;
                    }
                    continue;
                }
            }
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                n = (Integer)object.get(n2);
                for (int i = 0; i < arrayList.size(); ++i) {
                    stringArray2 = (String[])arrayList.get(i);
                    if (!stringArray[n].equalsIgnoreCase((String)stringArray2)) continue;
                    String string3 = this.CurrentControls;
                    synchronized (string3) {
                        String[] stringArray3 = this.controlFilePtr.getVariables(stringArray[n]);
                        if (stringArray3 != null) {
                            vector.add(stringArray[n]);
                            vector.add(stringArray3[0]);
                            vector.add(this.controlFilePtr.getValue(stringArray[n], stringArray3[0]));
                            return vector;
                        }
                        continue;
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getCommands(String string, boolean bl) {
        this.checkForUpdate();
        Vector<Object> vector = new Vector<Object>(3);
        ArrayList arrayList = this.getAllNamesOf(string);
        String[] stringArray = null;
        Object object = this.CurrentControls;
        synchronized (object) {
            stringArray = this.controlFilePtr.getSubjects();
        }
        if (stringArray != null) {
            String[] stringArray2;
            int n;
            int n2;
            object = new ArrayList();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                object.add(new Integer(n2));
            }
            Collections.shuffle(object);
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                n = (Integer)object.get(n2);
                if (!arrayList.contains(stringArray[n])) continue;
                String string2 = this.CurrentControls;
                synchronized (string2) {
                    stringArray2 = this.controlFilePtr.getVariables(stringArray[n]);
                    if (stringArray2 != null) {
                        vector.add(stringArray[n]);
                        Hashtable<String, String> hashtable = new Hashtable<String, String>();
                        for (int i = 0; i < stringArray2.length; ++i) {
                            hashtable.put(stringArray2[i], this.controlFilePtr.getValue(stringArray[n], stringArray2[i]));
                        }
                        vector.add(hashtable);
                        return vector;
                    }
                    continue;
                }
            }
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                n = (Integer)object.get(n2);
                for (int i = 0; i < arrayList.size(); ++i) {
                    stringArray2 = (String[])arrayList.get(i);
                    if (!stringArray[n].equalsIgnoreCase((String)stringArray2)) continue;
                    String string3 = this.CurrentControls;
                    synchronized (string3) {
                        String[] stringArray3 = this.controlFilePtr.getVariables(stringArray[n]);
                        if (stringArray3 != null) {
                            vector.add(stringArray[n]);
                            Hashtable<String, String> hashtable = new Hashtable<String, String>();
                            for (int j = 0; j < stringArray3.length; ++j) {
                                hashtable.put(stringArray3[j], this.controlFilePtr.getValue(stringArray[n], stringArray3[j]));
                            }
                            vector.add(hashtable);
                            return vector;
                        }
                        continue;
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deleteCommand(String string, String string2) {
        this.checkForUpdate();
        ArrayList arrayList = this.getAllNamesOf(string);
        String[] stringArray = null;
        IniFile iniFile = EgConfigFilesSync.getInstance(this.controlFileName);
        stringArray = iniFile.getSubjects();
        if (stringArray != null) {
            int n;
            for (n = 0; n < stringArray.length; ++n) {
                if (!arrayList.contains(stringArray[n])) continue;
                String[] stringArray2 = iniFile.getVariables(stringArray[n]);
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (!string2.equals(stringArray2[i])) continue;
                    iniFile.deleteValue(stringArray[n], string2);
                    iniFile.saveFile();
                    EgConfigFilesSync.releaseInstance(iniFile);
                    String string3 = this.CurrentControls;
                    synchronized (string3) {
                        this.controlFilePtr = new IniFile(this.controlFileName);
                    }
                    return stringArray[n];
                }
            }
            for (n = 0; n < stringArray.length; ++n) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string4 = (String)arrayList.get(i);
                    if (!stringArray[n].equalsIgnoreCase(string4)) continue;
                    String[] stringArray3 = iniFile.getVariables(stringArray[n]);
                    for (int j = 0; j < stringArray3.length; ++j) {
                        if (!string2.equals(stringArray3[j])) continue;
                        iniFile.deleteValue(stringArray[n], string2);
                        iniFile.saveFile();
                        EgConfigFilesSync.releaseInstance(iniFile);
                        String string5 = this.CurrentControls;
                        synchronized (string5) {
                            this.controlFilePtr = new IniFile(this.controlFileName);
                        }
                        return stringArray[n];
                    }
                }
            }
        }
        EgConfigFilesSync.releaseInstance(iniFile);
        String string6 = this.CurrentControls;
        synchronized (string6) {
            this.controlFilePtr = new IniFile(this.controlFileName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSubject(String string) {
        this.checkForUpdate();
        ArrayList arrayList = this.getAllNamesOf(string);
        String[] stringArray = null;
        IniFile iniFile = EgConfigFilesSync.getInstance(this.controlFileName);
        stringArray = iniFile.getSubjects();
        boolean bl = false;
        if (stringArray != null) {
            int n;
            for (n = 0; n < stringArray.length; ++n) {
                if (!arrayList.contains(stringArray[n])) continue;
                bl = true;
                iniFile.deleteSubject(stringArray[n]);
            }
            if (!bl) {
                for (n = 0; n < stringArray.length; ++n) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        String string2 = (String)arrayList.get(i);
                        if (!stringArray[n].equalsIgnoreCase(string2)) continue;
                        iniFile.deleteSubject(stringArray[n]);
                    }
                }
            }
        }
        if (bl) {
            iniFile.saveFile();
        }
        EgConfigFilesSync.releaseInstance(iniFile);
        String string3 = this.CurrentControls;
        synchronized (string3) {
            this.controlFilePtr = new IniFile(this.controlFileName);
        }
    }

    public ArrayList getAllNamesOf(String string) {
        Object object;
        Object object2;
        ArrayList<String> arrayList;
        Object object3;
        Object object4;
        Object object5;
        Object object6 = null;
        String string2 = null;
        String string3 = ":";
        if (string.indexOf(EgInstallInfo.ipV6Identifier) >= 0) {
            string = string.substring(EgInstallInfo.ipV6Identifier.length());
            string3 = EgInstallInfo.ipV6Sep;
        }
        Hashtable hashtable = null;
        try {
            object5 = new Class[]{};
            object4 = new Object[]{};
            Class<?> clazz = Class.forName("com.egurkha.admin.WVDHostnames");
            if (clazz != null) {
                object3 = clazz.newInstance();
                arrayList = clazz.getMethod("getWVDHostnames", (Class<?>)object5).invoke(object3, (Object[])object4);
                if (arrayList instanceof Hashtable) {
                    hashtable = (Hashtable)((Object)arrayList);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object5 = new ArrayList();
        if (hashtable != null && !hashtable.isEmpty()) {
            ((ArrayList)object5).addAll(hashtable.keySet());
        }
        object4 = new EgServicesInfo("manager");
        boolean bl = ((EgServicesInfo)object4).autoIpNameCheck();
        object4 = null;
        if (!bl) {
            Object object7;
            object3 = new StringTokenizer(string, string3);
            arrayList = new ArrayList<String>();
            while (((StringTokenizer)object3).hasMoreTokens()) {
                object7 = ((StringTokenizer)object3).nextToken();
                arrayList.add((String)object7);
                string2 = object7;
                if (!hashtable.containsKey(object7)) continue;
                object6 = object7;
            }
            if (object6 != null && string2 != null && (object7 = (ArrayList)hashtable.get(object6)) != null && ((ArrayList)object7).contains(string2)) {
                arrayList.add((String)object6 + "$" + string2);
            }
            return arrayList;
        }
        object3 = new EgDiscInfo("manager");
        arrayList = ((EgDiscInfo)object3).getIpNickMap();
        object3 = null;
        if (arrayList == null) {
            Object object8;
            StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                object8 = stringTokenizer.nextToken();
                arrayList2.add((String)object8);
                string2 = object8;
                if (!hashtable.containsKey(object8)) continue;
                object6 = object8;
            }
            if (object6 != null && string2 != null && (object8 = (ArrayList)hashtable.get(object6)) != null && ((ArrayList)object8).contains(string2)) {
                arrayList2.add((String)object6 + "$" + string2);
            }
            return arrayList2;
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (arrayList3.indexOf(string4) < 0) {
                arrayList3.add(string4);
                string2 = string4;
                if (hashtable.containsKey(string4)) {
                    object6 = string4;
                }
            }
            if ((object2 = this.getHostName(string4, (Hashtable)((Object)arrayList))) == null || ((String)object2).length() == 0) continue;
            object = new StringTokenizer((String)object2, ":");
            int n = ((StringTokenizer)object).countTokens();
            for (int i = 0; i < n; ++i) {
                String string5 = ((StringTokenizer)object).nextToken();
                if (arrayList3.indexOf(string5) >= 0) continue;
                arrayList3.add(string5);
            }
        }
        int n = arrayList3.size();
        if (n <= 0) {
            ArrayList arrayList4;
            object2 = new StringTokenizer(string, ":");
            object = new ArrayList<String>();
            while (((StringTokenizer)object2).hasMoreTokens()) {
                String string6 = ((StringTokenizer)object2).nextToken();
                ((ArrayList)object).add(string6);
                string2 = string6;
                if (!hashtable.containsKey(string6)) continue;
                object6 = string6;
            }
            if (object6 != null && string2 != null && (arrayList4 = (ArrayList)hashtable.get(object6)) != null && arrayList4.contains(string2)) {
                ((ArrayList)object).add((String)object6 + "$" + string2);
            }
            return object;
        }
        if (object6 != null && string2 != null && (object2 = (ArrayList)hashtable.get(object6)) != null && ((ArrayList)object2).contains(string2)) {
            arrayList3.add((String)object6 + "$" + string2);
        }
        return arrayList3;
    }

    private boolean isIpAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return false;
        }
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            try {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 <= 255 && n2 >= 0) continue;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    private String getHostName(String string, Hashtable hashtable) {
        Object object = null;
        try {
            Object object2;
            if (!this.isIpAddress(string)) {
                object2 = hashtable.keySet().iterator();
                while (object2.hasNext()) {
                    String string2 = (String)object2.next();
                    if (!string2.equalsIgnoreCase(string)) continue;
                    string = string2;
                    break;
                }
            }
            if ((object = !hashtable.containsKey(string) ? null : ((object2 = (String)hashtable.get(string)) == null ? null : object2)) == null || ((String)object).length() == 0) {
                return null;
            }
            return object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isAllowRemoteControlWithoutLicense() {
        return this.isAllowRemoteControlWithoutLicense(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAllowRemoteControlWithoutLicense(boolean bl) {
        boolean bl2 = false;
        if (bl) {
            this.checkForUpdate();
        }
        String string = "false";
        String string2 = this.CurrentControls;
        synchronized (string2) {
            string = this.controlFilePtr.getValue(this.ControlDefaults, "AllowRemoteControlWithoutLicense");
        }
        bl2 = string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"));
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTimeOut() {
        this.checkForUpdate();
        String string = this.CurrentControls;
        synchronized (string) {
            return this.controlFilePtr.getValue(this.ControlDefaults, "TimeOut");
        }
    }
}

