/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMComponent;
import com.eg.apm.APMDiscoveryHelper;
import com.eg.apm.APMLanguage;
import com.eg.apm.APMUtils;
import com.eg.apm.BaseComponentIDRepository;
import com.eg.apm.JavaAPMComponent;
import com.eg.apm.JavaBTMOffloadLogger;
import com.eg.apm.NodeAPMComponent;
import com.eg.apm.NodeBTMLogger;

public final class APMComponentIDRepository
extends BaseComponentIDRepository {
    private static final String loggerDispStr = "[APMComponentIDRepository]";
    private static final APMComponentIDRepository repository = new APMComponentIDRepository();

    private APMComponentIDRepository() {
    }

    public static APMComponentIDRepository getRepository() {
        return repository;
    }

    public void registerComponent(String string, String string2, APMLanguage aPMLanguage) {
        APMComponent aPMComponent = (APMComponent)componentRepository.get(string);
        if (aPMComponent == null) {
            if (aPMLanguage == APMLanguage.JAVA) {
                aPMComponent = new JavaAPMComponent(string);
            } else if (aPMLanguage == APMLanguage.NODEJS) {
                aPMComponent = new NodeAPMComponent(string);
            } else {
                return;
            }
            aPMComponent.setAPMLanguage(aPMLanguage);
        }
        aPMComponent.addEntity(string2);
        componentRepository.put(string, aPMComponent);
    }

    public void registerComponent(String string, String string2, boolean bl, APMLanguage aPMLanguage) {
        this.registerComponent(string, string2, aPMLanguage);
        APMComponent aPMComponent = (APMComponent)componentRepository.get(string);
        if (aPMComponent != null) {
            aPMComponent.setNewlyDiscoverd(bl);
        }
    }

    public void registerComponent(String string, String string2, String string3, String string4, String string5, String string6, APMLanguage aPMLanguage) {
        if (string == null || string.length() <= 0) {
            return;
        }
        APMComponent aPMComponent = (APMComponent)componentRepository.get(string);
        if (aPMComponent == null) {
            if (aPMLanguage == APMLanguage.JAVA) {
                aPMComponent = new JavaAPMComponent(string, string3, string4, string5, string6);
            } else if (aPMLanguage == APMLanguage.NODEJS) {
                aPMComponent = new NodeAPMComponent(string, string3, string4, string5, string6);
            } else {
                return;
            }
            aPMComponent.setAPMLanguage(aPMLanguage);
        }
        aPMComponent.addEntity(string2);
        componentRepository.put(string, aPMComponent);
        aPMComponent.initiateSnapShotTaker();
    }

    public void unRegisterComponent(String string, boolean bl, boolean bl2) {
        APMComponent aPMComponent = (APMComponent)componentRepository.remove(string);
        if (aPMComponent != null) {
            String string2;
            aPMComponent.removeAllEntities();
            aPMComponent.setHandlerObject(null, null);
            String string3 = aPMComponent.getHostIP();
            String string4 = aPMComponent.getHostPort();
            String string5 = aPMComponent.getComponentType();
            String string6 = string3 + ":" + string4 + ":" + string5;
            APMDiscoveryHelper.removeEntriesFromApmDiscoveryIni(string, string6, bl, bl2);
            if (bl && bl2) {
                string2 = string5 + ":" + string3 + ":" + string4;
                String string7 = string5 + "," + string3 + "," + string3 + "," + string4;
                this.addEntryIntoAutoDeleteIni("Removed_Servers", string2, string7);
            }
            if (aPMComponent.getAPMLanguage() == APMLanguage.JAVA) {
                string2 = aPMComponent.getNickWithPort();
                APMUtils.removeComponentZipFile(string2);
            }
            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Component ID : {} is completely removed from Component Repository.", (Object)loggerDispStr, (Object)string);
        }
    }

    public void unRegisterComponent(String string, String string2) {
        APMComponent aPMComponent = (APMComponent)componentRepository.get(string);
        if (aPMComponent != null) {
            aPMComponent.removeEntity(string2);
        }
    }

    public boolean isThisTestEnabled(String string, String string2) {
        APMComponent aPMComponent;
        if (componentRepository.containsKey(string) && (aPMComponent = (APMComponent)componentRepository.get(string)).isEntityExists(string2)) {
            NodeBTMLogger.nodeLogger.debug(" {} {} is enabled for {}.", new Object[]{loggerDispStr, string2, string});
            return true;
        }
        return false;
    }
}

