/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.apm.AgentStartupLogger;
import com.eg.jtm.BTMConstants;
import com.egurkha.util.EgUtilities;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;

public class APMFileOperations {
    List<String> filesListInDir = new ArrayList<String>();
    private static final int BUFFER_SIZE = 4096;
    protected static final String loggerDispStr = "[APMFileOperations]";

    public void createDirectory(String string) {
        try {
            File file = new File(string);
            if (!file.exists()) {
                try {
                    file.mkdir();
                    AgentStartupLogger.logger.debug("{} Directory created:  {} [ {} ] ", new Object[]{loggerDispStr, file.getName(), string});
                }
                catch (SecurityException securityException) {
                    AgentStartupLogger.logger.error("{} Exception while creating folder :{}  [{} ] {}", new Object[]{loggerDispStr, file.getName(), string, securityException});
                }
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} File name is empty when creating directory {}", (Object)loggerDispStr, (Object)exception.getMessage());
        }
    }

    public boolean deleteDirectory(String string) {
        try {
            File file = new File(string);
            try {
                if (file.exists()) {
                    FileUtils.deleteDirectory((File)file);
                }
                if (!file.exists()) {
                    AgentStartupLogger.logger.debug("{} Directory deleted : {} [ {} ] ", new Object[]{loggerDispStr, file.getName(), string});
                    return true;
                }
            }
            catch (Exception exception) {
                AgentStartupLogger.logger.error("{} Unable to delete folder : {} [ {} ] {}", new Object[]{loggerDispStr, file.getName(), string, exception});
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} File name is empty {}", (Object)loggerDispStr, (Object)exception.getMessage());
        }
        return false;
    }

    public void deleteDirectoryContents(String string) {
        try {
            File file = new File(string);
            try {
                if (file.exists()) {
                    FileUtils.cleanDirectory((File)file);
                    AgentStartupLogger.logger.debug("{} Directory contents deleted : {} [ {} ] ", new Object[]{loggerDispStr, file.getName(), string});
                }
            }
            catch (Exception exception) {
                AgentStartupLogger.logger.error("{} Unable to delete folder : {} [ {} ] {}", new Object[]{loggerDispStr, file.getName(), string, exception});
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} File name is empty {}", (Object)loggerDispStr, (Object)exception.getMessage());
        }
    }

    public void createFile(String string) {
        try {
            File file = new File(string);
            if (!file.exists()) {
                try {
                    file.createNewFile();
                    AgentStartupLogger.logger.debug("{} Config File created: {} [ {} ] ", new Object[]{loggerDispStr, file.getName(), string});
                }
                catch (Exception exception) {
                    AgentStartupLogger.logger.error("{} Exception while creating file : {} [{}] {}", new Object[]{loggerDispStr, file.getName(), string, exception});
                }
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} File name is empty .{}", (Object)loggerDispStr, (Object)exception.getMessage());
        }
    }

    public void deleteFile(String string) {
        try {
            File file = new File(string);
            try {
                if (file.exists()) {
                    file.delete();
                }
                AgentStartupLogger.logger.debug("{} File deleted :{} [ {} ] ", new Object[]{loggerDispStr, file.getName(), string});
            }
            catch (Exception exception) {
                AgentStartupLogger.logger.error("{} Exception while deleting file : {}  [ {} ] {}", new Object[]{loggerDispStr, file.getName(), string, exception});
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} File name is empty .{}", (Object)loggerDispStr, (Object)exception);
        }
    }

    public boolean isExists(String string) {
        try {
            File file = new File(string);
            try {
                if (file.exists()) {
                    return true;
                }
            }
            catch (Exception exception) {
                AgentStartupLogger.logger.error("{} Exception while checking file : {} [{}] {}", new Object[]{loggerDispStr, file.getName(), string, exception});
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} File name is empty . {} ", (Object)loggerDispStr, (Object)exception);
        }
        return false;
    }

    public void copyDirectory(File file, File file2) {
        try {
            FileUtils.copyDirectory((File)file, (File)file2);
            AgentStartupLogger.logger.debug("{} Folder copied!! to - {}", (Object)loggerDispStr, (Object)file2);
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Exception in [copyDirectory] {}:", (Object)loggerDispStr, (Object)exception);
        }
    }

    public void copyFile(File file, File file2) {
        try {
            FileUtils.copyFile((File)file, (File)file2);
            AgentStartupLogger.logger.debug("{} File copied!! to - {}", (Object)loggerDispStr, (Object)file2);
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Exception in [copyFile] :{}  {}", new Object[]{loggerDispStr, file2, exception});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void zipDirectory(File file, String string) {
        block20: {
            FileOutputStream fileOutputStream = null;
            ZipOutputStream zipOutputStream = null;
            this.populateFilesList(file);
            fileOutputStream = new FileOutputStream(string);
            zipOutputStream = new ZipOutputStream(fileOutputStream);
            for (String string2 : this.filesListInDir) {
                Object var12_13;
                AgentStartupLogger.logger.debug("{} Zipping  {} ", (Object)loggerDispStr, (Object)string2);
                ZipEntry zipEntry = new ZipEntry(string2.substring(file.getAbsolutePath().length() + 1, string2.length()));
                zipOutputStream.putNextEntry(zipEntry);
                FileInputStream fileInputStream = null;
                try {
                    int n;
                    fileInputStream = new FileInputStream(string2);
                    byte[] byArray = new byte[1024];
                    while ((n = fileInputStream.read(byArray)) > 0) {
                        zipOutputStream.write(byArray, 0, n);
                    }
                    zipOutputStream.closeEntry();
                    var12_13 = null;
                }
                catch (Throwable throwable) {
                    var12_13 = null;
                    fileInputStream.close();
                    throw throwable;
                }
                fileInputStream.close();
                {
                    continue;
                    catch (Exception exception) {
                        AgentStartupLogger.logger.error("{} Exception in [zipDirectory]:{} {}", new Object[]{loggerDispStr, string, exception});
                        var12_13 = null;
                        fileInputStream.close();
                    }
                }
            }
            AgentStartupLogger.logger.info("{} APM files Zipped into ::  {}", (Object)loggerDispStr, (Object)string);
            Object var14_15 = null;
            try {
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                break block20;
            }
            catch (Exception exception) {
                AgentStartupLogger.logger.error("{} Unable to close streams [zipDirectory]: {} {}", new Object[]{loggerDispStr, string, exception});
            }
            break block20;
            {
                catch (IOException iOException) {
                    AgentStartupLogger.logger.error("{} Exception in [zipDirectory]:{} {}", new Object[]{loggerDispStr, string, iOException});
                    Object var14_16 = null;
                    try {
                        if (zipOutputStream != null) {
                            zipOutputStream.close();
                        }
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        break block20;
                    }
                    catch (Exception exception) {
                        AgentStartupLogger.logger.error("{} Unable to close streams [zipDirectory]: {} {}", new Object[]{loggerDispStr, string, exception});
                    }
                }
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                try {
                    if (zipOutputStream != null) {
                        zipOutputStream.close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception) {
                    AgentStartupLogger.logger.error("{} Unable to close streams [zipDirectory]: {} {}", new Object[]{loggerDispStr, string, exception});
                }
                throw throwable;
            }
        }
    }

    private void populateFilesList(File file) {
        try {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                if (file2.isFile()) {
                    this.filesListInDir.add(file2.getAbsolutePath());
                    continue;
                }
                this.populateFilesList(file2);
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} unable to add files for Zipping operation {}", (Object)loggerDispStr, (Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void zipSingleFile(File file, String string) {
        block9: {
            int n;
            FileOutputStream fileOutputStream = null;
            ZipOutputStream zipOutputStream = null;
            FileInputStream fileInputStream = null;
            fileOutputStream = new FileOutputStream(string);
            zipOutputStream = new ZipOutputStream(fileOutputStream);
            ZipEntry zipEntry = new ZipEntry(file.getName());
            zipOutputStream.putNextEntry(zipEntry);
            fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[1024];
            while ((n = fileInputStream.read(byArray)) > 0) {
                zipOutputStream.write(byArray, 0, n);
            }
            AgentStartupLogger.logger.debug("{}  {} is zipped to {}", new Object[]{loggerDispStr, file.getCanonicalPath(), string});
            Object var10_10 = null;
            try {
                zipOutputStream.closeEntry();
                zipOutputStream.close();
                fileInputStream.close();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                AgentStartupLogger.logger.error("{} Unable to close streams [zipSingleFile]: {}", (Object)loggerDispStr, (Object)iOException);
            }
            break block9;
            {
                catch (IOException iOException) {
                    AgentStartupLogger.logger.error("{} Exception in [zipSingleFile]: {} ", (Object)loggerDispStr, (Object)iOException);
                    Object var10_11 = null;
                    try {
                        zipOutputStream.closeEntry();
                        zipOutputStream.close();
                        fileInputStream.close();
                        fileOutputStream.close();
                    }
                    catch (IOException iOException2) {
                        AgentStartupLogger.logger.error("{} Unable to close streams [zipSingleFile]: {}", (Object)loggerDispStr, (Object)iOException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    zipOutputStream.closeEntry();
                    zipOutputStream.close();
                    fileInputStream.close();
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    AgentStartupLogger.logger.error("{} Unable to close streams [zipSingleFile]: {}", (Object)loggerDispStr, (Object)iOException);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unZip(String string, String string2) throws IOException {
        ZipInputStream zipInputStream = null;
        try {
            try {
                File file = new File(string2);
                if (!file.exists()) {
                    file.mkdirs();
                }
                zipInputStream = new ZipInputStream(new FileInputStream(string));
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                while (zipEntry != null) {
                    String string3 = string2 + File.separator + zipEntry.getName();
                    if (!zipEntry.isDirectory()) {
                        this.extractFile(zipInputStream, string3);
                    } else {
                        File file2 = new File(string3);
                        file2.mkdir();
                    }
                    zipInputStream.closeEntry();
                    zipEntry = zipInputStream.getNextEntry();
                }
                Object var9_9 = null;
                if (zipInputStream == null) return;
            }
            catch (Exception exception) {
                AgentStartupLogger.logger.error("{} Exception in UnZip operation: {}", (Object)loggerDispStr, (Object)exception);
                Object var9_10 = null;
                if (zipInputStream == null) return;
                zipInputStream.close();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (zipInputStream == null) throw throwable;
            zipInputStream.close();
            throw throwable;
        }
        zipInputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void extractFile(ZipInputStream zipInputStream, String string) {
        block12: {
            BufferedOutputStream bufferedOutputStream = null;
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            byte[] byArray = new byte[4096];
            int n = 0;
            while ((n = zipInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            Object var7_7 = null;
            try {
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.close();
                }
                break block12;
            }
            catch (Exception exception) {
                AgentStartupLogger.logger.error("{} Unable to close stream in extractFile : {}", (Object)loggerDispStr, (Object)exception);
            }
            break block12;
            {
                catch (Exception exception) {
                    AgentStartupLogger.logger.error("{} Exception in extractFile : {}", (Object)loggerDispStr, (Object)exception);
                    Object var7_8 = null;
                    try {
                        if (bufferedOutputStream != null) {
                            bufferedOutputStream.close();
                        }
                        break block12;
                    }
                    catch (Exception exception2) {
                        AgentStartupLogger.logger.error("{} Unable to close stream in extractFile : {}", (Object)loggerDispStr, (Object)exception2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (bufferedOutputStream != null) {
                        bufferedOutputStream.close();
                    }
                }
                catch (Exception exception) {
                    AgentStartupLogger.logger.error("{} Unable to close stream in extractFile : {}", (Object)loggerDispStr, (Object)exception);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public byte[] compress(String string) {
        byte[] byArray;
        block14: {
            byArray = null;
            ByteArrayOutputStream byteArrayOutputStream = null;
            DeflaterOutputStream deflaterOutputStream = null;
            byteArrayOutputStream = new ByteArrayOutputStream(string.length());
            deflaterOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            deflaterOutputStream.write(string.getBytes());
            byArray = byteArrayOutputStream.toByteArray();
            Object var7_5 = null;
            try {
                if (deflaterOutputStream != null) {
                    deflaterOutputStream.close();
                }
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
                break block14;
            }
            catch (Exception exception) {
                AgentStartupLogger.logger.error("{} Unable to close stream  : {}", (Object)loggerDispStr, (Object)exception);
            }
            break block14;
            {
                catch (Exception exception) {
                    AgentStartupLogger.logger.error("{} Exception in GZip compress: {} ", (Object)loggerDispStr, (Object)exception);
                    Object var7_6 = null;
                    try {
                        if (deflaterOutputStream != null) {
                            deflaterOutputStream.close();
                        }
                        if (byteArrayOutputStream != null) {
                            byteArrayOutputStream.close();
                        }
                        break block14;
                    }
                    catch (Exception exception2) {
                        AgentStartupLogger.logger.error("{} Unable to close stream  : {}", (Object)loggerDispStr, (Object)exception2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (deflaterOutputStream != null) {
                        deflaterOutputStream.close();
                    }
                    if (byteArrayOutputStream != null) {
                        byteArrayOutputStream.close();
                    }
                }
                catch (Exception exception) {
                    AgentStartupLogger.logger.error("{} Unable to close stream  : {}", (Object)loggerDispStr, (Object)exception);
                }
                throw throwable;
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public byte[] readGzipFile(String string) {
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPInputStream gZIPInputStream = null;
        gZIPInputStream = new GZIPInputStream(new FileInputStream(string));
        int n = 1024;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        n2 = gZIPInputStream.read(byArray2);
        while (n2 != -1) {
            byteArrayOutputStream.write(byArray2, 0, n2);
            n2 = gZIPInputStream.read(byArray2);
        }
        byteArrayOutputStream.flush();
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        Object var10_10 = null;
        try {
            gZIPInputStream.close();
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.debug("Error while reading the data {}", (Throwable)exception);
        }
        return byArray3;
        catch (Exception exception) {
            try {
                AgentStartupLogger.logger.debug("Error while reading the data {}", (Throwable)exception);
                Object var10_11 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    gZIPInputStream.close();
                }
                catch (Exception exception2) {
                    AgentStartupLogger.logger.debug("Error while reading the data {}", (Throwable)exception2);
                }
                throw throwable;
            }
            try {
                gZIPInputStream.close();
            }
            catch (Exception exception3) {
                AgentStartupLogger.logger.debug("Error while reading the data {}", (Throwable)exception3);
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public byte[] readFile(String string) {
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(string);
        int n = 1024;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        n2 = fileInputStream.read(byArray2);
        while (n2 != -1) {
            byteArrayOutputStream.write(byArray2, 0, n2);
            n2 = fileInputStream.read(byArray2);
        }
        byteArrayOutputStream.flush();
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        Object var10_10 = null;
        try {
            fileInputStream.close();
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.debug("Error while reading the data {}", (Throwable)exception);
        }
        return byArray3;
        catch (Exception exception) {
            try {
                AgentStartupLogger.logger.debug("Error while reading the data {}", (Throwable)exception);
                Object var10_11 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    fileInputStream.close();
                }
                catch (Exception exception2) {
                    AgentStartupLogger.logger.debug("Error while reading the data {}", (Throwable)exception2);
                }
                throw throwable;
            }
            try {
                fileInputStream.close();
            }
            catch (Exception exception3) {
                AgentStartupLogger.logger.debug("Error while reading the data {}", (Throwable)exception3);
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public byte[] readFile(File file) {
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(file);
        int n = 1024;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        n2 = fileInputStream.read(byArray2);
        while (n2 != -1) {
            byteArrayOutputStream.write(byArray2, 0, n2);
            n2 = fileInputStream.read(byArray2);
        }
        byteArrayOutputStream.flush();
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        Object var10_10 = null;
        try {
            fileInputStream.close();
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.debug("Error while reading the data {}", (Throwable)exception);
        }
        return byArray3;
        catch (Exception exception) {
            try {
                AgentStartupLogger.logger.debug("Error while reading the data {}", (Throwable)exception);
                Object var10_11 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    fileInputStream.close();
                }
                catch (Exception exception2) {
                    AgentStartupLogger.logger.debug("Error while reading the data {}", (Throwable)exception2);
                }
                throw throwable;
            }
            try {
                fileInputStream.close();
            }
            catch (Exception exception3) {
                AgentStartupLogger.logger.debug("Error while reading the data {}", (Throwable)exception3);
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String decompress(byte[] byArray) {
        StringBuilder stringBuilder;
        block18: {
            String string;
            stringBuilder = null;
            ByteArrayInputStream byteArrayInputStream = null;
            GZIPInputStream gZIPInputStream = null;
            BufferedReader bufferedReader = null;
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)gZIPInputStream, "UTF-8"));
            stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
            Object var8_8 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (gZIPInputStream != null) {
                    gZIPInputStream.close();
                }
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                }
                break block18;
            }
            catch (Exception exception) {
                AgentStartupLogger.logger.debug("Unable to close streams while  decompress {}", (Throwable)exception);
            }
            break block18;
            {
                catch (Exception exception) {
                    AgentStartupLogger.logger.error("{} Exception in GZip decompress: {}", (Object)loggerDispStr, (Object)exception);
                    Object var8_9 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        if (gZIPInputStream != null) {
                            gZIPInputStream.close();
                        }
                        if (byteArrayInputStream != null) {
                            byteArrayInputStream.close();
                        }
                        break block18;
                    }
                    catch (Exception exception2) {
                        AgentStartupLogger.logger.debug("Unable to close streams while  decompress {}", (Throwable)exception2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (gZIPInputStream != null) {
                        gZIPInputStream.close();
                    }
                    if (byteArrayInputStream != null) {
                        byteArrayInputStream.close();
                    }
                }
                catch (Exception exception) {
                    AgentStartupLogger.logger.debug("Unable to close streams while  decompress {}", (Throwable)exception);
                }
                throw throwable;
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void compress(String string, String string2) {
        block15: {
            int n;
            byte[] byArray = new byte[1024];
            GZIPOutputStream gZIPOutputStream = null;
            FileInputStream fileInputStream = null;
            gZIPOutputStream = new GZIPOutputStream(new FileOutputStream(string2));
            fileInputStream = new FileInputStream(string);
            while ((n = fileInputStream.read(byArray)) > 0) {
                gZIPOutputStream.write(byArray, 0, n);
            }
            Object var8_8 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (gZIPOutputStream != null) {
                    gZIPOutputStream.finish();
                    gZIPOutputStream.close();
                }
                break block15;
            }
            catch (IOException iOException) {
                AgentStartupLogger.logger.debug("{} Unable to close streams while compress {}", (Object)loggerDispStr, (Object)iOException);
            }
            break block15;
            {
                catch (IOException iOException) {
                    AgentStartupLogger.logger.error("{} Exception in GZip compress: {}", (Object)loggerDispStr, (Object)iOException);
                    Object var8_9 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        if (gZIPOutputStream != null) {
                            gZIPOutputStream.finish();
                            gZIPOutputStream.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException2) {
                        AgentStartupLogger.logger.debug("{} Unable to close streams while compress {}", (Object)loggerDispStr, (Object)iOException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    if (gZIPOutputStream != null) {
                        gZIPOutputStream.finish();
                        gZIPOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    AgentStartupLogger.logger.debug("{} Unable to close streams while compress {}", (Object)loggerDispStr, (Object)iOException);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void compress(String string, byte[] byArray) {
        block14: {
            byte[] byArray2 = new byte[1024];
            GZIPOutputStream gZIPOutputStream = null;
            FileOutputStream fileOutputStream = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
            gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(byteArrayOutputStream.toByteArray());
            Object var8_8 = null;
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (gZIPOutputStream != null) {
                    gZIPOutputStream.finish();
                    gZIPOutputStream.close();
                }
                break block14;
            }
            catch (IOException iOException) {
                AgentStartupLogger.logger.debug("Unable to close streams while compress {}", (Throwable)iOException);
            }
            break block14;
            {
                catch (IOException iOException) {
                    AgentStartupLogger.logger.error("{} Exception in GZip compress : {} ", (Object)loggerDispStr, (Object)iOException);
                    Object var8_9 = null;
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        if (gZIPOutputStream != null) {
                            gZIPOutputStream.finish();
                            gZIPOutputStream.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException2) {
                        AgentStartupLogger.logger.debug("Unable to close streams while compress {}", (Throwable)iOException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    if (gZIPOutputStream != null) {
                        gZIPOutputStream.finish();
                        gZIPOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    AgentStartupLogger.logger.debug("Unable to close streams while compress {}", (Throwable)iOException);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void decompress(String string, String string2) {
        block15: {
            int n;
            byte[] byArray = new byte[1024];
            GZIPInputStream gZIPInputStream = null;
            FileOutputStream fileOutputStream = null;
            gZIPInputStream = new GZIPInputStream(new FileInputStream(string));
            fileOutputStream = new FileOutputStream(string2);
            while ((n = gZIPInputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            Object var8_8 = null;
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (gZIPInputStream != null) {
                    gZIPInputStream.close();
                }
                break block15;
            }
            catch (IOException iOException) {
                AgentStartupLogger.logger.debug("Unable to close streams while decompress {} ", (Throwable)iOException);
            }
            break block15;
            {
                catch (IOException iOException) {
                    AgentStartupLogger.logger.error("{} Exception in GZip decompress: {}", (Object)loggerDispStr, (Object)iOException);
                    Object var8_9 = null;
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        if (gZIPInputStream != null) {
                            gZIPInputStream.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException2) {
                        AgentStartupLogger.logger.debug("Unable to close streams while decompress {} ", (Throwable)iOException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    if (gZIPInputStream != null) {
                        gZIPInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    AgentStartupLogger.logger.debug("Unable to close streams while decompress {} ", (Throwable)iOException);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void decompress(byte[] byArray, String string) {
        block15: {
            int n;
            byte[] byArray2 = new byte[1024];
            GZIPInputStream gZIPInputStream = null;
            FileOutputStream fileOutputStream = null;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            fileOutputStream = new FileOutputStream(string);
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                fileOutputStream.write(byArray2, 0, n);
            }
            Object var9_9 = null;
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (gZIPInputStream != null) {
                    gZIPInputStream.close();
                }
                break block15;
            }
            catch (IOException iOException) {
                AgentStartupLogger.logger.debug("Unable to close streams while decompress {} ", (Throwable)iOException);
            }
            break block15;
            {
                catch (IOException iOException) {
                    AgentStartupLogger.logger.error("{}  Exception in GZip decompress: {}", (Object)loggerDispStr, (Object)iOException);
                    Object var9_10 = null;
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        if (gZIPInputStream != null) {
                            gZIPInputStream.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException2) {
                        AgentStartupLogger.logger.debug("Unable to close streams while decompress {} ", (Throwable)iOException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    if (gZIPInputStream != null) {
                        gZIPInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    AgentStartupLogger.logger.debug("Unable to close streams while decompress {} ", (Throwable)iOException);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String writeFile(String string, String string2) {
        String string3;
        block12: {
            String string4 = EgInstallInfo.getInstallDir() + "/agent/DumpData/";
            FileOutputStream fileOutputStream = null;
            string3 = null;
            String string5 = ".gz";
            long l = System.currentTimeMillis();
            String string6 = String.valueOf(l);
            String string7 = UUID.randomUUID().toString();
            String string8 = string + "_" + string7 + "_" + string6;
            string3 = string4 + BTMConstants.fileSeperator + string8 + string5;
            File file = new File(string3);
            if (!file.exists()) {
                file.createNewFile();
            }
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = string2.getBytes();
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            fileOutputStream.close();
            AgentStartupLogger.logger.debug(" File write done successfully");
            Object var15_14 = null;
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                break block12;
            }
            catch (IOException iOException) {
                AgentStartupLogger.logger.debug("Error while write the data {} ", (Throwable)iOException);
            }
            break block12;
            {
                catch (IOException iOException) {
                    AgentStartupLogger.logger.debug("Error while write the data {} ", (Throwable)iOException);
                    Object var15_15 = null;
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        break block12;
                    }
                    catch (IOException iOException2) {
                        AgentStartupLogger.logger.debug("Error while write the data {} ", (Throwable)iOException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    AgentStartupLogger.logger.debug("Error while write the data {} ", (Throwable)iOException);
                }
                throw throwable;
            }
        }
        return string3;
    }

    public String GZipAndWriteFile(String string, String string2) {
        String string3 = EgInstallInfo.getInstallDir() + "/agent/DumpData/";
        String string4 = null;
        try {
            String string5 = ".gz";
            long l = System.currentTimeMillis();
            String string6 = String.valueOf(l);
            String string7 = UUID.randomUUID().toString();
            String string8 = string + "_" + string7 + "_" + string6;
            this.createDirectory(string3);
            string4 = string3 + BTMConstants.fileSeperator + string8 + string5 + ".gz";
            byte[] byArray = string2.getBytes();
            this.compress(string4, byArray);
            AgentStartupLogger.logger.debug(" File write done successfully");
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.debug("Error while write the data {} ", (Throwable)exception);
        }
        return string4;
    }

    public void dos2unix(String string) {
        try {
            if (this.textLineEOLConversion(string, "\n")) {
                // empty if block
            }
            AgentStartupLogger.logger.debug("{} Dos2Unix conversion done to {}", (Object)loggerDispStr, (Object)string);
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.warn("{} {} - Unable to do doc2unix. {}", new Object[]{loggerDispStr, string, exception.getMessage()});
        }
    }

    public void unix2dos(String string) {
        try {
            if (this.textLineEOLConversion(string, "\r\n")) {
                AgentStartupLogger.logger.debug("{} Unix2Doc conversion done to {}", (Object)loggerDispStr, (Object)string);
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.warn("{} {} - Unable to do unix2doc. {}", new Object[]{loggerDispStr, string, exception.getMessage()});
        }
    }

    public void setExecutionPermissionForShFile(String string) {
        try {
            if (!EgInstallInfo.isWindows) {
                EgUtilities egUtilities = EgUtilities.createInstance();
                ArrayList arrayList = egUtilities.getCommandOutputLines("chmod 755 " + string);
                if (arrayList != null && arrayList.size() == 0) {
                    AgentStartupLogger.logger.debug("{} chmod 755 Execution permission added to {}", (Object)loggerDispStr, (Object)string);
                } else {
                    AgentStartupLogger.logger.warn("{} Problem occuured while adding chmod 755 execution permission to {}, CommandOutputLines : {} ", new Object[]{loggerDispStr, string, arrayList});
                }
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.warn("{} {} - Unable to do chmod 755 execution permission setting. EgInstallInfo.isWindows - {} . {}", new Object[]{loggerDispStr, string, EgInstallInfo.isWindows, exception.getMessage()});
        }
    }

    private boolean textLineEOLConversion(String string, String string2) {
        boolean bl = new File(string).exists();
        if (!bl) {
            AgentStartupLogger.logger.warn("{} {} - File not found ", (Object)loggerDispStr, (Object)string);
            return false;
        }
        ArrayList arrayList = this.readFileContentForEOLConverion(string);
        if (arrayList != null && arrayList.size() > 0) {
            return this.doEOLConversion(string, arrayList, string2);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doEOLConversion(String string, ArrayList arrayList, String string2) {
        if (arrayList == null && arrayList.size() <= 0) {
            return false;
        }
        PrintWriter printWriter = null;
        try {
            try {
                printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string, false), "UTF-8"));
                for (int i = 0; i < arrayList.size(); ++i) {
                    printWriter.write(arrayList.get(i) + string2);
                }
                Object var7_9 = null;
                printWriter.close();
                return true;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                AgentStartupLogger.logger.warn("{} {} Unable to close stream. {}", new Object[]{loggerDispStr, string, unsupportedEncodingException.getMessage()});
                Object var7_10 = null;
                printWriter.close();
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                AgentStartupLogger.logger.warn("{} {} File not found. {}", new Object[]{loggerDispStr, string, fileNotFoundException.getMessage()});
                Object var7_11 = null;
                printWriter.close();
                return true;
            }
            catch (Exception exception) {
                AgentStartupLogger.logger.warn("{} {} Unable to do EOL converion. {}", new Object[]{loggerDispStr, string, exception.getMessage()});
                Object var7_12 = null;
                printWriter.close();
                return true;
            }
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            printWriter.close();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ArrayList readFileContentForEOLConverion(String string) {
        ArrayList<String> arrayList;
        block11: {
            String string2 = "";
            BufferedReader bufferedReader = null;
            arrayList = new ArrayList<String>();
            try {
                bufferedReader = new BufferedReader(new FileReader(new File(string)));
            }
            catch (IOException iOException) {
                AgentStartupLogger.logger.warn("{} {} Cannot open file {}", new Object[]{loggerDispStr, string, iOException.getMessage()});
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                arrayList.add(string2);
            }
            Object var7_7 = null;
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                AgentStartupLogger.logger.warn("{} {} Unable to close stream. {}", new Object[]{loggerDispStr, string, iOException.getMessage()});
            }
            break block11;
            {
                catch (IOException iOException) {
                    AgentStartupLogger.logger.warn("{} {} Unable to read a file. {}", new Object[]{loggerDispStr, string, iOException.getMessage()});
                    Object var7_8 = null;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException2) {
                        AgentStartupLogger.logger.warn("{} {} Unable to close stream. {}", new Object[]{loggerDispStr, string, iOException2.getMessage()});
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    AgentStartupLogger.logger.warn("{} {} Unable to close stream. {}", new Object[]{loggerDispStr, string, iOException.getMessage()});
                }
                throw throwable;
            }
        }
        return arrayList;
    }

    public static void main(String[] stringArray) throws IOException {
        APMFileOperations aPMFileOperations = new APMFileOperations();
        File file = new File("C:/eGurkha/agent/APM props");
        File file2 = new File("C:/eGurkha/lib/btm/APM props");
        aPMFileOperations.deleteDirectory("C:/eGurkha/lib/btm/APM props");
        aPMFileOperations.deleteFile("C:/eGurkha/lib/btm/VenkatTomcat_1_9090/APM.zip");
        aPMFileOperations.copyDirectory(file, file2);
        aPMFileOperations.copyFile(new File("C:/eGurkha/lib/btm/VenkatTomcat_1_9090/config.props"), new File("C:/eGurkha/lib/btm/APM props/config.props"));
        File file3 = new File("C:/eGurkha/lib/btm/APM props");
        String string = "C:/eGurkha/lib/btm/VenkatTomcat_1_9090/APM.zip";
        aPMFileOperations.zipDirectory(file3, string);
    }
}

