/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.IniHelper;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMFileOperations;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.BTMConfigWriter;
import com.eg.apm.EgApmFilesSync;
import com.eg.apm.JavaTransactionFlowUtility;
import com.eg.apm.OS;
import com.eg.jtm.BTMConstants;
import com.eg.org.apache.commons.lang3.StringEscapeUtils;
import com.eg.org.slf4j.Logger;
import com.egurkha.util.EgUtilities;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.json.simple.JSONValue;

public final class APMUtils {
    static final String loggerDispStr = "[APMUtils]";
    private static final HashMap<String, String> CONTAINER_NAME_MAPPINGS = new HashMap();

    private APMUtils() {
    }

    public static void removeComponentZipFile(String string) {
        if (string == null || string.length() <= 0) {
            return;
        }
        String string2 = string.substring(1, string.lastIndexOf(":"));
        String string3 = string.substring(string.lastIndexOf(":") + 1, string.lastIndexOf("]"));
        String string4 = string2 + "_" + string3 + ".zip";
        APMFileOperations aPMFileOperations = new APMFileOperations();
        String string5 = EgInstallInfo.getInstallDir() + BTMConstants.apmOffloadFolderPath + string4;
        aPMFileOperations.deleteFile(string5);
    }

    public static double String2Double(String string) {
        double d = -1.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d;
    }

    public static long String2Long(String string) {
        long l = -1L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l;
    }

    public static int String2Integer(String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public static long getTimeStamp() {
        return System.currentTimeMillis();
    }

    public static String readJvmGUID(String string) {
        IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + BTMConstants.AGENT_APM_GUID_FILEPATH);
        String string2 = iniFile.getValue("APM_GUID_MAPPING_WITH_NICK", string);
        return string2;
    }

    public static String readNodeGUID(String string) {
        return APMUtils.readJvmGUID(string);
    }

    public static boolean storeGuidWithNick(String string, String string2, Logger logger) {
        if (string == null || string.length() == 0 || string2 == null) {
            return false;
        }
        boolean bl = false;
        try {
            bl = JavaTransactionFlowUtility.storeToIni("JAVA_UNIQUE_GUID_COMPONENT_NAME_MAPPING", string, string2);
            logger.trace("{} Writtern {}:{} into {} ", new Object[]{loggerDispStr, string, string2, BTMConstants.APM_DISCOVERY_FILEPATH});
        }
        catch (Exception exception) {
            logger.warn("{}  Unable to write {} with {}:{} - {} ", new Object[]{loggerDispStr, BTMConstants.APM_DISCOVERY_FILEPATH, string, string2, exception});
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeGuidWithIpPort(String string, String string2, String string3, Logger logger) {
        if (string == null || string.length() == 0) {
            return;
        }
        IniFile iniFile = EgApmFilesSync.getInstance(EgInstallInfo.getInstallDir() + BTMConstants.UNIQUE_JVM_FILEPATH);
        try {
            if (string3 != null) {
                iniFile.setValue("NEW_UNIQUE_JVM_DETAILS", string3, string);
            }
            if (string2 != null) {
                iniFile.setValue("NEW_UNIQUE_JVM_DETAILS", string, string2);
            }
            logger.trace("{} Writtern {}:{} into {} ", new Object[]{loggerDispStr, string, string2, BTMConstants.UNIQUE_JVM_FILEPATH});
            logger.trace("{} Writtern {}:{} into {} ", new Object[]{loggerDispStr, string3, string, BTMConstants.UNIQUE_JVM_FILEPATH});
        }
        catch (Exception exception) {
            logger.warn("{}  Unable to write {} with {}:{} - {} ", new Object[]{loggerDispStr, BTMConstants.UNIQUE_JVM_FILEPATH, string, string2, exception});
        }
        finally {
            iniFile.saveFile();
            EgApmFilesSync.releaseInstance(iniFile);
        }
    }

    public static void sleep(Long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static IniHelper getIniHelper(final String string, final String string2, final String string3) {
        IniHelper iniHelper = new IniHelper(string, string2, string3){

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string);
                stringBuilder.append("  ");
                stringBuilder.append(string2);
                stringBuilder.append("=");
                stringBuilder.append(string3);
                return stringBuilder.toString();
            }
        };
        return iniHelper;
    }

    public static String getServerType(String string) {
        String string2 = null;
        if (string.equals("eG_Manager") || string.equals("Atlassian_Confluence")) {
            string2 = string;
        } else {
            Set<String> set = CONTAINER_NAME_MAPPINGS.keySet();
            for (String string3 : set) {
                if (string3.equals("JBoss") && string.indexOf(string3) > -1) {
                    int n;
                    String string4 = APMUtils.getServerInfoVersion(string3);
                    if (string4 != null && (n = Integer.parseInt((string4 = string4.trim()).substring(0, string4.indexOf(".")))) < 6) {
                        string2 = "JBoss_server";
                        break;
                    }
                    string2 = CONTAINER_NAME_MAPPINGS.get(string3);
                    break;
                }
                if (string3.equals("WebSphere") && string3.indexOf("Liberty") > -1) {
                    string2 = CONTAINER_NAME_MAPPINGS.get("Liberty");
                    break;
                }
                if (string.indexOf("Tomcat") > -1) {
                    string2 = CONTAINER_NAME_MAPPINGS.get("Tomcat");
                    break;
                }
                if (string.indexOf(string3) <= -1) continue;
                string2 = CONTAINER_NAME_MAPPINGS.get(string3);
                break;
            }
        }
        return string2;
    }

    private static String getServerInfoVersion(String string) {
        int n = string.indexOf(47);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(32, n);
        if (n2 == -1) {
            n2 = string.length();
        }
        return string.substring(n + 1, n2);
    }

    public static boolean isDetailsAvailable(Map map, String string) {
        return map.containsKey(string);
    }

    public static boolean isDetailsAvailableInFile(IniFile iniFile, String string, String string2, String string3) {
        String string4 = iniFile.getValue(string3, string);
        return string4 != null && string4.length() > 0 && string2.equalsIgnoreCase(string4);
    }

    public static String getAndValidateStringValue(IniFile iniFile, String string, String string2, String string3) {
        String string4 = iniFile.getValue(string, string2).trim();
        if (string4 != null && string4.length() > 0) {
            return string4;
        }
        string4 = string3;
        return string4;
    }

    public static int getAndValidateIntegerValue(IniFile iniFile, String string, String string2, int n, Logger logger) {
        int n2 = n;
        String string3 = iniFile.getValue(string, string2);
        if (string3 != null && string3.length() > 0) {
            try {
                n2 = Integer.parseInt(string3);
            }
            catch (Exception exception) {
                n2 = n;
                logger.warn("{} Exception Occurred in getAndValidateIntegerValue() :{} ", (Object)loggerDispStr, (Object)exception);
            }
        }
        return n2;
    }

    public static long getAndValidateLongValue(IniFile iniFile, String string, String string2, long l, long l2, Logger logger) {
        long l3 = l2;
        String string3 = iniFile.getValue(string, string2);
        logger.trace("{} Sub:{} Var :{}  Value: {} ", new Object[]{loggerDispStr, string, string2, string3});
        if (string3 != null && string3.length() > 0) {
            try {
                double d = Double.parseDouble(string3) * (double)l;
                l3 = (long)d;
            }
            catch (Exception exception) {
                logger.warn("{} Exception Occurred in getAndValidateLongValue() :{} ", (Object)loggerDispStr, (Object)exception);
            }
        }
        return l3;
    }

    public static boolean getAndValidateBooleanValue(IniFile iniFile, String string, String string2) {
        boolean bl = false;
        String string3 = iniFile.getValue(string, string2);
        if (string3 != null && string3.length() > 0) {
            try {
                bl = Boolean.parseBoolean(string3);
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public static boolean getAndValidateBooleanValue(IniFile iniFile, String string, String string2, boolean bl) {
        boolean bl2 = bl;
        String string3 = iniFile.getValue(string, string2);
        if (string3 != null && string3.length() > 0) {
            try {
                bl2 = Boolean.parseBoolean(string3);
            }
            catch (Exception exception) {
                bl2 = bl;
            }
        }
        return bl2;
    }

    public static ArrayList getStringAsArrayList(IniFile iniFile, String string, String string2, String string3, Logger logger) {
        String string4 = iniFile.getValue(string, string2).trim();
        if (string4 != null && string4.length() > 0) {
            try {
                return APMUtils.getStringAsArrayList(string4, string3, logger);
            }
            catch (Exception exception) {
                logger.warn("{} Exception Occurred in getAndReadValueAsArrayList() :{} ", (Object)loggerDispStr, (Object)exception);
            }
        }
        return new ArrayList(1);
    }

    public static HashMap getAutoLinesAsArrayListMap(IniFile iniFile, String string, String string2, Logger logger) {
        HashMap hashMap = new HashMap();
        if (iniFile == null) {
            return hashMap;
        }
        try {
            logger.debug("{} Trying to read {} from {}.", new Object[]{loggerDispStr, string, iniFile.fileName});
            Vector vector = iniFile.getAllValues(string);
            String[] stringArray = iniFile.getVariables(string);
            if (stringArray != null) {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String string3 = stringArray[i];
                    String string4 = (String)vector.get(i);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    if (!string4.equalsIgnoreCase("true") && !string4.equalsIgnoreCase("yes")) continue;
                    arrayList.add(string4);
                    hashMap.put(string3, arrayList);
                }
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception Occurred in getAutoLinesAsArrayListMap() :{} ", (Object)loggerDispStr, (Object)exception);
        }
        return hashMap;
    }

    public static HashMap getLinesAsMap(IniFile iniFile, String string, Logger logger) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            String[] stringArray = iniFile.getLinesUnderSubject(string);
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    int n = string2.indexOf("=");
                    if (n < 0) continue;
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n + 1);
                    hashMap.put(string3.trim(), string4.trim());
                }
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception Occurred in getLinesAsMap() :{} ", (Object)loggerDispStr, (Object)exception);
        }
        return hashMap;
    }

    public static LinkedHashMap getLinesAsLinkedHashMap(IniFile iniFile, String string, Logger logger) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        try {
            String[] stringArray = iniFile.getLinesUnderSubject(string);
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    int n = string2.indexOf("=");
                    if (n < 0) continue;
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n + 1);
                    linkedHashMap.put(string3.trim(), string4.trim());
                }
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception Occurred in getLinesAsLinkedHashMap() :{} ", (Object)loggerDispStr, (Object)exception);
        }
        return linkedHashMap;
    }

    public static ArrayList getIniVariablesAsList(IniFile iniFile, String string, Logger logger) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String[] stringArray = iniFile.getVariables(string);
            if (stringArray != null && stringArray.length > 0) {
                arrayList.addAll(Arrays.asList(stringArray));
            }
        }
        catch (Exception exception) {
            logger.error(" Exception occurred : ", (Throwable)exception);
        }
        return arrayList;
    }

    public static HashMap getLinesAsMap(String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    int n = string.indexOf("=");
                    if (n < 0) continue;
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 1);
                    hashMap.put(string2.trim(), string3.trim());
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.error("{} Exception occured due to {} ", (Object)loggerDispStr, (Object)exception);
        }
        return hashMap;
    }

    public static TreeSet getStringAsTreeSet(String string, String string2, Logger logger) {
        TreeSet<String> treeSet = new TreeSet<String>();
        try {
            if (string != null && string.length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (string3.length() <= 0) continue;
                    treeSet.add(string3.trim());
                }
            }
        }
        catch (Exception exception) {
            logger.error(" Exception occurred : ", (Throwable)exception);
        }
        return treeSet;
    }

    public static ArrayList getStringAsArrayList(String string, String string2, Logger logger) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (string != null && string.length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (string3.length() <= 0) continue;
                    arrayList.add(string3.trim());
                }
            }
        }
        catch (Exception exception) {
            logger.error(" Exception occurred : ", (Throwable)exception);
        }
        return arrayList;
    }

    public static HashMap getLinesAsTreeSetMap(IniFile iniFile, String string, Logger logger) {
        HashMap<String, TreeSet> hashMap = new HashMap<String, TreeSet>();
        try {
            String[] stringArray = iniFile.getLinesUnderSubject(string);
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    int n = string2.indexOf("=");
                    if (n < 0) continue;
                    String string3 = string2.substring(0, n);
                    TreeSet treeSet = APMUtils.getStringAsTreeSet(string2.substring(n + 1), ",", logger);
                    hashMap.put(string3, treeSet);
                }
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception Occurred in getLinesAsMap() :{} ", (Object)loggerDispStr, (Object)exception);
        }
        return hashMap;
    }

    public static HashMap getLinesAsArrayListMap(IniFile iniFile, String string, Logger logger) {
        return APMUtils.getLinesAsArrayListMap(iniFile, string, ",", logger);
    }

    public static HashMap getLinesAsArrayListMap(IniFile iniFile, String string, String string2, Logger logger) {
        HashMap<String, ArrayList> hashMap = new HashMap<String, ArrayList>();
        if (iniFile == null) {
            return hashMap;
        }
        try {
            logger.debug("{} Trying to read {} from {}.", new Object[]{loggerDispStr, string, iniFile.fileName});
            String[] stringArray = iniFile.getLinesUnderSubject(string);
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i];
                    int n = string3.indexOf("=");
                    if (n < 0) continue;
                    String string4 = string3.substring(0, n);
                    ArrayList arrayList = APMUtils.getStringAsArrayList(string3.substring(n + 1), string2, logger);
                    hashMap.put(string4, arrayList);
                }
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception Occurred in getLinesAsArrayListMap() :{} ", (Object)loggerDispStr, (Object)exception);
        }
        return hashMap;
    }

    public static boolean isLoopbackAddress(InetAddress inetAddress) {
        boolean bl = false;
        String string = inetAddress.getHostAddress();
        if (string.startsWith("127.") || string.startsWith("0:0:0:0:0:0:0:1")) {
            bl = true;
        }
        return bl;
    }

    public static boolean wildCardPatternMatch(String string, String string2) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!string2.startsWith("*")) {
            bl2 = true;
        }
        if (!string2.endsWith("*")) {
            bl3 = true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "*");
        int n2 = stringTokenizer.countTokens();
        String string3 = new String(string);
        String[] stringArray = new String[n2];
        if (n2 <= 0) {
            return false;
        }
        for (n = 0; n < n2; ++n) {
            stringArray[n] = stringTokenizer.nextToken();
        }
        n = 0;
        if (bl2 && !string3.startsWith(stringArray[0])) {
            return false;
        }
        if (bl3 && !string3.endsWith(stringArray[n2 - 1])) {
            return false;
        }
        String string4 = null;
        for (int i = 0; i < n2; ++i) {
            string4 = stringArray[i];
            n = string3.indexOf(string4);
            if (n == -1) {
                return false;
            }
            bl = true;
            string3 = new String(string3.substring(n += string4.length()));
        }
        return bl;
    }

    public static String subStringLastTwoOccurrence(String string, String string2) {
        int n;
        if (string != null && string2 != null && (n = string.lastIndexOf(string2)) > -1) {
            if ((n = (string = string.substring(0, n)).lastIndexOf(string2)) > -1) {
                string = string.substring(0, n);
            }
            return string;
        }
        return string;
    }

    public static void main(String[] stringArray) {
        System.out.println(APMUtils.subStringLastTwoOccurrence("pet-deploy-5ffbcb8f59-x44lg", "-"));
    }

    public static String getShortContainerId(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf("/")) > 1) {
            string = string.substring(n + 1);
            return APMUtils.trimTo12Char(string);
        }
        return string;
    }

    public static String trimTo12Char(String string) {
        if (string != null && string.length() >= 13) {
            string = string.substring(0, 12);
        }
        return string;
    }

    public static String getAgentIpAddress() {
        String string;
        block3: {
            String string2 = loggerDispStr;
            string = "";
            try {
                String string3;
                string = string3 = InetAddress.getLocalHost().getHostName();
                InetAddress[] inetAddressArray = InetAddress.getAllByName(string3);
                APMDiscoveryLogger.discoveryLogger.trace("{} localHostName : {} & InetAddress : {} ", new Object[]{string2, string3, inetAddressArray});
                if (inetAddressArray == null || inetAddressArray.length <= 1) break block3;
                for (int i = 0; i < inetAddressArray.length; ++i) {
                    String string4;
                    InetAddress inetAddress = inetAddressArray[i];
                    APMDiscoveryLogger.discoveryLogger.trace("{} Ip Address : {} ", (Object)string2, (Object)inetAddress.getHostAddress());
                    if (inetAddress != null && APMUtils.isLoopbackAddress(inetAddress) || (string4 = inetAddress.getHostAddress()) == null || string4.startsWith("169.254.") || string4.indexOf(":") > 0) continue;
                    string = string4;
                    break;
                }
            }
            catch (UnknownHostException unknownHostException) {
                APMDiscoveryLogger.discoveryLogger.warn("{} {} - Unable to do getAgentIpAddress() {}", (Object)loggerDispStr, (Object)unknownHostException);
            }
        }
        return string;
    }

    public static ArrayList executeCmd(String string, boolean bl) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = null;
        APMDiscoveryLogger.discoveryLogger.debug("{} Trying to execute the command : \"{}\" ", (Object)loggerDispStr, (Object)string);
        try {
            EgUtilities egUtilities = EgUtilities.createInstance();
            arrayList = egUtilities.getCommandOutputLines(string, bl, true, true);
            if (arrayList != null && arrayList.size() > 0) {
                arrayList2 = (ArrayList)arrayList.get(0);
                ArrayList arrayList3 = (ArrayList)arrayList.get(1);
                if (arrayList3 != null && arrayList3.size() > 0) {
                    APMDiscoveryLogger.discoveryLogger.warn("{} command : \"{}\" and result : {}", new Object[]{loggerDispStr, string, arrayList});
                }
                if (arrayList2 != null && arrayList2.size() > 0) {
                    APMDiscoveryLogger.discoveryLogger.debug("{} command : \"{}\" and cmdOutput : {}", new Object[]{loggerDispStr, string, arrayList2});
                } else {
                    arrayList2 = new ArrayList();
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} {} - Unable to execute {}", new Object[]{loggerDispStr, string, exception.getMessage()});
        }
        return arrayList2;
    }

    public static ArrayList executeCmd(String string, long l, String string2) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = null;
        APMDiscoveryLogger.discoveryLogger.debug("{} Trying to execute the command : \"{}\" ", (Object)loggerDispStr, (Object)string);
        try {
            EgUtilities egUtilities = EgUtilities.createInstance();
            arrayList = egUtilities.getExecOutputLines(string, l, string2, 0);
            if (arrayList != null && arrayList.size() > 0) {
                arrayList2 = (ArrayList)arrayList.get(0);
                ArrayList arrayList3 = (ArrayList)arrayList.get(1);
                if (arrayList3 != null && arrayList3.size() > 0) {
                    APMDiscoveryLogger.discoveryLogger.warn("{} command : \"{}\" and result : {}", new Object[]{loggerDispStr, string, arrayList});
                }
                if (arrayList2 != null && arrayList2.size() > 0) {
                    APMDiscoveryLogger.discoveryLogger.debug("{} command : \"{}\" and cmdOutput : {}", new Object[]{loggerDispStr, string, arrayList2});
                } else {
                    arrayList2 = new ArrayList();
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} {} - Unable to execute {}", new Object[]{loggerDispStr, string, exception.getMessage()});
        }
        return arrayList2;
    }

    public static ArrayList executeCmd(String string, boolean bl, boolean bl2) {
        ArrayList arrayList = new ArrayList();
        Object var4_4 = null;
        APMDiscoveryLogger.discoveryLogger.debug("{} Trying to execute the command : \"{}\" ", (Object)loggerDispStr, (Object)string);
        try {
            EgUtilities egUtilities = EgUtilities.createInstance();
            arrayList = egUtilities.getCommandOutputLines(string, bl, true, true);
            if (arrayList != null && arrayList.size() > 0) {
                return arrayList;
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} {} - Unable to execute {}", new Object[]{loggerDispStr, string, exception.getMessage()});
        }
        return arrayList;
    }

    public static String getFullCmd(String string, String string2) {
        String string3 = string2;
        if (string != null && string.length() > 0) {
            string3 = string + " " + string2;
        }
        return string3.trim();
    }

    public static SimpleDateFormat getDateFormat(String string) {
        return new SimpleDateFormat(string);
    }

    public static long getEpochFromDate(String string, String string2, long l) {
        try {
            Date date = APMUtils.getDateFormat(string2).parse(string);
            return date.getTime();
        }
        catch (ParseException parseException) {
            APMDiscoveryLogger.discoveryLogger.warn("{} {} - Unable to get epoch time for  {}", new Object[]{loggerDispStr, string, parseException.getMessage()});
            return l;
        }
    }

    public static String getDateFromEpoch(long l) {
        try {
            String string = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date(l));
            return string;
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} {} - Unable to get date for  {}", new Object[]{loggerDispStr, l, exception.getMessage()});
            return new Date().toString();
        }
    }

    public static boolean isWindows() {
        return ApmConfigManager.getInstance().getOsType() == OS.WINDOWS;
    }

    public static boolean isLinux() {
        return ApmConfigManager.getInstance().getOsType() == OS.LINUX;
    }

    public static boolean isHpux() {
        return ApmConfigManager.getInstance().getOsType() == OS.HPUX;
    }

    public static boolean isAix() {
        return ApmConfigManager.getInstance().getOsType() == OS.AIX;
    }

    public static boolean isSolaris() {
        return ApmConfigManager.getInstance().getOsType() == OS.SOLARIS;
    }

    public static HashMap getModifiedData(HashMap hashMap, HashMap hashMap2, Logger logger) {
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        logger.debug("{} - getModifiedData() : currentTable: {} \t  previousTable : {} ", new Object[]{loggerDispStr, hashMap, hashMap2});
        if (hashMap != null && hashMap.size() > 0) {
            Set set = hashMap.keySet();
            for (String string : set) {
                String string2 = (String)hashMap.get(string);
                if (string.startsWith("+")) {
                    string = string.substring(1);
                }
                if (hashMap2.containsKey(string)) {
                    String string3 = (String)hashMap2.get(string);
                    if (string2.equals(string3)) continue;
                    hashMap2.put(string, string2);
                    hashMap3.put(string, string2);
                    continue;
                }
                hashMap2.put(string, string2);
                hashMap3.put(string, string2);
            }
        }
        return hashMap3;
    }

    public static HashMap getArrayListAsMap(ArrayList arrayList, String string, Logger logger) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    int n;
                    String string2 = (String)arrayList.get(i);
                    if (string2 == null || (n = string2.indexOf(string)) <= 0) continue;
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n + 1);
                    hashMap.put(string3.trim(), string4.trim());
                    continue;
                }
                catch (Exception exception) {
                    logger.warn("{} {} - Unable to parse  {}", (Object)loggerDispStr, (Object)exception);
                }
            }
        }
        return hashMap;
    }

    public static String removeJavaEscapeChar(String string) {
        try {
            string = string == null ? "" : string;
            return StringEscapeUtils.unescapeJava((String)string);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} {} - Unable to remove java escape char {}", (Object)loggerDispStr, (Object)exception);
            return string;
        }
    }

    public static String getAsJsonString(Object object) {
        if (object == null) {
            return "";
        }
        try {
            return JSONValue.toJSONString((Object)object);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} {} - Unable to get as json obj  {}", (Object)loggerDispStr, (Object)exception);
            return object.toString();
        }
    }

    public static String wrapWithDoubleQuotes(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"");
        stringBuilder.append(string);
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }

    public static String concatWithCurrentTime(String string) {
        try {
            if (string != null) {
                return string + APMUtils.getTimeStamp();
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred {}", (Object)loggerDispStr, (Object)exception);
        }
        return System.currentTimeMillis() + "";
    }

    public static Boolean IsThisAvailableInIniValue(IniFile iniFile, String string, String string2, String string3, String string4, Logger logger) {
        try {
            if (iniFile != null) {
                ArrayList arrayList = APMUtils.getStringAsArrayList(iniFile, string, string2, string3, APMDiscoveryLogger.discoveryLogger);
                logger.trace("{} IsThisAvailableInIniValue() - Value of '{}' under section [{}] in [{}] : {}", new Object[]{loggerDispStr, string2, string, iniFile.fileName, arrayList});
                if (arrayList != null && arrayList.contains(string4)) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception Occurred in IsThisAvailableInIniValue() :{} ", (Object)loggerDispStr, (Object)exception);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeAPMConfigData(HashMap hashMap, boolean bl, Logger logger) {
        IniFile iniFile = EgApmFilesSync.getInstance(EgInstallInfo.getInstallDir() + BTMConstants.APMCONFIG_FILEPATH);
        TreeSet<String> treeSet = new TreeSet<String>();
        try {
            for (String string : hashMap.keySet()) {
                HashMap hashMap2 = (HashMap)hashMap.get(string);
                if (string == null || string.length() <= 0 || hashMap2 == null || hashMap2.size() <= 0) continue;
                if (string.indexOf("^") != -1) {
                    treeSet.add(string.substring(string.indexOf("^") + 1, string.length()));
                    string = string.substring(0, string.indexOf("^"));
                }
                for (String string2 : hashMap2.keySet()) {
                    String string3 = (String)hashMap2.get(string2);
                    if (bl) {
                        treeSet.add(string2);
                    }
                    iniFile.setValue(string, string2, string3);
                }
            }
        }
        catch (Exception exception) {
            logger.error("{} Exception Occurred in storeAPMConfigData() :{} ", (Object)loggerDispStr, (Object)exception);
        }
        finally {
            iniFile.saveFile();
            EgApmFilesSync.releaseInstance(iniFile);
        }
        if (treeSet.size() > 0) {
            BTMConfigWriter.getInstance().btmConfigAgentWriter(treeSet);
        }
    }

    static {
        CONTAINER_NAME_MAPPINGS.put("Tomcat", "Tomcat_server");
        CONTAINER_NAME_MAPPINGS.put("JBoss", "JBoss_server");
        CONTAINER_NAME_MAPPINGS.put("WildFly", "WildFly");
        CONTAINER_NAME_MAPPINGS.put("WebLogic", "WebLogic_server");
        CONTAINER_NAME_MAPPINGS.put("WebSphere", "WebSphere_server");
        CONTAINER_NAME_MAPPINGS.put("GlassFish", "GlassFish_server");
        CONTAINER_NAME_MAPPINGS.put("Liberty", "IBMWLP");
        CONTAINER_NAME_MAPPINGS.put("java", "Java_virtual_machine");
        CONTAINER_NAME_MAPPINGS.put("NodeJS", "NodeJS");
    }
}

