/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMComponent;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.AcknowledgeHandler;
import com.eg.apm.ClientSocketHandler;
import com.eg.apm.CommonGUIDConfigRemover;
import com.eg.apm.Component;
import com.eg.apm.EntityPropsRemover;
import com.eg.apm.JavaBTMOffloadLogger;
import com.eg.apm.MessageHandler;
import com.eg.apm.OffloadCPCConfigRemover;
import com.eg.apm.OffloadConfigRemover;
import com.eg.apm.ThresholdPropsRemover;
import java.util.HashMap;
import java.util.Map;

public class AckMessageHandler
implements MessageHandler {
    private final Map<String, AcknowledgeHandler> handlerMap = new HashMap<String, AcknowledgeHandler>();
    private static final String loggerDispStr = "[AckMessageHandler]";

    public AckMessageHandler() {
        this.handlerMap.put("BTM_PROPS_OK", new EntityPropsRemover("BusinessTransTest"));
        this.handlerMap.put("KBTM_PROPS_OK", new EntityPropsRemover("KBusinessTransTest"));
        this.handlerMap.put("BTM_THRESH_OK", new ThresholdPropsRemover("BusinessTransTest"));
        this.handlerMap.put("KBTM_THRESH_OK", new ThresholdPropsRemover("KBusinessTransTest"));
        this.handlerMap.put("NODEJS_BTM_PROPS_OK", new EntityPropsRemover("NodeTransTest"));
        this.handlerMap.put("NODEJS_KBTM_PROPS_OK", new EntityPropsRemover("KNodeTransTest"));
        this.handlerMap.put("NODEJS_BTM_THRESH_OK", new ThresholdPropsRemover("NodeTransTest"));
        this.handlerMap.put("NODEJS_KBTM_THRESH_OK", new ThresholdPropsRemover("KNodeTransTest"));
        this.handlerMap.put("NODEJS_OFFLOAD_CONFIG_OK", new OffloadConfigRemover());
        this.handlerMap.put("OFFLOAD_CONFIG_OK", new OffloadConfigRemover());
        this.handlerMap.put("OFFLOAD_CPC_CONFIG_OK", new OffloadCPCConfigRemover());
        this.handlerMap.put("COMMON_GUID_CONFIG_OK", new CommonGUIDConfigRemover());
    }

    public boolean handleMessage(String string, Object object, ClientSocketHandler clientSocketHandler) {
        this.removeConfigFromRepository(string);
        clientSocketHandler.sendResponseToProfiler("OK", object, "");
        return true;
    }

    private void removeConfigFromRepository(String string) {
        Object object;
        String string2 = string.replace("ACK4BTM_!;-;!", "");
        String[] stringArray = string2.split("!;-;!");
        String string3 = stringArray[0];
        APMComponentIDRepository aPMComponentIDRepository = APMComponentIDRepository.getRepository();
        APMComponent aPMComponent = aPMComponentIDRepository.getAPMComponent(string3);
        if (aPMComponent == null) {
            return;
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} - Trying to removing config from respective repository for {} & data {}", new Object[]{loggerDispStr, string3, string2});
        int n = stringArray.length;
        Long l = Component.DEFAULT_WORKER_ID;
        if (n > 2) {
            try {
                String string4 = stringArray[1];
                int n2 = string4.indexOf(",");
                if (n2 > 0) {
                    object = string4.substring(0, n2);
                    long l2 = Long.parseLong((String)object);
                    l = new Long(l2);
                }
            }
            catch (Exception exception) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Unable to get WorkerID from Acknowledge message -{}- from Comp.ID - {}, due to {}", new Object[]{loggerDispStr, string2, string3, exception});
            }
        }
        for (int i = 0; i < n; ++i) {
            String string5 = stringArray[i];
            if (string5.length() <= 0) continue;
            object = this.handlerMap.get(string5.toUpperCase());
            if (object != null) {
                object.handleAcknowledge(aPMComponent, l);
                continue;
            }
            if (!string5.equalsIgnoreCase("New_JvmGuid_OK")) continue;
            if (string3.startsWith("DISCOVER_ME")) {
                aPMComponentIDRepository.unRegisterComponent(string3, false, true);
                continue;
            }
            String string6 = aPMComponentIDRepository.getComponentGuidFromTemp(string3);
            aPMComponentIDRepository.unRegisterComponent(string6, false, true);
            aPMComponent.setAsDiscoverdManagedComponent(true);
        }
    }
}

