/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.CRIOContainers;
import com.eg.apm.Container;
import com.eg.apm.ContainerCategory;
import com.eg.apm.DockerContainers;
import com.eg.apm.PodmanContainers;
import com.egurkha.util.EgUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class ContainerInstanceFactory {
    private final Map<ContainerCategory, Container> handlerMap;
    private static ContainerInstanceFactory instance = null;
    private ContainerCategory containerCategory = ContainerCategory.NONE;
    private static final String CRIO_CMD = "crictl ";
    private static final String loggerDispStr = "[ContainerInstanceFactory]";

    private ContainerInstanceFactory() {
        this.findContainerType();
        this.handlerMap = new HashMap<ContainerCategory, Container>();
        this.handlerMap.put(ContainerCategory.DOCKER, DockerContainers.getDockerContainerInstance(ContainerCategory.DOCKER));
        this.handlerMap.put(ContainerCategory.CRIO, CRIOContainers.getCRIOContainerInstance(ContainerCategory.CRIO));
        this.handlerMap.put(ContainerCategory.PODMAN, PodmanContainers.getPodmanContainerInstance(ContainerCategory.PODMAN));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContainerInstanceFactory getInstance() {
        if (instance != null) return instance;
        Class<ContainerInstanceFactory> clazz = ContainerInstanceFactory.class;
        synchronized (ContainerInstanceFactory.class) {
            if (instance != null) return instance;
            instance = new ContainerInstanceFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean isDockerContainer() {
        return this.containerCategory.isDocker();
    }

    public boolean isCrioContainer() {
        return this.containerCategory.isCrio();
    }

    public boolean isPodmanContainer() {
        return this.containerCategory.isPodman();
    }

    public Container getContainerInstance() {
        return this.handlerMap.get((Object)this.containerCategory);
    }

    private void findContainerType() {
        String string = System.getenv("EG_CONTAINER_RUNTIME");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        APMDiscoveryLogger.discoveryLogger.trace("{} contaniner environment EG_CONTAINER_RUNTIME : {} ", (Object)loggerDispStr, (Object)string);
        if (string != null && string.length() > 0) {
            if (string.equalsIgnoreCase("crio")) {
                bl = this.isITCRIOComponent();
            } else if (string.equalsIgnoreCase("docker")) {
                bl2 = this.isItDockerServer();
            } else if (string.equalsIgnoreCase("podman")) {
                // empty if block
            }
            if (bl) {
                this.containerCategory = ContainerCategory.CRIO;
            }
            if (bl2) {
                this.containerCategory = ContainerCategory.DOCKER;
            }
            if (bl3) {
                this.containerCategory = ContainerCategory.PODMAN;
            }
            APMDiscoveryLogger.discoveryLogger.debug("{} contaniner environment EG_CONTAINER_RUNTIME : {}, isCrio : {}, isDocker :{}, isPodman :{} ", new Object[]{loggerDispStr, string, bl, bl2, bl3});
        }
        if (!(bl || bl2 || bl3)) {
            bl = this.isITCRIOComponent();
            if (bl) {
                this.containerCategory = ContainerCategory.CRIO;
            }
            if (bl2 = this.isItDockerServer()) {
                this.containerCategory = ContainerCategory.DOCKER;
                return;
            }
            bl3 = this.isPodmanMachine();
            if (bl3) {
                this.containerCategory = ContainerCategory.PODMAN;
            }
        }
    }

    private boolean isItDockerServer() {
        String string = System.getProperty("os.name").toLowerCase();
        boolean bl = false;
        try {
            ArrayList arrayList = null;
            String string2 = "";
            if (string != null && string.indexOf("linux") >= 0) {
                if (new File("/usr/bin/docker").exists()) {
                    string2 = "/usr/bin/docker info";
                    arrayList = this.executeCommand(string2);
                } else if (new File("/usr/sbin/docker").exists()) {
                    string2 = "/usr/sbin/docker info";
                    arrayList = this.executeCommand(string2);
                } else if (new File("/bin/docker").exists()) {
                    string2 = "/bin/docker info";
                    arrayList = this.executeCommand(string2);
                } else {
                    return false;
                }
                if (arrayList == null || arrayList.size() == 0) {
                    return false;
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string3 = ((String)arrayList.get(i)).trim();
                    if (string3 == null || string3.indexOf("Containers:") < 0 && string3.indexOf("Images:") < 0) continue;
                    bl = true;
                    break;
                }
            }
            System.out.println("[DockerContainers] flag = " + bl);
        }
        catch (Exception exception) {
            System.out.println("Exception Occured in DockerContainers while checking current server is docker :" + exception.toString());
            exception.printStackTrace();
        }
        return bl;
    }

    public ArrayList executeCommand(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList arrayList = null;
        ArrayList arrayList2 = new ArrayList();
        try {
            EgUtilities egUtilities = EgUtilities.createInstance();
            arrayList2 = egUtilities.getExecOutputLines(string);
            if (arrayList2 != null && arrayList2.size() >= 2) {
                arrayList = (ArrayList)arrayList2.get(0);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception  occured in DockerContainers while calling executeCommand " + string + " \tdata =" + arrayList2);
            exception.printStackTrace();
        }
        return arrayList;
    }

    public boolean isITCRIOComponent() {
        boolean bl;
        block15: {
            String string = System.getProperty("os.name").toLowerCase();
            bl = false;
            try {
                String string2;
                int n;
                ArrayList arrayList = null;
                String string3 = "";
                if (string.indexOf("linux") < 0) break block15;
                boolean bl2 = false;
                if (new File("/var/run/crio/crio.sock").exists() || new File("/var/run/containerd/containerd.sock").exists()) {
                    n = 0;
                    try {
                        string2 = "which crictl";
                        ArrayList arrayList2 = this.executeCommand(string2);
                        String string4 = null;
                        if (arrayList2 != null && arrayList2.size() > 0) {
                            string4 = (String)arrayList2.get(0);
                        }
                        if (string4 != null && string4.length() > 0) {
                            n = 1;
                            bl2 = true;
                        }
                        System.out.println(" ContainerInstanceFactory crioDiscovery isCrioSrv = " + (n != 0) + "\tcmd1 = " + string2 + "\tst_list = " + arrayList2);
                        APMDiscoveryLogger.discoveryLogger.debug("{} isCrioSrv : {}, cmd : {}, result : {} ", new Object[]{loggerDispStr, n != 0, string2, arrayList2});
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} Unable to verify crio cmd : {}", (Object)loggerDispStr, (Object)exception);
                    }
                    if (n && ((arrayList = this.executeCommand(string3 = "crictl images")) == null || arrayList.size() == 0)) {
                        string3 = "sudo crictl images";
                        arrayList = this.executeCommand(string3);
                    }
                } else {
                    return false;
                }
                if ((arrayList == null || arrayList.size() == 0) && bl2) {
                    string3 = "ps -aef | grep crio.sock";
                    arrayList = this.executeCommand(string3);
                }
                if ((arrayList == null || arrayList.size() == 0) && bl2) {
                    string3 = "ps -aef | grep containerd.sock";
                    arrayList = this.executeCommand(string3);
                }
                if (arrayList == null || arrayList.size() == 0) {
                    return false;
                }
                for (n = 0; n < arrayList.size(); n += 1) {
                    string2 = ((String)arrayList.get(n)).trim();
                    if (string2 == null) continue;
                    if (string2.toLowerCase().indexOf("image") >= 0) {
                        bl = true;
                    } else {
                        if (string2.toLowerCase().indexOf("crio.sock") < 0 && string2.toLowerCase().indexOf("containerd.sock") < 0) continue;
                        bl = true;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Unable to verify crio host : {}", (Object)loggerDispStr, (Object)exception);
            }
        }
        return bl;
    }

    public boolean isPodmanMachine() {
        boolean bl;
        block10: {
            String string = System.getProperty("os.name").toLowerCase();
            bl = false;
            try {
                ArrayList arrayList = null;
                String string2 = "";
                if (string.indexOf("linux") < 0) break block10;
                if (new File("/usr/bin/podman").exists()) {
                    string2 = "/usr/bin/podman images";
                    arrayList = this.executeCommand(string2);
                    if (arrayList == null || arrayList.size() == 0) {
                        string2 = "sudo /usr/bin/podman images";
                        arrayList = this.executeCommand(string2);
                    }
                } else if (new File("/var/run/podman").exists()) {
                    string2 = "podman images";
                    arrayList = this.executeCommand(string2);
                    if (arrayList == null || arrayList.size() == 0) {
                        string2 = "sudo podman images";
                        arrayList = this.executeCommand(string2);
                    }
                } else {
                    System.out.println(" podman is not available. So return");
                    return false;
                }
                if (arrayList == null || arrayList.size() == 0) {
                    return false;
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string3 = ((String)arrayList.get(i)).trim();
                    if (string3 == null || string3.toLowerCase().indexOf("image") < 0) continue;
                    bl = true;
                    break;
                }
            }
            catch (Exception exception) {
                System.out.println("Exception Occured in podman while checking current server is podman :" + exception.toString());
                exception.printStackTrace();
            }
        }
        return bl;
    }
}

