/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.AgentLogger;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMUtils;
import com.eg.apm.ContainerDataRepo;
import com.eg.apm.KubernetesAPI;
import com.eg.apm.PatternMatcher;
import com.egurkha.util.EgUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ContainerUtils {
    private static final String loggerDispStr = "[ContainerUtils]";
    private static final String PROC = "/proc/";
    private static final String CGROUP = "/cgroup";
    private static final String containerIdPattern = "([a-f0-9]{64})";
    private static String logDispStr = "";

    private static String getHostProcCgroupFilePath(String string) {
        return PROC + string + CGROUP;
    }

    private static boolean canRead(String string) {
        try {
            File file = new File(string);
            if (file.exists() && file.canRead()) {
                return true;
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred ", (Object)loggerDispStr, (Object)exception);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getDockerContainerId(String string) {
        String string2 = ContainerUtils.getHostProcCgroupFilePath(string);
        if (ContainerUtils.canRead(string2)) {
            PatternMatcher patternMatcher = new PatternMatcher();
            Pattern pattern = patternMatcher.getCompiledPatteren(containerIdPattern);
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(string2));
                while (true) {
                    String string3;
                    if ((string3 = bufferedReader.readLine()) == null) break;
                    Matcher matcher = pattern.matcher(string3 = string3.substring(string3.lastIndexOf("/")));
                    if (!matcher.find()) continue;
                    String string4 = matcher.group(1);
                    return string4;
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Unable to read : {}, {}", new Object[]{loggerDispStr, string2, exception.getMessage()});
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {}
            }
        } else {
            APMDiscoveryLogger.discoveryLogger.trace("{} No read permission for - {} ", (Object)loggerDispStr, (Object)string2);
        }
        return null;
    }

    static String getDockerFileSystemPath(String string) {
        String string2 = string + "/root";
        Path path = Paths.get(PROC + string2, new String[0]);
        if (Files.isSymbolicLink(path)) {
            try {
                Path path2 = Files.readSymbolicLink(path);
                int n = path2.getNameCount();
                if (n > 0) {
                    StringBuilder stringBuilder = new StringBuilder(string2);
                    for (int i = 0; i < n; ++i) {
                        stringBuilder.append("/..");
                    }
                    return stringBuilder.toString();
                }
                return path.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return path.toString();
    }

    static boolean isCrioDaemonRunning() {
        boolean bl;
        block8: {
            String string = "[CrioHostFinder]";
            bl = false;
            try {
                EgUtilities egUtilities = EgUtilities.createInstance();
                ArrayList arrayList = null;
                String string2 = "";
                boolean bl2 = false;
                if (!APMUtils.isLinux()) break block8;
                if (!new File("/var/run/crio/crio.sock").exists()) {
                    APMDiscoveryLogger.discoveryLogger.info("{} {} No CRIO SOCK found ", (Object)loggerDispStr, (Object)string);
                    return false;
                }
                bl2 = true;
                string2 = "crictl";
                arrayList = egUtilities.getCommandOutputLines(string2);
                APMDiscoveryLogger.discoveryLogger.warn("{} {} [EG_EVENT_INFO] crio cmd:  {} & output: {} ", new Object[]{loggerDispStr, string, string2, arrayList});
                if ((arrayList == null || arrayList.size() == 0) && bl2) {
                    string2 = "ps -aef | grep \"crio.sock\"";
                    arrayList = egUtilities.getCommandOutputLines(string2);
                    APMDiscoveryLogger.discoveryLogger.warn("{} [EG_EVENT_INFO] {} crio ps cmd  {} & output: {} ", new Object[]{loggerDispStr, string, string2, arrayList});
                }
                if (arrayList == null || arrayList.size() == 0) {
                    return false;
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string3 = ((String)arrayList.get(i)).trim();
                    if (string3 == null) continue;
                    if (string3.toLowerCase().indexOf("image") >= 0) {
                        APMDiscoveryLogger.discoveryLogger.info("{} {} CRIO image found", (Object)loggerDispStr, (Object)string);
                        bl = true;
                    } else {
                        if (string3.toLowerCase().indexOf("crio.sock") < 0) continue;
                        APMDiscoveryLogger.discoveryLogger.info("{} {} CRIO SOCK found in the process list ", (Object)loggerDispStr, (Object)string);
                        bl = true;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} {} Exception occurred ", new Object[]{loggerDispStr, string, exception});
            }
        }
        return bl;
    }

    static boolean isDockerDaemonRunning() {
        boolean bl;
        block10: {
            bl = false;
            String string = "";
            try {
                ArrayList arrayList = null;
                String string2 = "";
                if (!APMUtils.isLinux()) break block10;
                if (new File("/usr/bin/docker").exists()) {
                    string = "/usr/bin/";
                    string2 = "/usr/bin/docker info";
                    arrayList = APMUtils.executeCmd(string2, false);
                } else if (new File("/usr/sbin/docker").exists()) {
                    string = "/usr/sbin/";
                    string2 = "/usr/sbin/docker info";
                    arrayList = APMUtils.executeCmd(string2, false);
                } else if (new File("/bin/docker").exists()) {
                    string = "/bin/";
                    string2 = "/bin/docker info";
                    arrayList = APMUtils.executeCmd(string2, false);
                } else {
                    return false;
                }
                if (arrayList == null || arrayList.size() == 0) {
                    return false;
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string3 = ((String)arrayList.get(i)).trim();
                    if (string3 == null || string3.indexOf("Containers:") < 0 && string3.indexOf("Images:") < 0) continue;
                    bl = true;
                    break;
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Exception Occured while checking current server is docker {} :", (Object)loggerDispStr, (Object)exception);
            }
        }
        return bl;
    }

    public static String getEgPayloadDataAsJsonString(Hashtable hashtable, String string, HashMap hashMap) {
        if (hashtable != null) {
            try {
                APMDiscoveryLogger.discoveryLogger.trace("{} {} DD data : {} ", new Object[]{loggerDispStr, string, hashtable});
                if (hashMap == null) {
                    hashMap = new HashMap();
                }
                hashMap.put("eG-GroupName", hashtable.get("eG-GroupName"));
                hashMap.put("eG-K8sClusterName", hashtable.get("eG-K8sClusterName"));
                hashMap.put("eG-ServiceName", hashtable.get("eG-ServiceName"));
                hashMap.put("nameSpace", hashtable.get("nameSpace"));
                hashMap.put("serviceName", hashtable.get("serviceName"));
                hashMap.put("deploymentName", hashtable.get("deploymentName"));
                hashMap.put("eG-AccountId", hashtable.get("eG-AccountId"));
                return APMUtils.getAsJsonString(hashMap);
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred while converting to json {} :", (Object)loggerDispStr, (Object)exception);
            }
        }
        return "{}";
    }

    public static void updateEgPayloadData(Hashtable hashtable, Hashtable hashtable2) {
        if (hashtable2 == null || hashtable == null) {
            return;
        }
        try {
            hashtable.put("eG-ServiceName", hashtable2.get("eG-ServiceName") + "");
            hashtable.put("eG-GroupName", hashtable2.get("eG-GroupName") + "");
            hashtable.put("eG-K8sClusterName", hashtable2.get("eG-K8sClusterName") + "");
            hashtable.put("eG-AccountId", hashtable2.get("eG-AccountId") + "");
            hashtable.put("deploymentName", hashtable2.get("deploymentName") + "");
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred while extracing payload data {} :", (Object)loggerDispStr, (Object)exception);
        }
    }

    public static void updateEnv(Hashtable hashtable, ArrayList arrayList) {
        ContainerUtils.extractEgEnvDetailsFromPod(hashtable, arrayList, "eG-ServiceName", "EG_SERVICE_NAME");
        ContainerUtils.extractEgEnvDetailsFromPod(hashtable, arrayList, "eG-GroupName", "EG_GROUP_NAME");
        ContainerUtils.extractEgEnvDetailsFromAgent(hashtable, arrayList, "eG-K8sClusterName", "EG_KUBERNETES_CLUSTER_NAME");
        ContainerUtils.extractEgEnvDetailsFromAgent(hashtable, arrayList, "eG-AccountId", "EG_AGENT_IDENTIFIER_ID");
    }

    public static void extractEgEnvDetailsFromPod(Hashtable hashtable, ArrayList arrayList, String string, String string2) {
        try {
            String string3 = ContainerUtils.getContainerEnv(arrayList, string2);
            if (string3 != null) {
                hashtable.put(string, string3);
            } else {
                hashtable.put(string, "none");
            }
        }
        catch (Exception exception) {
            AgentLogger.discoveryLogger.warn("{} Exception : ", (Object)logDispStr, (Object)exception);
        }
    }

    public static void extractEgEnvDetailsFromAgent(Hashtable hashtable, ArrayList arrayList, String string, String string2) {
        try {
            String string3 = ContainerUtils.getAgentEnv(string2);
            if (string3 != null) {
                hashtable.put(string, string3);
            } else {
                hashtable.put(string, "none");
            }
        }
        catch (Exception exception) {
            AgentLogger.discoveryLogger.warn("{} Exception : ", (Object)logDispStr, (Object)exception);
        }
    }

    private static String getContainerEnv(ArrayList arrayList, String string) {
        try {
            if (arrayList != null && arrayList.size() > 0) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string2 = arrayList.get(i).toString();
                    if (string2.indexOf(string) < 0 || string2.indexOf("=") <= 0) continue;
                    return string2.split("=")[1];
                }
            }
        }
        catch (Exception exception) {
            AgentLogger.discoveryLogger.warn("{} Exception : ", (Object)logDispStr, (Object)exception);
        }
        return null;
    }

    private static String getAgentEnv(String string) {
        try {
            String string2;
            if (string != null && string.length() > 0 && (string2 = System.getenv(string)) != null && string2.length() > 0) {
                return string2;
            }
        }
        catch (Exception exception) {
            AgentLogger.discoveryLogger.warn("{} Exception : ", (Object)logDispStr, (Object)exception);
        }
        return null;
    }

    public static String getContainerEnv(Hashtable hashtable, String string) {
        try {
            if (hashtable != null && hashtable.containsKey("ContainerEnv")) {
                ArrayList arrayList = (ArrayList)hashtable.get("ContainerEnv");
                AgentLogger.discoveryLogger.trace("{} ContainerEnv : ", (Object)logDispStr, (Object)arrayList);
                if (arrayList != null && arrayList.size() > 0) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        String string2 = arrayList.get(i).toString();
                        if (string2.indexOf(string) < 0 || string2.indexOf("=") <= 0) continue;
                        AgentLogger.discoveryLogger.debug("{} ContainerEnv key : {}, result value : ", new Object[]{logDispStr, string, string2.split("=")[1]});
                        return string2.split("=")[1];
                    }
                }
            }
        }
        catch (Exception exception) {
            AgentLogger.discoveryLogger.warn("{} Exception : ", (Object)logDispStr, (Object)exception);
        }
        return null;
    }

    public static String trimTo12Char(String string) {
        if (string != null && string.length() >= 12) {
            string = string.substring(0, 12);
        }
        return string;
    }

    public static void discoverSpecInfo(KubernetesAPI kubernetesAPI, Hashtable hashtable, String string) {
        if (hashtable == null) {
            return;
        }
        if (kubernetesAPI == null) {
            kubernetesAPI = KubernetesAPI.createInstance();
        }
        try {
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(hashtable);
            ContainerUtils.getSpecInfo(kubernetesAPI, concurrentHashMap, "nameSpace", "podName", string);
            hashtable.putAll(concurrentHashMap);
        }
        catch (Exception exception) {
            AgentLogger.testLogger.warn("{} discoverSpecInfo() exception {} ", (Object)logDispStr, (Object)exception);
        }
    }

    public static void getSpecInfo(KubernetesAPI kubernetesAPI, ConcurrentHashMap concurrentHashMap, String string, String string2, String string3) {
        if (concurrentHashMap == null) {
            return;
        }
        Iterator iterator = concurrentHashMap.entrySet().iterator();
        HashMap<String, HashMap> hashMap = new HashMap<String, HashMap>();
        while (iterator.hasNext()) {
            try {
                Map.Entry entry = iterator.next();
                String string4 = (String)entry.getKey();
                Hashtable hashtable = (Hashtable)entry.getValue();
                String string5 = (String)hashtable.get(string);
                String string6 = (String)hashtable.get(string2);
                if (string6 == null || string5 == null) continue;
                if (kubernetesAPI == null) {
                    kubernetesAPI = KubernetesAPI.createInstance();
                }
                HashMap hashMap2 = null;
                boolean bl = false;
                HashMap hashMap3 = ContainerDataRepo.getContainerSpecInfo(string3);
                String string7 = string5 + "|" + string6;
                if (hashMap3 != null && hashMap3.containsKey(string7)) {
                    hashMap2 = (HashMap)hashMap3.get(string7);
                } else {
                    hashMap2 = kubernetesAPI.getContainerInfoFromPod(string5, string6);
                    bl = true;
                }
                if (hashMap2 == null || hashMap2.isEmpty()) continue;
                hashtable.putAll(hashMap2);
                if (!bl) continue;
                hashMap.put(string7, hashMap2);
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred.. {}", (Object)logDispStr, (Object)exception);
            }
        }
        if (hashMap != null && hashMap.size() > 0) {
            ContainerDataRepo.updateContainerSpecInfo(string3, hashMap);
        }
        ContainerDataRepo.cleanUpContainerSpecInfo(string3);
        if (AgentLogger.discoveryLogger.isTraceEnabled()) {
            AgentLogger.discoveryLogger.trace("apiData: {}", hashMap);
            AgentLogger.discoveryLogger.trace("getContainerSpecInfo(): {}", (Object)ContainerDataRepo.getContainerSpecInfo());
        }
    }
}

