/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.ConnectionThread;
import com.eg.EgConfigInfo;
import com.eg.EgInstallInfo;
import com.eg.EgMgrInfo;
import com.eg.apm.AgentStartupLogger;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

public class DataTransmitter {
    protected String loggerPrefix = "[DataTransmitter]";
    private static long minimumSleep = 100L;
    private static final long minSleep = 50L;
    private static long maxSleep = -1L;
    private EgMgrInfo mi = null;
    private boolean isMgrInfoAvailable = false;
    private static DataTransmitter dataTransmitter;

    private DataTransmitter() {
        this.getManagerInfo();
    }

    private void getManagerInfo() {
        this.mi = EgMgrInfo.getInstance();
        if (this.mi != null) {
            AgentStartupLogger.logger.info("{} EgMgrInfo is initialized successfully ", (Object)this.loggerPrefix);
            this.isMgrInfoAvailable = true;
        } else {
            AgentStartupLogger.logger.error("{} EgMgrInfo is null or not intialized ", (Object)this.loggerPrefix);
            this.isMgrInfoAvailable = false;
        }
    }

    public static DataTransmitter getInstance() {
        return dataTransmitter != null ? dataTransmitter : (dataTransmitter = new DataTransmitter());
    }

    public HashMap transmitDataToManager(String string, HashMap hashMap) throws IOException {
        boolean bl = true;
        if (hashMap == null || hashMap.size() <= 0) {
            AgentStartupLogger.logger.debug("{} inputPayload is null or no inputpayload {} ", (Object)this.loggerPrefix, (Object)hashMap);
            bl = false;
        }
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        HttpURLConnection httpURLConnection = null;
        int n = -1;
        if (this.isMgrInfoAvailable) {
            Object object;
            URL uRL = this.getManagerURL(string);
            if (uRL == null) {
                AgentStartupLogger.logger.debug("{} Constructed Manager URL is null or invalid {} ", (Object)this.loggerPrefix, (Object)uRL);
            }
            AgentStartupLogger.logger.info("{} About to send data to manager, URL is : {}", (Object)this.loggerPrefix, (Object)uRL);
            if (this.mi.isProxySet()) {
                object = this.getProxy();
                httpURLConnection = (HttpURLConnection)uRL.openConnection((Proxy)object);
            } else {
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
            }
            if (httpURLConnection != null) {
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setRequestProperty("Content-Type", "application/octet-stream");
            }
            object = new ArrayList();
            ((ArrayList)object).ensureCapacity(1);
            ((ArrayList)object).add(hashMap);
            ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, true, (ArrayList)object);
            Object v = null;
            boolean bl2 = this.checkForTimeout(connectionThread);
            if (bl2) {
                n = connectionThread.code;
                if (connectionThread.done && n == 200 && connectionThread.data != null) {
                    v = connectionThread.data.get(0);
                }
            }
            connectionThread = null;
            hashMap2.put("results", (Integer)v);
            hashMap2.put("responseCode", n);
            httpURLConnection = null;
        } else {
            AgentStartupLogger.logger.error("{} EgMgrInfo is null or not initialized {}", (Object)this.loggerPrefix, (Object)this.isMgrInfoAvailable);
        }
        return hashMap2;
    }

    private Proxy getProxy() {
        int n = 0;
        try {
            if (this.mi.getProxyPort() != null) {
                n = Integer.parseInt(this.mi.getProxyPort().trim());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.mi.getProxyHost(), n);
        Proxy proxy = new Proxy(Proxy.Type.HTTP, inetSocketAddress);
        return proxy;
    }

    private URL getManagerURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(EgInstallInfo.urlPrefix + "//" + this.mi.getMgrIp() + ":" + this.mi.getMgrPort() + string);
        }
        catch (MalformedURLException malformedURLException) {
            AgentStartupLogger.logger.error("{} Exception while creating URL {} ", (Object)this.loggerPrefix, (Object)malformedURLException);
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(HttpURLConnection httpURLConnection, HashMap hashMap) {
        ObjectOutputStream objectOutputStream = null;
        try {
            if (httpURLConnection != null) {
                objectOutputStream = new ObjectOutputStream(httpURLConnection.getOutputStream());
                objectOutputStream.writeObject(hashMap);
                objectOutputStream.flush();
                AgentStartupLogger.logger.debug("{} Input payload is successfully written in output stream ", (Object)this.loggerPrefix);
            } else {
                AgentStartupLogger.logger.debug("{} URL Connection Object is null or invalid {} ", (Object)this.loggerPrefix, (Object)httpURLConnection);
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} writeObject - Excetion while sending object ", (Object)this.loggerPrefix, (Object)exception);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readObject(HttpURLConnection httpURLConnection) {
        Object object = null;
        ObjectInputStream objectInputStream = null;
        try {
            if (httpURLConnection != null) {
                objectInputStream = new ObjectInputStream(new BufferedInputStream(httpURLConnection.getInputStream(), 65536));
                object = objectInputStream.readObject();
                AgentStartupLogger.logger.debug("{} Response Object is successfully read from input stream ", (Object)this.loggerPrefix);
            } else {
                AgentStartupLogger.logger.debug("{} URL Connection Object is null or invalid {} ", (Object)this.loggerPrefix, (Object)httpURLConnection);
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} readObject - Exception while reading object from stream ", (Object)this.loggerPrefix, (Object)exception);
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                    objectInputStream = null;
                }
            }
            catch (Exception exception) {
                AgentStartupLogger.logger.error("{} readObject - Exception while closing object input stream ", (Object)this.loggerPrefix, (Object)exception);
            }
        }
        return object;
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2;
        long l3;
        EgConfigInfo egConfigInfo = new EgConfigInfo("agent");
        long l4 = EgConfigInfo.getResponseCodeTimeout * 10L;
        long l5 = 0L;
        long l6 = 250L;
        do {
            l = System.currentTimeMillis();
            if (l6 < minimumSleep) {
                l6 = minimumSleep;
            } else if (l6 > maxSleep) {
                l6 = maxSleep;
            }
            try {
                Thread.currentThread();
                Thread.sleep(l6);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!connectionThread.done) continue;
            return true;
        } while ((l5 += (l3 = (l2 = System.currentTimeMillis()) - l)) < l4 && l3 >= 0L);
        connectionThread.interrupt();
        try {
            Thread.currentThread();
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        connectionThread.stop();
        return false;
    }
}

