/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.EgLog;
import com.eg.ch.qos.logback.classic.LoggerContext;
import com.eg.org.slf4j.Logger;
import com.eg.org.slf4j.LoggerFactory;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class EgLogbackManager {
    private static final EgLogbackManager instance = new EgLogbackManager();
    private static final ConcurrentHashMap<String, EgLog> LOGGER_TABLE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Object> SYNC_TABLE = new ConcurrentHashMap();
    private boolean debugSysout = false;

    private EgLogbackManager() {
        String string = this.getJavaCommand();
        if (string != null && string.indexOf("EgMainAgent") > -1) {
            this.debugSysout = true;
        }
    }

    public static EgLogbackManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getLogger(String string) {
        if (LOGGER_TABLE.containsKey(string)) {
            return LOGGER_TABLE.get(string).getLogger();
        }
        Object object = null;
        if (SYNC_TABLE.contains(string)) {
            object = SYNC_TABLE.get(string);
        } else {
            object = new Object();
            SYNC_TABLE.put(string, object);
        }
        Object object2 = object;
        synchronized (object2) {
            EgLog egLog = new EgLog(string, this.debugSysout);
            LOGGER_TABLE.put(string, egLog);
        }
        return LOGGER_TABLE.get(string).getLogger();
    }

    public void updateConfig(Properties properties) {
        Set set = LOGGER_TABLE.keySet();
        for (String string : set) {
            EgLog egLog = LOGGER_TABLE.get(string);
            egLog.checkForUpdate(properties);
        }
    }

    public void reset() {
        try {
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            loggerContext.reset();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getJavaCommand() {
        String string = "";
        try {
            string = System.getProperty("sun.java.command");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }
}

